/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ExpressionHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.matchers.IrCallMatcher;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/DefaultSequenceHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ExpressionHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "sequenceClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "matchIterable", "", "ir.backend.common"})
public final class DefaultSequenceHandler
implements ExpressionHandler {
    @NotNull
    private final CommonBackendContext context;
    @Nullable
    private final IrClassSymbol sequenceClassSymbol;

    public DefaultSequenceHandler(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.sequenceClassSymbol = this.context.getIr().getSymbols().getSequence();
    }

    public boolean matchIterable(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.sequenceClassSymbol != null && IrTypeUtilsKt.isSubtypeOfClass(expression2.getType(), this.sequenceClassSymbol);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression2, @NotNull IrSymbol scopeOwner) {
        void $this$build_u24lambda_u2d1_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$build_u24lambda_u2d1 = declarationIrBuilder;
        boolean bl3 = false;
        Object object = this.sequenceClassSymbol;
        Intrinsics.checkNotNull((Object)object);
        IrClassSymbol irClassSymbol = object;
        object = OperatorNameConventions.ITERATOR.asString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITERATOR.asString()");
        Object object2 = AdditionalIrUtilsKt.getSimpleFunction(irClassSymbol, (String)object);
        Intrinsics.checkNotNull((Object)object2);
        IrSimpleFunction iteratorFun = (IrSimpleFunction)object2.getOwner();
        object2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$build_u24lambda_u2d1, iteratorFun);
        boolean bl4 = false;
        boolean bl5 = false;
        Object object3 = object2;
        Scope scope2 = $this$build_u24lambda_u2d1.getScope();
        boolean bl6 = false;
        $this$build_u24lambda_u2d1_u24lambda_u2d0.setDispatchReceiver(expression2);
        Unit unit = Unit.INSTANCE;
        IrVariable irVariable2 = IrBuildersKt.createTmpVariable$default(scope2, (IrExpression)object2, "iterator", false, null, null, 28, null);
        return new IterableHeaderInfo(irVariable2);
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression2, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        return ExpressionHandler.DefaultImpls.build(this, expression2, data, scopeOwner);
    }

    @Nullable
    public HeaderInfo handle(@NotNull IrExpression expression2, @Nullable IrCall iteratorCall, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        return ExpressionHandler.DefaultImpls.handle(this, expression2, iteratorCall, data, scopeOwner);
    }

    @Override
    @Nullable
    public IrCallMatcher getIteratorCallMatcher() {
        return ExpressionHandler.DefaultImpls.getIteratorCallMatcher(this);
    }
}

