/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.RequireKotlinConstants;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J.\u0010\u0010\u001a\u00020\u0004*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DeprecatedSinceKotlinAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "lessOrNull", "", "a", "Lorg/jetbrains/kotlin/config/ApiVersion;", "b", "checkVersion", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parsedVersion", "name", "", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "frontend"})
public final class DeprecatedSinceKotlinAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final DeprecatedSinceKotlinAnnotationChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.deprecatedSinceKotlin);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor deprecatedSinceAnnotation = annotationDescriptor;
        PsiElement psiElement = KotlinSourceElementKt.getPsi(deprecatedSinceAnnotation.getSource());
        if (!(psiElement instanceof KtAnnotationEntry)) {
            psiElement = null;
        }
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement;
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry deprecatedSinceAnnotationPsi = ktAnnotationEntry;
        AnnotationDescriptor deprecatedAnnotation = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.deprecated);
        KtTypeReference ktTypeReference = deprecatedSinceAnnotationPsi.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"deprecatedSinceAnnotatio\u2026i.typeReference ?: return");
        KtTypeReference deprecatedSinceAnnotationName = ktTypeReference;
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull(descriptor2);
        if (fqName2 != null) {
            if (!FqNamesUtilKt.isSubpackageOf(fqName2, StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) {
                context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE.on(deprecatedSinceAnnotationName));
                return;
            }
        }
        if (deprecatedAnnotation == null) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED.on(deprecatedSinceAnnotationName));
            return;
        }
        if (AnnotationUtilKt.argumentValue(deprecatedAnnotation, "level") != null) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL.on(deprecatedSinceAnnotationName));
            return;
        }
        if (deprecatedSinceAnnotation.getAllValueArguments().isEmpty()) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS.on(deprecatedSinceAnnotationName));
            return;
        }
        Function2<AnnotationDescriptor, String, ApiVersion> $fun$getCheckedSinceVersion$2 = new Function2<AnnotationDescriptor, String, ApiVersion>(context2, deprecatedSinceAnnotationName){
            final /* synthetic */ DeclarationCheckerContext $context;
            final /* synthetic */ KtTypeReference $deprecatedSinceAnnotationName;

            @Nullable
            public final ApiVersion invoke(@NotNull AnnotationDescriptor $this$getCheckedSinceVersion, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)$this$getCheckedSinceVersion, (String)"$this$getCheckedSinceVersion");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                ApiVersion apiVersion = DeprecationUtilKt.getSinceVersion($this$getCheckedSinceVersion, name);
                boolean bl = false;
                boolean bl2 = false;
                ApiVersion it = apiVersion;
                boolean bl3 = false;
                DeprecatedSinceKotlinAnnotationChecker.access$checkVersion(DeprecatedSinceKotlinAnnotationChecker.INSTANCE, $this$getCheckedSinceVersion, it, name, this.$context, this.$deprecatedSinceAnnotationName);
                return apiVersion;
            }
            {
                this.$context = declarationCheckerContext;
                this.$deprecatedSinceAnnotationName = ktTypeReference;
                super(2);
            }
        };
        ApiVersion warningSince = $fun$getCheckedSinceVersion$2.invoke(deprecatedSinceAnnotation, "warningSince");
        ApiVersion errorSince = $fun$getCheckedSinceVersion$2.invoke(deprecatedSinceAnnotation, "errorSince");
        ApiVersion hiddenSince = $fun$getCheckedSinceVersion$2.invoke(deprecatedSinceAnnotation, "hiddenSince");
        if (!(this.lessOrNull(warningSince, errorSince) && this.lessOrNull(errorSince, hiddenSince) && this.lessOrNull(warningSince, hiddenSince))) {
            context2.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS.on(deprecatedSinceAnnotationName));
            return;
        }
    }

    private final void checkVersion(AnnotationDescriptor $this$checkVersion, ApiVersion parsedVersion, String name, DeclarationCheckerContext context2, PsiElement reportOn) {
        block5: {
            block6: {
                String argumentValue;
                ConstantValue<?> $this$safeAs$iv = AnnotationUtilKt.argumentValue($this$checkVersion, name);
                boolean $i$f$safeAs = false;
                ConstantValue<?> constantValue = $this$safeAs$iv;
                if (!(constantValue instanceof StringValue)) {
                    constantValue = null;
                }
                StringValue stringValue = (StringValue)constantValue;
                String string2 = argumentValue = stringValue != null ? (String)stringValue.getValue() : null;
                if (argumentValue == null) break block5;
                if (parsedVersion == null) break block6;
                CharSequence charSequence = argumentValue;
                Regex regex = RequireKotlinConstants.INSTANCE.getVERSION_REGEX();
                boolean bl = false;
                if (regex.matches(charSequence)) break block5;
            }
            BindingTrace bindingTrace = context2.getTrace();
            FqName fqName2 = $this$checkVersion.getFqName();
            if (fqName2 == null) {
                return;
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.ILLEGAL_KOTLIN_VERSION_STRING_VALUE.on(reportOn, fqName2);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"Errors.ILLEGAL_KOTLIN_VE\u2026 return\n                )");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
        }
    }

    private final boolean lessOrNull(ApiVersion a, ApiVersion b) {
        return a == null || b == null ? true : a.compareTo(b) <= 0;
    }

    private DeprecatedSinceKotlinAnnotationChecker() {
    }

    static {
        DeprecatedSinceKotlinAnnotationChecker deprecatedSinceKotlinAnnotationChecker;
        INSTANCE = deprecatedSinceKotlinAnnotationChecker = new DeprecatedSinceKotlinAnnotationChecker();
    }

    public static final /* synthetic */ void access$checkVersion(DeprecatedSinceKotlinAnnotationChecker $this, AnnotationDescriptor $this$access_u24checkVersion, ApiVersion parsedVersion, String name, DeclarationCheckerContext context2, PsiElement reportOn) {
        $this.checkVersion($this$access_u24checkVersion, parsedVersion, name, context2, reportOn);
    }
}

