/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.CompileTimeUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u009a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u001a2\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0000\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u0004\u0018\u00010\u0010H\u0000\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\"\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0007*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\fH\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0019H\u0000\u001a\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u0010*\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\u0019H\u0000\u001a\u000e\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u0019H\u0000\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u001e*\u00020\u0014H\u0000\u001a\u000e\u0010$\u001a\u0004\u0018\u00010\"*\u00020\u0019H\u0000\u001a\n\u0010%\u001a\u00020\u0019*\u00020\u0019\u001a\u000e\u0010&\u001a\u0004\u0018\u00010'*\u00020\u0019H\u0000\u001a\u0014\u0010(\u001a\u0004\u0018\u00010\u0003*\u00020\f2\u0006\u0010)\u001a\u00020*\u001a\u0014\u0010+\u001a\u00020\u0005*\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010,\u001a\u00020\u001e*\u00020-\u001a\f\u0010.\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u0010/\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u00100\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u00101\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u00102\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\f\u00103\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a,\u00104\u001a\u0006\u0012\u0002\b\u000305*\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020*2\b\b\u0002\u00107\u001a\u00020*\u001a\u0014\u00108\u001a\u000209*\u00020\u00102\u0006\u0010\u000b\u001a\u000209H\u0000\u001a\u001e\u0010:\u001a\b\u0012\u0004\u0012\u0002H<0;\"\u0004\b\u0000\u0010<*\b\u0012\u0004\u0012\u0002H<05H\u0000\u001a \u0010=\u001a\u0006\u0012\u0002\b\u00030;*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00072\u0006\u0010>\u001a\u00020\u0003H\u0000\u001a\u0016\u0010?\u001a\u00020\u0010*\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006@"}, d2={"getPrimitiveClass", "Ljava/lang/Class;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "", "getTypeArguments", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "mapper", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "extractNonLocalDeclarations", "getAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "annotation", "Lorg/jetbrains/kotlin/name/FqName;", "getArgsForMethodInvocation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "args", "getBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "getCapitalizedFileName", "", "getCorrectReceiverByFunction", "irFunction", "getDispatchReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getEvaluateIntrinsicValue", "getExtensionReceiver", "getLastOverridden", "getReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getVarargType", "index", "", "hasAnnotation", "internalName", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isFunction", "isInterface", "isPrimitiveArray", "isThrowable", "isTypeParameter", "isUnsigned", "toIrConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "startOffset", "endOffset", "toIrExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "toPrimitive", "Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "T", "toPrimitiveStateArray", "type", "toState", "ir.interpreter"})
public final class UtilsKt {
    @Nullable
    public static final IrValueParameterSymbol getDispatchReceiver(@NotNull IrFunction $this$getDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getDispatchReceiver, (String)"$this$getDispatchReceiver");
        IrValueParameter irValueParameter = $this$getDispatchReceiver.getDispatchReceiverParameter();
        return irValueParameter != null ? (IrValueParameterSymbol)irValueParameter.getSymbol() : null;
    }

    @Nullable
    public static final IrValueParameterSymbol getExtensionReceiver(@NotNull IrFunction $this$getExtensionReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getExtensionReceiver, (String)"$this$getExtensionReceiver");
        IrValueParameter irValueParameter = $this$getExtensionReceiver.getExtensionReceiverParameter();
        return irValueParameter != null ? (IrValueParameterSymbol)irValueParameter.getSymbol() : null;
    }

    @Nullable
    public static final IrSymbol getReceiver(@NotNull IrFunction $this$getReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"$this$getReceiver");
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver($this$getReceiver);
        return irValueParameterSymbol != null ? (IrSymbol)irValueParameterSymbol : (IrSymbol)UtilsKt.getExtensionReceiver($this$getReceiver);
    }

    @Nullable
    public static final IrBody getBody(@NotNull IrFunctionAccessExpression $this$getBody) {
        Intrinsics.checkNotNullParameter((Object)$this$getBody, (String)"$this$getBody");
        return ((IrFunctionSymbol)$this$getBody.getSymbol()).getOwner().getBody();
    }

    @NotNull
    public static final IrExpression toIrExpression(@NotNull State $this$toIrExpression, @NotNull IrExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$toIrExpression, (String)"$this$toIrExpression");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        int start = expression2.getStartOffset();
        int end = expression2.getEndOffset();
        IrType type2 = IrTypesKt.makeNotNull(expression2.getType());
        State state = $this$toIrExpression;
        if (state instanceof Primitive) {
            irExpression = ((Primitive)$this$toIrExpression).getValue() == null ? (IrExpression)UtilsKt.toIrConst(((Primitive)$this$toIrExpression).getValue(), type2, start, end) : (IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null) || IrTypePredicatesKt.isString(type2) ? (IrExpression)UtilsKt.toIrConst(((Primitive)$this$toIrExpression).getValue(), type2, start, end) : expression2);
        } else if (state instanceof Complex) {
            IrSimpleType stateType = IrUtilsKt.getDefaultType($this$toIrExpression.getIrClass());
            if (UtilsKt.isUnsigned(stateType)) {
                State state2 = ((Variable)CollectionsKt.single($this$toIrExpression.getFields())).getState();
                if (state2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
                }
                irExpression = UtilsKt.toIrConst(((Primitive)state2).getValue(), type2, start, end);
            } else {
                irExpression = expression2;
            }
        } else {
            irExpression = expression2;
        }
        return irExpression;
    }

    @NotNull
    public static final State toState(@Nullable Object $this$toState, @NotNull IrType irType) {
        State state;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Object object = $this$toState;
        if (object instanceof State) {
            state = (State)$this$toState;
        } else if (object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof String || object instanceof Float || object instanceof Double || object instanceof Object[] || object instanceof byte[] || object instanceof char[] || object instanceof short[] || object instanceof int[] || object instanceof long[] || object instanceof float[] || object instanceof double[] || object instanceof boolean[]) {
            state = new Primitive<Object>($this$toState, irType);
        } else if (object == null) {
            state = new Primitive<Object>($this$toState, irType);
        } else {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            state = new Wrapper($this$toState, (IrClass)irClassSymbol.getOwner());
        }
        return state;
    }

    @NotNull
    public static final IrConst<?> toIrConst(@Nullable Object $this$toIrConst, @NotNull IrType irType, int startOffset, int endOffset) {
        IrConst irConst;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        IrType constType = IrTypesKt.makeNotNull(irType);
        if ($this$toIrConst == null) {
            irConst = IrConstImpl.Companion.constNull(startOffset, endOffset, irType);
        } else if (IrTypePredicatesKt.isBoolean(constType)) {
            irConst = IrConstImpl.Companion.boolean(startOffset, endOffset, constType, (Boolean)$this$toIrConst);
        } else if (IrTypePredicatesKt.isChar(constType)) {
            irConst = IrConstImpl.Companion.char(startOffset, endOffset, constType, ((Character)$this$toIrConst).charValue());
        } else if (IrTypePredicatesKt.isByte(constType)) {
            irConst = IrConstImpl.Companion.byte(startOffset, endOffset, constType, ((Number)$this$toIrConst).byteValue());
        } else if (IrTypePredicatesKt.isShort(constType)) {
            irConst = IrConstImpl.Companion.short(startOffset, endOffset, constType, ((Number)$this$toIrConst).shortValue());
        } else if (IrTypePredicatesKt.isInt(constType)) {
            irConst = IrConstImpl.Companion.int(startOffset, endOffset, constType, ((Number)$this$toIrConst).intValue());
        } else if (IrTypePredicatesKt.isLong(constType)) {
            irConst = IrConstImpl.Companion.long(startOffset, endOffset, constType, ((Number)$this$toIrConst).longValue());
        } else if (IrTypePredicatesKt.isString(constType)) {
            irConst = IrConstImpl.Companion.string(startOffset, endOffset, constType, (String)$this$toIrConst);
        } else if (IrTypePredicatesKt.isFloat(constType)) {
            irConst = IrConstImpl.Companion.float(startOffset, endOffset, constType, ((Number)$this$toIrConst).floatValue());
        } else if (IrTypePredicatesKt.isDouble(constType)) {
            irConst = IrConstImpl.Companion.double(startOffset, endOffset, constType, ((Number)$this$toIrConst).doubleValue());
        } else if (IrTypePredicatesKt.isUByte(constType)) {
            irConst = IrConstImpl.Companion.byte(startOffset, endOffset, constType, ((Number)$this$toIrConst).byteValue());
        } else if (IrTypePredicatesKt.isUShort(constType)) {
            irConst = IrConstImpl.Companion.short(startOffset, endOffset, constType, ((Number)$this$toIrConst).shortValue());
        } else if (IrTypePredicatesKt.isUInt(constType)) {
            irConst = IrConstImpl.Companion.int(startOffset, endOffset, constType, ((Number)$this$toIrConst).intValue());
        } else if (IrTypePredicatesKt.isULong(constType)) {
            irConst = IrConstImpl.Companion.long(startOffset, endOffset, constType, ((Number)$this$toIrConst).longValue());
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported const element type " + RenderIrElementKt.render(constType));
        }
        return irConst;
    }

    public static /* synthetic */ IrConst toIrConst$default(Object object, IrType irType, int n, int n2, int n3, Object object2) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        return UtilsKt.toIrConst(object, irType, n, n2);
    }

    @NotNull
    public static final <T> Primitive<T> toPrimitive(@NotNull IrConst<T> $this$toPrimitive) {
        Intrinsics.checkNotNullParameter($this$toPrimitive, (String)"$this$toPrimitive");
        return new Primitive<T>($this$toPrimitive.getValue(), $this$toPrimitive.getType());
    }

    public static final boolean hasAnnotation(@Nullable IrAnnotationContainer $this$hasAnnotation, @NotNull FqName annotation2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        if ($this$hasAnnotation == null) {
            return false;
        }
        Collection collection = $this$hasAnnotation.getAnnotations();
        boolean bl = false;
        if (!collection.isEmpty()) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation2)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        return false;
    }

    @NotNull
    public static final IrConstructorCall getAnnotation(@NotNull IrAnnotationContainer $this$getAnnotation, @NotNull FqName annotation2) {
        IrConstructorCall irConstructorCall;
        Object v0;
        IrConstructorCall it;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$getAnnotation, (String)"$this$getAnnotation");
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            Iterable $this$firstOrNull$iv = $this$getAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (IrConstructorCall)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation2)) continue;
                v0 = element$iv2;
                break block4;
            }
            v0 = null;
        }
        if ((irConstructorCall = (IrConstructorCall)v0) == null) {
            Object element$iv2;
            block5: {
                IrDeclarationParent irDeclarationParent = ((IrFunction)$this$getAnnotation).getParent();
                if (irDeclarationParent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                }
                Iterable $this$first$iv = ((IrClass)irDeclarationParent).getAnnotations();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (IrConstructorCall)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation2)) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            irConstructorCall = (IrConstructorCall)element$iv2;
        }
        return irConstructorCall;
    }

    @Nullable
    public static final String getEvaluateIntrinsicValue(@NotNull IrAnnotationContainer $this$getEvaluateIntrinsicValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getEvaluateIntrinsicValue, (String)"$this$getEvaluateIntrinsicValue");
        if ($this$getEvaluateIntrinsicValue instanceof IrClass) {
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$getEvaluateIntrinsicValue);
            if (fqName2 != null) {
                if (fqName2.startsWith(Name.identifier("java"))) {
                    FqName fqName3 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$getEvaluateIntrinsicValue);
                    return fqName3 != null ? fqName3.asString() : null;
                }
            }
        }
        if (!UtilsKt.hasAnnotation($this$getEvaluateIntrinsicValue, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation())) {
            return null;
        }
        IrExpression irExpression = UtilsKt.getAnnotation($this$getEvaluateIntrinsicValue, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation()).getValueArgument(0);
        if (irExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
        }
        return String.valueOf(((IrConst)irExpression).getValue());
    }

    @Nullable
    public static final Class<?> getPrimitiveClass(@NotNull IrType irType, boolean asObject) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        return IrTypePredicatesKt.isBoolean(irType) ? (asObject ? Boolean.class : Boolean.TYPE) : (IrTypePredicatesKt.isChar(irType) ? (asObject ? Character.class : Character.TYPE) : (IrTypePredicatesKt.isByte(irType) ? (asObject ? Byte.class : Byte.TYPE) : (IrTypePredicatesKt.isShort(irType) ? (asObject ? Short.class : Short.TYPE) : (IrTypePredicatesKt.isInt(irType) ? (asObject ? Integer.class : Integer.TYPE) : (IrTypePredicatesKt.isLong(irType) ? (asObject ? Long.class : Long.TYPE) : (IrTypePredicatesKt.isString(irType) ? (asObject ? String.class : String.class) : (IrTypePredicatesKt.isFloat(irType) ? (asObject ? Float.class : Float.TYPE) : (IrTypePredicatesKt.isDouble(irType) ? (asObject ? Double.class : Double.TYPE) : null))))))));
    }

    public static /* synthetic */ Class getPrimitiveClass$default(IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilsKt.getPrimitiveClass(irType, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> getArgsForMethodInvocation(@NotNull IrFunction $this$getArgsForMethodInvocation, @NotNull List<Variable> args) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getArgsForMethodInvocation, (String)"$this$getArgsForMethodInvocation");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            Variable variable2 = (Variable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            State state = it.getState();
            if (state instanceof ExceptionState) {
                object = ((ExceptionState)state).getThisAsCauseForException();
            } else if (state instanceof Wrapper) {
                object = ((Wrapper)state).getValue();
            } else if (state instanceof Primitive) {
                object = ((Primitive)state).getValue();
            } else {
                throw (Throwable)((Object)new AssertionError((Object)(Reflection.getOrCreateKotlinClass(state.getClass()) + " is unsupported as argument for wrapper method invocation")));
            }
            ExceptionState.ExceptionData exceptionData = object;
            collection.add(exceptionData);
        }
        List argsValues = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.lastOrNull($this$getArgsForMethodInvocation.getValueParameters());
        if ((irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null) {
            Object varargValue = CollectionsKt.last((List)argsValues);
            argsValues.remove(argsValues.size() - 1);
            Object object = varargValue;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<out kotlin.Any?>");
            }
            CollectionsKt.addAll((Collection)argsValues, (Object[])((Object[])object));
        }
        return argsValues;
    }

    @NotNull
    public static final IrFunction getLastOverridden(@NotNull IrFunction $this$getLastOverridden) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastOverridden, (String)"$this$getLastOverridden");
        if (!($this$getLastOverridden instanceof IrSimpleFunction)) {
            return $this$getLastOverridden;
        }
        return (IrFunction)SequencesKt.last((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.generateSequence((Object)CollectionsKt.listOf((Object)$this$getLastOverridden), (Function1)getLastOverridden.1.INSTANCE)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Primitive<?> toPrimitiveStateArray(@NotNull List<? extends Object> $this$toPrimitiveStateArray, @NotNull IrType type2) {
        Primitive<boolean[]> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitiveStateArray, (String)"$this$toPrimitiveStateArray");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (IrTypePredicatesKt.isByteArray(type2)) {
            byte[] byArray;
            int n = $this$toPrimitiveStateArray.size();
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byte by;
                void i;
                int n3 = n2;
                int n4 = n2++;
                byArray = byArray2;
                boolean bl = false;
                Object object = $this$toPrimitiveStateArray.get((int)i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                byArray[n4] = by = ((Number)object).byteValue();
            }
            byArray = byArray2;
            IrType irType = type2;
            byte[] byArray3 = byArray;
            primitive = new Primitive<boolean[]>((boolean[])byArray3, irType);
        } else if (IrTypePredicatesKt.isCharArray(type2)) {
            char[] cArray;
            int n = $this$toPrimitiveStateArray.size();
            char[] cArray2 = new char[n];
            int n5 = 0;
            while (n5 < n) {
                char c;
                int i = n5;
                int n6 = n5++;
                cArray = cArray2;
                boolean bl = false;
                Object object = $this$toPrimitiveStateArray.get(i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                }
                cArray[n6] = c = ((Character)object).charValue();
            }
            cArray = cArray2;
            IrType irType = type2;
            char[] cArray3 = cArray;
            primitive = new Primitive<boolean[]>((boolean[])cArray3, irType);
        } else if (IrTypePredicatesKt.isShortArray(type2)) {
            short[] sArray;
            int n = $this$toPrimitiveStateArray.size();
            short[] sArray2 = new short[n];
            int n7 = 0;
            while (n7 < n) {
                short s;
                int i = n7;
                int n8 = n7++;
                sArray = sArray2;
                boolean bl = false;
                Object object = $this$toPrimitiveStateArray.get(i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                sArray[n8] = s = ((Number)object).shortValue();
            }
            sArray = sArray2;
            IrType irType = type2;
            short[] sArray3 = sArray;
            primitive = new Primitive<boolean[]>((boolean[])sArray3, irType);
        } else if (IrTypePredicatesKt.isIntArray(type2)) {
            int[] nArray;
            int n = $this$toPrimitiveStateArray.size();
            int[] nArray2 = new int[n];
            int n9 = 0;
            while (n9 < n) {
                int n10;
                int i = n9;
                int n11 = n9++;
                nArray = nArray2;
                boolean bl = false;
                Object object = $this$toPrimitiveStateArray.get(i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                nArray[n11] = n10 = ((Number)object).intValue();
            }
            nArray = nArray2;
            IrType irType = type2;
            int[] nArray3 = nArray;
            primitive = new Primitive<boolean[]>((boolean[])nArray3, irType);
        } else if (IrTypePredicatesKt.isLongArray(type2)) {
            long[] lArray;
            int n = $this$toPrimitiveStateArray.size();
            long[] lArray2 = new long[n];
            int n12 = 0;
            while (n12 < n) {
                long l;
                int i = n12;
                int n13 = n12++;
                lArray = lArray2;
                boolean bl = false;
                Object object = $this$toPrimitiveStateArray.get(i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                lArray[n13] = l = ((Number)object).longValue();
            }
            lArray = lArray2;
            IrType irType = type2;
            long[] lArray3 = lArray;
            primitive = new Primitive<boolean[]>((boolean[])lArray3, irType);
        } else if (IrTypePredicatesKt.isFloatArray(type2)) {
            float[] fArray;
            int n = $this$toPrimitiveStateArray.size();
            float[] fArray2 = new float[n];
            int n14 = 0;
            while (n14 < n) {
                float f;
                int i = n14;
                int n15 = n14++;
                fArray = fArray2;
                boolean bl = false;
                Object object = $this$toPrimitiveStateArray.get(i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                fArray[n15] = f = ((Number)object).floatValue();
            }
            fArray = fArray2;
            IrType irType = type2;
            float[] fArray3 = fArray;
            primitive = new Primitive<boolean[]>((boolean[])fArray3, irType);
        } else if (IrTypePredicatesKt.isDoubleArray(type2)) {
            double[] dArray;
            int n = $this$toPrimitiveStateArray.size();
            double[] dArray2 = new double[n];
            int n16 = 0;
            while (n16 < n) {
                double d;
                int i = n16;
                int n17 = n16++;
                dArray = dArray2;
                boolean bl = false;
                Object object = $this$toPrimitiveStateArray.get(i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                dArray[n17] = d = ((Number)object).doubleValue();
            }
            dArray = dArray2;
            IrType irType = type2;
            double[] dArray3 = dArray;
            primitive = new Primitive<boolean[]>((boolean[])dArray3, irType);
        } else if (IrTypePredicatesKt.isBooleanArray(type2)) {
            boolean[] blArray;
            int n = $this$toPrimitiveStateArray.size();
            boolean[] blArray2 = new boolean[n];
            int n18 = 0;
            while (n18 < n) {
                boolean bl;
                int i = n18;
                int n19 = n18++;
                blArray = blArray2;
                boolean bl2 = false;
                String string2 = String.valueOf($this$toPrimitiveStateArray.get(i));
                boolean bl3 = false;
                blArray[n19] = bl = Boolean.parseBoolean(string2);
            }
            blArray = blArray2;
            IrType irType = type2;
            boolean[] blArray3 = blArray;
            primitive = new Primitive<boolean[]>(blArray3, irType);
        } else {
            Collection $this$toTypedArray$iv = $this$toPrimitiveStateArray;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            primitive = new Primitive<Object[]>(objectArray, type2);
        }
        return primitive;
    }

    @Nullable
    public static final IrType getVarargType(@NotNull IrFunctionAccessExpression $this$getVarargType, int index2) {
        Intrinsics.checkNotNullParameter((Object)$this$getVarargType, (String)"$this$getVarargType");
        IrType irType = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getVarargElementType();
        if (irType == null) {
            return null;
        }
        IrType varargType = irType;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(varargType);
        if (irClassSymbol != null) {
            IrClassSymbol irClassSymbol2 = irClassSymbol;
            boolean bl = false;
            boolean bl2 = false;
            IrClassSymbol it = irClassSymbol2;
            boolean bl3 = false;
            return ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getType();
        }
        IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(varargType).getOwner();
        if (irSymbolOwner == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrTypeParameter");
        }
        IrTypeParameter typeParameter = (IrTypeParameter)irSymbolOwner;
        return $this$getVarargType.getTypeArgument(typeParameter.getIndex());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Variable> getTypeArguments(@NotNull IrTypeParametersContainer container2, @NotNull IrFunctionAccessExpression expression2, @NotNull Function1<? super IrTypeParameterSymbol, ? extends State> mapper) {
        List typeArguments2;
        block4: {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            Function1<IrType, State> $fun$getState$1 = new Function1<IrType, State>(mapper){
                final /* synthetic */ Function1 $mapper;

                @NotNull
                public final State invoke(@NotNull IrType $this$getState) {
                    State state;
                    Intrinsics.checkNotNullParameter((Object)$this$getState, (String)"$this$getState");
                    Object object = IrTypesKt.getClassOrNull($this$getState);
                    if (object != null && (object = (IrClass)object.getOwner()) != null) {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        state = new Common((IrClass)it);
                    } else {
                        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail($this$getState);
                        if (irClassifierSymbol == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol");
                        }
                        state = (State)this.$mapper.invoke((Object)((IrTypeParameterSymbol)irClassifierSymbol));
                    }
                    return state;
                }
                {
                    this.$mapper = function1;
                    super(1);
                }
            };
            Iterable $this$mapIndexed$iv = container2.getTypeParameters();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                IrType typeArgument;
                void typeParameter;
                void index2;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)expression2.getTypeArgument((int)index2));
                Variable variable2 = new Variable((IrSymbol)typeParameter.getSymbol(), $fun$getState$1.invoke(typeArgument));
                collection.add(variable2);
            }
            typeArguments2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            if (!(container2 instanceof IrSimpleFunction)) break block4;
            IrSymbolOwner $this$safeAs$iv = IrTypesKt.getClassifierOrFail(((IrSimpleFunction)container2).getReturnType()).getOwner();
            boolean $i$f$safeAs = false;
            IrSymbolOwner irSymbolOwner = $this$safeAs$iv;
            if (!(irSymbolOwner instanceof IrTypeParameter)) {
                irSymbolOwner = null;
            }
            IrTypeParameter irTypeParameter = (IrTypeParameter)irSymbolOwner;
            if (irTypeParameter != null) {
                IrTypeParameter irTypeParameter2 = irTypeParameter;
                boolean bl = false;
                boolean bl3 = false;
                IrTypeParameter it = irTypeParameter2;
                boolean bl4 = false;
                typeArguments2.add(new Variable((IrSymbol)it.getSymbol(), $fun$getState$1.invoke(expression2.getType())));
            }
        }
        return typeArguments2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Variable> extractNonLocalDeclarations(@Nullable State $this$extractNonLocalDeclarations) {
        void $this$filterTo$iv$iv;
        if ($this$extractNonLocalDeclarations == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        State state = $this$extractNonLocalDeclarations;
        boolean bl = false;
        boolean bl2 = false;
        State it = state;
        boolean bl3 = false;
        State state2 = !(it instanceof Complex) ? state : null;
        if (state2 == null) {
            state2 = ((Complex)$this$extractNonLocalDeclarations).getOriginal();
        }
        State state3 = state2;
        Iterable $this$filter$iv = state3.getFields();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Variable it2 = (Variable)element$iv$iv;
            boolean bl4 = false;
            if (!(!(it2.getSymbol() instanceof IrFieldSymbol))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final State getCorrectReceiverByFunction(@Nullable State $this$getCorrectReceiverByFunction, @NotNull IrFunction irFunction) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            if (!($this$getCorrectReceiverByFunction instanceof Complex)) {
                return $this$getCorrectReceiverByFunction;
            }
            Complex original = ((Complex)$this$getCorrectReceiverByFunction).getOriginal();
            IrDeclarationBase irDeclarationBase = IrUtilsKt.getParentClassOrNull(irFunction);
            if (irDeclarationBase == null || (irDeclarationBase = irDeclarationBase.getThisReceiver()) == null) {
                return $this$getCorrectReceiverByFunction;
            }
            IrDeclarationBase other = irDeclarationBase;
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)original, (Function1)getCorrectReceiverByFunction.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Complex it = (Complex)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIrClass().getThisReceiver(), (Object)other)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Complex complex = v1;
        return complex != null ? (State)complex : $this$getCorrectReceiverByFunction;
    }

    @NotNull
    public static final String getCapitalizedFileName(@NotNull IrFunction $this$getCapitalizedFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$getCapitalizedFileName, (String)"$this$getCapitalizedFileName");
        return StringsKt.capitalize((String)StringsKt.replace$default((String)IrFileKt.getName(IrUtilsKt.getFile($this$getCapitalizedFileName)), (String)".kt", (String)"Kt", (boolean)false, (int)4, null));
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsigned, (String)"$this$isUnsigned");
        return IrTypePredicatesKt.isUByte($this$isUnsigned) || IrTypePredicatesKt.isUShort($this$isUnsigned) || IrTypePredicatesKt.isUInt($this$isUnsigned) || IrTypePredicatesKt.isULong($this$isUnsigned);
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"$this$isPrimitiveArray");
        Object object = IrTypesKt.getClass($this$isPrimitiveArray);
        if (object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
            Object object2 = object;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object2;
            boolean bl4 = false;
            Object object3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it");
            bl = StandardNames.isPrimitiveArray((FqNameUnsafe)object3);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"$this$isFunction");
        Object object = IrTypesKt.getClass($this$isFunction);
        return object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).asString()) != null ? StringsKt.startsWith$default((String)object, (String)"kotlin.Function", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeParameter, (String)"$this$isTypeParameter");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterface, (String)"$this$isInterface");
        Object object = IrTypesKt.getClassOrNull($this$isInterface);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        Intrinsics.checkNotNullParameter((Object)$this$isThrowable, (String)"$this$isThrowable");
        Object object = IrTypesKt.getClass($this$isThrowable);
        return Intrinsics.areEqual(object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null ? ((FqName)object).asString() : null, (Object)"kotlin.Throwable");
    }

    @NotNull
    public static final String internalName(@NotNull IrClass $this$internalName) {
        Intrinsics.checkNotNullParameter((Object)$this$internalName, (String)"$this$internalName");
        StringBuilder internalName2 = new StringBuilder($this$internalName.getName().asString());
        IrClass irClass2 = $this$internalName;
        if (!(irClass2 instanceof IrDeclarationParent)) {
            irClass2 = null;
        }
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)irClass2, (Function1)internalName.1.INSTANCE), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclarationParent it = (IrDeclarationParent)element$iv;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it;
            if (irDeclarationParent instanceof IrClass) {
                internalName2.insert(0, ((IrClass)it).getName().asString() + "$");
                continue;
            }
            if (!(irDeclarationParent instanceof IrPackageFragment)) continue;
            String string2 = ((IrPackageFragment)it).getFqName().asString();
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string2;
            boolean bl4 = false;
            String string3 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
            CharSequence charSequence = string3;
            boolean bl5 = false;
            String string4 = charSequence.length() > 0 ? string2 : null;
            if (string4 == null) continue;
            string2 = string4;
            bl2 = false;
            bl3 = false;
            it2 = string2;
            boolean bl6 = false;
            internalName2.insert(0, it2 + '.');
        }
        String string5 = internalName2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"internalName.toString()");
        return string5;
    }
}

