/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer$WhenMappings;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J$\u0010\u0018\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u00192\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001a2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002002\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u00101\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002022\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002062\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002082\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020:2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\f\u0010;\u001a\u00020<*\u00020=H\u0002\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "()V", "binaryOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "operator", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;", "data", "postfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "prefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "toDoubleConst", "", "f", "", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "context", "visitConst", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDynamicMemberExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "visitDynamicOperatorExpression", "visitExpressionBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "isThisReceiver", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "backend.js"})
public final class IrElementToJsExpressionTransformer
implements BaseIrElementToJsNodeTransformer<JsExpression, JsGenerationContext> {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext context2) {
        Collection<JsExpression> collection;
        void $this$mapTo$iv$iv;
        boolean bl;
        boolean $i$f$none;
        block5: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Iterable $this$none$iv = expression2.getElements();
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv22 : $this$none$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv22;
                    boolean bl2 = false;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        boolean $this$none$iv = bl;
        $i$f$none = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !$this$none$iv) {
            boolean element$iv22 = false;
            String element$iv22 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)element$iv22));
        }
        Iterable $this$map$iv = expression2.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            JsExpression jsExpression = (JsExpression)it.accept(this, context2);
            collection.add(jsExpression);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsArrayLiteral(list2);
    }

    @Override
    @NotNull
    public JsExpression visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return (JsExpression)body2.getExpression().accept(this, context2);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrSimpleFunction irFunction = expression2.getFunction();
        Object r = irFunction.accept(new IrFunctionToJsTransformer(), context2);
        boolean bl = false;
        boolean bl2 = false;
        JsFunction $this$apply = (JsFunction)r;
        boolean bl3 = false;
        $this$apply.setName(null);
        return (JsExpression)r;
    }

    @Override
    @NotNull
    public <T> JsExpression visitConst(@NotNull IrConst<T> expression2, @NotNull JsGenerationContext context2) {
        JsExpression jsExpression;
        IrConstKind<T> kind;
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrConstKind<T> irConstKind = kind = expression2.getKind();
        if (irConstKind instanceof IrConstKind.String) {
            jsExpression = new JsStringLiteral((String)((IrConstKind.String)kind).valueOf(expression2));
        } else if (irConstKind instanceof IrConstKind.Null) {
            jsExpression = new JsNullLiteral();
        } else if (irConstKind instanceof IrConstKind.Boolean) {
            jsExpression = new JsBooleanLiteral((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2));
        } else if (irConstKind instanceof IrConstKind.Byte) {
            jsExpression = new JsIntLiteral(((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue());
        } else if (irConstKind instanceof IrConstKind.Short) {
            jsExpression = new JsIntLiteral(((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue());
        } else if (irConstKind instanceof IrConstKind.Int) {
            jsExpression = new JsIntLiteral(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue());
        } else {
            if (irConstKind instanceof IrConstKind.Long) {
                throw (Throwable)new IllegalStateException("Long const should have been lowered at this point");
            }
            if (irConstKind instanceof IrConstKind.Char) {
                throw (Throwable)new IllegalStateException("Char const should have been lowered at this point");
            }
            if (irConstKind instanceof IrConstKind.Float) {
                jsExpression = new JsDoubleLiteral(this.toDoubleConst(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue()));
            } else if (irConstKind instanceof IrConstKind.Double) {
                jsExpression = new JsDoubleLiteral(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsExpression;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final double toDoubleConst(float f) {
        double d;
        float f2 = f;
        boolean bl = false;
        if (!Float.isInfinite(f2)) {
            f2 = f;
            bl = false;
            if (!Float.isNaN(f2)) {
                String string2 = String.valueOf(f);
                bl = false;
                d = Double.parseDouble(string2);
                return d;
            }
        }
        d = f;
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext context2) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable iterable = expression2.getArguments();
        JsStringLiteral initial$iv = new JsStringLiteral("");
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void irExpr;
            IrExpression irExpression = (IrExpression)element$iv;
            JsExpression jsExpr = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.ADD, jsExpr, (JsExpression)irExpr.accept(this, context2));
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public JsExpression visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrFieldSymbol symbol2 = expression2.getSymbol();
        IrField field = (IrField)symbol2.getOwner();
        IrDeclarationParent fieldParent = field.getParent();
        if (fieldParent instanceof IrClass && IrUtilsKt.isEffectivelyExternal(field)) {
            boolean bl = IrUtilsKt.isEnumClass((IrClass)fieldParent);
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = RenderIrElementKt.render(field) + " in non-external class " + RenderIrElementKt.render(fieldParent);
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            return new JsNameRef(AnnotationUtilsKt.getJsNameOrKotlinName(field).getIdentifier(), (JsExpression)context2.getNameForClass((IrClass)fieldParent).makeRef());
        }
        if (fieldParent instanceof IrClass && ((IrClass)fieldParent).isInline()) {
            IrExpression irExpression = expression2.getReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            return (JsExpression)irExpression.accept(this, context2);
        }
        JsName fieldName = context2.getNameForField(field);
        IrExpression irExpression = expression2.getReceiver();
        return new JsNameRef(fieldName, irExpression != null ? (JsExpression)irExpression.accept(this, context2) : null);
    }

    @Override
    @NotNull
    public JsExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isThisReceiver(expression2.getSymbol().getOwner())) {
            return new JsThisRef();
        }
        JsNameRef jsNameRef = context2.getNameForValueDeclaration(expression2.getSymbol().getOwner()).makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"context.getNameForValueD\u2026n.symbol.owner).makeRef()");
        return jsNameRef;
    }

    @Override
    @NotNull
    public JsExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrClass obj = (IrClass)expression2.getSymbol().getOwner();
        boolean bl = obj.getKind() == ClassKind.OBJECT;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        bl = IrUtilsKt.isEffectivelyExternal(obj);
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Non external IrGetObjectValue must be lowered";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        if (obj.isCompanion() && IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass(obj))) {
            return new JsNullLiteral();
        }
        return context2.getRefForExternalClass(obj);
    }

    @Override
    @NotNull
    public JsExpression visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsName fieldName = context2.getNameForField((IrField)expression2.getSymbol().getOwner());
        IrExpression irExpression = expression2.getReceiver();
        JsNameRef dest = new JsNameRef(fieldName, irExpression != null ? (JsExpression)irExpression.accept(this, context2) : null);
        JsExpression source = (JsExpression)expression2.getValue().accept(this, context2);
        return JsAstUtilsKt.jsAssignment(dest, source);
    }

    @Override
    @NotNull
    public JsExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsNameRef ref = new JsNameRef(context2.getNameForValueDeclaration(expression2.getSymbol().getOwner()));
        JsExpression value2 = (JsExpression)expression2.getValue().accept(this, context2);
        return new JsBinaryOperation(JsBinaryOperator.ASG, ref, value2);
    }

    @Override
    @NotNull
    public JsExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsNameRef jsNameRef = context2.getNameForConstructor((IrConstructor)expression2.getSymbol().getOwner()).makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"context.getNameForConstr\u2026n.symbol.owner).makeRef()");
        JsNameRef classNameRef = jsNameRef;
        JsNameRef callFuncRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)classNameRef);
        boolean fromPrimary = context2.getCurrentFunction() instanceof IrConstructor;
        if (fromPrimary) {
            jsExpression = new JsThisRef();
        } else {
            IrFunction irFunction = context2.getCurrentFunction();
            Intrinsics.checkNotNull((Object)irFunction);
            JsNameRef jsNameRef2 = context2.getNameForValueDeclaration((IrValueDeclaration)CollectionsKt.last(irFunction.getValueParameters())).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"context.getNameForValueD\u2026ameters.last()).makeRef()");
            jsExpression = jsNameRef2;
        }
        JsExpression thisRef = jsExpression;
        List<JsExpression> arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context2, this);
        IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
        if (IrUtilsKt.getParentAsClass(constructor2).isInline()) {
            boolean bl = constructor2.isPrimary();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Delegation to secondary inline constructors must be lowered into simple function calls";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            return new JsBinaryOperation(JsBinaryOperator.ASG, thisRef, (JsExpression)CollectionsKt.single(arguments2));
        }
        return context2.getStaticContext().getBackendContext().getEs6mode() ? (JsExpression)new JsInvocation((JsExpression)new JsNameRef("super"), arguments2) : (JsExpression)new JsInvocation((JsExpression)callFuncRef, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)thisRef), (Iterable)arguments2));
    }

    @Override
    @NotNull
    public JsExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext context2) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
        List<JsExpression> arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context2, this);
        IrClass klass = IrUtilsKt.getParentAsClass(function2);
        if (klass.isInline()) {
            boolean bl = function2.isPrimary();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Inline class secondary constructors must be lowered into static methods";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            jsExpression = (JsExpression)CollectionsKt.single(arguments2);
        } else {
            JsNameRef jsNameRef;
            if (IrUtilsKt.isEffectivelyExternal(klass)) {
                jsNameRef = context2.getRefForExternalClass(klass);
            } else {
                JsNameRef jsNameRef2 = context2.getNameForClass(klass).makeRef();
                jsNameRef = jsNameRef2;
                Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"context.getNameForClass(klass).makeRef()");
            }
            JsNameRef ref = jsNameRef;
            jsExpression = new JsNew(ref, arguments2);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.checkIfJsCode(expression2.getSymbol())) {
            IrExpression irExpression = expression2.getValueArgument(0);
            if (irExpression == null) {
                String string2 = "JsCode is expected";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            List<JsStatement> statements2 = JsCodeKt.translateJsCodeIntoStatementList(irExpression);
            if (statements2.isEmpty()) {
                return new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(3));
            }
            JsStatement lastStatement = (JsStatement)CollectionsKt.last(statements2);
            if (statements2.size() == 1 && lastStatement instanceof JsExpressionStatement) {
                JsExpression jsExpression = ((JsExpressionStatement)lastStatement).getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"lastStatement.expression");
                return jsExpression;
            }
            List newStatements = CollectionsKt.toMutableList((Collection)statements2);
            JsStatement jsStatement = lastStatement;
            if (!(jsStatement instanceof JsReturn)) {
                if (jsStatement instanceof JsExpressionStatement) {
                    newStatements.set(CollectionsKt.getLastIndex(statements2), new JsReturn(((JsExpressionStatement)lastStatement).getExpression()));
                } else {
                    Collection collection = newStatements;
                    JsReturn jsReturn = new JsReturn(new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(3)));
                    boolean bl = false;
                    collection.add(jsReturn);
                }
            }
            JsFunction syntheticFunction = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(newStatements), "");
            return new JsInvocation((JsExpression)syntheticFunction, new JsExpression[0]);
        }
        return JsAstUtilsKt.translateCall(expression2, context2, this);
    }

    @Override
    @NotNull
    public JsExpression visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrBranch lastBranch = (IrBranch)CollectionsKt.lastOrNull(expression2.getBranches());
        JsPrefixOperation implicitElse = lastBranch == null || !org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isElseBranch(lastBranch) ? new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(0)) : null;
        boolean bl = implicitElse == null || IrTypePredicatesKt.isUnit(expression2.getType());
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Non unit when-expression must have else branch";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        JsNode jsNode = JsAstUtilsKt.toJsNode(expression2, this, context2, visitWhen.2.INSTANCE, (JsNode)implicitElse);
        Intrinsics.checkNotNull((Object)jsNode);
        return (JsExpression)jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        switch (IrElementToJsExpressionTransformer$WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                break;
            }
            default: {
                String string2 = "All type operator calls except REINTERPRET_CAST should be lowered at this point: " + (Object)((Object)expression2.getOperator());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return (JsExpression)expression2.getArgument().accept(this, data);
    }

    @Override
    @NotNull
    public JsExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new JsNameRef(expression2.getMemberName(), (JsExpression)expression2.getReceiver().accept(this, data));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        switch (IrElementToJsExpressionTransformer$WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                jsExpression = this.prefixOperation(JsUnaryOperator.POS, expression2, data);
                break;
            }
            case 2: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NEG, expression2, data);
                break;
            }
            case 3: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NOT, expression2, data);
                break;
            }
            case 4: {
                jsExpression = this.prefixOperation(JsUnaryOperator.INC, expression2, data);
                break;
            }
            case 5: {
                jsExpression = this.prefixOperation(JsUnaryOperator.DEC, expression2, data);
                break;
            }
            case 6: {
                jsExpression = this.postfixOperation(JsUnaryOperator.INC, expression2, data);
                break;
            }
            case 7: {
                jsExpression = this.postfixOperation(JsUnaryOperator.DEC, expression2, data);
                break;
            }
            case 8: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ADD, expression2, data);
                break;
            }
            case 9: {
                jsExpression = this.binaryOperation(JsBinaryOperator.SUB, expression2, data);
                break;
            }
            case 10: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MUL, expression2, data);
                break;
            }
            case 11: {
                jsExpression = this.binaryOperation(JsBinaryOperator.DIV, expression2, data);
                break;
            }
            case 12: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MOD, expression2, data);
                break;
            }
            case 13: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GT, expression2, data);
                break;
            }
            case 14: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LT, expression2, data);
                break;
            }
            case 15: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GTE, expression2, data);
                break;
            }
            case 16: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LTE, expression2, data);
                break;
            }
            case 17: {
                jsExpression = this.binaryOperation(JsBinaryOperator.EQ, expression2, data);
                break;
            }
            case 18: {
                jsExpression = this.binaryOperation(JsBinaryOperator.NEQ, expression2, data);
                break;
            }
            case 19: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_EQ, expression2, data);
                break;
            }
            case 20: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_NEQ, expression2, data);
                break;
            }
            case 21: {
                jsExpression = this.binaryOperation(JsBinaryOperator.AND, expression2, data);
                break;
            }
            case 22: {
                jsExpression = this.binaryOperation(JsBinaryOperator.OR, expression2, data);
                break;
            }
            case 23: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG, expression2, data);
                break;
            }
            case 24: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_ADD, expression2, data);
                break;
            }
            case 25: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_SUB, expression2, data);
                break;
            }
            case 26: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MUL, expression2, data);
                break;
            }
            case 27: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_DIV, expression2, data);
                break;
            }
            case 28: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MOD, expression2, data);
                break;
            }
            case 29: {
                jsExpression = new JsArrayAccess((JsExpression)IrDynamicExpressionKt.getLeft(expression2).accept(this, data), (JsExpression)IrDynamicExpressionKt.getRight(expression2).accept(this, data));
                break;
            }
            case 30: {
                Collection<JsExpression> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = expression2.getArguments();
                JsExpression jsExpression2 = (JsExpression)expression2.getReceiver().accept(this, data);
                boolean $i$f$map = false;
                void var5_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrExpression irExpression = (IrExpression)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    JsExpression jsExpression3 = (JsExpression)it.accept(this, data);
                    collection.add(jsExpression3);
                }
                collection = (List)destination$iv$iv;
                List list2 = collection;
                JsExpression jsExpression4 = jsExpression2;
                jsExpression = new JsInvocation(jsExpression4, list2);
                break;
            }
            default: {
                String string2 = "Unexpected operator " + (Object)((Object)expression2.getOperator()) + ": " + RenderIrElementKt.render(expression2);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull JsGenerationContext data) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrFunction function2 = expression2.getSymbol().getOwner();
        if (function2 instanceof IrConstructor) {
            jsName = data.getNameForConstructor((IrConstructor)function2);
        } else if (function2 instanceof IrSimpleFunction) {
            jsName = data.getNameForStaticFunction((IrSimpleFunction)function2);
        } else {
            String string2 = "Unexpected function kind";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        JsName name = jsName;
        return new JsNameRef(name);
    }

    private final JsPrefixOperation prefixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsPrefixOperation(operator, (JsExpression)expression2.getReceiver().accept(this, data));
    }

    private final JsPostfixOperation postfixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsPostfixOperation(operator, (JsExpression)expression2.getReceiver().accept(this, data));
    }

    private final JsBinaryOperation binaryOperation(JsBinaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsBinaryOperation(operator, (JsExpression)IrDynamicExpressionKt.getLeft(expression2).accept(this, data), (JsExpression)IrDynamicExpressionKt.getRight(expression2).accept(this, data));
    }

    private final boolean isThisReceiver(IrValueDeclaration $this$isThisReceiver) {
        IrDeclarationParent p = $this$isThisReceiver.getParent();
        return p instanceof IrSimpleFunction ? $this$isThisReceiver == ((IrSimpleFunction)p).getDispatchReceiverParameter() : (p instanceof IrClass ? $this$isThisReceiver == ((IrClass)p).getThisReceiver() : false);
    }

    @Override
    @NotNull
    public JsExpression visitElement(@NotNull IrElement element, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public JsExpression visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBlockBody(@NotNull IrBlockBody body2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBody(@NotNull IrBody body2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsExpression visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)aCatch, (String)"aCatch");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public JsExpression visitClass(@NotNull IrClass declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitConstructor(@NotNull IrConstructor declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitDeclaration(@NotNull IrDeclarationBase declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitField(@NotNull IrField declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFile(@NotNull IrFile declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunction(@NotNull IrFunction declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitProperty(@NotNull IrProperty declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitScript(@NotNull IrScript declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitScript(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)spread, (String)"spread");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public JsExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsExpression visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    @NotNull
    public JsExpression visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitVariable(@NotNull IrVariable declaration2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    @NotNull
    public JsExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
    }
}

