/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/IncrementalFileToPathConverter;", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "rootProjectDir", "Ljava/io/File;", "(Ljava/io/File;)V", "projectDirPath", "", "getRootProjectDir", "()Ljava/io/File;", "toFile", "path", "toPath", "file", "Companion", "kotlin-build-common"})
public class IncrementalFileToPathConverter
implements FileToPathConverter {
    private final String projectDirPath;
    @Nullable
    private final File rootProjectDir;
    @NotNull
    private static final Companion Companion = new Companion(null);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String toPath(@NotNull File file2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String path2 = FilesKt.normalize((File)file2).getAbsolutePath();
        if (this.projectDirPath != null) {
            String string3 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
            if (StringsKt.startsWith$default((String)string3, (String)this.projectDirPath, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder2 = new StringBuilder().append("$PROJECT_DIR$");
                String string4 = path2;
                int n = this.projectDirPath.length();
                boolean bl = false;
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                string2 = stringBuilder2.append(string5).toString();
                return string2;
            }
        }
        String string6 = path2;
        string2 = string6;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"path");
        return string2;
    }

    @Override
    @NotNull
    public File toFile(@NotNull String path2) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (this.rootProjectDir != null && StringsKt.startsWith$default((String)path2, (String)"$PROJECT_DIR$", (boolean)false, (int)2, null)) {
            String string2 = path2;
            int n = "$PROJECT_DIR$/".length();
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            file2 = FilesKt.resolve((File)this.rootProjectDir, (String)string3);
        } else {
            file2 = new File(path2);
        }
        return file2;
    }

    @Nullable
    public final File getRootProjectDir() {
        return this.rootProjectDir;
    }

    public IncrementalFileToPathConverter(@Nullable File rootProjectDir) {
        this.rootProjectDir = rootProjectDir;
        File file2 = this.rootProjectDir;
        this.projectDirPath = file2 != null && (file2 = FilesKt.normalize((File)file2)) != null ? file2.getAbsolutePath() : null;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/IncrementalFileToPathConverter$Companion;", "", "()V", "PATH_PREFIX", "", "PROJECT_DIR_PLACEHOLDER", "kotlin-build-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

