/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\r\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J.\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00182\b\b\u0002\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u0018H\u0007J$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\t2\b\b\u0002\u0010\u001c\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u0018H\u0007J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J \u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0002R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "functionResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lkotlin/jvm/functions/Function1;)V", "getFunctionDescriptor", "findMainFunction", "Lkotlin/internal/NoInfer;", "declarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMainFunction", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "hasMain", "", "isMain", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkJvmStaticAnnotation", "checkReturnType", "allowParameterless", "function", "isMainWithParameter", "declaration", "isParameterNumberSuitsForMain", "parametersCount", "", "isTopLevel", "Companion", "frontend"})
public final class MainFunctionDetector {
    private final Function1<KtNamedFunction, FunctionDescriptor> getFunctionDescriptor;
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean hasMain(@NotNull List<? extends KtDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        return this.findMainFunction(declarations2) != null;
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2, boolean checkJvmStaticAnnotation, boolean allowParameterless) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (function2.isLocal()) {
            return false;
        }
        int parametersCount = function2.getValueParameters().size();
        if (function2.getReceiverTypeReference() != null) {
            ++parametersCount;
        }
        if (!this.isParameterNumberSuitsForMain(parametersCount, function2.isTopLevel(), allowParameterless)) {
            return false;
        }
        if (!function2.getTypeParameters().isEmpty()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"main", (Object)function2.getName()) ^ true && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 1)) {
            return false;
        }
        if (checkJvmStaticAnnotation && !function2.isTopLevel() && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 0)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.getFunctionDescriptor.invoke((Object)function2);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        return MainFunctionDetector.isMain$default(this, functionDescriptor2, checkJvmStaticAnnotation, false, allowParameterless, 4, null);
    }

    public static /* synthetic */ boolean isMain$default(MainFunctionDetector mainFunctionDetector, KtNamedFunction ktNamedFunction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return mainFunctionDetector.isMain(ktNamedFunction, bl, bl2);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2, boolean checkJvmStaticAnnotation) {
        return MainFunctionDetector.isMain$default(this, function2, checkJvmStaticAnnotation, false, 4, null);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull KtNamedFunction function2) {
        return MainFunctionDetector.isMain$default(this, function2, false, false, 6, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation, boolean checkReturnType, boolean allowParameterless) {
        Collection it;
        boolean bl;
        void destination$iv2;
        Object $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)MainFunctionDetector.Companion.getJVMFunctionName((FunctionDescriptor)descriptor2), (Object)"main") ^ true) {
            return false;
        }
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
        Iterable iterable = list2;
        boolean bl2 = false;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv = iterator2.next();
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            void var13_26 = destination$iv2;
            bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            KotlinType kotlinType = v1.getType();
            var13_26.add(kotlinType);
        }
        List parameters2 = (List)destination$iv2;
        Annotated annotated = ((FunctionDescriptor)descriptor2).getExtensionReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            $this$mapTo$iv = annotated;
            boolean destination$iv2 = false;
            $i$f$mapTo = false;
            Annotated annotated2 = $this$mapTo$iv;
            boolean bl3 = false;
            it = parameters2;
            bl = false;
            it.add(annotated2);
        }
        if (!this.isParameterNumberSuitsForMain(parameters2.size(), DescriptorUtils.isTopLevelDeclaration(descriptor2), allowParameterless)) {
            return false;
        }
        List<TypeParameterDescriptor> list3 = ((FunctionDescriptor)descriptor2).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"descriptor.typeParameters");
        $this$mapTo$iv = list3;
        boolean destination$iv2 = false;
        if (!$this$mapTo$iv.isEmpty()) {
            return false;
        }
        boolean bl4 = false;
        if (bl4) {
            return false;
        }
        if (parameters2.size() == 1) {
            Object e = parameters2.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"parameters[0]");
            KotlinType parameterType = (KotlinType)e;
            if (!KotlinBuiltIns.isArray(parameterType)) {
                return false;
            }
            List<TypeProjection> typeArguments2 = parameterType.getArguments();
            if (typeArguments2.size() != 1) {
                return false;
            }
            KotlinType kotlinType = typeArguments2.get(0).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"typeArguments[0].type");
            KotlinType typeArgument = kotlinType;
            if (!KotlinBuiltIns.isString(typeArgument)) {
                return false;
            }
            if (typeArguments2.get(0).getProjectionKind() == Variance.IN_VARIANCE) {
                return false;
            }
        } else {
            boolean parameterType = parameters2.size() == 0;
            boolean typeArguments2 = false;
            if (_Assertions.ENABLED && !parameterType) {
                boolean $i$a$-assert-MainFunctionDetector$isMain$42 = false;
                String $i$a$-assert-MainFunctionDetector$isMain$42 = "Parameter list is expected to be empty";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-MainFunctionDetector$isMain$42));
            }
            parameterType = DescriptorUtils.isTopLevelDeclaration(descriptor2);
            typeArguments2 = false;
            if (_Assertions.ENABLED && !parameterType) {
                boolean $i$a$-assert-MainFunctionDetector$isMain$52 = false;
                String $i$a$-assert-MainFunctionDetector$isMain$52 = "main without parameters works only for top-level";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-MainFunctionDetector$isMain$52));
            }
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            if (Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName().asString(), (Object)"main") ^ true) {
                return false;
            }
            Object object = containingFile;
            if (object != null && (object = ((KtFile)object).getDeclarations()) != null) {
                boolean bl5;
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtDeclaration declaration2 = (KtDeclaration)element$iv;
                        boolean bl6 = false;
                        if (!this.isMainWithParameter(declaration2, checkJvmStaticAnnotation)) continue;
                        return false;
                    }
                    bl5 = false;
                }
                if (bl5) {
                    return false;
                }
            }
        }
        if (((FunctionDescriptor)descriptor2).isSuspend() && !this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
            return false;
        }
        if (checkReturnType && !MainFunctionDetector.Companion.isMainReturnType((FunctionDescriptor)descriptor2)) {
            return false;
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            return true;
        }
        DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!(containingDeclaration instanceof ClassDescriptor)) return false;
        ClassKind classKind = ((ClassDescriptor)containingDeclaration).getKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)classKind), (String)"containingDeclaration.kind");
        if (!classKind.isSingleton()) return false;
        if (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2)) return true;
        if (checkJvmStaticAnnotation) return false;
        return true;
    }

    public static /* synthetic */ boolean isMain$default(MainFunctionDetector mainFunctionDetector, DeclarationDescriptor declarationDescriptor, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return mainFunctionDetector.isMain(declarationDescriptor, bl, bl2, bl3);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation, boolean checkReturnType) {
        return MainFunctionDetector.isMain$default(this, descriptor2, checkJvmStaticAnnotation, checkReturnType, false, 8, null);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2, boolean checkJvmStaticAnnotation) {
        return MainFunctionDetector.isMain$default(this, descriptor2, checkJvmStaticAnnotation, false, false, 12, null);
    }

    @JvmOverloads
    public final boolean isMain(@NotNull DeclarationDescriptor descriptor2) {
        return MainFunctionDetector.isMain$default(this, descriptor2, false, false, false, 14, null);
    }

    private final boolean isMainWithParameter(KtDeclaration declaration2, boolean checkJvmStaticAnnotation) {
        return declaration2 instanceof KtNamedFunction && this.isMain((KtNamedFunction)declaration2, checkJvmStaticAnnotation, false);
    }

    @Nullable
    public final FunctionDescriptor getMainFunction(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqName.ROOT");
        return this.getMainFunction(module2, module2.getPackage(fqName2));
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionDescriptor getMainFunction(ModuleDescriptor module2, PackageViewDescriptor packageView) {
        FunctionDescriptor it;
        boolean bl;
        FunctionDescriptor functionDescriptor;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = packageView.getFragments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageFragmentDescriptor it2 = (PackageFragmentDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(it2), (Object)module2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (PackageFragmentDescriptor packageFragment : (List)destination$iv$iv) {
            Object v1;
            block5: {
                void $this$firstOrNull$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Collection<DeclarationDescriptor> collection = DescriptorUtils.getAllDescriptors(packageFragment.getMemberScope());
                Intrinsics.checkNotNullExpressionValue(collection, (String)"DescriptorUtils.getAllDe\u2026ragment.getMemberScope())");
                $this$filter$iv = collection;
                boolean $i$f$filterIsInstance = false;
                $this$filterTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FunctionDescriptor it3 = (FunctionDescriptor)element$iv;
                    boolean bl3 = false;
                    if (!MainFunctionDetector.isMain$default(this, it3, false, false, false, 14, null)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            FunctionDescriptor functionDescriptor2 = v1;
            if (functionDescriptor2 == null) continue;
            functionDescriptor = functionDescriptor2;
            bl = false;
            boolean bl4 = false;
            it = functionDescriptor;
            boolean bl5 = false;
            return it;
        }
        for (FqName subpackageName : module2.getSubPackagesOf(packageView.getFqName(), MemberScope.Companion.getALL_NAME_FILTER())) {
            FunctionDescriptor functionDescriptor3 = this.getMainFunction(module2, module2.getPackage(subpackageName));
            if (functionDescriptor3 == null) continue;
            functionDescriptor = functionDescriptor3;
            bl = false;
            boolean bl6 = false;
            it = functionDescriptor;
            boolean bl7 = false;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtNamedFunction findMainFunction(List<? extends KtDeclaration> declarations2) {
        Iterator iterator2;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = declarations2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            boolean bl = false;
            iterable = iterable2;
            boolean bl2 = false;
            for (Iterator iterator3 : iterable) {
                KtNamedFunction it = (KtNamedFunction)((Object)iterator3);
                boolean bl3 = false;
                if (!MainFunctionDetector.isMain$default(this, it, false, false, 6, null)) continue;
                iterator2 = iterator3;
                break block2;
            }
            iterator2 = null;
        }
        return (KtNamedFunction)((Object)iterator2);
    }

    private final boolean isParameterNumberSuitsForMain(int parametersCount, boolean isTopLevel, boolean allowParameterless) {
        boolean bl;
        switch (parametersCount) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                if (isTopLevel && allowParameterless && this.languageVersionSettings.supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public MainFunctionDetector(final @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.getFunctionDescriptor = (Function1)new Function1<KtNamedFunction, FunctionDescriptor>(){

            @NotNull
            public final FunctionDescriptor invoke(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext.get(BindingContext.FUNCTION, function2);
                if (simpleFunctionDescriptor == null) {
                    throw (Throwable)new KotlinExceptionWithAttachments("No descriptor resolved for " + function2).withAttachment("function.text", function2.getText());
                }
                return simpleFunctionDescriptor;
            }
        };
        this.languageVersionSettings = languageVersionSettings;
    }

    public MainFunctionDetector(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super KtNamedFunction, ? extends FunctionDescriptor> functionResolver) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(functionResolver, (String)"functionResolver");
        this.getFunctionDescriptor = functionResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Companion;", "", "()V", "getJVMFunctionName", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "hasAnnotationWithExactNumberOfArguments", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "number", "", "isMainReturnType", "descriptor", "frontend"})
    public static final class Companion {
        private final boolean isMainReturnType(FunctionDescriptor descriptor2) {
            KotlinType returnType2 = descriptor2.getReturnType();
            return returnType2 != null && KotlinBuiltIns.isUnit(returnType2);
        }

        private final String getJVMFunctionName(FunctionDescriptor functionDescriptor) {
            String string2 = DescriptorUtils.getJvmName(functionDescriptor);
            if (string2 == null) {
                String string3 = functionDescriptor.getName().asString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"functionDescriptor.name.asString()");
            }
            return string2;
        }

        private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function2, int number) {
            boolean bl;
            block3: {
                List<KtAnnotationEntry> list2 = function2.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"function.annotationEntries");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        KtAnnotationEntry ktAnnotationEntry = it;
                        Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"it");
                        if (!(ktAnnotationEntry.getValueArguments().size() == number)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

