/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.FirDefaultParametersResolverKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentPassedTwice;
import org.jetbrains.kotlin.fir.resolve.calls.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.NameNotFound;
import org.jetbrains.kotlin.fir.resolve.calls.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.NoValueForParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NonVarargSpread;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.TooManyArguments;
import org.jetbrains.kotlin.fir.resolve.calls.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001:\u0001;B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020!H\u0002J\b\u00100\u001a\u00020,H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020!2\u0006\u00102\u001a\u00020\u0013H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u00020\u0013H\u0002J\u0014\u00104\u001a\u00020,2\f\u00105\u001a\b\u0012\u0004\u0012\u00020!0\u0016J\u0006\u00106\u001a\u00020,J\u000e\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020!J\u0018\u00109\u001a\u00020,2\u0006\u0010/\u001a\u00020!2\u0006\u00102\u001a\u00020\u0013H\u0002J\u0010\u0010:\u001a\u00020&2\u0006\u0010/\u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R-\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001a0\u0019j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001a`\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u0004\u0018\u00010\u0013*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\u00020&*\u0006\u0012\u0002\b\u00030\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\u00020&*\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor;", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "currentPositionedParameterIndex", "", "<set-?>", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostics", "getDiagnostics", "()Ljava/util/List;", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "parameters", "", "getParameters", "result", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "getResult", "()Ljava/util/LinkedHashMap;", "state", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "varargArguments", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "argumentName", "getArgumentName", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/name/Name;", "hasStableParameterNames", "", "getHasStableParameterNames", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Z", "isSpread", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "addDiagnostic", "", "diagnostic", "addVarargArgument", "argument", "completeVarargPositionArguments", "findParameterByName", "name", "getParameterByName", "processArgumentsInParenthesis", "arguments", "processDefaultsAndRunChecks", "processExternalArgument", "externalArgument", "processNamedArgument", "processPositionArgument", "State", "resolve"})
final class FirCallArgumentsProcessor {
    private State state;
    private int currentPositionedParameterIndex;
    private List<FirExpression> varargArguments;
    private Map<Name, ? extends FirValueParameter> nameToParameter;
    @Nullable
    private List<ResolutionDiagnostic> diagnostics;
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument> result;
    private final FirFunction<?> function;
    private final BodyResolveComponents bodyResolveComponents;
    private final FirScope originScope;

    @Nullable
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> getResult() {
        return this.result;
    }

    public final void processArgumentsInParenthesis(@NotNull List<? extends FirExpression> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        for (FirExpression firExpression2 : arguments2) {
            Name argumentName = this.getArgumentName(firExpression2);
            if (argumentName == null) {
                if (!this.processPositionArgument(firExpression2)) continue;
                this.state = State.VARARG_POSITION;
                continue;
            }
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
            this.processNamedArgument(firExpression2, argumentName);
        }
        if (this.state == State.VARARG_POSITION) {
            this.completeVarargPositionArguments();
        }
    }

    private final boolean processPositionArgument(FirExpression argument) {
        boolean bl;
        if (this.state == State.NAMED_ONLY_ARGUMENTS) {
            this.addDiagnostic(new MixingNamedAndPositionArguments(argument));
            return false;
        }
        FirValueParameter parameter = (FirValueParameter)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex);
        if (parameter == null) {
            this.addDiagnostic(new TooManyArguments(argument, this.function));
            return false;
        }
        if (!parameter.isVararg()) {
            int n = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n + 1;
            ((Map)this.result).put(parameter, new ResolvedCallArgument.SimpleArgument(argument));
            bl = false;
        } else {
            this.addVarargArgument(argument);
            bl = true;
        }
        return bl;
    }

    private final void processNamedArgument(FirExpression argument, Name name) {
        if (!this.getHasStableParameterNames(this.function)) {
            this.addDiagnostic(new NamedArgumentNotAllowed(argument, this.function));
        }
        boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
        this.state = State.NAMED_ONLY_ARGUMENTS;
        FirValueParameter firValueParameter = this.findParameterByName(argument, name);
        if (firValueParameter == null) {
            return;
        }
        FirValueParameter parameter = firValueParameter;
        ResolvedCallArgument resolvedCallArgument = this.result.get(parameter);
        if (resolvedCallArgument != null) {
            ResolvedCallArgument resolvedCallArgument2 = resolvedCallArgument;
            boolean bl = false;
            boolean bl2 = false;
            ResolvedCallArgument it = resolvedCallArgument2;
            boolean bl3 = false;
            ResolvedCallArgument resolvedCallArgument3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedCallArgument3, (String)"it");
            this.addDiagnostic(new ArgumentPassedTwice(argument, parameter, resolvedCallArgument3));
            return;
        }
        ((Map)this.result).put(parameter, new ResolvedCallArgument.SimpleArgument(argument));
        if (stateAllowsMixedNamedAndPositionArguments && Intrinsics.areEqual((Object)((FirValueParameter)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex)), (Object)parameter)) {
            this.state = State.POSITION_ARGUMENTS;
            int n = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n + 1;
        }
    }

    public final void processExternalArgument(@NotNull FirExpression externalArgument) {
        Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
        FirValueParameter lastParameter = (FirValueParameter)CollectionsKt.lastOrNull(this.getParameters());
        if (lastParameter == null) {
            this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
            return;
        }
        if (lastParameter.isVararg()) {
            this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
            return;
        }
        ResolvedCallArgument previousOccurrence = this.result.get(lastParameter);
        if (previousOccurrence != null) {
            this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
            return;
        }
        ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument(externalArgument));
    }

    /*
     * WARNING - void declaration
     */
    public final void processDefaultsAndRunChecks() {
        Object object = this.result;
        boolean bl = false;
        for (Map.Entry entry : object.entrySet()) {
            void parameter;
            Object object2 = entry;
            boolean bl2 = false;
            object = (FirValueParameter)object2.getKey();
            object2 = entry;
            bl2 = false;
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)object2.getValue();
            if (parameter.isVararg()) continue;
            if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                object2 = "Incorrect resolved argument for parameter " + parameter + " :" + resolvedArgument;
                bl2 = false;
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            if (!this.isSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument())) continue;
            this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()));
        }
        boolean bl3 = false;
        for (FirValueParameter parameter : (Iterable)this.getParameters()) {
            void index2;
            if (!this.result.containsKey(parameter)) {
                if (FirDefaultParametersResolverKt.getDefaultParameterResolver(this.bodyResolveComponents.getSession()).declaresDefaultValue(parameter, this.function, this.originScope, (int)index2)) {
                    ((Map)this.result).put(parameter, ResolvedCallArgument.DefaultArgument.INSTANCE);
                } else if (parameter.isVararg()) {
                    ((Map)this.result).put(parameter, new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
                } else {
                    this.addDiagnostic(new NoValueForParameter(parameter, this.function));
                }
            }
            ++index2;
        }
    }

    private final void completeVarargPositionArguments() {
        boolean bl = this.state == State.VARARG_POSITION;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Incorrect state: " + (Object)((Object)this.state);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        FirValueParameter parameter = this.getParameters().get(this.currentPositionedParameterIndex);
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        this.result.put(parameter, new ResolvedCallArgument.VarargArgument(list2));
    }

    private final void addVarargArgument(FirExpression argument) {
        if (this.varargArguments == null) {
            this.varargArguments = new ArrayList();
        }
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        list2.add(argument);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter getParameterByName(Name name) {
        if (this.nameToParameter == null) {
            Map map2;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Iterable iterable = this.getParameters();
            FirCallArgumentsProcessor firCallArgumentsProcessor = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var5_6 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)element$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                Name name2 = it.getName();
                map2.put(name2, element$iv$iv);
            }
            firCallArgumentsProcessor.nameToParameter = map2 = destination$iv$iv;
        }
        Map<Name, ? extends FirValueParameter> map3 = this.nameToParameter;
        Intrinsics.checkNotNull(map3);
        return map3.get(name);
    }

    private final FirValueParameter findParameterByName(FirExpression argument, Name name) {
        FirValueParameter parameter = this.getParameterByName(name);
        if (parameter == null) {
            this.addDiagnostic(new NameNotFound(argument, this.function));
        }
        return parameter;
    }

    private final void addDiagnostic(ResolutionDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            boolean bl = false;
            this.diagnostics = new ArrayList();
        }
        List<ResolutionDiagnostic> list2 = this.diagnostics;
        Intrinsics.checkNotNull(list2);
        list2.add(diagnostic);
    }

    private final boolean isSpread(FirExpression $this$isSpread) {
        return $this$isSpread instanceof FirSpreadArgumentExpression && ((FirSpreadArgumentExpression)$this$isSpread).isSpread();
    }

    private final List<FirValueParameter> getParameters() {
        return this.function.getValueParameters();
    }

    private final Name getArgumentName(FirExpression $this$argumentName) {
        FirExpression firExpression2 = $this$argumentName;
        if (!(firExpression2 instanceof FirNamedArgumentExpression)) {
            firExpression2 = null;
        }
        FirNamedArgumentExpression firNamedArgumentExpression = (FirNamedArgumentExpression)firExpression2;
        return firNamedArgumentExpression != null ? firNamedArgumentExpression.getName() : null;
    }

    private final boolean getHasStableParameterNames(FirFunction<?> $this$hasStableParameterNames) {
        return true;
    }

    public FirCallArgumentsProcessor(@NotNull FirFunction<?> function2, @NotNull BodyResolveComponents bodyResolveComponents, @Nullable FirScope originScope) {
        Intrinsics.checkNotNullParameter(function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        this.function = function2;
        this.bodyResolveComponents = bodyResolveComponents;
        this.originScope = originScope;
        this.state = State.POSITION_ARGUMENTS;
        this.result = new LinkedHashMap(this.function.getValueParameters().size());
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolve"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State POSITION_ARGUMENTS;
        public static final /* enum */ State VARARG_POSITION;
        public static final /* enum */ State NAMED_ONLY_ARGUMENTS;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = POSITION_ARGUMENTS = new State();
            stateArray[1] = VARARG_POSITION = new State();
            stateArray[2] = NAMED_ONLY_ARGUMENTS = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }
    }
}

