/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/FirValueParameterComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/Comparator;", "()V", "compare", "", "a", "b", "tree"})
public final class FirValueParameterComparator
implements Comparator<FirValueParameter> {
    @NotNull
    public static final FirValueParameterComparator INSTANCE;

    @Override
    public int compare(@NotNull FirValueParameter a, @NotNull FirValueParameter b) {
        int bHasDefaultValue;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int valueParameterNameDiff = a.getName().compareTo(b.getName());
        if (valueParameterNameDiff != 0) {
            return valueParameterNameDiff;
        }
        int valueParameterTypeDiff = FirTypeRefComparator.INSTANCE.compare(a.getReturnTypeRef(), b.getReturnTypeRef());
        if (valueParameterTypeDiff != 0) {
            return valueParameterTypeDiff;
        }
        int aHasDefaultValue = a.getDefaultValue() != null ? 1 : 0;
        int defaultValueDiff = aHasDefaultValue - (bHasDefaultValue = b.getDefaultValue() != null ? 1 : 0);
        if (defaultValueDiff != 0) {
            return defaultValueDiff;
        }
        int aIsVararg = a.isVararg() ? 1 : 0;
        int bIsVararg = b.isVararg() ? 1 : 0;
        return aIsVararg - bIsVararg;
    }

    private FirValueParameterComparator() {
    }

    static {
        FirValueParameterComparator firValueParameterComparator;
        INSTANCE = firValueParameterComparator = new FirValueParameterComparator();
    }
}

