/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictingProjectionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "reportConflictingProjections", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "desiredProjection", "", "reportVarianceNotAllowed", "checkers"})
public final class FirConflictingProjectionChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictingProjectionChecker INSTANCE;

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block5: {
            FirDeclaration firDeclaration;
            block4: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (declaration2 instanceof FirPropertyAccessor) {
                    return;
                }
                if (declaration2 instanceof FirTypedDeclaration) {
                    this.checkTypeRef(((FirTypedDeclaration)declaration2).getReturnTypeRef(), context2, reporter);
                }
                if (!((firDeclaration = declaration2) instanceof FirClass)) break block4;
                for (FirTypeRef it : ((FirClass)declaration2).getSuperTypeRefs()) {
                    this.checkTypeRef(it, context2, reporter);
                }
                break block5;
            }
            if (!(firDeclaration instanceof FirTypeAlias)) break block5;
            for (FirTypeParameter it : ((FirTypeAlias)declaration2).getTypeParameters()) {
                if (it.getVariance() == Variance.INVARIANT) continue;
                this.reportVarianceNotAllowed(reporter, it.getSource());
            }
            this.checkTypeRef(((FirTypeAlias)declaration2).getExpandedTypeRef(), context2, reporter);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkTypeRef(FirTypeRef typeRef, CheckerContext context, DiagnosticReporter reporter) {
        $this$safeAs$iv = typeRef;
        $i$f$safeAs = false;
        v0 = $this$safeAs$iv;
        if (!(v0 instanceof FirResolvedTypeRef)) {
            v0 = null;
        }
        if ((v1 = (FirResolvedTypeRef)v0) == null) ** GOTO lbl-1000
        $this$safeAs$iv = (FirTypeRef)v1;
        $i$f$coneTypeSafe = false;
        var7_9 = 0;
        v2 = $this$coneTypeSafe$iv;
        if (!(v2 instanceof FirResolvedTypeRef)) {
            v2 = null;
        }
        v3 = (FirResolvedTypeRef)v2;
        v4 = v3 != null ? v3.getType() : null;
        if (!(v4 instanceof ConeClassLikeType)) {
            v4 = null;
        }
        if ((v1 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)v4))) != null && (v1 = v1.getLookupTag()) != null && (v1 = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)v1, context.getSession())) != null) {
            v5 = (FirClassLikeDeclaration)v1.getFir();
        } else lbl-1000:
        // 2 sources

        {
            v5 = null;
        }
        $this$coneTypeSafe$iv = v5;
        $i$f$safeAs = false;
        v6 = $this$safeAs$iv;
        if (!(v6 instanceof FirRegularClass)) {
            v6 = null;
        }
        v7 = (FirRegularClass)v6;
        if (v7 == null) {
            return;
        }
        declaration = v7;
        $this$coneType$iv = typeRef;
        $i$f$getConeType = false;
        $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        $i$f$coneTypeUnsafe = false;
        v8 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (v8 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        size = ((Number)AddToStdlibKt.min(declaration.getTypeParameters().size(), v8.getTypeArguments().length)).intValue();
        $this$coneType$iv = 0;
        var7_9 = size;
        while ($this$coneType$iv < var7_9) {
            proto = declaration.getTypeParameters().get((int)it);
            $this$coneType$iv = typeRef;
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            v9 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (v9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            actual = v9.getTypeArguments()[it];
            $this$safeAs$iv = proto;
            $i$f$safeAs = false;
            v10 /* !! */  = $this$safeAs$iv;
            if (!(v10 /* !! */  instanceof FirTypeParameterRef)) {
                v10 /* !! */  = v11 = null;
            }
            if (v10 /* !! */  == null || (v11 = v11.getSymbol()) == null || (v11 = (FirTypeParameter)v11.getFir()) == null || (v11 = v11.getVariance()) == null) {
            } else {
                protoVariance = v11;
                if (protoVariance != Variance.INVARIANT && (actual instanceof ConeKotlinTypeProjectionIn && protoVariance == Variance.OUT_VARIANCE || actual instanceof ConeKotlinTypeProjectionOut && protoVariance == Variance.IN_VARIANCE)) {
                    $this$coneType$iv = typeRef;
                    $i$f$getConeType = false;
                    $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
                    $i$f$coneTypeUnsafe = false;
                    v12 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
                    if (v12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                    }
                    this.reportConflictingProjections(reporter, typeRef.getSource(), v12.toString());
                    return;
                }
            }
            ++it;
        }
    }

    private final void reportConflictingProjections(DiagnosticReporter $this$reportConflictingProjections, FirSourceElement source, String desiredProjection) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportConflictingProjections.report((FirDiagnostic)FirErrors.INSTANCE.getCONFLICTING_PROJECTION().on(it, desiredProjection));
        }
    }

    private final void reportVarianceNotAllowed(DiagnosticReporter $this$reportVarianceNotAllowed, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportVarianceNotAllowed.report((FirDiagnostic)FirErrors.INSTANCE.getVARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED().on(it));
        }
    }

    private FirConflictingProjectionChecker() {
    }

    static {
        FirConflictingProjectionChecker firConflictingProjectionChecker;
        INSTANCE = firConflictingProjectionChecker = new FirConflictingProjectionChecker();
    }
}

