/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a&\u0010\f\u001a\u00020\r*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u0013"}, d2={"createSourceFilesFromSourceRoots", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "sourceRoots", "", "Lorg/jetbrains/kotlin/cli/common/config/KotlinSourceRoot;", "reportLocation", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "report", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "cli"})
public final class CoreEnvironmentUtilsKt {
    public static final void report(@NotNull CompilerConfiguration $this$report, @NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageLocation location2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$this$report, (String)"$this$report");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            MessageCollector messageCollector = $this$report.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector == null) break block0;
            messageCollector.report(severity, message2, location2);
        }
    }

    public static /* synthetic */ void report$default(CompilerConfiguration compilerConfiguration, CompilerMessageSeverity compilerMessageSeverity, String string2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.report(compilerConfiguration, compilerMessageSeverity, string2, compilerMessageLocation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFile> createSourceFilesFromSourceRoots(@NotNull CompilerConfiguration configuration, @NotNull Project project, @NotNull List<KotlinSourceRoot> sourceRoots, @Nullable CompilerMessageLocation reportLocation) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(sourceRoots, (String)"sourceRoots");
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        PsiManager psiManager = PsiManager.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager psiManager2 = psiManager;
        boolean bl = false;
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        boolean bl2 = false;
        List result2 = new ArrayList();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        for (KotlinSourceRoot kotlinSourceRoot : sourceRoots) {
            void sourceRootPath;
            String string2 = kotlinSourceRoot.component1();
            boolean isCommon = kotlinSourceRoot.component2();
            VirtualFile vFile = localFileSystem.findFileByPath((String)sourceRootPath);
            if (vFile == null) {
                String message2 = "Source file or directory not found: " + (String)sourceRootPath;
                File buildFilePath = configuration.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message2 + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default((File)buildFilePath, null, (int)1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, message2, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && Intrinsics.areEqual((Object)vFile.getFileType(), (Object)KotlinFileType.INSTANCE) ^ true) {
                CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + (String)sourceRootPath, reportLocation);
                continue;
            }
            for (File file2 : FilesKt.walkTopDown((File)new File((String)sourceRootPath))) {
                PsiFile psiFile;
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                if (!file2.isFile()) continue;
                if (localFileSystem.findFileByPath(file2.getAbsolutePath()) != null) {
                    VirtualFile virtualFile4;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    VirtualFile p1 = virtualFile4;
                    boolean bl5 = false;
                    virtualFile3 = virtualFileCreator.create(p1);
                } else {
                    virtualFile3 = null;
                }
                if ((virtualFile2 = virtualFile3) == null || !processedFiles.add(virtualFile2) || !((psiFile = psiManager2.findFile(virtualFile2)) instanceof KtFile)) continue;
                result2.add(psiFile);
                if (!isCommon) continue;
                IsCommonSourceKt.setCommonSource((KtFile)psiFile, true);
            }
        }
        return result2;
    }

    public static /* synthetic */ List createSourceFilesFromSourceRoots$default(CompilerConfiguration compilerConfiguration, Project project, List list2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 8) != 0) {
            compilerMessageLocation = null;
        }
        return CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots(compilerConfiguration, project, list2, compilerMessageLocation);
    }
}

