/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001:B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0017H\u0002J\u001c\u0010%\u001a\u00020\u001d2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u001c\u0010%\u001a\u00020\u001d2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0014\u0010)\u001a\u00020\u00042\n\u0010*\u001a\u0006\u0012\u0002\b\u00030'H\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0007J\u0018\u0010.\u001a\u00020,2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u00010\u0013J\u0010\u00102\u001a\u00020,2\b\u00101\u001a\u0004\u0018\u00010\u0013J\u0010\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\u0007J\u0010\u00104\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\u0007J\u0010\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020\u0013J!\u00106\u001a\u00020\u0017\"\u0006\b\u0000\u00107\u0018\u00012\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0007H\u0082\bJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00072\b\u00101\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u00101\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap;", "", "()V", "CLASS_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "FUNCTION_N_CLASS_ID", "FUNCTION_N_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getFUNCTION_N_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "K_CLASS_CLASS_ID", "K_FUNCTION_CLASS_ID", "NUMBERED_FUNCTION_PREFIX", "", "NUMBERED_K_FUNCTION_PREFIX", "NUMBERED_K_SUSPEND_FUNCTION_PREFIX", "NUMBERED_SUSPEND_FUNCTION_PREFIX", "javaToKotlin", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "kotlinToJava", "mutabilityMappings", "", "Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap$PlatformMutabilityMapping;", "getMutabilityMappings", "()Ljava/util/List;", "mutableToReadOnly", "readOnlyToMutable", "add", "", "javaClassId", "kotlinClassId", "addJavaToKotlin", "addKotlinToJava", "kotlinFqNameUnsafe", "addMapping", "platformMutabilityMapping", "addTopLevel", "javaClass", "Ljava/lang/Class;", "kotlinFqName", "classId", "clazz", "isJavaPlatformClass", "", "fqName", "isKotlinFunctionWithBigArity", "prefix", "isMutable", "fqNameUnsafe", "isReadOnly", "mapJavaToKotlin", "mapJavaToKotlinIncludingClassMapping", "mapKotlinToJava", "mutabilityMapping", "T", "kotlinReadOnly", "kotlinMutable", "PlatformMutabilityMapping", "compiler.common.jvm"})
public final class JavaToKotlinClassMap {
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    @NotNull
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final ClassId K_CLASS_CLASS_ID;
    private static final ClassId CLASS_CLASS_ID;
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    @NotNull
    private static final List<PlatformMutabilityMapping> mutabilityMappings;
    @NotNull
    public static final JavaToKotlinClassMap INSTANCE;

    @NotNull
    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    @NotNull
    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    @Nullable
    public final ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public final ClassId mapJavaToKotlinIncludingClassMapping(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (Intrinsics.areEqual((Object)fqName2, (Object)CLASS_CLASS_ID.asSingleFqName())) {
            return K_CLASS_CLASS_ID;
        }
        return this.mapJavaToKotlin(fqName2);
    }

    @Nullable
    public final ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        Intrinsics.checkNotNullParameter((Object)kotlinFqName, (String)"kotlinFqName");
        return this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_SUSPEND_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_SUSPEND_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : kotlinToJava.get(kotlinFqName))));
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe kotlinFqName, String prefix) {
        String string2 = kotlinFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"kotlinFqName.asString()");
        String arityString = StringsKt.substringAfter((String)string2, (String)prefix, (String)"");
        CharSequence charSequence = arityString;
        boolean bl = false;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((CharSequence)arityString, (char)'0', (boolean)false, (int)2, null)) {
            Integer arity = StringsKt.toIntOrNull((String)arityString);
            return arity != null && arity >= 23;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        void readOnlyClassId;
        void javaClassId;
        PlatformMutabilityMapping platformMutabilityMapping2 = platformMutabilityMapping;
        ClassId classId = platformMutabilityMapping2.component1();
        ClassId classId2 = platformMutabilityMapping2.component2();
        ClassId mutableClassId = platformMutabilityMapping2.component3();
        this.add((ClassId)javaClassId, (ClassId)readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"mutableClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, (ClassId)javaClassId);
        FqName fqName3 = readOnlyClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"readOnlyClassId.asSingleFqName()");
        FqName readOnlyFqName = fqName3;
        FqName fqName4 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"mutableClassId.asSingleFqName()");
        FqName mutableFqName = fqName4;
        Map map2 = mutableToReadOnly;
        FqNameUnsafe fqNameUnsafe = mutableClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"mutableClassId.asSingleFqName().toUnsafe()");
        map2.put(fqNameUnsafe, readOnlyFqName);
        Map map3 = readOnlyToMutable;
        FqNameUnsafe fqNameUnsafe2 = readOnlyFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe2, (String)"readOnlyFqName.toUnsafe()");
        map3.put(fqNameUnsafe2, mutableFqName);
    }

    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = kotlinClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
    }

    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        FqName fqName2 = kotlinFqName.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinFqName.toSafe()");
        this.addTopLevel(javaClass, fqName2);
    }

    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        ClassId classId = this.classId(javaClass);
        ClassId classId2 = ClassId.topLevel(kotlinFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"ClassId.topLevel(kotlinFqName)");
        this.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        Map map2 = javaToKotlin;
        FqNameUnsafe fqNameUnsafe = javaClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"javaClassId.asSingleFqName().toUnsafe()");
        map2.put(fqNameUnsafe, kotlinClassId);
    }

    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        Map map2 = kotlinToJava;
        FqNameUnsafe fqNameUnsafe = kotlinFqNameUnsafe.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"kotlinFqNameUnsafe.toUnsafe()");
        map2.put(fqNameUnsafe, javaClassId);
    }

    public final boolean isJavaPlatformClass(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.mapJavaToKotlin(fqName2) != null;
    }

    @Nullable
    public final FqName mutableToReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = mutableToReadOnly;
        boolean bl = false;
        return (FqName)map2.get(fqNameUnsafe);
    }

    @Nullable
    public final FqName readOnlyToMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = readOnlyToMutable;
        boolean bl = false;
        return (FqName)map2.get(fqNameUnsafe);
    }

    public final boolean isMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = mutableToReadOnly;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = readOnlyToMutable;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(fqNameUnsafe);
    }

    private final ClassId classId(Class<?> clazz) {
        ClassId classId;
        boolean bl = !clazz.isPrimitive() && !clazz.isArray();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Invalid class: " + clazz;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Class<?> outer = clazz.getDeclaringClass();
        if (outer == null) {
            ClassId classId2 = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            classId = classId2;
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"ClassId.topLevel(FqName(clazz.canonicalName))");
        } else {
            ClassId classId3 = this.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            classId = classId3;
            Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"classId(outer).createNes\u2026tifier(clazz.simpleName))");
        }
        return classId;
    }

    private JavaToKotlinClassMap() {
    }

    static {
        int i;
        JavaToKotlinClassMap this_$iv;
        ClassId kotlinReadOnly$iv;
        JavaToKotlinClassMap javaToKotlinClassMap;
        INSTANCE = javaToKotlinClassMap = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionClassKind.Function.getPackageFqName().toString() + "." + FunctionClassKind.Function.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionClassKind.KFunction.getPackageFqName().toString() + "." + FunctionClassKind.KFunction.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionClassKind.SuspendFunction.getPackageFqName().toString() + "." + FunctionClassKind.SuspendFunction.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionClassKind.KSuspendFunction.getPackageFqName().toString() + "." + FunctionClassKind.KSuspendFunction.getClassNamePrefix();
        ClassId classId = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"ClassId.topLevel(FqName(\u2026vm.functions.FunctionN\"))");
        FUNCTION_N_CLASS_ID = classId;
        FqName fqName2 = FUNCTION_N_CLASS_ID.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FUNCTION_N_CLASS_ID.asSingleFqName()");
        FUNCTION_N_FQ_NAME = fqName2;
        ClassId classId2 = ClassId.topLevel(new FqName("kotlin.reflect.KFunction"));
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"ClassId.topLevel(FqName(\u2026tlin.reflect.KFunction\"))");
        K_FUNCTION_CLASS_ID = classId2;
        ClassId classId3 = ClassId.topLevel(new FqName("kotlin.reflect.KClass"));
        Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"ClassId.topLevel(FqName(\"kotlin.reflect.KClass\"))");
        K_CLASS_CLASS_ID = classId3;
        CLASS_CLASS_ID = javaToKotlinClassMap.classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        Object[] objectArray = new PlatformMutabilityMapping[8];
        JavaToKotlinClassMap javaToKotlinClassMap2 = javaToKotlinClassMap;
        ClassId classId4 = ClassId.topLevel(StandardNames.FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue((Object)classId4, (String)"ClassId.topLevel(FqNames.iterable)");
        ClassId classId5 = classId4;
        JvmPrimitiveType[] kotlinMutable$iv = StandardNames.FqNames.mutableIterable;
        int $i$f$mutabilityMapping = 0;
        FqName fqName3 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName4 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"kotlinReadOnly.packageFqName");
        ClassId mutableClassId$iv = new ClassId(fqName3, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName4), false);
        objectArray[0] = new PlatformMutabilityMapping(this_$iv.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId6 = ClassId.topLevel(StandardNames.FqNames.iterator);
        Intrinsics.checkNotNullExpressionValue((Object)classId6, (String)"ClassId.topLevel(FqNames.iterator)");
        kotlinReadOnly$iv = classId6;
        kotlinMutable$iv = StandardNames.FqNames.mutableIterator;
        $i$f$mutabilityMapping = 0;
        FqName fqName5 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName6 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName6, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName5, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName6), false);
        objectArray[1] = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId7 = ClassId.topLevel(StandardNames.FqNames.collection);
        Intrinsics.checkNotNullExpressionValue((Object)classId7, (String)"ClassId.topLevel(FqNames.collection)");
        kotlinReadOnly$iv = classId7;
        kotlinMutable$iv = StandardNames.FqNames.mutableCollection;
        $i$f$mutabilityMapping = 0;
        FqName fqName7 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName8 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName8, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName7, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName8), false);
        objectArray[2] = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId8 = ClassId.topLevel(StandardNames.FqNames.list);
        Intrinsics.checkNotNullExpressionValue((Object)classId8, (String)"ClassId.topLevel(FqNames.list)");
        kotlinReadOnly$iv = classId8;
        kotlinMutable$iv = StandardNames.FqNames.mutableList;
        $i$f$mutabilityMapping = 0;
        FqName fqName9 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName10 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName10, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName9, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName10), false);
        objectArray[3] = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId9 = ClassId.topLevel(StandardNames.FqNames.set);
        Intrinsics.checkNotNullExpressionValue((Object)classId9, (String)"ClassId.topLevel(FqNames.set)");
        kotlinReadOnly$iv = classId9;
        kotlinMutable$iv = StandardNames.FqNames.mutableSet;
        $i$f$mutabilityMapping = 0;
        FqName fqName11 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName12 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName12, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName11, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName12), false);
        objectArray[4] = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId10 = ClassId.topLevel(StandardNames.FqNames.listIterator);
        Intrinsics.checkNotNullExpressionValue((Object)classId10, (String)"ClassId.topLevel(FqNames.listIterator)");
        kotlinReadOnly$iv = classId10;
        kotlinMutable$iv = StandardNames.FqNames.mutableListIterator;
        $i$f$mutabilityMapping = 0;
        FqName fqName13 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName14 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName14, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName13, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName14), false);
        objectArray[5] = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId11 = ClassId.topLevel(StandardNames.FqNames.map);
        Intrinsics.checkNotNullExpressionValue((Object)classId11, (String)"ClassId.topLevel(FqNames.map)");
        kotlinReadOnly$iv = classId11;
        kotlinMutable$iv = StandardNames.FqNames.mutableMap;
        $i$f$mutabilityMapping = 0;
        FqName fqName15 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName16 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName16, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName15, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName16), false);
        objectArray[6] = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId12 = ClassId.topLevel(StandardNames.FqNames.map).createNestedClassId(StandardNames.FqNames.mapEntry.shortName());
        Intrinsics.checkNotNullExpressionValue((Object)classId12, (String)"ClassId.topLevel(FqNames\u2026mes.mapEntry.shortName())");
        kotlinReadOnly$iv = classId12;
        kotlinMutable$iv = StandardNames.FqNames.mutableMapEntry;
        $i$f$mutabilityMapping = 0;
        FqName fqName17 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName18 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName18, (String)"kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName17, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName18), false);
        objectArray[7] = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf((Object[])objectArray);
        javaToKotlinClassMap.addTopLevel(Object.class, StandardNames.FqNames.any);
        javaToKotlinClassMap.addTopLevel(String.class, StandardNames.FqNames.string);
        javaToKotlinClassMap.addTopLevel(CharSequence.class, StandardNames.FqNames.charSequence);
        javaToKotlinClassMap.addTopLevel(Throwable.class, StandardNames.FqNames.throwable);
        javaToKotlinClassMap.addTopLevel(Cloneable.class, StandardNames.FqNames.cloneable);
        javaToKotlinClassMap.addTopLevel(Number.class, StandardNames.FqNames.number);
        javaToKotlinClassMap.addTopLevel(Comparable.class, StandardNames.FqNames.comparable);
        javaToKotlinClassMap.addTopLevel(Enum.class, StandardNames.FqNames._enum);
        javaToKotlinClassMap.addTopLevel(Annotation.class, StandardNames.FqNames.annotation);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            javaToKotlinClassMap.addMapping(platformCollection);
        }
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            ClassId classId13 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkNotNullExpressionValue((Object)classId13, (String)"ClassId.topLevel(jvmType.wrapperFqName)");
            PrimitiveType primitiveType = jvmType.getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"jvmType.primitiveType");
            ClassId classId14 = ClassId.topLevel(StandardNames.getPrimitiveFqName(primitiveType));
            Intrinsics.checkNotNullExpressionValue((Object)classId14, (String)"ClassId.topLevel(Standar\u2026e(jvmType.primitiveType))");
            javaToKotlinClassMap.add(classId13, classId14);
        }
        for (ClassId classId15 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            ClassId classId16 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId15.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkNotNullExpressionValue((Object)classId16, (String)"ClassId.topLevel(FqName(\u2026g() + \"CompanionObject\"))");
            ClassId classId17 = classId15.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue((Object)classId17, (String)"classId.createNestedClas\u2026AME_FOR_COMPANION_OBJECT)");
            javaToKotlinClassMap.add(classId16, classId17);
        }
        int classId15 = 0;
        int n = 23;
        while (classId15 < n) {
            ClassId classId18 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i));
            Intrinsics.checkNotNullExpressionValue((Object)classId18, (String)"ClassId.topLevel(FqName(\u2026m.functions.Function$i\"))");
            javaToKotlinClassMap.add(classId18, StandardNames.getFunctionClassId(i));
            javaToKotlinClassMap.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + i), K_FUNCTION_CLASS_ID);
            ++i;
        }
        n = 22;
        for (i = 0; i < n; ++i) {
            FunctionClassKind kSuspendFunction = FunctionClassKind.KSuspendFunction;
            String kSuspendFun = kSuspendFunction.getPackageFqName().toString() + "." + kSuspendFunction.getClassNamePrefix();
            javaToKotlinClassMap.addKotlinToJava(new FqName(kSuspendFun + i), K_FUNCTION_CLASS_ID);
        }
        FqName fqName19 = StandardNames.FqNames.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName19, (String)"FqNames.nothing.toSafe()");
        javaToKotlinClassMap.addKotlinToJava(fqName19, javaToKotlinClassMap.classId(Void.class));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap$PlatformMutabilityMapping;", "", "javaClass", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlinReadOnly", "kotlinMutable", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/ClassId;)V", "getJavaClass", "()Lorg/jetbrains/kotlin/name/ClassId;", "getKotlinMutable", "getKotlinReadOnly", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "compiler.common.jvm"})
    public static final class PlatformMutabilityMapping {
        @NotNull
        private final ClassId javaClass;
        @NotNull
        private final ClassId kotlinReadOnly;
        @NotNull
        private final ClassId kotlinMutable;

        @NotNull
        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId getKotlinReadOnly() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId getKotlinMutable() {
            return this.kotlinMutable;
        }

        public PlatformMutabilityMapping(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinReadOnly, (String)"kotlinReadOnly");
            Intrinsics.checkNotNullParameter((Object)kotlinMutable, (String)"kotlinMutable");
            this.javaClass = javaClass;
            this.kotlinReadOnly = kotlinReadOnly;
            this.kotlinMutable = kotlinMutable;
        }

        @NotNull
        public final ClassId component1() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId component3() {
            return this.kotlinMutable;
        }

        @NotNull
        public final PlatformMutabilityMapping copy(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinReadOnly, (String)"kotlinReadOnly");
            Intrinsics.checkNotNullParameter((Object)kotlinMutable, (String)"kotlinMutable");
            return new PlatformMutabilityMapping(javaClass, kotlinReadOnly, kotlinMutable);
        }

        public static /* synthetic */ PlatformMutabilityMapping copy$default(PlatformMutabilityMapping platformMutabilityMapping, ClassId classId, ClassId classId2, ClassId classId3, int n, Object object) {
            if ((n & 1) != 0) {
                classId = platformMutabilityMapping.javaClass;
            }
            if ((n & 2) != 0) {
                classId2 = platformMutabilityMapping.kotlinReadOnly;
            }
            if ((n & 4) != 0) {
                classId3 = platformMutabilityMapping.kotlinMutable;
            }
            return platformMutabilityMapping.copy(classId, classId2, classId3);
        }

        @NotNull
        public String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ")";
        }

        public int hashCode() {
            ClassId classId = this.javaClass;
            ClassId classId2 = this.kotlinReadOnly;
            ClassId classId3 = this.kotlinMutable;
            return ((classId != null ? ((Object)classId).hashCode() : 0) * 31 + (classId2 != null ? ((Object)classId2).hashCode() : 0)) * 31 + (classId3 != null ? ((Object)classId3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PlatformMutabilityMapping)) break block3;
                    PlatformMutabilityMapping platformMutabilityMapping = (PlatformMutabilityMapping)object;
                    if (!Intrinsics.areEqual((Object)this.javaClass, (Object)platformMutabilityMapping.javaClass) || !Intrinsics.areEqual((Object)this.kotlinReadOnly, (Object)platformMutabilityMapping.kotlinReadOnly) || !Intrinsics.areEqual((Object)this.kotlinMutable, (Object)platformMutabilityMapping.kotlinMutable)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

