/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.ToArrayLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\r\u001a\u00020\u0007*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0007*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0007*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0002H\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\"\u001a\u0010\n\u001a\u0004\u0018\u00010\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"toArrayPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getToArrayPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "isCollectionSubClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "superClass", "getSuperClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isArrayOrNullableArrayOf", "Lorg/jetbrains/kotlin/ir/types/IrType;", "context", "element", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "isGenericToArray", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isNonGenericToArray", "backend.jvm"})
public final class ToArrayLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> toArrayPhase = PhaseBuildersKt.makeIrFilePhase$default(toArrayPhase.1.INSTANCE, "ToArray", "Handle toArray functions", null, null, null, null, null, 248, null);

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getToArrayPhase() {
        return toArrayPhase;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrClass getSuperClass(IrClass $this$superClass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$superClass.getSuperTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrClass irClass2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            if (IrTypesKt.getClass(it) != null) {
                IrClass irClass3;
                boolean bl3 = false;
                boolean bl4 = false;
                IrClass superClass2 = irClass3;
                boolean bl5 = false;
                irClass2 = IrUtilsKt.isClass(superClass2) ? irClass3 : null;
            } else {
                irClass2 = null;
            }
            if (irClass2 == null) continue;
            IrClass irClass4 = irClass2;
            boolean bl6 = false;
            boolean bl7 = false;
            IrClass it$iv$iv = irClass4;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (IrClass)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    public static final boolean isCollectionSubClass(@NotNull IrClass $this$isCollectionSubClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isCollectionSubClass, (String)"$this$isCollectionSubClass");
        Boolean bl = DFS.ifAny((Collection)$this$isCollectionSubClass.getSuperTypes(), isCollectionSubClass.1.INSTANCE, isCollectionSubClass.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"DFS.ifAny(superTypes, { \u2026 }) { it.isCollection() }");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isArrayOrNullableArrayOf(IrType $this$isArrayOrNullableArrayOf, JvmBackendContext context2, IrClassifierSymbol element) {
        if (!($this$isArrayOrNullableArrayOf instanceof IrSimpleType)) return false;
        if (!IrTypePredicatesKt.isArray($this$isArrayOrNullableArrayOf)) {
            if (!IrTypePredicatesKt.isNullableArray($this$isArrayOrNullableArrayOf)) return false;
        }
        if (((IrSimpleType)$this$isArrayOrNullableArrayOf).getArguments().size() != 1) return false;
        IrTypeArgument it = ((IrSimpleType)$this$isArrayOrNullableArrayOf).getArguments().get(0);
        if (!Intrinsics.areEqual((Object)element, (Object)(it instanceof IrStarProjection ? (IrClassifierSymbol)context2.getIrBuiltIns().getAnyClass() : (it instanceof IrTypeProjection ? (((IrTypeProjection)it).getVariance() == Variance.IN_VARIANCE ? (IrClassifierSymbol)context2.getIrBuiltIns().getAnyClass() : IrTypesKt.getClassifierOrNull(((IrTypeProjection)it).getType())) : null)))) return false;
        return true;
    }

    public static final boolean isGenericToArray(@NotNull IrSimpleFunction $this$isGenericToArray, @NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isGenericToArray, (String)"$this$isGenericToArray");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return Intrinsics.areEqual((Object)$this$isGenericToArray.getName().asString(), (Object)"toArray") && $this$isGenericToArray.getTypeParameters().size() == 1 && $this$isGenericToArray.getValueParameters().size() == 1 && $this$isGenericToArray.getExtensionReceiverParameter() == null && ToArrayLoweringKt.isArrayOrNullableArrayOf($this$isGenericToArray.getReturnType(), context2, (IrClassifierSymbol)$this$isGenericToArray.getTypeParameters().get(0).getSymbol()) && ToArrayLoweringKt.isArrayOrNullableArrayOf($this$isGenericToArray.getValueParameters().get(0).getType(), context2, (IrClassifierSymbol)$this$isGenericToArray.getTypeParameters().get(0).getSymbol());
    }

    public static final boolean isNonGenericToArray(@NotNull IrSimpleFunction $this$isNonGenericToArray, @NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonGenericToArray, (String)"$this$isNonGenericToArray");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return Intrinsics.areEqual((Object)$this$isNonGenericToArray.getName().asString(), (Object)"toArray") && $this$isNonGenericToArray.getTypeParameters().isEmpty() && $this$isNonGenericToArray.getValueParameters().isEmpty() && $this$isNonGenericToArray.getExtensionReceiverParameter() == null && ToArrayLoweringKt.isArrayOrNullableArrayOf($this$isNonGenericToArray.getReturnType(), context2, context2.getIrBuiltIns().getAnyClass());
    }

    public static final /* synthetic */ IrClass access$getSuperClass$p(IrClass $this$access_u24superClass_u24p) {
        return ToArrayLoweringKt.getSuperClass($this$access_u24superClass_u24p);
    }
}

