/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u000b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u000b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticCallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "containsReifiedTypeParametersCache", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "", "staticInstanceFields", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "containsReifiedTypeParameters", "getContainsReifiedTypeParameters", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isSyntheticSingleton", "getFieldForStaticCallableReferenceInstance", "irClass", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "backend.jvm"})
public final class StaticCallableReferenceLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    private final HashMap<IrClass, IrField> staticInstanceFields;
    private final Map<IrClass, Boolean> containsReifiedTypeParametersCache;
    @NotNull
    private final JvmBackendContext backendContext;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.transformChildrenVoid(declaration2);
        if (this.isSyntheticSingleton(declaration2)) {
            void $this$run;
            Collection collection = declaration2.getDeclarations();
            IrField irField = this.getFieldForStaticCallableReferenceInstance(declaration2);
            boolean bl = false;
            boolean bl2 = false;
            IrField field = irField;
            boolean bl3 = false;
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.backendContext, field.getSymbol(), 0, 0, 6, null);
            boolean bl4 = false;
            boolean bl5 = false;
            DeclarationIrBuilder declarationIrBuilder2 = declarationIrBuilder;
            IrField irField2 = field;
            boolean bl6 = false;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$run;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$run;
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(declaration2);
            Intrinsics.checkNotNull((Object)irConstructor2);
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody(irBuilderWithScope, ExpressionHelpersKt.irCall(irBuilderWithScope2, irConstructor2));
            irField2.setInitializer(irExpressionBody);
            bl = false;
            collection.add(irField);
        }
        return declaration2;
    }

    private final IrField getFieldForStaticCallableReferenceInstance(IrClass irClass2) {
        Object object;
        Map $this$getOrPut$iv = this.staticInstanceFields;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(irClass2);
        if (value$iv == null) {
            boolean bl = false;
            IrFactory $this$buildField$iv = this.backendContext.getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            IrFieldBuilder $this$run$iv = irFieldBuilder;
            boolean bl4 = false;
            IrFieldBuilder $this$buildField = $this$run$iv;
            boolean bl5 = false;
            Name name = Name.identifier("INSTANCE");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(JvmAbi.INSTANCE_FIELD)");
            $this$buildField.setName(name);
            $this$buildField.setType(IrUtilsKt.getDefaultType(irClass2));
            $this$buildField.setOrigin(JvmLoweredDeclarationOrigin.FIELD_FOR_STATIC_CALLABLE_REFERENCE_INSTANCE.INSTANCE);
            $this$buildField.setFinal(true);
            $this$buildField.setStatic(true);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"DescriptorVisibilities.PUBLIC");
            $this$buildField.setVisibility(descriptorVisibility);
            IrField irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$run$iv);
            boolean bl6 = false;
            boolean bl7 = false;
            IrField $this$apply = irField;
            boolean bl8 = false;
            $this$apply.setParent(irClass2);
            IrField answer$iv = irField;
            $this$getOrPut$iv.put(irClass2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IrField)object;
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
        if (!this.isSyntheticSingleton(AdditionalIrUtilsKt.getConstructedClass(constructor2))) {
            return super.visitConstructorCall(expression2);
        }
        IrField instanceField = this.getFieldForStaticCallableReferenceInstance(AdditionalIrUtilsKt.getConstructedClass(constructor2));
        return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)instanceField.getSymbol(), expression2.getType(), null, null, 48, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSyntheticSingleton(IrClass $this$isSyntheticSingleton) {
        if (!Intrinsics.areEqual((Object)$this$isSyntheticSingleton.getOrigin(), (Object)JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE) && !Intrinsics.areEqual((Object)$this$isSyntheticSingleton.getOrigin(), (Object)JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE)) {
            if (!Intrinsics.areEqual((Object)$this$isSyntheticSingleton.getOrigin(), (Object)JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE)) return false;
        }
        IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor($this$isSyntheticSingleton);
        Intrinsics.checkNotNull((Object)irConstructor2);
        if (!irConstructor2.getValueParameters().isEmpty()) return false;
        if (this.getContainsReifiedTypeParameters($this$isSyntheticSingleton)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean getContainsReifiedTypeParameters(IrClass $this$containsReifiedTypeParameters) {
        Map<IrClass, Boolean> $this$getOrPut$iv = this.containsReifiedTypeParametersCache;
        boolean $i$f$getOrPut = false;
        Boolean value$iv = $this$getOrPut$iv.get($this$containsReifiedTypeParameters);
        if (value$iv == null) {
            void containsReified;
            boolean bl = false;
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            IrElementVisitorVoidKt.acceptChildrenVoid($this$containsReifiedTypeParameters, new IrElementVisitorVoid((Ref.BooleanRef)containsReified){
                final /* synthetic */ Ref.BooleanRef $containsReified;

                public void visitElement(@NotNull IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!this.$containsReified.element) {
                        IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                    Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                    int n = 0;
                    int n2 = expression2.getTypeArgumentsCount();
                    while (n < n2) {
                        void i;
                        IrType irType = expression2.getTypeArgument((int)i);
                        if (irType != null) {
                            if (this.isReified(irType)) {
                                this.$containsReified.element = true;
                                break;
                            }
                        }
                        ++i;
                    }
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (this.isReified(expression2.getTypeOperand())) {
                        this.$containsReified.element = true;
                    }
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                }

                public void visitClassReference(@NotNull IrClassReference expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (this.isReified(expression2.getClassType())) {
                        this.$containsReified.element = true;
                    }
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private final boolean isReified(IrType $this$isReified) {
                    IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isReified);
                    Object object = irClassifierSymbol;
                    if (irClassifierSymbol == null) return false;
                    IrClassifierSymbol $this$safeAs$iv = object;
                    boolean $i$f$safeAs = false;
                    IrClassifierSymbol irClassifierSymbol2 = $this$safeAs$iv;
                    if (!(irClassifierSymbol2 instanceof IrTypeParameterSymbol)) {
                        irClassifierSymbol2 = null;
                    }
                    IrTypeParameterSymbol irTypeParameterSymbol = (IrTypeParameterSymbol)irClassifierSymbol2;
                    object = irTypeParameterSymbol;
                    if (irTypeParameterSymbol == null) return false;
                    IrTypeParameter irTypeParameter = (IrTypeParameter)object.getOwner();
                    object = irTypeParameter;
                    if (irTypeParameter == null) return false;
                    if (!((IrTypeParameter)object).isReified()) return false;
                    return true;
                }
                {
                    this.$containsReified = $captured_local_variable$0;
                }

                public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                }

                public void visitBlock(@NotNull IrBlock expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                }

                public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitBlockBody(@NotNull IrBlockBody body2) {
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                }

                public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                }

                public void visitBody(@NotNull IrBody body2) {
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                }

                public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                }

                public void visitBranch(@NotNull IrBranch branch) {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBreak(@NotNull IrBreak jump) {
                    Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                    Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitCall(@NotNull IrCall expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                }

                public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                }

                public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                    Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                }

                public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitCatch(@NotNull IrCatch aCatch) {
                    Intrinsics.checkNotNullParameter((Object)aCatch, (String)"aCatch");
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)aCatch, (String)"aCatch");
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitClass(@NotNull IrClass declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
                }

                public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
                }

                public void visitComposite(@NotNull IrComposite expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                }

                public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2) {
                    Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitConstructor(@NotNull IrConstructor declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
                }

                public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                public void visitContinue(@NotNull IrContinue jump) {
                    Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
                }

                public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                    Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch) {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitExpression(@NotNull IrExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                }

                public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                }

                public void visitField(@NotNull IrField declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
                }

                public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitFile(@NotNull IrFile declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
                }

                public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
                }

                public void visitFunction(@NotNull IrFunction declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
                }

                public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                }

                public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitGetClass(@NotNull IrGetClass expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                }

                public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitGetField(@NotNull IrGetField expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                }

                public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                }

                public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitLoop(@NotNull IrLoop loop2) {
                    Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                }

                public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
                }

                public void visitProperty(@NotNull IrProperty declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
                }

                public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                }

                public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                }

                public void visitReturn(@NotNull IrReturn expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                }

                public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitScript(@NotNull IrScript declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
                }

                public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
                }

                public void visitSetField(@NotNull IrSetField expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                }

                public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitSetValue(@NotNull IrSetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                }

                public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                    Intrinsics.checkNotNullParameter((Object)spread, (String)"spread");
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)spread, (String)"spread");
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                }

                public void visitThrow(@NotNull IrThrow expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                }

                public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitTry(@NotNull IrTry aTry) {
                    Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
                }

                public void visitVararg(@NotNull IrVararg expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                }

                public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitVariable(@NotNull IrVariable declaration2) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
                }

                public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
                }

                public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
                }

                public void visitWhen(@NotNull IrWhen expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                }

                public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                    Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                    Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            });
            return containsReified.element;
        }
        return value$iv;
    }

    @NotNull
    public final JvmBackendContext getBackendContext() {
        return this.backendContext;
    }

    public StaticCallableReferenceLowering(@NotNull JvmBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        this.backendContext = backendContext;
        this.staticInstanceFields = new HashMap();
        boolean bl = false;
        this.containsReifiedTypeParametersCache = new LinkedHashMap();
    }
}

