/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.SamEqualsHashCodeMethodsGenerator;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbi;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\n*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "ignoredFunctionReferences", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "isIgnored", "", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)Z", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitFunctionReference", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isSuspendFunctionReference", "Companion", "FunctionReferenceBuilder", "backend.jvm"})
public final class FunctionReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    private final Set<IrCallableReference<?>> ignoredFunctionReferences;
    private final JvmBackendContext context;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final boolean isIgnored(IrFunctionReference $this$isIgnored) {
        return !IrTypeUtilsKt.isFunctionOrKFunction($this$isIgnored.getType()) && !this.isSuspendFunctionReference($this$isIgnored) || this.ignoredFunctionReferences.contains($this$isIgnored);
    }

    private final boolean isSuspendFunctionReference(IrFunctionReference $this$isSuspendFunctionReference) {
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend($this$isSuspendFunctionReference) && ($this$isSuspendFunctionReference.getOrigin() == null || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE) || Intrinsics.areEqual((Object)$this$isSuspendFunctionReference.getOrigin(), (Object)IrStatementOrigin.SUSPEND_CONVERSION.INSTANCE));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.ignoredFunctionReferences.addAll((Collection)IrInlineReferenceLocator.Companion.scan(this.context, irFile));
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!IrUtilsKt.isLambda(expression2.getOrigin())) {
            return super.visitBlock(expression2);
        }
        Object object = CollectionsKt.last(expression2.getStatements());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
        }
        IrFunctionReference reference = (IrFunctionReference)object;
        if (this.isIgnored(reference)) {
            return super.visitBlock(expression2);
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast(expression2.getStatements(), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            it.transform(this, null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(reference, this);
        return new FunctionReferenceBuilder(this, reference, null, 2, null).build();
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        return this.isIgnored(expression2) ? (IrExpression)expression2 : new FunctionReferenceBuilder(this, expression2, null, 2, null).build();
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getOperator() == IrTypeOperator.SAM_CONVERSION) {
            IrFunctionReference irFunctionReference;
            IrExpression invokable = expression2.getArgument();
            if (invokable instanceof IrFunctionReference) {
                irFunctionReference = (IrFunctionReference)invokable;
            } else if (invokable instanceof IrBlock && IrUtilsKt.isLambda(((IrBlock)invokable).getOrigin()) && CollectionsKt.last(((IrBlock)invokable).getStatements()) instanceof IrFunctionReference) {
                Iterable $this$forEach$iv = CollectionsKt.dropLast(((IrBlock)invokable).getStatements(), (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl = false;
                    it.transform(this, null);
                }
                Object object = CollectionsKt.last(((IrBlock)invokable).getStatements());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                }
                irFunctionReference = (IrFunctionReference)object;
            } else {
                return super.visitTypeOperator(expression2);
            }
            IrFunctionReference reference = irFunctionReference;
            this.transformChildrenVoid(reference);
            return new FunctionReferenceBuilder(this, reference, expression2.getTypeOperand()).build();
        }
        return super.visitTypeOperator(expression2);
    }

    public FunctionReferenceLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.ignoredFunctionReferences = new LinkedHashSet();
    }

    public static final /* synthetic */ IrDeclarationParent access$getCurrentDeclarationParent$p(FunctionReferenceLowering $this) {
        return $this.getCurrentDeclarationParent();
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010-\u001a\u00020\u0010J\u001a\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\b\b\u0002\u00101\u001a\u00020\u0005H\u0002J\b\u00102\u001a\u000203H\u0002J\u0014\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002050\u000eH\u0002J\u0012\u00106\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u000108H\u0002J)\u00109\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0017\u0010:\u001a\u0013\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u00100;\u00a2\u0006\u0002\b=H\u0002J\b\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020\bH\u0002J\b\u0010B\u001a\u00020\u0019H\u0002J\u0016\u0010C\u001a\u00020D*\u00020/2\b\u0010E\u001a\u0004\u0018\u000108H\u0002J\f\u0010F\u001a\u00020D*\u00020/H\u0002J-\u0010G\u001a\u00020D*\u00020<2\u0006\u0010H\u001a\u00020\n2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\u00100;\u00a2\u0006\u0002\b=H\u0002J\u0016\u0010K\u001a\u00020D*\u00020<2\b\u0010L\u001a\u0004\u0018\u00010MH\u0002J\u0014\u0010N\u001a\u00020\u0010*\u00020<2\u0006\u0010O\u001a\u00020PH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00050&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010)\u001a\u00020**\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006Q"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$FunctionReferenceBuilder;", "", "irFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "adaptedReferenceOriginalTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "adapteeCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "argumentTypes", "", "boundReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "callee", "functionReferenceClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "functionSuperClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getIrFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "isAdaptedReference", "", "isKotlinFunInterface", "isLambda", "needToGenerateSamEqualsHashCodeMethods", "parameterTypes", "receiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getSamSuperType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "superMethod", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "superType", "typeArgumentsMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "useOptimizedSuperClass", "originalName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/name/Name;", "build", "buildOverride", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "superFunction", "newReturnType", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "createFakeBoundReceiverForJvmStaticInObject", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "createInvokeMethod", "receiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createLegacyMethodOverride", "generator", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "Lkotlin/ExtensionFunctionType;", "getAdaptedCallableReferenceFlags", "", "getFunctionReferenceFlags", "callableReferenceTarget", "hasVarargMappedToElement", "createFunctionReferenceInvokeMethod", "", "receiver", "createLambdaInvokeMethod", "generateConstructorCallArguments", "call", "generateBoundReceiver", "Lorg/jetbrains/kotlin/ir/builders/IrBuilder;", "generateSamEqualsHashCodeMethods", "boundReceiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "generateSignature", "target", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "backend.jvm"})
    private final class FunctionReferenceBuilder {
        private final boolean isLambda;
        private final IrFunction callee;
        private final Pair<IrValueParameter, IrExpression> boundReceiver;
        private final List<IrType> parameterTypes;
        private final List<IrType> argumentTypes;
        private final Map<IrTypeParameterSymbol, IrType> typeArgumentsMap;
        private final IrClassSymbol functionSuperClass;
        private final IrSimpleFunctionSymbol superMethod;
        private final boolean useOptimizedSuperClass;
        private final IrFunctionAccessExpression adapteeCall;
        private final IrFunction adaptedReferenceOriginalTarget;
        private final boolean isAdaptedReference;
        private final boolean isKotlinFunInterface;
        private final boolean needToGenerateSamEqualsHashCodeMethods;
        private final IrType superType;
        private final IrClass functionReferenceClass;
        private final IrField receiverField;
        @NotNull
        private final IrFunctionReference irFunctionReference;
        @Nullable
        private final IrType samSuperType;
        final /* synthetic */ FunctionReferenceLowering this$0;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression build() {
            void $this$apply;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock$iv;
            JvmBackendContext jvmBackendContext = this.this$0.context;
            ScopeWithIr scopeWithIr = this.this$0.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder$default(jvmBackendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null);
            boolean bl = false;
            boolean bl2 = false;
            JvmIrBuilder $this$run = jvmIrBuilder;
            boolean bl3 = false;
            IrBuilderWithScope irBuilderWithScope = $this$run;
            int n = this.irFunctionReference.getStartOffset();
            int endOffset$iv = this.irFunctionReference.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$irBlock = this_$iv$iv;
            boolean bl4 = false;
            IrConstructor constructor2 = this.createConstructor();
            IrVariable boundReceiverVar = this.samSuperType != null && this.boundReceiver != null ? ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$irBlock, (IrExpression)this.boundReceiver.getSecond(), null, null, false, 14, null) : null;
            this.createInvokeMethod(boundReceiverVar);
            if (!this.isLambda && this.samSuperType == null && !this.useOptimizedSuperClass) {
                this.createLegacyMethodOverride((IrSimpleFunction)$this$run.getIrSymbols().getFunctionReferenceGetSignature().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>($this$run, this){
                    final /* synthetic */ JvmIrBuilder $this_run$inlined;
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.$this_run$inlined = jvmIrBuilder;
                        this.this$0 = functionReferenceBuilder;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)$this$createLegacyMethodOverride, (String)"$receiver");
                        return FunctionReferenceBuilder.access$generateSignature(this.this$0, $this$createLegacyMethodOverride, FunctionReferenceBuilder.access$getCallee$p(this.this$0).getSymbol());
                    }
                }));
                this.createLegacyMethodOverride((IrSimpleFunction)$this$run.getIrSymbols().getFunctionReferenceGetName().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>($this$run, this){
                    final /* synthetic */ JvmIrBuilder $this_run$inlined;
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.$this_run$inlined = jvmIrBuilder;
                        this.this$0 = functionReferenceBuilder;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)$this$createLegacyMethodOverride, (String)"$receiver");
                        IrBuilderWithScope irBuilderWithScope = $this$createLegacyMethodOverride;
                        String string2 = FunctionReferenceBuilder.access$getOriginalName$p(this.this$0, FunctionReferenceBuilder.access$getCallee$p(this.this$0)).asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"callee.originalName.asString()");
                        return ExpressionHelpersKt.irString(irBuilderWithScope, string2);
                    }
                }));
                this.createLegacyMethodOverride((IrSimpleFunction)$this$run.getIrSymbols().getFunctionReferenceGetOwner().getOwner(), (Function1<? super JvmIrBuilder, ? extends IrExpression>)((Function1)new Function1<JvmIrBuilder, IrExpression>($this$run, this){
                    final /* synthetic */ JvmIrBuilder $this_run$inlined;
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.$this_run$inlined = jvmIrBuilder;
                        this.this$0 = functionReferenceBuilder;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull JvmIrBuilder $this$createLegacyMethodOverride) {
                        Intrinsics.checkNotNullParameter((Object)$this$createLegacyMethodOverride, (String)"$receiver");
                        return FunctionReferenceLowering.Companion.calculateOwner$backend_jvm($this$createLegacyMethodOverride, FunctionReferenceBuilder.access$getCallee$p(this.this$0).getParent(), $this$createLegacyMethodOverride.getBackendContext());
                    }
                }));
            }
            if (this.needToGenerateSamEqualsHashCodeMethods) {
                this.generateSamEqualsHashCodeMethods($this$run, boundReceiverVar);
            }
            if (this.isKotlinFunInterface) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.addFakeOverrides$default(this.functionReferenceClass, $this$irBlock.getContext().getIrBuiltIns(), null, 2, null);
            }
            $this$irBlock.unaryPlus(this.functionReferenceClass);
            IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, (IrConstructorSymbol)constructor2.getSymbol());
            boolean bl5 = false;
            boolean bl6 = false;
            IrConstructorCall irConstructorCall2 = irConstructorCall;
            void var22_22 = $this$irBlock;
            boolean bl7 = false;
            if ($this$apply.getValueArgumentsCount() > 0) {
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                Intrinsics.checkNotNull(pair);
                $this$apply.putValueArgument(0, (IrExpression)pair.getSecond());
            }
            Unit unit = Unit.INSTANCE;
            var22_22.unaryPlus(irConstructorCall);
            return this_$iv$iv.doBuild();
        }

        private final void generateSamEqualsHashCodeMethods(JvmIrBuilder $this$generateSamEqualsHashCodeMethods, IrVariable boundReceiverVar) {
            IrAnnotationContainer irAnnotationContainer = this.samSuperType;
            boolean bl = false;
            boolean bl2 = false;
            if (irAnnotationContainer == null) {
                boolean bl3 = false;
                String string2 = "equals/hashCode can only be generated for fun interface wrappers: " + RenderIrElementKt.render(this.callee);
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            if (!this.useOptimizedSuperClass) {
                irAnnotationContainer = DeclarationBuildersKt.addFunction$default(this.functionReferenceClass, "equals", $this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getBooleanType(), Modality.ABSTRACT, null, false, false, false, null, 0, 0, 1016, null);
                bl = false;
                bl2 = false;
                IrAnnotationContainer $this$apply = irAnnotationContainer;
                boolean bl4 = false;
                DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$apply, "other", $this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getAnyNType(), null, 4, null);
                DeclarationBuildersKt.addFunction$default(this.functionReferenceClass, "hashCode", $this$generateSamEqualsHashCodeMethods.getBackendContext().getIrBuiltIns().getIntType(), Modality.ABSTRACT, null, false, false, false, null, 0, 0, 1016, null);
                return;
            }
            new SamEqualsHashCodeMethodsGenerator($this$generateSamEqualsHashCodeMethods.getBackendContext(), this.functionReferenceClass, this.samSuperType, (Function2<? super IrBuilderWithScope, ? super IrExpression, ? extends IrExpression>)((Function2)new Function2<IrBuilderWithScope, IrExpression, IrExpression>(this, $this$generateSamEqualsHashCodeMethods, boundReceiverVar){
                final /* synthetic */ FunctionReferenceBuilder this$0;
                final /* synthetic */ JvmIrBuilder $this_generateSamEqualsHashCodeMethods;
                final /* synthetic */ IrVariable $boundReceiverVar;

                @NotNull
                public final IrExpression invoke(@NotNull IrBuilderWithScope $receiver, @NotNull IrExpression it) {
                    Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IrClassSymbol internalClass = FunctionReferenceBuilder.access$isAdaptedReference$p(this.this$0) ? this.$this_generateSamEqualsHashCodeMethods.getBackendContext().getIr().getSymbols().getAdaptedFunctionReference() : this.$this_generateSamEqualsHashCodeMethods.getBackendContext().getIr().getSymbols().getFunctionReferenceImpl();
                    Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors((IrClass)internalClass.getOwner());
                    boolean $i$f$single = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (E element$iv : $this$single$iv) {
                        IrConstructor it2 = (IrConstructor)element$iv;
                        boolean bl = false;
                        if (!(it2.getValueParameters().size() == 1 + (FunctionReferenceBuilder.access$getBoundReceiver$p(this.this$0) != null ? 1 : 0) + 4)) continue;
                        if (found$iv) {
                            throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    IrConstructor constructor2 = single$iv;
                    IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCallConstructor($receiver, (IrConstructorSymbol)constructor2.getSymbol(), CollectionsKt.emptyList());
                    boolean bl = false;
                    boolean bl2 = false;
                    IrConstructorCall $this$apply = irConstructorCall;
                    boolean bl3 = false;
                    FunctionReferenceBuilder.access$generateConstructorCallArguments(this.this$0, this.$this_generateSamEqualsHashCodeMethods, $this$apply, (Function1)new Function1<IrBuilder, IrExpression>(this, $receiver){
                        final /* synthetic */ generateSamEqualsHashCodeMethods.3 this$0;
                        final /* synthetic */ IrBuilderWithScope $receiver$0$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$receiver$0$inlined = irBuilderWithScope;
                            super(1);
                        }

                        @NotNull
                        public final IrExpression invoke(@NotNull IrBuilder $this$generateConstructorCallArguments) {
                            Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$receiver");
                            IrVariable irVariable2 = this.this$0.$boundReceiverVar;
                            Intrinsics.checkNotNull((Object)irVariable2);
                            return ExpressionHelpersKt.irGet(this.$receiver$0$inlined, irVariable2);
                        }
                    });
                    return irConstructorCall;
                }
                {
                    this.this$0 = functionReferenceBuilder;
                    this.$this_generateSamEqualsHashCodeMethods = jvmIrBuilder;
                    this.$boundReceiverVar = irVariable2;
                    super(2);
                }
            })).generate();
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor() {
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            void $this$run;
            JvmIrBuilder single$iv;
            IrConstructor irConstructor2;
            Object arg;
            IrClass $this$addConstructor$iv = this.functionReferenceClass;
            boolean $i$f$addConstructor = false;
            IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionBuilder $this$run$iv$iv2 = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$buildConstructor$iv = $this$run$iv$iv2;
            boolean bl42 = false;
            IrFunctionBuilder $this$addConstructor = $this$buildConstructor$iv;
            boolean bl5 = false;
            $this$addConstructor.setOrigin(JvmLoweredDeclarationOrigin.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$addConstructor.setReturnType(IrUtilsKt.getDefaultType(this.functionReferenceClass));
            $this$addConstructor.setPrimary(true);
            $this$buildConstructor$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            Pair<IrValueParameter, IrExpression> pair = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, $this$run$iv$iv2);
            $i$f$buildConstructor = false;
            boolean bl6 = false;
            Pair<IrValueParameter, IrExpression> constructor$iv = pair;
            boolean bl7 = false;
            $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
            constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
            Pair<IrValueParameter, IrExpression> pair2 = pair;
            boolean bl8 = false;
            boolean bl9 = false;
            Pair<IrValueParameter, IrExpression> $this$apply = pair2;
            boolean bl10 = false;
            if (this.samSuperType == null) {
                Pair<IrValueParameter, IrExpression> pair3 = this.boundReceiver;
                if (pair3 != null) {
                    void param;
                    constructor$iv = pair3;
                    bl7 = false;
                    boolean $this$run$iv$iv2 = false;
                    Pair<IrValueParameter, IrExpression> $dstr$param$arg = constructor$iv;
                    boolean bl11 = false;
                    IrValueParameter bl42 = (IrValueParameter)$dstr$param$arg.component1();
                    arg = (IrExpression)$dstr$param$arg.component2();
                    Pair<IrValueParameter, IrExpression> pair4 = $this$apply;
                    pair4.setValueParameters((List<? extends IrValueParameter>)CollectionsKt.plus((Collection)pair4.getValueParameters(), (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, (IrFunction)$this$apply, null, 0, 0, 0, null, null, ((IrExpression)arg).getType(), null, null, false, false, false, 8058, null)));
                }
            }
            if (this.samSuperType != null) {
                irConstructor2 = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)this.this$0.context.getIrBuiltIns().getAnyClass().getOwner()));
            } else {
                int expectedArity = this.isLambda && !this.isAdaptedReference ? 1 : 1 + (this.boundReceiver != null ? 1 : 0) + (this.useOptimizedSuperClass ? 4 : 0);
                IrClass irClass2 = IrTypesKt.getClass(this.superType);
                Intrinsics.checkNotNull((Object)irClass2);
                Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors(irClass2);
                boolean $i$f$single = false;
                single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    IrConstructor it = (IrConstructor)element$iv;
                    boolean bl12 = false;
                    if (!(it.getValueParameters().size() == expectedArity)) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                irConstructor2 = (IrConstructor)((Object)single$iv);
            }
            IrConstructor constructor2 = irConstructor2;
            JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder$default(this.this$0.context, $this$apply.getSymbol(), 0, 0, 6, null);
            boolean bl13 = false;
            boolean bl14 = false;
            single$iv = jvmIrBuilder;
            Pair<IrValueParameter, IrExpression> pair5 = $this$apply;
            boolean bl15 = false;
            arg = (IrBuilderWithScope)$this$run;
            int element$iv = $this$run.getStartOffset();
            int endOffset$iv = $this$run.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$irBlockBody = this_$iv$iv;
            boolean bl16 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$irBlockBody, constructor2);
            boolean bl17 = false;
            boolean bl18 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall;
            void var25_37 = $this$irBlockBody;
            boolean bl19 = false;
            if (this.samSuperType == null) {
                void call2;
                this.generateConstructorCallArguments((JvmIrBuilder)$this$run, (IrFunctionAccessExpression)call2, (Function1<? super IrBuilder, ? extends IrExpression>)((Function1)new Function1<IrBuilder, IrExpression>((IrBlockBodyBuilder)$this$irBlockBody, (JvmIrBuilder)$this$run, $this$apply, constructor2, this){
                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody$inlined;
                    final /* synthetic */ JvmIrBuilder $this_run$inlined;
                    final /* synthetic */ IrConstructor $this_apply$inlined;
                    final /* synthetic */ IrConstructor $constructor$inlined;
                    final /* synthetic */ FunctionReferenceBuilder this$0;
                    {
                        this.$this_irBlockBody$inlined = irBlockBodyBuilder;
                        this.$this_run$inlined = jvmIrBuilder;
                        this.$this_apply$inlined = irConstructor2;
                        this.$constructor$inlined = irConstructor3;
                        this.this$0 = functionReferenceBuilder;
                        super(1);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull IrBuilder $this$generateConstructorCallArguments) {
                        Intrinsics.checkNotNullParameter((Object)$this$generateConstructorCallArguments, (String)"$receiver");
                        return ExpressionHelpersKt.irGet(this.$this_irBlockBody$inlined, (IrValueDeclaration)CollectionsKt.first(this.$this_apply$inlined.getValueParameters()));
                    }
                }));
            }
            Unit unit = Unit.INSTANCE;
            var25_37.unaryPlus(irDelegatingConstructorCall);
            $this$irBlockBody.unaryPlus(new IrInstanceInitializerCallImpl($this$irBlockBody.getStartOffset(), $this$irBlockBody.getEndOffset(), (IrClassSymbol)this.functionReferenceClass.getSymbol(), $this$irBlockBody.getContext().getIrBuiltIns().getUnitType()));
            IrBlockBody irBlockBody2 = this_$iv$iv.doBuild();
            pair5.setBody((IrBody)irBlockBody2);
            return pair2;
        }

        private final void generateConstructorCallArguments(JvmIrBuilder $this$generateConstructorCallArguments, IrFunctionAccessExpression call2, Function1<? super IrBuilder, ? extends IrExpression> generateBoundReceiver) {
            int index2 = 0;
            call2.putValueArgument(index2++, ExpressionHelpersKt.irInt$default($this$generateConstructorCallArguments, this.argumentTypes.size() + (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(this.irFunctionReference) ? 1 : 0), null, 2, null));
            if (this.boundReceiver != null) {
                call2.putValueArgument(index2++, (IrExpression)generateBoundReceiver.invoke((Object)$this$generateConstructorCallArguments));
            }
            if (!this.isLambda && this.useOptimizedSuperClass) {
                IrFunction irFunction = this.adaptedReferenceOriginalTarget;
                if (irFunction == null) {
                    irFunction = this.callee;
                }
                IrFunction callableReferenceTarget = irFunction;
                IrExpression owner = Companion.calculateOwnerKClass$backend_jvm($this$generateConstructorCallArguments, callableReferenceTarget.getParent(), $this$generateConstructorCallArguments.getBackendContext());
                call2.putValueArgument(index2++, Companion.kClassToJavaClass$backend_jvm($this$generateConstructorCallArguments, owner, $this$generateConstructorCallArguments.getBackendContext()));
                int n = index2++;
                IrBuilderWithScope irBuilderWithScope = $this$generateConstructorCallArguments;
                String string2 = this.getOriginalName(callableReferenceTarget).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"callableReferenceTarget.originalName.asString()");
                call2.putValueArgument(n, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
                call2.putValueArgument(index2++, this.generateSignature($this$generateConstructorCallArguments, callableReferenceTarget.getSymbol()));
                call2.putValueArgument(index2, ExpressionHelpersKt.irInt$default($this$generateConstructorCallArguments, this.getFunctionReferenceFlags(callableReferenceTarget), null, 2, null));
            }
        }

        private final int getFunctionReferenceFlags(IrFunction callableReferenceTarget) {
            int isTopLevelBit = Companion.getCallableReferenceTopLevelFlag$backend_jvm(callableReferenceTarget);
            int adaptedCallableReferenceFlags = this.getAdaptedCallableReferenceFlags();
            return isTopLevelBit + (adaptedCallableReferenceFlags << 1);
        }

        private final int getAdaptedCallableReferenceFlags() {
            if (this.adaptedReferenceOriginalTarget == null) {
                return 0;
            }
            int isVarargMappedToElementBit = this.hasVarargMappedToElement() ? 1 : 0;
            int isSuspendConvertedBit = !AdditionalIrUtilsKt.isSuspend(this.adaptedReferenceOriginalTarget) && AdditionalIrUtilsKt.isSuspend(this.callee) ? 1 : 0;
            int isCoercedToUnitBit = !IrTypePredicatesKt.isUnit(this.adaptedReferenceOriginalTarget.getReturnType()) && IrTypePredicatesKt.isUnit(this.callee.getReturnType()) ? 1 : 0;
            return isVarargMappedToElementBit + (isSuspendConvertedBit << 1) + (isCoercedToUnitBit << 2);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean hasVarargMappedToElement() {
            if (this.adapteeCall == null) {
                return false;
            }
            int n = 0;
            int n2 = this.adapteeCall.getValueArgumentsCount();
            while (n < n2) {
                IrExpression arg;
                void i;
                if (this.adapteeCall.getValueArgument((int)i) == null) {
                } else if (arg instanceof IrVararg) {
                    for (IrVarargElement varargElement : ((IrVararg)arg).getElements()) {
                        if (!(varargElement instanceof IrGetValue)) continue;
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        private final IrSimpleFunction createInvokeMethod(IrValueDeclaration receiverVar) {
            Name name;
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionBuilder $this$run$iv$iv$iv = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$addFunction = $this$run$iv$iv$iv;
            boolean bl4 = false;
            IrElementBuilderKt.setSourceRange($this$addFunction, this.isLambda ? (IrElement)this.callee : (IrElement)this.irFunctionReference);
            if (this.samSuperType == null && org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getErasedUpperBound(this.callee.getReturnType()).isInline() && this.this$0.context.getState().getFunctionsWithInlineClassReturnTypesMangled()) {
                String suffix = InlineClassAbi.INSTANCE.hashReturnSuffix(this.callee);
                Name name2 = Name.identifier(((IrSimpleFunction)this.superMethod.getOwner()).getName().asString() + '-' + suffix);
                name = name2;
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"${super\u2026e.asString()}-${suffix}\")");
            } else {
                name = ((IrSimpleFunction)this.superMethod.getOwner()).getName();
            }
            $this$addFunction.setName(name);
            $this$addFunction.setReturnType(this.callee.getReturnType());
            $this$addFunction.setSuspend(AdditionalIrUtilsKt.isSuspend(this.callee));
            $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$run$iv$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            Object function$iv$iv = $this$buildFun$iv$iv$iv;
            boolean bl7 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object object = $this$buildFun$iv$iv$iv;
            boolean bl8 = false;
            boolean bl9 = false;
            Object $this$apply = object;
            boolean bl10 = false;
            Object object2 = $this$apply;
            object2.setOverriddenSymbols(CollectionsKt.plus((Collection)object2.getOverriddenSymbols(), (Object)this.superMethod));
            IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass((IrDeclaration)$this$apply).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            ((IrFunction)$this$apply).setDispatchReceiverParameter(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter, (IrFunction)$this$apply, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
            if (this.isLambda) {
                this.createLambdaInvokeMethod((IrSimpleFunction)$this$apply);
            } else {
                this.createFunctionReferenceInvokeMethod((IrSimpleFunction)$this$apply, receiverVar);
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            IrSimpleFunction irSimpleFunction = $this$createLambdaInvokeMethod;
            irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)irSimpleFunction.getAnnotations(), (Iterable)this.callee.getAnnotations()));
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.callee));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                void index2;
                Map map2 = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int n = $dstr$index$param.component1();
                IrValueParameter param = (IrValueParameter)$dstr$index$param.component2();
                Pair pair = TuplesKt.to((Object)param, (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, (int)index2, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                boolean bl2 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            IrSimpleFunction irSimpleFunction2 = $this$createLambdaInvokeMethod;
            irSimpleFunction2.setValueParameters(CollectionsKt.plus((Collection)irSimpleFunction2.getValueParameters(), (Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.callee, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod, IrValueDeclaration receiver) {
            void $this$apply;
            void $this$run;
            boolean bl;
            Object $this$addValueParameter$iv;
            boolean bl2 = false;
            for (IrType argumentType : (Iterable)this.argumentTypes) {
                void index2;
                $this$addValueParameter$iv = $this$createFunctionReferenceInvokeMethod;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl3 = false;
                bl = false;
                IrValueParameterBuilder $this$run$iv = irValueParameterBuilder;
                boolean bl4 = false;
                IrValueParameterBuilder $this$addValueParameter = $this$run$iv;
                boolean bl5 = false;
                Name name = Name.identifier("" + 'p' + (int)index2);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"p$index\")");
                $this$addValueParameter.setName(name);
                $this$addValueParameter.setType(argumentType);
                if ($this$run$iv.getIndex() == -1) {
                    $this$run$iv.setIndex(((IrFunction)$this$addValueParameter$iv).getValueParameters().size());
                }
                Iterator<IrValueParameter> iterator2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$run$iv, (IrDeclarationParent)$this$addValueParameter$iv);
                boolean bl6 = false;
                boolean bl7 = false;
                Iterator<IrValueParameter> valueParameter$iv = iterator2;
                boolean bl8 = false;
                ((IrFunction)$this$addValueParameter$iv).setValueParameters(CollectionsKt.plus((Collection)((IrFunction)$this$addValueParameter$iv).getValueParameters(), valueParameter$iv));
                ++index2;
            }
            JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder(this.this$0.context, $this$createFunctionReferenceInvokeMethod.getSymbol(), $this$createFunctionReferenceInvokeMethod.getStartOffset(), $this$createFunctionReferenceInvokeMethod.getEndOffset());
            boolean bl9 = false;
            boolean bl10 = false;
            $this$addValueParameter$iv = jvmIrBuilder;
            IrSimpleFunction irSimpleFunction = $this$createFunctionReferenceInvokeMethod;
            boolean bl11 = false;
            int unboundIndex = 0;
            IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$run, this.callee);
            bl = false;
            boolean bl12 = false;
            IrFunctionAccessExpression bl4 = irFunctionAccessExpression;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$run;
            boolean bl13 = false;
            for (IrTypeParameter typeParameter : IrUtilsKt.getAllTypeParameters(((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner())) {
                $this$apply.putTypeArgument(typeParameter.getIndex(), this.typeArgumentsMap.get(typeParameter.getSymbol()));
            }
            for (IrValueParameter parameter : IrUtilsKt.getExplicitParameters(this.callee)) {
                IrExpression irExpression;
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                if (Intrinsics.areEqual((Object)(pair != null ? (IrValueParameter)pair.getFirst() : null), (Object)parameter)) {
                    if (this.samSuperType == null) {
                        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$run;
                        IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$run;
                        IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$run;
                        IrValueParameter irValueParameter = $this$createFunctionReferenceInvokeMethod.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter);
                        irExpression = ExpressionHelpersKt.irImplicitCast(irBuilderWithScope2, ExpressionHelpersKt.irGetField(irBuilderWithScope3, ExpressionHelpersKt.irGet(irBuilderWithScope4, irValueParameter), this.receiverField), ((IrExpression)this.boundReceiver.getSecond()).getType());
                    } else {
                        IrBuilderWithScope irBuilderWithScope5 = (IrBuilderWithScope)$this$run;
                        IrValueDeclaration irValueDeclaration = receiver;
                        Intrinsics.checkNotNull((Object)irValueDeclaration);
                        irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope5, irValueDeclaration);
                    }
                } else if (AdditionalIrUtilsKt.isVararg(parameter) && unboundIndex < this.argumentTypes.size() && Intrinsics.areEqual((Object)parameter.getType(), (Object)$this$createFunctionReferenceInvokeMethod.getValueParameters().get(unboundIndex).getType())) {
                    int n = unboundIndex;
                    unboundIndex = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n));
                } else if (AdditionalIrUtilsKt.isVararg(parameter) && (unboundIndex < this.argumentTypes.size() || !IrUtilsKt.hasDefaultValue(parameter))) {
                    void $this$irArray$iv;
                    void var17_28 = $this$run;
                    IrType arrayType$iv = parameter.getType();
                    boolean $i$f$irArray = false;
                    IrArrayBuilder irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
                    boolean bl14 = false;
                    boolean bl15 = false;
                    IrArrayBuilder $this$apply$iv = irArrayBuilder;
                    boolean bl16 = false;
                    IrArrayBuilder $this$irArray = $this$apply$iv;
                    boolean bl17 = false;
                    Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)unboundIndex, (int)this.argumentTypes.size());
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv.iterator();
                    while (iterator3.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator3).nextInt();
                        boolean bl18 = false;
                        int n = unboundIndex;
                        unboundIndex = n + 1;
                        $this$irArray.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n)));
                    }
                    irExpression = irArrayBuilder.build();
                } else if (unboundIndex >= this.argumentTypes.size()) {
                    irExpression = null;
                } else {
                    int n = unboundIndex;
                    unboundIndex = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n));
                }
                if (irExpression == null) continue;
                IrExpression irExpression2 = irExpression;
                boolean bl19 = false;
                boolean bl20 = false;
                IrExpression it = irExpression2;
                boolean bl21 = false;
                IrMemberAccessExpressionKt.putArgument((IrMemberAccessExpression)$this$apply, this.callee, parameter, it);
            }
            Unit unit = Unit.INSTANCE;
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody(irBuilderWithScope, irFunctionAccessExpression);
            irSimpleFunction.setBody(irExpressionBody);
        }

        private final IrSimpleFunction buildOverride(IrSimpleFunction superFunction, IrType newReturnType) {
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionBuilder $this$run$iv$iv$iv = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$addFunction = $this$run$iv$iv$iv;
            boolean bl4 = false;
            IrElementBuilderKt.setSourceRange($this$addFunction, this.irFunctionReference);
            $this$addFunction.setOrigin(JvmLoweredDeclarationOrigin.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$addFunction.setName(superFunction.getName());
            $this$addFunction.setReturnType(newReturnType);
            $this$addFunction.setVisibility(superFunction.getVisibility());
            $this$addFunction.setSuspend(superFunction.isSuspend());
            $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$run$iv$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            Object function$iv$iv = $this$buildFun$iv$iv$iv;
            boolean bl7 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object object = $this$buildFun$iv$iv$iv;
            boolean bl8 = false;
            boolean bl9 = false;
            Object $this$apply = object;
            boolean bl10 = false;
            Object object2 = $this$apply;
            object2.setOverriddenSymbols(CollectionsKt.plus((Collection)object2.getOverriddenSymbols(), (Object)superFunction.getSymbol()));
            IrValueParameter irValueParameter = this.functionReferenceClass.getThisReceiver();
            ((IrFunction)$this$apply).setDispatchReceiverParameter(irValueParameter != null ? org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter, (IrFunction)$this$apply, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null) : null);
            return object;
        }

        static /* synthetic */ IrSimpleFunction buildOverride$default(FunctionReferenceBuilder functionReferenceBuilder, IrSimpleFunction irSimpleFunction, IrType irType, int n, Object object) {
            if ((n & 2) != 0) {
                irType = irSimpleFunction.getReturnType();
            }
            return functionReferenceBuilder.buildOverride(irSimpleFunction, irType);
        }

        private final Name getOriginalName(IrFunction $this$originalName) {
            Object object = $this$originalName.getMetadata();
            if (object == null || (object = object.getName()) == null) {
                object = $this$originalName.getName();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression generateSignature(JvmIrBuilder $this$generateSignature, IrFunctionSymbol target) {
            void $this$apply;
            IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$generateSignature, $this$generateSignature.getBackendContext().getIr().getSymbols().getSignatureStringIntrinsic());
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$apply2 = irCall;
            boolean bl3 = false;
            IrFunctionReferenceImpl irFunctionReferenceImpl = new IrFunctionReferenceImpl(-1, -1, this.irFunctionReference.getType(), target, this.irFunctionReference.getTypeArgumentsCount(), target.getOwner().getValueParameters().size(), this.irFunctionReference.getReflectionTarget(), null);
            boolean bl4 = false;
            boolean bl5 = false;
            IrFunctionReferenceImpl irFunctionReferenceImpl2 = irFunctionReferenceImpl;
            int n = 0;
            IrCall irCall2 = $this$apply2;
            boolean bl6 = false;
            IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$apply, this.irFunctionReference, 0, 2, null);
            Unit unit = Unit.INSTANCE;
            irCall2.putValueArgument(n, irFunctionReferenceImpl);
            return irCall;
        }

        private final Pair<IrValueParameter, IrGetObjectValueImpl> createFakeBoundReceiverForJvmStaticInObject() {
            IrClass objectClass = IrUtilsKt.getParentAsClass(this.callee);
            IrDeclaration declaration$iv = this.callee;
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameterBuilder $this$run$iv = irValueParameterBuilder;
            boolean bl3 = false;
            IrValueParameterBuilder $this$buildValueParameter = $this$run$iv;
            boolean bl4 = false;
            Name name = Name.identifier("$this");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"\\$this\")");
            $this$buildValueParameter.setName(name);
            $this$buildValueParameter.setType(IrTypesKt.typeWith(objectClass, new IrType[0]));
            return TuplesKt.to((Object)DeclarationBuildersKt.buildValueParameter(declaration$iv.getFactory(), $this$run$iv, (IrDeclarationParent)((Object)declaration$iv)), (Object)new IrGetObjectValueImpl(-1, -1, IrTypesKt.typeWith(objectClass, new IrType[0]), (IrClassSymbol)objectClass.getSymbol()));
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createLegacyMethodOverride(IrSimpleFunction superFunction, Function1<? super JvmIrBuilder, ? extends IrExpression> generator2) {
            void $this$run;
            IrSimpleFunction irSimpleFunction = FunctionReferenceBuilder.buildOverride$default(this, superFunction, null, 2, null);
            boolean bl = false;
            boolean bl2 = false;
            IrSimpleFunction $this$apply = irSimpleFunction;
            boolean bl3 = false;
            JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder(this.this$0.context, $this$apply.getSymbol(), $this$apply.getStartOffset(), $this$apply.getEndOffset());
            boolean bl4 = false;
            boolean bl5 = false;
            JvmIrBuilder jvmIrBuilder2 = jvmIrBuilder;
            IrSimpleFunction irSimpleFunction2 = $this$apply;
            boolean bl6 = false;
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$run, (IrExpression)generator2.invoke((Object)$this$run));
            irSimpleFunction2.setBody(irExpressionBody);
            return irSimpleFunction;
        }

        @NotNull
        public final IrFunctionReference getIrFunctionReference() {
            return this.irFunctionReference;
        }

        @Nullable
        public final IrType getSamSuperType() {
            return this.samSuperType;
        }

        /*
         * Unable to fully structure code
         */
        public FunctionReferenceBuilder(@NotNull FunctionReferenceLowering this$0, @Nullable IrFunctionReference irFunctionReference, IrType samSuperType) {
            Intrinsics.checkNotNullParameter((Object)irFunctionReference, (String)"irFunctionReference");
            this.this$0 = this$0;
            super();
            this.irFunctionReference = irFunctionReference;
            this.samSuperType = samSuperType;
            this.isLambda = IrUtilsKt.isLambda(this.irFunctionReference.getOrigin());
            this.callee = ((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner();
            this.boundReceiver = JvmStaticAnnotationLoweringKt.isJvmStaticInObject(this.callee) != false ? this.createFakeBoundReceiverForJvmStaticInObject() : (Pair)CollectionsKt.singleOrNull(IrUtilsKt.getArgumentsWithIr(this.irFunctionReference));
            v0 = this.irFunctionReference.getType();
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            }
            var4_4 = ((IrSimpleType)v0).getArguments();
            var13_5 = this;
            $i$f$map = false;
            var6_9 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var11_24 = (IrTypeArgument)item$iv$iv;
                var14_28 = destination$iv$iv;
                $i$a$-map-FunctionReferenceLowering$FunctionReferenceBuilder$parameterTypes$1 = false;
                v1 = it;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
                }
                var15_29 = ((IrTypeProjection)v1).getType();
                var14_28.add(var15_29);
            }
            var14_28 = (List)destination$iv$iv;
            var13_5.parameterTypes = var14_28;
            this.argumentTypes = CollectionsKt.dropLast(this.parameterTypes, (int)1);
            this.typeArgumentsMap = IrUtilsKt.getTypeSubstitutionMap(this.irFunctionReference);
            v2 = this.samSuperType;
            if (v2 == null || (v2 = IrTypesKt.getClassOrNull((IrType)v2)) == null) {
                v2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(this.irFunctionReference) != false ? FunctionReferenceLowering.access$getContext$p(this$0).getIr().getSymbols().getJvmSuspendFunctionClass(this.argumentTypes.size()) : FunctionReferenceLowering.access$getContext$p(this$0).getIr().getSymbols().getJvmFunctionClass(this.argumentTypes.size());
            }
            this.functionSuperClass = v2;
            $this$map$iv = IrUtilsKt.getFunctions(this.functionSuperClass);
            var13_5 = this;
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            for (E element$iv : $this$single$iv) {
                it = (IrSimpleFunctionSymbol)element$iv;
                $i$a$-single-FunctionReferenceLowering$FunctionReferenceBuilder$superMethod$1 = false;
                if (!(((IrSimpleFunction)it.getOwner()).getModality() == Modality.ABSTRACT)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            var14_28 = single$iv;
            var13_5.superMethod = (IrSimpleFunctionSymbol)var14_28;
            this.useOptimizedSuperClass = FunctionReferenceLowering.access$getContext$p(this$0).getState().getGenerateOptimizedCallableReferenceSuperClasses();
            if (Intrinsics.areEqual((Object)this.callee.getOrigin(), (Object)IrDeclarationOrigin.ADAPTER_FOR_CALLABLE_REFERENCE.INSTANCE)) {
                v3 = this.callee.getBody();
                Intrinsics.checkNotNull((Object)v3);
                statement = (IrStatement)CollectionsKt.single(IrUtilsKt.getStatements(v3));
                if (statement instanceof IrTypeOperatorCall) {
                    var6_10 = ((IrTypeOperatorCall)statement).getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                    found$iv = false;
                    if (_Assertions.ENABLED && !var6_10) {
                        var13_5 = this;
                        $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$1 = false;
                        var14_28 = "Unexpected type operator in ADAPTER_FOR_CALLABLE_REFERENCE: " + RenderIrElementKt.render(this.callee);
                        v4 = var13_5;
                        $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$1 = var14_28;
                        throw (Throwable)new AssertionError($i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$1);
                    }
                    v5 = ((IrTypeOperatorCall)statement).getArgument();
                } else {
                    v5 = call = statement instanceof IrReturn != false ? (IrStatement)((IrReturn)statement).getValue() : statement;
                }
                if (!(call instanceof IrFunctionAccessExpression)) {
                    throw (Throwable)new UnsupportedOperationException("Unknown structure of ADAPTER_FOR_CALLABLE_REFERENCE: " + RenderIrElementKt.render(this.callee));
                }
                v6 = (IrFunctionAccessExpression)call;
            } else {
                v6 = null;
            }
            this.adaptedReferenceOriginalTarget = (v7 = (this.adapteeCall = v6)) != null && (v7 = (IrFunctionSymbol)v7.getSymbol()) != null ? v7.getOwner() : null;
            v8 = this.isAdaptedReference = this.adaptedReferenceOriginalTarget != null;
            if (this.samSuperType == null) ** GOTO lbl-1000
            v9 = IrTypesKt.getClass(this.samSuperType);
            if (Intrinsics.areEqual((Object)(v9 != null ? v9.getOrigin() : null), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) ^ true) {
                v10 = true;
            } else lbl-1000:
            // 2 sources

            {
                v10 = false;
            }
            this.isKotlinFunInterface = v10;
            this.needToGenerateSamEqualsHashCodeMethods = this.isKotlinFunInterface != false && (this.isAdaptedReference != false || this.isLambda == false);
            v11 = this.samSuperType;
            if (v11 == null) {
                v11 = IrTypesKt.getDefaultType(this.isLambda ? FunctionReferenceLowering.access$getContext$p(this$0).getIr().getSymbols().getLambdaClass() : (this.useOptimizedSuperClass ? (this.isAdaptedReference ? FunctionReferenceLowering.access$getContext$p(this$0).getIr().getSymbols().getAdaptedFunctionReference() : FunctionReferenceLowering.access$getContext$p(this$0).getIr().getSymbols().getFunctionReferenceImpl()) : FunctionReferenceLowering.access$getContext$p(this$0).getIr().getSymbols().getFunctionReference()));
            }
            this.superType = v11;
            $this$buildClass$iv = FunctionReferenceLowering.access$getContext$p(this$0).getIrFactory();
            $i$f$buildClass = false;
            var6_11 = new IrClassBuilder();
            found$iv = false;
            $i$a$-assert-FunctionReferenceLowering$FunctionReferenceBuilder$adapteeCall$call$1 = false;
            $this$run$iv = var6_11;
            $i$a$-run-DeclarationBuildersKt$buildClass$2$iv = false;
            $i$a$-single-FunctionReferenceLowering$FunctionReferenceBuilder$superMethod$1 = $this$run$iv;
            var13_5 = this;
            $i$a$-buildClass-FunctionReferenceLowering$FunctionReferenceBuilder$functionReferenceClass$1 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$buildClass, this.irFunctionReference);
            v12 = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"DescriptorVisibilities.LOCAL");
            $this$buildClass.setVisibility(v12);
            $this$buildClass.setOrigin(this.isLambda != false ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE);
            v13 = SpecialNames.NO_NAME_PROVIDED;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"SpecialNames.NO_NAME_PROVIDED");
            $this$buildClass.setName(v13);
            var14_28 = Unit.INSTANCE;
            var4_4 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$run$iv);
            var5_8 = false;
            var6_12 = false;
            found$iv = var4_4;
            $i$a$-apply-FunctionReferenceLowering$FunctionReferenceBuilder$functionReferenceClass$2 = false;
            v14 = FunctionReferenceLowering.access$getCurrentDeclarationParent$p(this.this$0);
            if (v14 == null) {
                var9_21 = "No current declaration parent at " + DumpIrTreeKt.dump$default(this.irFunctionReference, false, 1, null);
                var10_23 = false;
                throw (Throwable)new IllegalStateException(var9_21.toString());
            }
            $this$apply.setParent(v14);
            $this$apply.setSuperTypes(CollectionsKt.listOfNotNull((Object[])new IrType[]{this.superType, this.samSuperType == null ? IrTypesKt.typeWith((IrClassifierSymbol)this.functionSuperClass, this.parameterTypes) : null, org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(this.irFunctionReference) != false ? IrTypesKt.getDefaultType(FunctionReferenceLowering.access$getContext$p(this.this$0).getIr().getSymbols().getSuspendFunctionInterface()) : null, this.needToGenerateSamEqualsHashCodeMethods != false ? IrTypesKt.getDefaultType(FunctionReferenceLowering.access$getContext$p(this.this$0).getIr().getSymbols().getFunctionAdapter()) : null}));
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$apply);
            IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$apply, this.irFunctionReference);
            if (this.isLambda) {
                $this$apply.setMetadata(((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner().getMetadata());
            }
            var14_28 = Unit.INSTANCE;
            var13_5.functionReferenceClass = var4_4;
            this.receiverField = (IrField)FunctionReferenceLowering.access$getContext$p(this$0).getIr().getSymbols().getFunctionReferenceReceiverField().getOwner();
        }

        public /* synthetic */ FunctionReferenceBuilder(FunctionReferenceLowering functionReferenceLowering, IrFunctionReference irFunctionReference, IrType irType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irType = null;
            }
            this(functionReferenceLowering, irFunctionReference, irType);
        }

        public static final /* synthetic */ IrExpression access$generateSignature(FunctionReferenceBuilder $this, JvmIrBuilder $this$access_u24generateSignature, IrFunctionSymbol target) {
            return $this.generateSignature($this$access_u24generateSignature, target);
        }

        public static final /* synthetic */ IrFunction access$getCallee$p(FunctionReferenceBuilder $this) {
            return $this.callee;
        }

        public static final /* synthetic */ Name access$getOriginalName$p(FunctionReferenceBuilder $this, IrFunction $this$access_u24originalName_u24p) {
            return $this.getOriginalName($this$access_u24originalName_u24p);
        }

        public static final /* synthetic */ boolean access$isAdaptedReference$p(FunctionReferenceBuilder $this) {
            return $this.isAdaptedReference;
        }

        public static final /* synthetic */ Pair access$getBoundReceiver$p(FunctionReferenceBuilder $this) {
            return $this.boundReceiver;
        }

        public static final /* synthetic */ void access$generateConstructorCallArguments(FunctionReferenceBuilder $this, JvmIrBuilder $this$access_u24generateConstructorCallArguments, IrFunctionAccessExpression call2, Function1 generateBoundReceiver) {
            $this.generateConstructorCallArguments($this$access_u24generateConstructorCallArguments, call2, (Function1<? super IrBuilder, ? extends IrExpression>)generateBoundReceiver);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0011J!\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015J!\u0010\u0016\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0017J!\u0010\u0018\u001a\u00020\u0019*\u00020\u00142\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u00142\u0006\u0010\u001a\u001a\u00020\tH\u0002J!\u0010\u001e\u001a\u00020\u0019*\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FunctionReferenceLowering$Companion;", "", "()V", "getCallableReferenceTopLevelFlag", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getCallableReferenceTopLevelFlag$backend_jvm", "getOwnerKClassType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "irContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getOwnerKClassType$backend_jvm", "isCallableReferenceTopLevel", "", "isCallableReferenceTopLevel$backend_jvm", "calculateOwner", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "calculateOwner$backend_jvm", "calculateOwnerKClass", "calculateOwnerKClass$backend_jvm", "javaClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "classType", "javaClassReference$backend_jvm", "kClassReference", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrClassReferenceImpl;", "kClassToJavaClass", "kClassToJavaClass$backend_jvm", "backend.jvm"})
    public static final class Companion {
        private final IrClassReferenceImpl kClassReference(IrBuilderWithScope $this$kClassReference, IrType classType) {
            return new IrClassReferenceImpl($this$kClassReference.getStartOffset(), $this$kClassReference.getEndOffset(), IrTypesKt.getStarProjectedType($this$kClassReference.getContext().getIrBuiltIns().getKClassClass()), $this$kClassReference.getContext().getIrBuiltIns().getKClassClass(), classType);
        }

        @NotNull
        public final IrCall kClassToJavaClass$backend_jvm(@NotNull IrBuilderWithScope $this$kClassToJavaClass, @NotNull IrExpression kClassReference, @NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)$this$kClassToJavaClass, (String)"$this$kClassToJavaClass");
            Intrinsics.checkNotNullParameter((Object)kClassReference, (String)"kClassReference");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            IrType irType = IrTypesKt.getStarProjectedType(context2.getIr().getSymbols().getJavaLangClass());
            IrSimpleFunction irSimpleFunction = ((IrProperty)context2.getIr().getSymbols().getKClassJava().getOwner()).getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            IrCall irCall = ExpressionHelpersKt.irGet($this$kClassToJavaClass, irType, null, irSimpleFunction.getSymbol());
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$apply = irCall;
            boolean bl3 = false;
            $this$apply.setExtensionReceiver(kClassReference);
            return irCall;
        }

        @NotNull
        public final IrCall javaClassReference$backend_jvm(@NotNull IrBuilderWithScope $this$javaClassReference, @NotNull IrType classType, @NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)$this$javaClassReference, (String)"$this$javaClassReference");
            Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return this.kClassToJavaClass$backend_jvm($this$javaClassReference, this.kClassReference($this$javaClassReference, classType), context2);
        }

        @NotNull
        public final IrExpression calculateOwner$backend_jvm(@NotNull IrBuilderWithScope $this$calculateOwner, @NotNull IrDeclarationParent irContainer, @NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)$this$calculateOwner, (String)"$this$calculateOwner");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            IrExpression kClass2 = this.calculateOwnerKClass$backend_jvm($this$calculateOwner, irContainer, context2);
            IrDeclarationParent irDeclarationParent = irContainer;
            if (!(irDeclarationParent instanceof IrClass)) {
                irDeclarationParent = null;
            }
            IrClass irClass2 = (IrClass)irDeclarationParent;
            if (irClass2 == null || !IrUtilsKt.isFileClass(irClass2)) {
                if (!(irContainer instanceof IrPackageFragment)) {
                    return kClass2;
                }
            }
            IrCall irCall = ExpressionHelpersKt.irCall($this$calculateOwner, context2.getIr().getSymbols().getGetOrCreateKotlinPackage());
            boolean bl = false;
            boolean bl2 = false;
            IrCall $this$apply = irCall;
            boolean bl3 = false;
            $this$apply.putValueArgument(0, Companion.kClassToJavaClass$backend_jvm($this$calculateOwner, kClass2, context2));
            $this$apply.putValueArgument(1, ExpressionHelpersKt.irString($this$calculateOwner, context2.getState().getModuleName()));
            return irCall;
        }

        @NotNull
        public final IrExpression calculateOwnerKClass$backend_jvm(@NotNull IrBuilderWithScope $this$calculateOwnerKClass, @NotNull IrDeclarationParent irContainer, @NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)$this$calculateOwnerKClass, (String)"$this$calculateOwnerKClass");
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return this.kClassReference($this$calculateOwnerKClass, this.getOwnerKClassType$backend_jvm(irContainer, context2));
        }

        @NotNull
        public final IrType getOwnerKClassType$backend_jvm(@NotNull IrDeclarationParent irContainer, @NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)irContainer, (String)"irContainer");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return irContainer instanceof IrClass ? (IrType)IrUtilsKt.getDefaultType((IrClass)irContainer) : IrTypesKt.getDefaultType(context2.getIr().getSymbols().getIntrinsicsKotlinClass());
        }

        public final int getCallableReferenceTopLevelFlag$backend_jvm(@NotNull IrDeclaration declaration2) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            return this.isCallableReferenceTopLevel$backend_jvm(declaration2) ? 1 : 0;
        }

        public final boolean isCallableReferenceTopLevel$backend_jvm(@NotNull IrDeclaration declaration2) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            IrDeclarationParent irDeclarationParent = declaration2.getParent();
            boolean bl = false;
            boolean bl2 = false;
            IrDeclarationParent it = irDeclarationParent;
            boolean bl3 = false;
            return it instanceof IrClass && IrUtilsKt.isFileClass((IrDeclaration)((Object)it));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

