/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LateinitLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitUsageLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "backendContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.backend.common"})
public final class LateinitUsageLowering
implements BodyLoweringPass {
    @NotNull
    private final CommonBackendContext backendContext;

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        boolean bl = false;
        Map nullableVariables = new LinkedHashMap();
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this, nullableVariables){
            final /* synthetic */ LateinitUsageLowering this$0;
            final /* synthetic */ Map $nullableVariables;

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                if (!declaration2.isLateinit()) {
                    return declaration2;
                }
                IrVariable irVariable2 = DeclarationBuildersKt.buildVariable$default(declaration2.getParent(), declaration2.getStartOffset(), declaration2.getEndOffset(), declaration2.getOrigin(), declaration2.getName(), IrTypesKt.makeNullable(declaration2.getType()), true, false, false, 384, null);
                boolean bl = false;
                boolean bl2 = false;
                IrVariable it = irVariable2;
                boolean bl3 = false;
                it.setInitializer(IrConstImpl.Companion.constNull(declaration2.getStartOffset(), declaration2.getEndOffset(), this.this$0.getBackendContext().getIrBuiltIns().getNothingNType()));
                IrVariable newVar = irVariable2;
                this.$nullableVariables.put(declaration2, newVar);
                return newVar;
            }
            {
                this.this$0 = this$0;
                this.$nullableVariables = $captured_local_variable$1;
            }
        });
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this, nullableVariables){
            final /* synthetic */ LateinitUsageLowering this$0;
            final /* synthetic */ Map $nullableVariables;

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Map map2 = this.$nullableVariables;
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                boolean bl = false;
                IrVariable irVariable2 = (IrVariable)map2.get(irValueDeclaration);
                if (irVariable2 == null) {
                    return expression2;
                }
                IrVariable irVar = irVariable2;
                IrDeclarationParent irDeclarationParent = irVar.getParent();
                if (irDeclarationParent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                }
                IrSymbolOwner parent2 = (IrSymbolOwner)((Object)irDeclarationParent);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getBackendContext(), parent2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
                boolean bl2 = false;
                boolean bl3 = false;
                DeclarationIrBuilder $this$run = declarationIrBuilder;
                boolean bl4 = false;
                IrBuilderWithScope irBuilderWithScope = $this$run;
                IrType irType = expression2.getType();
                IrExpression irExpression = ExpressionHelpersKt.irEqualsNull($this$run, ExpressionHelpersKt.irGet($this$run, irVar));
                CommonBackendContext commonBackendContext = this.this$0.getBackendContext();
                IrBuilderWithScope irBuilderWithScope2 = $this$run;
                String string2 = irVar.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irVar.name.asString()");
                return ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression, commonBackendContext.throwUninitializedPropertyAccessException(irBuilderWithScope2, string2), ExpressionHelpersKt.irGet($this$run, irVar), null, 16, null);
            }

            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                Map map2 = this.$nullableVariables;
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                boolean bl = false;
                IrVariable irVariable2 = (IrVariable)map2.get(irValueDeclaration);
                if (irVariable2 == null) {
                    return expression2;
                }
                IrVariable newVar = irVariable2;
                boolean bl2 = false;
                boolean bl3 = false;
                IrSetValue $this$with = expression2;
                boolean bl4 = false;
                return new IrSetValueImpl($this$with.getStartOffset(), $this$with.getEndOffset(), $this$with.getType(), newVar.getSymbol(), $this$with.getValue(), $this$with.getOrigin());
            }

            @NotNull
            public IrExpression visitGetField(@NotNull IrGetField expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrField irField = this.this$0.getBackendContext().getMapping().getLateInitFieldToNullableField().get((IrField)((IrDeclaration)expression2.getSymbol().getOwner()));
                if (irField == null) {
                    return expression2;
                }
                IrField newField = irField;
                boolean bl = false;
                boolean bl2 = false;
                IrGetField $this$with = expression2;
                boolean bl3 = false;
                return new IrGetFieldImpl($this$with.getStartOffset(), $this$with.getEndOffset(), (IrFieldSymbol)newField.getSymbol(), newField.getType(), $this$with.getReceiver(), $this$with.getOrigin(), $this$with.getSuperQualifierSymbol());
            }

            @NotNull
            public IrExpression visitSetField(@NotNull IrSetField expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrField irField = this.this$0.getBackendContext().getMapping().getLateInitFieldToNullableField().get((IrField)((IrDeclaration)expression2.getSymbol().getOwner()));
                if (irField == null) {
                    return expression2;
                }
                IrField newField = irField;
                boolean bl = false;
                boolean bl2 = false;
                IrSetField $this$with = expression2;
                boolean bl3 = false;
                return new IrSetFieldImpl($this$with.getStartOffset(), $this$with.getEndOffset(), (IrFieldSymbol)newField.getSymbol(), $this$with.getReceiver(), $this$with.getValue(), $this$with.getType(), $this$with.getOrigin(), $this$with.getSuperQualifierSymbol());
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter(expression2.getSymbol())) {
                    return expression2;
                }
                IrExpression irExpression = expression2.getExtensionReceiver();
                if (irExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrPropertyReference");
                }
                IrPropertyReference receiver = (IrPropertyReference)irExpression;
                Object object = receiver.getGetter();
                IrBindableSymbol<PropertyDescriptor, IrProperty> irBindableSymbol = object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrSimpleFunction)object, false, null, 3, null)) != null ? ((IrSimpleFunction)object).getCorrespondingPropertySymbol() : null;
                Intrinsics.checkNotNull(irBindableSymbol);
                B b = irBindableSymbol.getOwner();
                boolean bl = false;
                boolean bl2 = false;
                IrProperty it = (IrProperty)b;
                boolean bl3 = false;
                boolean bl4 = it.isLateinit();
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl7 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                IrProperty property2 = (IrProperty)b;
                IrField irField = property2.getBackingField();
                if (irField == null) {
                    String string3 = "Lateinit property is supposed to have backing field";
                    bl2 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                IrField nullableField = LateinitLoweringKt.access$buildOrGetNullableField(this.this$0.getBackendContext(), irField);
                Object object2 = expression2;
                bl2 = false;
                boolean bl8 = false;
                Object $this$run = object2;
                boolean bl9 = false;
                object2 = LowerUtilsKt.createIrBuilder(this.this$0.getBackendContext(), ((IrCall)$this$run).getSymbol(), $this$run.getStartOffset(), $this$run.getEndOffset());
                bl2 = false;
                bl8 = false;
                $this$run = object2;
                boolean bl10 = false;
                return ExpressionHelpersKt.irNotEquals((IrBuilderWithScope)$this$run, ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$run, receiver.getDispatchReceiver(), nullableField), ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$run));
            }
            {
                this.this$0 = this$0;
                this.$nullableVariables = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public final CommonBackendContext getBackendContext() {
        return this.backendContext;
    }

    public LateinitUsageLowering(@NotNull CommonBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        this.backendContext = backendContext;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

