/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.base;

import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.base.CharMatcher;
import org.jetbrains.kotlin.com.google.common.base.CommonPattern;
import org.jetbrains.kotlin.com.google.common.base.Enums;
import org.jetbrains.kotlin.com.google.common.base.JdkPattern;
import org.jetbrains.kotlin.com.google.common.base.Optional;
import org.jetbrains.kotlin.com.google.common.base.PatternCompiler;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;

final class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher2) {
        return matcher2.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass2, String value2) {
        WeakReference<Enum<?>> ref = Enums.getEnumConstants(enumClass2).get(value2);
        return ref == null ? Optional.absent() : Optional.of(enumClass2.cast(ref.get()));
    }

    static String formatCompact4Digits(double value2) {
        return String.format(Locale.ROOT, "%.4g", value2);
    }

    static boolean stringIsNullOrEmpty(@Nullable String string2) {
        return string2 == null || string2.isEmpty();
    }

    static String nullToEmpty(@Nullable String string2) {
        return string2 == null ? "" : string2;
    }

    static String emptyToNull(@Nullable String string2) {
        return Platform.stringIsNullOrEmpty(string2) ? null : string2;
    }

    static CommonPattern compilePattern(String pattern) {
        Preconditions.checkNotNull(pattern);
        return patternCompiler.compile(pattern);
    }

    static boolean patternCompilerIsPcreLike() {
        return patternCompiler.isPcreLike();
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static void logPatternCompilerError(ServiceConfigurationError e) {
        logger.log(Level.WARNING, "Error loading regex compiler, falling back to next option", e);
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }

        @Override
        public CommonPattern compile(String pattern) {
            return new JdkPattern(Pattern.compile(pattern));
        }

        @Override
        public boolean isPcreLike() {
            return true;
        }
    }
}

