/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001d\u0010\u0012\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J$\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkContractAndRecordIfPresent", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "isFirstStatement", "", "isContractAllowedHere", "isContractDescriptionCall", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isContractDescriptionCall$frontend", "parseContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isContractDescriptionCallPreciseCheck", "frontend"})
public final class ContractParsingServices {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public final void checkContractAndRecordIfPresent(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull LexicalScope scope, boolean isFirstStatement) {
        block7: {
            ContractDescription contractDescription;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            DeclarationDescriptor ownerDescriptor = scope.getOwnerDescriptor();
            if (!KtPsiUtilKt.isContractDescriptionCallPsiCheck(expression2) || !(ownerDescriptor instanceof FunctionDescriptor)) {
                return;
            }
            LazyContractProvider contractProvider = (LazyContractProvider)((FunctionDescriptor)ownerDescriptor).getUserData(ContractProviderKey.INSTANCE);
            boolean isFeatureTurnedOn = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions) || this.languageVersionSettings.getFlag(AnalysisFlag.Flags.getAllowKotlinPackage()) != false;
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
            if (!this.isContractDescriptionCallPreciseCheck(expression2, bindingContext)) {
                contractDescription = null;
            } else if (!isFeatureTurnedOn) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(expression2, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.AllowContractsForCustomFunctions), (Object)this.languageVersionSettings)));
                contractDescription = null;
            } else if (!this.isContractAllowedHere(scope) || !isFirstStatement) {
                trace.report(Errors.CONTRACT_NOT_ALLOWED.on((KtElement)((PsiElement)expression2)));
                contractDescription = null;
            } else {
                contractDescription = this.parseContract(expression2, trace, (FunctionDescriptor)ownerDescriptor);
            }
            ContractDescription contractDescriptor = contractDescription;
            LazyContractProvider lazyContractProvider = contractProvider;
            if (lazyContractProvider == null) break block7;
            lazyContractProvider.setContractDescription(contractDescriptor);
        }
    }

    public final boolean isContractDescriptionCall$frontend(@NotNull KtExpression expression2, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return KtPsiUtilKt.isContractDescriptionCallPsiCheck(expression2) && this.isContractDescriptionCallPreciseCheck(expression2, context);
    }

    private final ContractDescription parseContract(KtExpression expression2, BindingTrace trace, FunctionDescriptor ownerDescriptor) {
        return new PsiContractParserDispatcher(trace, this).parseContract(expression2, ownerDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isContractAllowedHere(LexicalScope scope) {
        if (scope.getKind() != LexicalScopeKind.CODE_BLOCK) return false;
        HierarchicalScope hierarchicalScope = scope.getParent();
        if (!(hierarchicalScope instanceof LexicalScope)) {
            hierarchicalScope = null;
        }
        LexicalScope lexicalScope = (LexicalScope)hierarchicalScope;
        if ((lexicalScope != null ? lexicalScope.getKind() : null) != LexicalScopeKind.FUNCTION_INNER_SCOPE) return false;
        return true;
    }

    private final boolean isContractDescriptionCallPreciseCheck(@NotNull KtExpression $receiver, BindingContext context) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        return resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? PsiContractsUtilsKt.isContractCallDescriptor((DeclarationDescriptor)((Object)resolvedCall2)) : false;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public ContractParsingServices(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }
}

