/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.objectTree;

import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ObjectTree;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ObjectTreeAction;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ThrowableInterner;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

final class ObjectNode<T> {
    private static final ObjectNode[] EMPTY_ARRAY = new ObjectNode[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectNode");
    private final ObjectTree<T> myTree;
    private ObjectNode<T> myParent;
    private final T myObject;
    private List<ObjectNode<T>> myChildren;
    private final Throwable myTrace;
    private final long myOwnModification;

    ObjectNode(@NotNull ObjectTree<T> tree, @Nullable ObjectNode<T> parentNode, @NotNull T object, long modification) {
        if (tree == null) {
            ObjectNode.$$$reportNull$$$0(0);
        }
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(1);
        }
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
        this.myOwnModification = modification;
    }

    @NotNull
    private ObjectNode<T>[] getChildrenArray() {
        List<ObjectNode<ObjectNode>> children2 = this.myChildren;
        if (children2 == null || children2.isEmpty()) {
            if (EMPTY_ARRAY == null) {
                ObjectNode.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        ObjectNode[] objectNodeArray = children2.toArray(new ObjectNode[0]);
        if (objectNodeArray == null) {
            ObjectNode.$$$reportNull$$$0(3);
        }
        return objectNodeArray;
    }

    void addChild(@NotNull ObjectNode<T> child) {
        List<ObjectNode<T>> children2;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(4);
        }
        if ((children2 = this.myChildren) == null) {
            this.myChildren = new SmartList<ObjectNode<T>>(child);
        } else {
            children2.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode<T> child) {
        List<ObjectNode<T>> children2;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(5);
        }
        if ((children2 = this.myChildren) != null) {
            for (int i = children2.size() - 1; i >= 0; --i) {
                ObjectNode<T> node = children2.get(i);
                if (!node.equals(child)) continue;
                children2.remove(i);
                break;
            }
        }
        child.myParent = null;
    }

    ObjectNode<T> getParent() {
        return this.myParent;
    }

    void execute(final @NotNull ObjectTreeAction<T> action2) {
        if (action2 == null) {
            ObjectNode.$$$reportNull$$$0(8);
        }
        ObjectTree.executeActionWithRecursiveGuard(this, this.myTree.getNodesInExecution(), new ObjectTreeAction<ObjectNode<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(@NotNull ObjectNode<T> each) {
                ObjectNode[] childrenArray;
                if (each == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    action2.beforeTreeExecution(ObjectNode.this.myObject);
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                Object object = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                synchronized (object) {
                    childrenArray = ObjectNode.this.getChildrenArray();
                }
                SmartList<Throwable> exceptions = new SmartList<Throwable>();
                for (int i = childrenArray.length - 1; i >= 0; --i) {
                    try {
                        childrenArray[i].execute(action2);
                        continue;
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                    }
                }
                Object i = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                synchronized (i) {
                    ObjectNode.this.myChildren = null;
                }
                try {
                    action2.execute(ObjectNode.this.myObject);
                    ObjectNode.this.myTree.fireExecuted(ObjectNode.this.myObject);
                }
                catch (Throwable e) {
                    exceptions.add(e);
                }
                ObjectNode.this.remove();
                ObjectNode.handleExceptions(exceptions);
            }

            @Override
            public void beforeTreeExecution(@NotNull ObjectNode<T> parent2) {
                if (parent2 == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "each";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectNode$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeTreeExecution";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void handleExceptions(List<Throwable> exceptions) {
        if (!exceptions.isEmpty()) {
            for (Throwable exception : exceptions) {
                if (exception instanceof ProcessCanceledException) continue;
                LOG.error(exception);
            }
            ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
            if (pce != null) {
                throw pce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            this.myTree.putNode(this.myObject, null);
            if (this.myParent == null) {
                this.myTree.removeRootObject(this.myObject);
            } else {
                this.myParent.removeChild(this);
            }
        }
    }

    @NotNull
    T getObject() {
        T t = this.myObject;
        if (t == null) {
            ObjectNode.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/objectTree/ObjectNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenArray";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferencesKept";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findChildEqualTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

