/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.core;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.CoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.core.CoreJavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.core.CoreJavaCodeStyleSettingsFacade;
import org.jetbrains.kotlin.com.intellij.core.CoreJavaFileManager;
import org.jetbrains.kotlin.com.intellij.core.CoreJavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.core.CoreLanguageLevelProjectExtension;
import org.jetbrains.kotlin.com.intellij.core.CorePackageIndex;
import org.jetbrains.kotlin.com.intellij.core.CoreProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.lang.jvm.facade.JvmFacade;
import org.jetbrains.kotlin.com.intellij.lang.jvm.facade.JvmFacadeImpl;
import org.jetbrains.kotlin.com.intellij.mock.MockFileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.kotlin.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JvmPsiConversionHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiFacadeImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.JvmPsiConversionHelperImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementFactoryImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;

public class JavaCoreProjectEnvironment
extends CoreProjectEnvironment {
    private final JavaFileManager myFileManager;
    private final PackageIndex myPackageIndex;

    public JavaCoreProjectEnvironment(Disposable parentDisposable, CoreApplicationEnvironment applicationEnvironment2) {
        super(parentDisposable, applicationEnvironment2);
        this.myProject.registerService(PsiElementFactory.class, new PsiElementFactoryImpl(this.myPsiManager));
        this.myProject.registerService(JavaPsiImplementationHelper.class, this.createJavaPsiImplementationHelper());
        this.myProject.registerService(PsiResolveHelper.class, new PsiResolveHelperImpl(this.myPsiManager));
        this.myProject.registerService(LanguageLevelProjectExtension.class, new CoreLanguageLevelProjectExtension());
        this.myProject.registerService(JavaResolveCache.class, new JavaResolveCache(this.myMessageBus));
        this.myProject.registerService(JavaCodeStyleSettingsFacade.class, new CoreJavaCodeStyleSettingsFacade());
        this.myProject.registerService(JavaCodeStyleManager.class, new CoreJavaCodeStyleManager());
        this.myProject.registerService(ControlFlowFactory.class, new ControlFlowFactory(this.myPsiManager));
        this.myPackageIndex = this.createCorePackageIndex();
        this.myProject.registerService(PackageIndex.class, this.myPackageIndex);
        this.myFileManager = this.createCoreFileManager();
        this.myProject.registerService(JavaFileManager.class, this.myFileManager);
        this.myProject.registerService(JvmPsiConversionHelper.class, new JvmPsiConversionHelperImpl());
        this.registerJavaPsiFacade();
        this.myProject.registerService(JvmFacade.class, new JvmFacadeImpl(this.myProject, this.myMessageBus));
    }

    protected void registerJavaPsiFacade() {
        JavaPsiFacadeImpl javaPsiFacade = new JavaPsiFacadeImpl(this.myProject, this.myPsiManager, this.myFileManager, this.myMessageBus);
        this.myProject.registerService(JavaPsiFacade.class, javaPsiFacade);
    }

    protected CoreJavaPsiImplementationHelper createJavaPsiImplementationHelper() {
        return new CoreJavaPsiImplementationHelper(this.myProject);
    }

    protected JavaFileManager createCoreFileManager() {
        return new CoreJavaFileManager(this.myPsiManager);
    }

    protected PackageIndex createCorePackageIndex() {
        return new CorePackageIndex();
    }

    public void addJarToClassPath(File path2) {
        assert (path2.isFile());
        VirtualFile root2 = this.getEnvironment().getJarFileSystem().findFileByPath(path2 + "!/");
        if (root2 == null) {
            throw new IllegalArgumentException("trying to add non-existing file to classpath: " + path2);
        }
        this.addSourcesToClasspath(root2);
    }

    public void addSourcesToClasspath(@NotNull VirtualFile root2) {
        if (root2 == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(0);
        }
        assert (root2.isDirectory());
        ((CoreJavaFileManager)this.myFileManager).addToClasspath(root2);
        ((CorePackageIndex)this.myPackageIndex).addToClasspath(root2);
        ((MockFileIndexFacade)this.myFileIndexFacade).addLibraryRoot(root2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment", "addSourcesToClasspath"));
    }
}

