/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetClassImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrLocalDelegatedPropertyReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrPropertyReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JH\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018JN\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J8\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012JH\u0010%\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/ReflectionReferencesGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateCallableReference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "typeArguments", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktCallableReference", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "generateClassLiteral", "ktClassLiteral", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "generateFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "irDelegateSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "generatePropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "ir.psi2ir"})
public final class ReflectionReferencesGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generateClassLiteral(@NotNull KtClassLiteralExpression ktClassLiteral) {
        IrExpressionBase irExpressionBase;
        Intrinsics.checkParameterIsNotNull((Object)ktClassLiteral, (String)"ktClassLiteral");
        KtExpression ktExpression = ktClassLiteral.getReceiverExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktArgument = ktExpression;
        WritableSlice<KtExpression, DoubleColonLHS> writableSlice = BindingContext.DOUBLE_COLON_LHS;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.DOUBLE_COLON_LHS");
        DoubleColonLHS lhs = (DoubleColonLHS)GeneratorKt.getOrFail(this, writableSlice, ktArgument);
        KotlinType resultType = GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktClassLiteral);
        if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
            irExpressionBase = new IrGetClassImpl(PsiUtilsKt.getStartOffset(ktClassLiteral), PsiUtilsKt.getEndOffset(ktClassLiteral), resultType, this.genExpr(ktArgument));
        } else {
            ClassifierDescriptor typeConstructorDeclaration;
            ClassifierDescriptor classifierDescriptor = typeConstructorDeclaration = lhs.getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected type constructor for " + lhs.getType() + ": " + typeConstructorDeclaration)));
            }
            ClassifierDescriptor typeClass = classifierDescriptor;
            int n = PsiUtilsKt.getStartOffset(ktClassLiteral);
            int n2 = PsiUtilsKt.getEndOffset(ktClassLiteral);
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            ClassifierDescriptor classifierDescriptor2 = typeClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor2, (String)"typeClass");
            irExpressionBase = new IrClassReferenceImpl(n, n2, resultType, symbolTable.referenceClassifier(classifierDescriptor2), lhs.getType());
        }
        return irExpressionBase;
    }

    @NotNull
    public final IrExpression generateCallableReference(@NotNull KtCallableReferenceExpression ktCallableReference) {
        ImportedFromObjectCallableDescriptor descriptorImportedFromObject;
        ImportedFromObjectCallableDescriptor importedFromObjectCallableDescriptor;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        CallableDescriptor resultingDescriptor;
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)ktCallableReference, (String)"ktCallableReference");
        KtSimpleNameExpression ktSimpleNameExpression = ktCallableReference.getCallableReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"ktCallableReference.callableReference");
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = GeneratorKt.getResolvedCall(this, ktSimpleNameExpression);
        if (resolvedCall3 == null) {
            Intrinsics.throwNpe();
        }
        if (!((callableDescriptor = (resultingDescriptor = (resolvedCall2 = resolvedCall3).getResultingDescriptor())) instanceof ImportedFromObjectCallableDescriptor)) {
            callableDescriptor = null;
        }
        CallableDescriptor referencedDescriptor = (importedFromObjectCallableDescriptor = (descriptorImportedFromObject = (ImportedFromObjectCallableDescriptor)callableDescriptor)) != null && (importedFromObjectCallableDescriptor = importedFromObjectCallableDescriptor.getCallableFromObject()) != null ? (CallableDescriptor)importedFromObjectCallableDescriptor : resultingDescriptor;
        int startOffset = PsiUtilsKt.getStartOffset(ktCallableReference);
        int endOffset = PsiUtilsKt.getEndOffset(ktCallableReference);
        return ArgumentsGenerationUtilsKt.generateCallReceiver$default(this.getStatementGenerator(), ktCallableReference, resultingDescriptor, resolvedCall2.getDispatchReceiver(), resolvedCall2.getExtensionReceiver(), false, false, 32, null).call((Function2<? super IntermediateValue, ? super IntermediateValue, ? extends IrExpression>)((Function2)new Function2<IntermediateValue, IntermediateValue, IrExpression>(this, startOffset, endOffset, ktCallableReference, referencedDescriptor){
            final /* synthetic */ ReflectionReferencesGenerator this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ KtCallableReferenceExpression $ktCallableReference;
            final /* synthetic */ CallableDescriptor $referencedDescriptor;

            @NotNull
            public final IrExpression invoke(@Nullable IntermediateValue dispatchReceiverValue, @Nullable IntermediateValue extensionReceiverValue) {
                IrCallableReference irCallableReference;
                IrCallableReference irCallableReference2 = irCallableReference = ReflectionReferencesGenerator.generateCallableReference$default(this.this$0, this.$startOffset, this.$endOffset, GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this.this$0, this.$ktCallableReference), this.$referencedDescriptor, null, null, 32, null);
                IntermediateValue intermediateValue = dispatchReceiverValue;
                irCallableReference2.setDispatchReceiver(intermediateValue != null ? intermediateValue.loadIfExists() : null);
                IntermediateValue intermediateValue2 = extensionReceiverValue;
                irCallableReference2.setExtensionReceiver(intermediateValue2 != null ? intermediateValue2.loadIfExists() : null);
                return irCallableReference;
            }
            {
                this.this$0 = reflectionReferencesGenerator;
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$ktCallableReference = ktCallableReferenceExpression;
                this.$referencedDescriptor = callableDescriptor;
                super(2);
            }
        }));
    }

    @NotNull
    public final IrCallableReference generateCallableReference(int startOffset, int endOffset, @NotNull KotlinType type2, @NotNull CallableDescriptor callableDescriptor, @Nullable Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments2, @Nullable IrStatementOrigin origin) {
        IrCallableReference irCallableReference;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)callableDescriptor, (String)"callableDescriptor");
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        if (callableDescriptor2 instanceof FunctionDescriptor) {
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            FunctionDescriptor functionDescriptor = ((FunctionDescriptor)callableDescriptor).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"callableDescriptor.original");
            irCallableReference = this.generateFunctionReference(startOffset, endOffset, type2, symbolTable.referenceFunction(functionDescriptor), (FunctionDescriptor)callableDescriptor, typeArguments2, origin);
        } else if (callableDescriptor2 instanceof PropertyDescriptor) {
            irCallableReference = this.generatePropertyReference(startOffset, endOffset, type2, (PropertyDescriptor)callableDescriptor, typeArguments2, origin);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected callable reference: " + callableDescriptor)));
        }
        return irCallableReference;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IrCallableReference generateCallableReference$default(ReflectionReferencesGenerator reflectionReferencesGenerator, int n, int n2, KotlinType kotlinType, CallableDescriptor callableDescriptor, Map map2, IrStatementOrigin irStatementOrigin, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            irStatementOrigin = null;
        }
        return reflectionReferencesGenerator.generateCallableReference(n, n2, kotlinType, callableDescriptor, map2, irStatementOrigin);
    }

    @NotNull
    public final IrLocalDelegatedPropertyReference generateLocalDelegatedPropertyReference(int startOffset, int endOffset, @NotNull KotlinType type2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull IrVariableSymbol irDelegateSymbol, @Nullable IrStatementOrigin origin) {
        IrFunctionSymbol irFunctionSymbol;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)irDelegateSymbol, (String)"irDelegateSymbol");
        VariableAccessorDescriptor variableAccessorDescriptor = variableDescriptor.getGetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Local delegated property should have a getter: " + variableDescriptor)));
        }
        VariableAccessorDescriptor getterDescriptor = variableAccessorDescriptor;
        VariableAccessorDescriptor setterDescriptor = variableDescriptor.getSetter();
        IrFunctionSymbol getterSymbol = this.getContext().getSymbolTable().referenceFunction(getterDescriptor);
        VariableAccessorDescriptor variableAccessorDescriptor2 = setterDescriptor;
        if (variableAccessorDescriptor2 != null) {
            VariableAccessorDescriptor variableAccessorDescriptor3;
            VariableAccessorDescriptor it = variableAccessorDescriptor3 = variableAccessorDescriptor2;
            irFunctionSymbol = this.getContext().getSymbolTable().referenceFunction(it);
        } else {
            irFunctionSymbol = null;
        }
        IrFunctionSymbol setterSymbol = irFunctionSymbol;
        return new IrLocalDelegatedPropertyReferenceImpl(startOffset, endOffset, type2, variableDescriptor, irDelegateSymbol, getterSymbol, setterSymbol, origin);
    }

    private final IrPropertyReference generatePropertyReference(int startOffset, int endOffset, KotlinType type2, PropertyDescriptor propertyDescriptor, Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments2, IrStatementOrigin origin) {
        IrFunctionSymbol irFunctionSymbol;
        IrFunctionSymbol irFunctionSymbol2;
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
        IrFieldSymbol fieldSymbol = getterDescriptor == null ? this.getContext().getSymbolTable().referenceField(propertyDescriptor) : null;
        PropertyGetterDescriptor propertyGetterDescriptor = getterDescriptor;
        if (propertyGetterDescriptor != null) {
            PropertyGetterDescriptor propertyGetterDescriptor2;
            PropertyGetterDescriptor it = propertyGetterDescriptor2 = propertyGetterDescriptor;
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            PropertyGetterDescriptor propertyGetterDescriptor3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor3, (String)"it");
            PropertyGetterDescriptor propertyGetterDescriptor4 = propertyGetterDescriptor3.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor4, (String)"it.original");
            irFunctionSymbol2 = symbolTable.referenceFunction(propertyGetterDescriptor4);
        } else {
            irFunctionSymbol2 = null;
        }
        IrFunctionSymbol getterSymbol = irFunctionSymbol2;
        PropertySetterDescriptor propertySetterDescriptor = setterDescriptor;
        if (propertySetterDescriptor != null) {
            PropertySetterDescriptor propertySetterDescriptor2;
            PropertySetterDescriptor it = propertySetterDescriptor2 = propertySetterDescriptor;
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            PropertySetterDescriptor propertySetterDescriptor3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor3, (String)"it");
            PropertySetterDescriptor propertySetterDescriptor4 = propertySetterDescriptor3.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor4, (String)"it.original");
            irFunctionSymbol = symbolTable.referenceFunction(propertySetterDescriptor4);
        } else {
            irFunctionSymbol = null;
        }
        IrFunctionSymbol setterSymbol = irFunctionSymbol;
        return new IrPropertyReferenceImpl(startOffset, endOffset, type2, propertyDescriptor, fieldSymbol, getterSymbol, setterSymbol, typeArguments2, origin);
    }

    @NotNull
    public final IrFunctionReference generateFunctionReference(int startOffset, int endOffset, @NotNull KotlinType type2, @NotNull IrFunctionSymbol symbol2, @NotNull FunctionDescriptor descriptor2, @Nullable Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments2, @Nullable IrStatementOrigin origin) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)symbol2, (String)"symbol");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return new IrFunctionReferenceImpl(startOffset, endOffset, type2, symbol2, descriptor2, typeArguments2, origin);
    }

    public ReflectionReferencesGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }
}

