/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslatorKt;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0002!\"B%\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002J \u0010\u0016\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J<\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010 \u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "isNativeFunctionCall", "", "prepareConcatArguments", "", "arguments", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "list", "varargPrimitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "removeLastUndefinedArguments", "", "result", "toArray", "elements", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "translateUnresolvedArguments", "", "translateVarargArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "shouldWrapVarargInArray", "ArgumentsInfo", "Companion", "js.translator"})
public final class CallArgumentTranslator
extends AbstractTranslator {
    private final boolean isNativeFunctionCall;
    private final ResolvedCall<?> resolvedCall;
    private final JsExpression receiver;
    private final TranslationContext context;
    public static final Companion Companion = new Companion(null);

    private final void removeLastUndefinedArguments(List<JsExpression> result2) {
        int i;
        for (i = CollectionsKt.getLastIndex(result2); i >= 0 && JsAstUtils.isUndefinedExpression(result2.get(i)); --i) {
        }
        result2.subList(i + 1, result2.size()).clear();
    }

    private final ArgumentsInfo translate() {
        Object callableDescriptor;
        Object actualArgument;
        Object obj = this.resolvedCall.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        List<ValueParameterDescriptor> valueParameters = obj.getValueParameters();
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        List result2 = new ArrayList(valueParameters.size());
        List<ResolvedValueArgument> list2 = this.resolvedCall.getValueArgumentsByIndex();
        if (list2 == null) {
            throw (Throwable)new IllegalStateException("Failed to arrange value arguments by index: " + this.resolvedCall.getResultingDescriptor());
        }
        List<ResolvedValueArgument> valueArgumentsByIndex = list2;
        List argsBeforeVararg = null;
        List<JsExpression> concatArguments = null;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context()");
        Map<ValueArgument, JsExpression> argsToJsExpr = this.translateUnresolvedArguments(translationContext, this.resolvedCall);
        Object varargPrimitiveType = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters) {
            actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            if (actualArgument instanceof VarargValueArgument) {
                KotlinType varargElementType;
                Object object;
                List<ValueArgument> arguments2 = actualArgument.getArguments();
                if (!hasSpreadOperator) {
                    boolean bl;
                    block26: {
                        List<ValueArgument> list3 = arguments2;
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"arguments");
                        Iterable $receiver$iv = list3;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            object = $receiver$iv.iterator();
                            while (object.hasNext()) {
                                Object element$iv = object.next();
                                ValueArgument it = (ValueArgument)element$iv;
                                if (!(it.getSpreadElement() != null)) continue;
                                bl = true;
                                break block26;
                            }
                            bl = false;
                        }
                    }
                    hasSpreadOperator = bl;
                }
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameterDescriptor");
                if (valueParameterDescriptor.getOriginal().getVarargElementType() == null) {
                    Intrinsics.throwNpe();
                }
                Object it = object = KotlinBuiltIns.getPrimitiveType(varargElementType);
                PrimitiveType primitiveType = varargPrimitiveType = !varargElementType.isMarkedNullable() ? object : null;
                if (hasSpreadOperator) {
                    if (this.isNativeFunctionCall) {
                        argsBeforeVararg = result2;
                        result2 = new ArrayList();
                        List<ValueArgument> list4 = arguments2;
                        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"arguments");
                        concatArguments = this.prepareConcatArguments(list4, CallArgumentTranslator.Companion.translateResolvedArgument((ResolvedValueArgument)actualArgument, argsToJsExpr), null);
                        continue;
                    }
                    result2.addAll((Collection)this.translateVarargArgument((ResolvedValueArgument)actualArgument, (Map<ValueArgument, ? extends JsExpression>)argsToJsExpr, ((VarargValueArgument)actualArgument).getArguments().size() > 1, (PrimitiveType)((Object)varargPrimitiveType)));
                    continue;
                }
                if (this.isNativeFunctionCall) {
                    result2.addAll(CallArgumentTranslator.Companion.translateResolvedArgument((ResolvedValueArgument)actualArgument, argsToJsExpr));
                    continue;
                }
                result2.addAll((Collection)this.translateVarargArgument((ResolvedValueArgument)actualArgument, (Map<ValueArgument, ? extends JsExpression>)argsToJsExpr, true, (PrimitiveType)((Object)varargPrimitiveType)));
                continue;
            }
            Object object = actualArgument;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"actualArgument");
            result2.addAll(CallArgumentTranslator.Companion.translateResolvedArgument((ResolvedValueArgument)object, argsToJsExpr));
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            boolean parameterDescriptor;
            boolean bl = parameterDescriptor = argsBeforeVararg != null;
            if (_Assertions.ENABLED && !parameterDescriptor) {
                actualArgument = "argsBeforeVararg should not be null";
                throw (Throwable)((Object)new AssertionError(actualArgument));
            }
            boolean bl2 = parameterDescriptor = concatArguments != null;
            if (_Assertions.ENABLED && !parameterDescriptor) {
                actualArgument = "concatArguments should not be null";
                throw (Throwable)((Object)new AssertionError(actualArgument));
            }
            if (!result2.isEmpty()) {
                List<JsExpression> list5 = concatArguments;
                if (list5 == null) {
                    Intrinsics.throwNpe();
                }
                list5.add(this.toArray(null, result2));
            }
            List list6 = argsBeforeVararg;
            if (list6 == null) {
                Intrinsics.throwNpe();
            }
            if (!list6.isEmpty()) {
                List<JsExpression> list7 = concatArguments;
                if (list7 == null) {
                    Intrinsics.throwNpe();
                }
                list7.add(0, this.toArray(null, argsBeforeVararg));
            }
            Object[] objectArray = new JsExpression[1];
            List<JsExpression> list8 = concatArguments;
            if (list8 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[0] = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(list8, varargPrimitiveType, true);
            result2 = CollectionsKt.mutableListOf((Object[])objectArray);
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                JsNameRef jsNameRef = cachedReceiver.reference();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"cachedReceiver.reference()");
                result2.add(0, jsNameRef);
            } else {
                Object obj2 = this.resolvedCall.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(obj2, (String)"resolvedCall.resultingDescriptor");
                if (DescriptorUtils.isObject(obj2.getContainingDeclaration())) {
                    TranslationContext translationContext2 = this.context();
                    Object obj3 = this.resolvedCall.getResultingDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull(obj3, (String)"resolvedCall.resultingDescriptor");
                    cachedReceiver = translationContext2.getOrDeclareTemporaryConstVariable(ReferenceTranslator.translateAsValueReference(obj3.getContainingDeclaration(), this.context()));
                    JsNameRef jsNameRef = cachedReceiver.reference();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"cachedReceiver.reference()");
                    result2.add(0, jsNameRef);
                } else {
                    result2.add(0, new JsNullLiteral());
                }
            }
        }
        if ((callableDescriptor = this.resolvedCall.getResultingDescriptor()) instanceof FunctionDescriptor && ((FunctionDescriptor)callableDescriptor).isSuspend()) {
            JsExpression jsExpression = TranslationUtils.translateContinuationArgument(this.context());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"TranslationUtils.transla\u2026uationArgument(context())");
            JsExpression continuationArg = jsExpression;
            FunctionDescriptor functionDescriptor = ((FunctionDescriptor)callableDescriptor).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"callableDescriptor.original");
            LanguageVersionSettings languageVersionSettings = this.context.getLanguageVersionSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)languageVersionSettings, (String)"context.languageVersionSettings");
            if (CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineOrReturn(functionDescriptor, languageVersionSettings)) {
                JsName facadeName = this.context().getNameForDescriptor(TranslationUtils.getCoroutineProperty(this.context(), "facade"));
                JsNameRef jsNameRef = JsAstUtils.pureFqn(facadeName, continuationArg);
                Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"JsAstUtils.pureFqn(facadeName, continuationArg)");
                continuationArg = jsNameRef;
            }
            result2.add(continuationArg);
        }
        this.removeLastUndefinedArguments(result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ValueArgument, JsExpression> translateUnresolvedArguments(TranslationContext context, ResolvedCall<?> resolvedCall2) {
        Object it;
        boolean bl;
        boolean argumentsAreOrdered;
        Object element$iv;
        Object $receiver$iv;
        ValueArgument arg;
        Object $receiver$iv$iv;
        Object destination$iv$iv;
        Map result2;
        Map argumentContexts;
        block26: {
            boolean bl2;
            block25: {
                Iterable $receiver$iv2;
                JsExpression argJs;
                Object element$iv$iv4;
                void $receiver$iv$iv2;
                Object it2;
                void $receiver$iv$iv3;
                ValueArgument arg2;
                Object $param_arg;
                void $receiver$iv$iv4;
                Object it3;
                Collection destination$iv$iv2;
                ValueParameterDescriptor param;
                Object $param_args;
                void $receiver$iv$iv5;
                Iterable $receiver$iv3;
                Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"resolvedCall.valueArguments");
                Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
                void var5_4 = $receiver$iv3;
                Iterable destination$iv$iv3 = new ArrayList();
                void var7_10 = $receiver$iv$iv5;
                Iterator iterator2 = var7_10.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void $receiver$iv$iv6;
                    Iterable $receiver$iv4;
                    ResolvedValueArgument args;
                    Object element$iv$iv2;
                    $param_args = element$iv$iv2 = iterator2.next();
                    Map.Entry entry = $param_args;
                    param = (ValueParameterDescriptor)entry.getKey();
                    entry = $param_args;
                    ResolvedValueArgument resolvedValueArgument = args = (ResolvedValueArgument)entry.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"args");
                    List<ValueArgument> list2 = resolvedValueArgument.getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"args.arguments");
                    Iterable iterable = $receiver$iv4 = (Iterable)list2;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv6) {
                        ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        Pair pair = TuplesKt.to((Object)param, (Object)it3);
                        collection.add(pair);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                $receiver$iv3 = (List)destination$iv$iv3;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10)), (int)16);
                destination$iv$iv3 = $receiver$iv3;
                Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                for (Object element$iv$iv2 : $receiver$iv$iv4) {
                    $param_args = destination$iv$iv4;
                    $param_arg = (Pair)element$iv$iv2;
                    param = (ValueParameterDescriptor)$param_arg.component1();
                    arg2 = (ValueArgument)$param_arg.component2();
                    destination$iv$iv2 = TuplesKt.to((Object)arg2, (Object)param);
                    $param_args.put(destination$iv$iv2.getFirst(), destination$iv$iv2.getSecond());
                }
                Map argsToParameters = destination$iv$iv4;
                Call call2 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
                List<? extends ValueArgument> list3 = call2.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"resolvedCall.call.valueArguments");
                Iterable $receiver$iv5 = list3;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10)), (int)16);
                destination$iv$iv4 = $receiver$iv5;
                Object destination$iv$iv5 = new LinkedHashMap(capacity$iv2);
                for (Object element$iv$iv3 : $receiver$iv$iv3) {
                    $param_arg = destination$iv$iv5;
                    it2 = (ValueArgument)element$iv$iv3;
                    Pair $i$a$2$associate = TuplesKt.to((Object)it2, (Object)context.innerBlock());
                    $param_arg.put($i$a$2$associate.getFirst(), $i$a$2$associate.getSecond());
                }
                argumentContexts = destination$iv$iv5;
                Call call3 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call3, (String)"resolvedCall.call");
                List<? extends ValueArgument> list4 = call3.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"resolvedCall.call.valueArguments");
                Iterable $receiver$iv6 = list4;
                int capacity$iv222 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv6, (int)10)), (int)16);
                destination$iv$iv5 = $receiver$iv6;
                Object destination$iv$iv6 = new LinkedHashMap(capacity$iv222);
                for (Object element$iv$iv4 : $receiver$iv$iv2) {
                    KotlinType kotlinType;
                    boolean isLambda;
                    Object $i$f$associate;
                    it2 = destination$iv$iv6;
                    arg2 = (ValueArgument)element$iv$iv4;
                    Object v = argumentContexts.get(arg2);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    TranslationContext argumentContext = (TranslationContext)v;
                    KtExpression parenthisedArgumentExpression = arg2.getArgumentExpression();
                    Object v2 = argsToParameters.get(arg2);
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ValueParameterDescriptor param2 = ((ValueParameterDescriptor)v2).getOriginal();
                    Object obj = it3 = ($i$f$associate = resolvedCall2.getResultingDescriptor());
                    Intrinsics.checkExpressionValueIsNotNull(obj, (String)"it");
                    boolean bl3 = isLambda = FunctionTypesKt.getFunctionalClassKind((DeclarationDescriptor)obj) != null || it3 instanceof FunctionInvokeDescriptor;
                    if (!isLambda) {
                        kotlinType = param2.getVarargElementType();
                        if (kotlinType == null) {
                            KotlinType kotlinType2 = param2.getType();
                            kotlinType = kotlinType2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"param.type");
                        }
                    } else {
                        SimpleType simpleType2 = context.getCurrentModule().getBuiltIns().getAnyType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.currentModule.builtIns.anyType");
                        kotlinType = simpleType2;
                    }
                    KotlinType parameterType = kotlinType;
                    KtExpression ktExpression = parenthisedArgumentExpression;
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    argJs = Translation.translateAsExpression(ktExpression, argumentContext);
                    if (!ArgumentsUtilsKt.isVararg(param2) || arg2.getSpreadElement() == null) {
                        argJs = TranslationUtils.coerce(context, argJs, parameterType);
                    }
                    Pair pair = TuplesKt.to((Object)arg2, (Object)argJs);
                    it2.put(pair.getFirst(), pair.getSecond());
                }
                result2 = destination$iv$iv6;
                Iterable capacity$iv222 = resolvedCall2.getValueArgumentsByIndex();
                List list5 = capacity$iv222;
                if (list5 == null) {
                    list5 = CollectionsKt.emptyList();
                }
                capacity$iv222 = list5;
                $receiver$iv$iv2 = $receiver$iv2;
                destination$iv$iv6 = new ArrayList();
                for (Object element$iv$iv4 : $receiver$iv$iv2) {
                    Object object = it2 = (ResolvedValueArgument)element$iv$iv4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                    Iterable list$iv$iv = object.getArguments();
                    CollectionsKt.addAll((Collection)destination$iv$iv6, (Iterable)list$iv$iv);
                }
                $receiver$iv2 = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv6));
                int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
                destination$iv$iv6 = $receiver$iv2;
                destination$iv$iv = new LinkedHashMap(capacity$iv3);
                element$iv$iv4 = $receiver$iv$iv.iterator();
                while (element$iv$iv4.hasNext()) {
                    Object element$iv$iv5 = element$iv$iv4.next();
                    Map $i$a$1$flatMap = destination$iv$iv;
                    IndexedValue $index_arg = (IndexedValue)element$iv$iv5;
                    int index2 = $index_arg.component1();
                    arg = (ValueArgument)$index_arg.component2();
                    argJs = TuplesKt.to((Object)arg, (Object)index2);
                    $i$a$1$flatMap.put(argJs.getFirst(), argJs.getSecond());
                }
                Map resolvedOrder = destination$iv$iv;
                Call call4 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull((Object)call4, (String)"resolvedCall.call");
                List<? extends ValueArgument> list6 = call4.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list6, (String)"resolvedCall.call.valueArguments");
                $receiver$iv = CollectionsKt.withIndex((Iterable)list6);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv = $receiver$iv$iv.next();
                        IndexedValue $index_arg = (IndexedValue)element$iv;
                        int index3 = $index_arg.component1();
                        arg2 = (ValueArgument)$index_arg.component2();
                        Integer n = (Integer)resolvedOrder.get(arg2);
                        if (!(n == null || n != index3)) continue;
                        bl2 = false;
                        break block25;
                    }
                    bl2 = true;
                }
            }
            argumentsAreOrdered = bl2;
            $receiver$iv = argumentContexts.values();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                $receiver$iv$iv = $receiver$iv.iterator();
                while ($receiver$iv$iv.hasNext()) {
                    element$iv = $receiver$iv$iv.next();
                    it = (TranslationContext)element$iv;
                    if (!(!((TranslationContext)it).currentBlockIsEmpty())) continue;
                    bl = true;
                    break block26;
                }
                bl = false;
            }
        }
        if (bl || !argumentsAreOrdered) {
            $receiver$iv$iv = $receiver$iv = result2;
            destination$iv$iv = new ArrayList($receiver$iv.size());
            it = $receiver$iv$iv;
            Iterator $i$a$1$any = it.entrySet().iterator();
            while ($i$a$1$any.hasNext()) {
                void $arg_expr;
                Map.Entry item$iv$iv;
                Map.Entry $i$a$1$none = item$iv$iv = $i$a$1$any.next();
                Object object = destination$iv$iv;
                void $i$f$none = $arg_expr;
                arg = (ValueArgument)$i$f$none.getKey();
                $i$f$none = $arg_expr;
                JsExpression expr = (JsExpression)$i$f$none.getValue();
                Object v = argumentContexts.get(arg);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                TranslationContext argumentContext = (TranslationContext)v;
                Pair pair = TuplesKt.to((Object)arg, (Object)argumentContext.cacheExpressionIfNeeded(expr));
                object.add(pair);
            }
            result2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        $receiver$iv = argumentContexts.values();
        Iterator iterator3 = $receiver$iv.iterator();
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            it = (TranslationContext)element$iv;
            context.moveVarsFrom((TranslationContext)it);
            context.addStatementsToCurrentBlockFrom((TranslationContext)it);
        }
        return result2;
    }

    private final List<JsExpression> translateVarargArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs, boolean shouldWrapVarargInArray, PrimitiveType varargPrimitiveType) {
        List list2;
        List<ValueArgument> arguments2 = resolvedArgument.getArguments();
        if (arguments2.isEmpty()) {
            if (shouldWrapVarargInArray) {
                PrimitiveType primitiveType = varargPrimitiveType;
                CallArgumentTranslator callArgumentTranslator = this;
                List list3 = CollectionsKt.emptyList();
                return CollectionsKt.listOf((Object)callArgumentTranslator.toArray(primitiveType, list3));
            }
            return CollectionsKt.emptyList();
        }
        List list4 = CallArgumentTranslator.Companion.translateResolvedArgument(resolvedArgument, translatedArgs);
        if (shouldWrapVarargInArray) {
            List<ValueArgument> list5 = arguments2;
            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"arguments");
            List<JsExpression> concatArguments = this.prepareConcatArguments(list5, list4, varargPrimitiveType);
            JsExpression concatExpression = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(concatArguments, varargPrimitiveType, false);
            list2 = CollectionsKt.listOf((Object)concatExpression);
        } else {
            list2 = CollectionsKt.listOf((Object)JsAstUtils.invokeMethod((JsExpression)list4.get(0), "slice", new JsExpression[0]));
        }
        return list2;
    }

    private final JsExpression toArray(PrimitiveType varargPrimitiveType, List<? extends JsExpression> elements) {
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context()");
        JsArrayLiteral jsArrayLiteral = new JsArrayLiteral(elements);
        PrimitiveType primitiveType = varargPrimitiveType;
        TranslationContext translationContext2 = translationContext;
        ArrayFIF arrayFIF = ArrayFIF.INSTANCE;
        JsArrayLiteral $receiver = jsArrayLiteral;
        MetadataProperties.setSideEffects($receiver, SideEffectKind.PURE);
        JsArrayLiteral jsArrayLiteral2 = jsArrayLiteral;
        return arrayFIF.castOrCreatePrimitiveArray(translationContext2, primitiveType, jsArrayLiteral2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsExpression> prepareConcatArguments(List<? extends ValueArgument> arguments2, List<? extends JsExpression> list2, PrimitiveType varargPrimitiveType) {
        boolean bl;
        Collection collection = arguments2;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "arguments.size should not be 0";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = arguments2.size() == list2.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "arguments.size: " + arguments2.size() + " != list.size: " + list2.size();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List concatArguments = new ArrayList();
        List lastArrayContent = new ArrayList();
        int size = arguments2.size();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void index2;
            ValueArgument valueArgument = arguments2.get((int)index2);
            JsExpression expressionArgument = list2.get((int)index2);
            if (valueArgument.getSpreadElement() != null) {
                if (lastArrayContent.size() > 0) {
                    concatArguments.add(this.toArray(varargPrimitiveType, lastArrayContent));
                    lastArrayContent = new ArrayList();
                }
                concatArguments.add(expressionArgument);
            } else {
                lastArrayContent.add(expressionArgument);
            }
            ++index2;
        }
        if (lastArrayContent.size() > 0) {
            concatArguments.add(this.toArray(varargPrimitiveType, lastArrayContent));
        }
        return concatArguments;
    }

    private CallArgumentTranslator(ResolvedCall<?> resolvedCall2, JsExpression receiver, TranslationContext context) {
        super(context);
        this.resolvedCall = resolvedCall2;
        this.receiver = receiver;
        this.context = context;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject((DeclarationDescriptor)this.resolvedCall.getCandidateDescriptor());
    }

    public /* synthetic */ CallArgumentTranslator(@NotNull ResolvedCall resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context, DefaultConstructorMarker $constructor_marker) {
        this(resolvedCall2, receiver, context);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        return Companion.translate(resolvedCall2, receiver, context);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context, @NotNull JsBlock block) {
        return Companion.translate(resolvedCall2, receiver, context, block);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "", "valueArguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "hasSpreadOperator", "", "cachedReceiver", "Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "reifiedArguments", "(Ljava/util/List;ZLorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;Ljava/util/List;)V", "getCachedReceiver", "()Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "getHasSpreadOperator", "()Z", "getReifiedArguments", "()Ljava/util/List;", "translateArguments", "getTranslateArguments", "getValueArguments", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "js.translator"})
    public static final class ArgumentsInfo {
        @NotNull
        private final List<JsExpression> valueArguments;
        private final boolean hasSpreadOperator;
        @Nullable
        private final TemporaryConstVariable cachedReceiver;
        @NotNull
        private final List<JsExpression> reifiedArguments;

        @NotNull
        public final List<JsExpression> getTranslateArguments() {
            return CollectionsKt.plus((Collection)this.reifiedArguments, (Iterable)this.valueArguments);
        }

        @NotNull
        public final List<JsExpression> getValueArguments() {
            return this.valueArguments;
        }

        public final boolean getHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> getReifiedArguments() {
            return this.reifiedArguments;
        }

        public ArgumentsInfo(@NotNull List<? extends JsExpression> valueArguments, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkParameterIsNotNull(valueArguments, (String)"valueArguments");
            Intrinsics.checkParameterIsNotNull(reifiedArguments, (String)"reifiedArguments");
            this.valueArguments = valueArguments;
            this.hasSpreadOperator = hasSpreadOperator;
            this.cachedReceiver = cachedReceiver;
            this.reifiedArguments = reifiedArguments;
        }

        public /* synthetic */ ArgumentsInfo(List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 8) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            this(list2, bl, temporaryConstVariable, list3);
        }

        @NotNull
        public final List<JsExpression> component1() {
            return this.valueArguments;
        }

        public final boolean component2() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable component3() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> component4() {
            return this.reifiedArguments;
        }

        @NotNull
        public final ArgumentsInfo copy(@NotNull List<? extends JsExpression> valueArguments, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkParameterIsNotNull(valueArguments, (String)"valueArguments");
            Intrinsics.checkParameterIsNotNull(reifiedArguments, (String)"reifiedArguments");
            return new ArgumentsInfo(valueArguments, hasSpreadOperator, cachedReceiver, reifiedArguments);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ArgumentsInfo copy$default(ArgumentsInfo argumentsInfo, List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = argumentsInfo.valueArguments;
            }
            if ((n & 2) != 0) {
                bl = argumentsInfo.hasSpreadOperator;
            }
            if ((n & 4) != 0) {
                temporaryConstVariable = argumentsInfo.cachedReceiver;
            }
            if ((n & 8) != 0) {
                list3 = argumentsInfo.reifiedArguments;
            }
            return argumentsInfo.copy(list2, bl, temporaryConstVariable, list3);
        }

        public String toString() {
            return "ArgumentsInfo(valueArguments=" + this.valueArguments + ", hasSpreadOperator=" + this.hasSpreadOperator + ", cachedReceiver=" + this.cachedReceiver + ", reifiedArguments=" + this.reifiedArguments + ")";
        }

        public int hashCode() {
            List<JsExpression> list2 = this.valueArguments;
            int n = (list2 != null ? ((Object)list2).hashCode() : 0) * 31;
            int n2 = this.hasSpreadOperator ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            TemporaryConstVariable temporaryConstVariable = this.cachedReceiver;
            List<JsExpression> list3 = this.reifiedArguments;
            return ((n + n2) * 31 + (temporaryConstVariable != null ? temporaryConstVariable.hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArgumentsInfo)) break block3;
                    ArgumentsInfo argumentsInfo = (ArgumentsInfo)object;
                    if (!Intrinsics.areEqual(this.valueArguments, argumentsInfo.valueArguments) || !(this.hasSpreadOperator == argumentsInfo.hasSpreadOperator) || !Intrinsics.areEqual((Object)this.cachedReceiver, (Object)argumentsInfo.cachedReceiver) || !Intrinsics.areEqual(this.reifiedArguments, argumentsInfo.reifiedArguments)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion;", "", "()V", "concatArgumentsIfNeeded", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "concatArguments", "", "varargPrimitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "isMixed", "", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "translateResolvedArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "js.translator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            JsBlock jsBlock = context.dynamicContext().jsBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"context.dynamicContext().jsBlock()");
            return this.translate(resolvedCall2, receiver, context, jsBlock);
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context, @NotNull JsBlock block) {
            TranslationContext innerContext;
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            TranslationContext translationContext = innerContext = context.innerBlock(block);
            Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"innerContext");
            CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall2, receiver, translationContext, null);
            ArgumentsInfo result2 = argumentTranslator.translate();
            context.moveVarsFrom(innerContext);
            Object callDescriptor = resolvedCall2.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(callDescriptor)) {
                Map<TypeParameterDescriptor, KotlinType> typeArgs;
                Map<TypeParameterDescriptor, KotlinType> map2 = typeArgs = resolvedCall2.getTypeArguments();
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"typeArgs");
                return ArgumentsInfo.copy$default(result2, null, false, null, CallArgumentTranslatorKt.buildReifiedTypeArgs(map2, context), 7, null);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<JsExpression> translateResolvedArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            if (resolvedArgument instanceof DefaultValueArgument) {
                return CollectionsKt.listOf((Object)Namer.getUndefinedExpression());
            }
            List<ValueArgument> list2 = resolvedArgument.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedArgument.arguments");
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                JsExpression jsExpression;
                void it;
                ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                if (translatedArgs.get(it) == null) {
                    Intrinsics.throwNpe();
                }
                collection.add(jsExpression);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final JsExpression concatArgumentsIfNeeded(List<? extends JsExpression> concatArguments, PrimitiveType varargPrimitiveType, boolean isMixed) {
            JsExpression jsExpression;
            boolean bl;
            Collection collection = concatArguments;
            boolean bl2 = bl = !collection.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "concatArguments.size should not be 0";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (concatArguments.size() > 1) {
                JsInvocation jsInvocation;
                if (varargPrimitiveType != null) {
                    void $receiver$iv;
                    String method = isMixed ? "arrayConcat" : "primitiveArrayConcat";
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)concatArguments.get(0));
                    Collection $i$a$1$assert = concatArguments.subList(1, concatArguments.size());
                    SpreadBuilder spreadBuilder2 = spreadBuilder;
                    SpreadBuilder spreadBuilder3 = spreadBuilder;
                    String string = method;
                    void v2 = $receiver$iv;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    void thisCollection$iv = v2;
                    JsExpression[] jsExpressionArray = thisCollection$iv.toArray(new JsExpression[0]);
                    if (jsExpressionArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    JsExpression[] jsExpressionArray2 = jsExpressionArray;
                    SpreadBuilder spreadBuilder4 = spreadBuilder3;
                    spreadBuilder2.addSpread((Object)jsExpressionArray2);
                    jsInvocation = JsAstUtils.invokeKotlinFunction(string, (JsExpression[])spreadBuilder4.toArray((Object[])new JsExpression[spreadBuilder4.size()]));
                } else {
                    jsInvocation = new JsInvocation((JsExpression)new JsNameRef("concat", concatArguments.get(0)), concatArguments.subList(1, concatArguments.size()));
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)jsInvocation, (String)"if (varargPrimitiveType \u2026.size))\n                }");
                jsExpression = jsInvocation;
            } else {
                jsExpression = concatArguments.get(0);
            }
            return jsExpression;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

