/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.descriptors.DefaultImplsClassDescriptor;
import org.jetbrains.kotlin.backend.jvm.descriptors.DefaultImplsClassDescriptorImpl;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceDelegationLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "generateDelegationToDefaultImpl", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "interfaceFun", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "inheritedFun", "generateInterfaceMethods", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "lower", "backend"})
public final class InterfaceDelegationLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final GenerationState state;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        ClassDescriptor descriptor2 = irClass.getDescriptor();
        if (DescriptorUtils.isInterface(descriptor2)) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, this);
        this.generateInterfaceMethods(irClass, descriptor2);
    }

    private final void generateInterfaceMethods(IrClass irClass, ClassDescriptor descriptor2) {
        ClassDescriptor classDescriptor;
        ClassDescriptor classDescriptor2 = descriptor2;
        if (!(classDescriptor2 instanceof DefaultImplsClassDescriptor)) {
            classDescriptor2 = null;
        }
        if ((classDescriptor = (DefaultImplsClassDescriptor)classDescriptor2) == null || (classDescriptor = classDescriptor.getCorrespondingInterface()) == null) {
            classDescriptor = descriptor2;
        }
        ClassDescriptor classDescriptor3 = classDescriptor;
        Map<FunctionDescriptor, FunctionDescriptor> map2 = CodegenUtil.getNonPrivateTraitMethods(classDescriptor3);
        Iterator<Map.Entry<FunctionDescriptor, FunctionDescriptor>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            FunctionDescriptor functionDescriptor;
            Map.Entry<FunctionDescriptor, FunctionDescriptor> entry;
            Map.Entry<FunctionDescriptor, FunctionDescriptor> entry2 = entry = iterator2.next();
            FunctionDescriptor interfaceFun = entry2.getKey();
            entry2 = entry;
            FunctionDescriptor value = entry2.getValue();
            if (CodegenUtilKt.isDefinitelyNotDefaultImplsMethod(interfaceFun)) continue;
            if (classDescriptor3 != descriptor2) {
                ClassDescriptor classDescriptor4 = descriptor2;
                if (classDescriptor4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.backend.jvm.descriptors.DefaultImplsClassDescriptorImpl");
                }
                functionDescriptor = InterfaceLowering.Companion.createDefaultImplFunDescriptor((DefaultImplsClassDescriptorImpl)classDescriptor4, interfaceFun, classDescriptor3, this.state.getTypeMapper());
            } else {
                functionDescriptor = value;
            }
            FunctionDescriptor inheritedFun = functionDescriptor;
            this.generateDelegationToDefaultImpl(irClass, interfaceFun, inheritedFun);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDelegationToDefaultImpl(IrClass irClass, FunctionDescriptor interfaceFun, FunctionDescriptor inheritedFun) {
        void $receiver$iv$iv;
        int n;
        Object it;
        IrValueParameter irValueParameter;
        IrBlockBodyImpl irBody = new IrBlockBodyImpl(-1, -1);
        IrFunctionImpl irFunction = new IrFunctionImpl(-1, -1, IrDeclarationOrigin.DEFINED.INSTANCE, inheritedFun, irBody);
        IrUtilsKt.createParameterDeclarations(irFunction);
        irClass.getDeclarations().add(irFunction);
        DeclarationDescriptor declarationDescriptor = interfaceFun.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor interfaceDescriptor = (ClassDescriptor)declarationDescriptor;
        DefaultImplsClassDescriptorImpl defaultImpls = InterfaceLowering.Companion.createDefaultImplsClassDescriptor(interfaceDescriptor);
        FunctionDescriptor functionDescriptor = interfaceFun.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"interfaceFun.original");
        SimpleFunctionDescriptorImpl defaultImplFun = InterfaceLowering.Companion.createDefaultImplFunDescriptor(defaultImpls, functionDescriptor, interfaceDescriptor, this.state.getTypeMapper());
        IrCallImpl irCallImpl = new IrCallImpl(-1, -1, defaultImplFun, null, JvmLoweredStatementOrigin.DEFAULT_IMPLS_DELEGATION.INSTANCE, null, 32, null);
        irBody.getStatements().add(new IrReturnImpl(-1, -1, irFunction.getSymbol(), (IrExpression)irCallImpl));
        int offset2 = 0;
        IrValueParameter irValueParameter2 = irFunction.getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            irValueParameter = irValueParameter2;
            it = irValueParameter;
            irCallImpl.putValueArgument(offset2, new IrGetValueImpl(-1, -1, (IrValueSymbol)it.getSymbol(), null, 8, null));
            n = offset2;
            offset2 = n + 1;
        }
        IrValueParameter irValueParameter3 = irFunction.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            irValueParameter = irValueParameter3;
            it = irValueParameter;
            irCallImpl.putValueArgument(offset2, new IrGetValueImpl(-1, -1, (IrValueSymbol)it.getSymbol(), null, 8, null));
            n = offset2;
            offset2 = n + 1;
        }
        Iterable $receiver$iv = irFunction.getValueParameters();
        it = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void parameter;
            void i;
            int n2 = index$iv$iv++;
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            irCallImpl.putValueArgument((int)(i + offset2), new IrGetValueImpl(-1, -1, (IrValueSymbol)parameter.getSymbol(), null));
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    public InterfaceDelegationLowering(@NotNull GenerationState state2) {
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        this.state = state2;
    }
}

