/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.Producer;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSet;

public abstract class ConcurrentFactoryMap<K, V>
implements ConcurrentMap<K, V> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("factoryMap");
    private final ConcurrentMap<K, V> myMap = this.createMap();

    @Deprecated
    public ConcurrentFactoryMap() {
    }

    @Nullable
    protected abstract V create(K var1);

    @Override
    public V get(Object key) {
        ConcurrentMap<K, V> map2 = this.myMap;
        Object k = ConcurrentFactoryMap.notNull(key);
        Object value = map2.get(k);
        if (value == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value = this.create(key);
            if (stamp.mayCacheNow()) {
                Object v = ConcurrentFactoryMap.notNull(value);
                value = ConcurrencyUtil.cacheOrGet(map2, k, v);
            }
        }
        return ConcurrentFactoryMap.nullize(value);
    }

    @Nullable
    private static <T> T nullize(T value) {
        return value == ConcurrentFactoryMap.FAKE_NULL() ? null : (T)value;
    }

    private static <T> T FAKE_NULL() {
        return (T)ObjectUtils.NULL;
    }

    private static <T> T notNull(Object key) {
        return (T)(key == null ? ConcurrentFactoryMap.FAKE_NULL() : key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myMap.containsKey(ConcurrentFactoryMap.notNull(key));
    }

    @Override
    public V put(K key, V value) {
        Object k = ConcurrentFactoryMap.notNull(key);
        Object v = ConcurrentFactoryMap.notNull(value);
        v = this.myMap.put(k, v);
        return (V)ConcurrentFactoryMap.nullize(v);
    }

    @Override
    public V remove(Object key) {
        Object v = this.myMap.remove(key);
        return ConcurrentFactoryMap.nullize(v);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Object nullKey;
        Set ts = this.myMap.keySet();
        if (ts.contains(nullKey = ConcurrentFactoryMap.FAKE_NULL())) {
            HashSet hashSet = new HashSet(ts);
            hashSet.remove(nullKey);
            hashSet.add(null);
            HashSet hashSet2 = hashSet;
            if (hashSet2 == null) {
                ConcurrentFactoryMap.$$$reportNull$$$0(0);
            }
            return hashSet2;
        }
        Set set = ts;
        if (set == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(1);
        }
        return set;
    }

    public boolean removeValue(Object value) {
        Object t = ConcurrentFactoryMap.notNull(value);
        return this.myMap.values().remove(t);
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myMap.containsValue(value);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(2);
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        List list2 = ContainerUtil.map(this.myMap.values(), new Function<V, V>(){

            @Override
            public V fun(V v) {
                return ConcurrentFactoryMap.nullize(v);
            }
        });
        if (list2 == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = ContainerUtil.map2Set(this.myMap.entrySet(), new Function<Map.Entry<K, V>, Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> fun(Map.Entry<K, V> entry) {
                return new AbstractMap.SimpleEntry<Object, Object>(ConcurrentFactoryMap.nullize(entry.getKey()), ConcurrentFactoryMap.nullize(entry.getValue()));
            }
        });
        if (set == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    protected ConcurrentMap<K, V> createMap() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        if (concurrentMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(5);
        }
        return concurrentMap;
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(6);
        }
        return this.myMap.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(7);
        }
        return this.myMap.remove(key, value);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(8);
        }
        if (oldValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(9);
        }
        if (newValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(10);
        }
        return this.myMap.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(11);
        }
        if (value == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(12);
        }
        return this.myMap.replace(key, value);
    }

    @Deprecated
    @NotNull
    public static <T, V> ConcurrentFactoryMap<T, V> createConcurrentMap(final @NotNull Function<T, V> computeValue) {
        if (computeValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(13);
        }
        ConcurrentFactoryMap concurrentFactoryMap = new ConcurrentFactoryMap<T, V>(){

            @Override
            @Nullable
            protected V create(T key) {
                return computeValue.fun(key);
            }
        };
        if (concurrentFactoryMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(14);
        }
        return concurrentFactoryMap;
    }

    @NotNull
    public static <T, V> ConcurrentMap<T, V> createMap(final @NotNull Function<T, V> computeValue) {
        if (computeValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(15);
        }
        ConcurrentFactoryMap concurrentFactoryMap = new ConcurrentFactoryMap<T, V>(){

            @Override
            @Nullable
            protected V create(T key) {
                return computeValue.fun(key);
            }
        };
        if (concurrentFactoryMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(16);
        }
        return concurrentFactoryMap;
    }

    @NotNull
    public static <K, V> ConcurrentMap<K, V> createMap(final @NotNull Function<K, V> computeValue, final @NotNull Producer<ConcurrentMap<K, V>> mapCreator) {
        if (computeValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(17);
        }
        if (mapCreator == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(18);
        }
        ConcurrentFactoryMap concurrentFactoryMap = new ConcurrentFactoryMap<K, V>(){

            @Override
            @Nullable
            protected V create(K key) {
                return computeValue.fun(key);
            }

            @Override
            @NotNull
            protected ConcurrentMap<K, V> createMap() {
                ConcurrentMap concurrentMap = (ConcurrentMap)mapCreator.produce();
                if (concurrentMap == null) {
                    5.$$$reportNull$$$0(0);
                }
                return concurrentMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap$5", "createMap"));
            }
        };
        if (concurrentFactoryMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(19);
        }
        return concurrentFactoryMap;
    }

    @NotNull
    public static <T, V> ConcurrentMap<T, V> createWeakMap(@NotNull Function<T, V> compute) {
        if (compute == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(20);
        }
        ConcurrentMap<T, V> concurrentMap = ConcurrentFactoryMap.createMap(compute, new Producer<ConcurrentMap<T, V>>(){

            @Override
            public ConcurrentMap<T, V> produce() {
                return ContainerUtil.createConcurrentWeakMap();
            }
        });
        if (concurrentMap == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(21);
        }
        return concurrentMap;
    }

    @Override
    @Deprecated
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.get(key);
        return v != null ? v : defaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeValue";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapCreator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 5: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentMap";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

