/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSet;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean isInheritorOrSelf(@Nullable PsiClass aClass2, @Nullable PsiClass baseClass, boolean checkDeep) {
        if (aClass2 == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass2.getManager();
        return manager.areElementsEquivalent(baseClass, aClass2) || aClass2.isInheritor(baseClass, checkDeep);
    }

    public static boolean processSupers(@Nullable PsiClass aClass2, boolean includeSelf, @NotNull Processor<PsiClass> superProcessor) {
        if (superProcessor == null) {
            InheritanceUtil.$$$reportNull$$$0(0);
        }
        if (aClass2 == null) {
            return true;
        }
        if (includeSelf && !superProcessor.process(aClass2)) {
            return false;
        }
        return InheritanceUtil.processSupers(aClass2, superProcessor, new THashSet<PsiClass>());
    }

    private static boolean processSupers(@NotNull PsiClass aClass2, @NotNull Processor<PsiClass> superProcessor, @NotNull Set<PsiClass> visited2) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(1);
        }
        if (superProcessor == null) {
            InheritanceUtil.$$$reportNull$$$0(2);
        }
        if (visited2 == null) {
            InheritanceUtil.$$$reportNull$$$0(3);
        }
        if (!visited2.add(aClass2)) {
            return true;
        }
        for (PsiClass intf : aClass2.getInterfaces()) {
            if (superProcessor.process(intf) && InheritanceUtil.processSupers(intf, superProcessor, visited2)) continue;
            return false;
        }
        PsiClass superClass = aClass2.getSuperClass();
        return superClass == null || superProcessor.process(superClass) && InheritanceUtil.processSupers(superClass, superProcessor, visited2);
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiType type2, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(4);
        }
        if (type2 instanceof PsiClassType) {
            return InheritanceUtil.isInheritor(((PsiClassType)type2).resolve(), baseClassName);
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                if (!InheritanceUtil.isInheritor(conjunct, baseClassName)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, @NotNull String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(5);
        }
        return InheritanceUtil.isInheritor(psiClass, false, baseClassName);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, boolean strict, @NotNull String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            return false;
        }
        PsiClass base = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(baseClassName, psiClass.getResolveScope());
        if (base == null) {
            return false;
        }
        return strict ? psiClass.isInheritor(base, true) : InheritanceUtil.isInheritorOrSelf(psiClass, base, true);
    }

    public static void getSuperClasses(@NotNull PsiClass aClass2, @NotNull Set<PsiClass> results, boolean includeNonProject) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(7);
        }
        if (results == null) {
            InheritanceUtil.$$$reportNull$$$0(8);
        }
        InheritanceUtil.getSuperClassesOfList(aClass2.getSuperTypes(), results, includeNonProject, new THashSet<PsiClass>(), aClass2.getManager());
    }

    public static LinkedHashSet<PsiClass> getSuperClasses(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(9);
        }
        LinkedHashSet<PsiClass> result2 = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses(aClass2, result2, true);
        return result2;
    }

    private static void getSuperClassesOfList(@NotNull PsiClassType[] types, @NotNull Set<PsiClass> results, boolean includeNonProject, @NotNull Set<PsiClass> visited2, @NotNull PsiManager manager) {
        if (types == null) {
            InheritanceUtil.$$$reportNull$$$0(10);
        }
        if (results == null) {
            InheritanceUtil.$$$reportNull$$$0(11);
        }
        if (visited2 == null) {
            InheritanceUtil.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            InheritanceUtil.$$$reportNull$$$0(13);
        }
        for (PsiClassType type2 : types) {
            PsiClass resolved = type2.resolve();
            if (resolved == null || !visited2.add(resolved)) continue;
            if (includeNonProject || manager.isInProject(resolved)) {
                results.add(resolved);
            }
            InheritanceUtil.getSuperClassesOfList(resolved.getSuperTypes(), results, includeNonProject, visited2, manager);
        }
    }

    public static boolean hasEnclosingInstanceInScope(PsiClass aClass2, PsiElement scope, boolean isSuperClassAccepted, boolean isTypeParamsAccepted) {
        return InheritanceUtil.hasEnclosingInstanceInScope(aClass2, scope, psiClass -> isSuperClassAccepted, isTypeParamsAccepted);
    }

    public static boolean hasEnclosingInstanceInScope(PsiClass aClass2, PsiElement scope, Condition<PsiClass> isSuperClassAccepted, boolean isTypeParamsAccepted) {
        PsiElement place;
        PsiManager manager = aClass2.getManager();
        for (place = scope; place != null && place != aClass2 && !(place instanceof PsiFile); place = place.getParent()) {
            PsiModifierList modifierList;
            if (place instanceof PsiClass) {
                if (isSuperClassAccepted.value((PsiClass)place) ? InheritanceUtil.isInheritorOrSelf((PsiClass)place, aClass2, true) : manager.areElementsEquivalent(place, aClass2)) {
                    return true;
                }
                if (isTypeParamsAccepted && place instanceof PsiTypeParameter) {
                    return true;
                }
            }
            if (!(place instanceof PsiModifierListOwner) || (modifierList = ((PsiModifierListOwner)place).getModifierList()) == null || !modifierList.hasModifierProperty("static")) continue;
            return false;
        }
        return place == aClass2;
    }

    public static boolean processSuperTypes(@NotNull PsiType type2, boolean includeSelf, @NotNull Processor<PsiType> processor) {
        if (type2 == null) {
            InheritanceUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            InheritanceUtil.$$$reportNull$$$0(15);
        }
        if (includeSelf && !processor.process(type2)) {
            return false;
        }
        return InheritanceUtil.processSuperTypes(type2, processor, new HashSet<PsiType>());
    }

    private static boolean processSuperTypes(PsiType type2, Processor<PsiType> processor, Set<PsiType> visited2) {
        if (!visited2.add(type2)) {
            return true;
        }
        for (PsiType superType : type2.getSuperTypes()) {
            if (!processor.process(superType)) {
                return false;
            }
            InheritanceUtil.processSuperTypes(superType, processor, visited2);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superProcessor";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassName";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/InheritanceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processSupers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperClasses";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperClassesOfList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

