/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.impl.PackageDirectoryCache;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiPackageImpl;
import org.jetbrains.kotlin.com.intellij.psi.search.EverythingGlobalScope;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.NonClasspathDirectoriesScope;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.NonClasspathClassFinder");
    private static final EverythingGlobalScope ALL_SCOPE = new EverythingGlobalScope();
    protected final Project myProject;
    private volatile PackageDirectoryCache myCache;
    private final PsiManager myManager;
    private final String[] myFileExtensions;

    public NonClasspathClassFinder(@NotNull Project project, String ... fileExtensions) {
        if (project == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(0);
        }
        if (fileExtensions == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myManager = PsiManager.getInstance(this.myProject);
        this.myFileExtensions = ArrayUtil.append(fileExtensions, "class");
        MessageBusConnection connection = project.getMessageBus().connect(project);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                NonClasspathClassFinder.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder$1", "after"));
            }
        });
        LowMemoryWatcher.register(() -> this.clearCache(), project);
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        PackageDirectoryCache cache2 = this.myCache;
        if (cache2 == null) {
            List<VirtualFile> roots2 = this.calcClassRoots();
            List<VirtualFile> invalidRoots = ContainerUtil.filter(roots2, f -> !f.isValid());
            if (!invalidRoots.isEmpty()) {
                roots2.removeAll(invalidRoots);
                LOG.error("Invalid roots returned by " + this.getClass() + ": " + invalidRoots);
            }
            this.myCache = cache2 = NonClasspathClassFinder.createCache(roots2);
        }
        PackageDirectoryCache packageDirectoryCache = cache2;
        if (packageDirectoryCache == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(2);
        }
        return packageDirectoryCache;
    }

    @NotNull
    protected static PackageDirectoryCache createCache(@NotNull List<VirtualFile> roots2) {
        if (roots2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(3);
        }
        MultiMap<String, VirtualFile> map2 = MultiMap.create();
        map2.putValues("", roots2);
        PackageDirectoryCache packageDirectoryCache = new PackageDirectoryCache(map2);
        if (packageDirectoryCache == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(4);
        }
        return packageDirectoryCache;
    }

    public void clearCache() {
        this.myCache = null;
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope) {
        return this.getCache(scope).getDirectoriesByPackageName("");
    }

    public List<VirtualFile> getClassRoots() {
        return this.getClassRoots(ALL_SCOPE);
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(6);
        }
        Ref result2 = Ref.create();
        this.processDirectories(StringUtil.getPackageName(qualifiedName), scope, dir -> {
            PsiClass[] classes2;
            VirtualFile virtualFile2;
            PsiFile file2;
            if (qualifiedName == null) {
                NonClasspathClassFinder.$$$reportNull$$$0(37);
            }
            PsiFile psiFile = file2 = (virtualFile2 = NonClasspathClassFinder.findChild(dir, StringUtil.getShortName(qualifiedName), this.myFileExtensions)) == null ? null : this.myManager.findFile(virtualFile2);
            if (file2 instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)file2).getClasses()).length == 1) {
                result2.set(classes2[0]);
                return false;
            }
            return true;
        });
        return (PsiClass)result2.get();
    }

    protected abstract List<VirtualFile> calcClassRoots();

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(8);
        }
        ArrayList<PsiClass> result2 = ContainerUtil.newArrayList();
        this.processDirectories(psiPackage.getQualifiedName(), scope, dir -> {
            for (VirtualFile file2 : dir.getChildren()) {
                PsiFile psi;
                if (file2.isDirectory() || !ArrayUtil.contains(file2.getExtension(), this.myFileExtensions) || !((psi = this.myManager.findFile(file2)) instanceof PsiClassOwner)) continue;
                ContainerUtil.addAll(result2, ((PsiClassOwner)psi).getClasses());
            }
            return true;
        });
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(9);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(11);
        }
        HashSet<String> result2 = new HashSet<String>();
        this.processDirectories(psiPackage.getQualifiedName(), scope, dir -> {
            for (VirtualFile file2 : dir.getChildren()) {
                if (file2.isDirectory() || !ArrayUtil.contains(file2.getExtension(), this.myFileExtensions)) continue;
                result2.add(file2.getNameWithoutExtension());
            }
            return true;
        });
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(13);
        }
        CommonProcessors.FindFirstProcessor<VirtualFile> processor = new CommonProcessors.FindFirstProcessor<VirtualFile>();
        this.processDirectories(qualifiedName, ALL_SCOPE, processor);
        return processor.getFoundValue() != null ? this.createPackage(qualifiedName) : null;
    }

    private PsiPackageImpl createPackage(String qualifiedName) {
        return new PsiPackageImpl(this.myManager, qualifiedName);
    }

    @Override
    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(16);
        }
        return this.processDirectories(psiPackage.getQualifiedName(), scope, dir -> {
            PsiDirectory psiDirectory;
            if (psiPackage == null) {
                NonClasspathClassFinder.$$$reportNull$$$0(35);
            }
            if (consumer == null) {
                NonClasspathClassFinder.$$$reportNull$$$0(36);
            }
            return (psiDirectory = psiPackage.getManager().findDirectory((VirtualFile)dir)) == null || consumer.process(psiDirectory);
        });
    }

    private boolean processDirectories(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope, @NotNull Processor<VirtualFile> processor) {
        if (qualifiedName == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(19);
        }
        return ContainerUtil.process(this.getCache(scope).getDirectoriesByPackageName(qualifiedName), file2 -> {
            if (scope == null) {
                NonClasspathClassFinder.$$$reportNull$$$0(33);
            }
            if (processor == null) {
                NonClasspathClassFinder.$$$reportNull$$$0(34);
            }
            return !scope.contains((VirtualFile)file2) || processor.process((VirtualFile)file2);
        });
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(21);
        }
        String pkgName = psiPackage.getQualifiedName();
        Set<String> names2 = this.getCache(scope).getSubpackageNames(pkgName);
        if (names2.isEmpty()) {
            PsiPackage[] psiPackageArray = super.getSubPackages(psiPackage, scope);
            if (psiPackageArray == null) {
                NonClasspathClassFinder.$$$reportNull$$$0(22);
            }
            return psiPackageArray;
        }
        ArrayList<PsiPackageImpl> result2 = new ArrayList<PsiPackageImpl>();
        for (String name : names2) {
            result2.add(this.createPackage(pkgName.isEmpty() ? name : pkgName + "." + name));
        }
        PsiPackage[] psiPackageArray = result2.toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(23);
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        PsiClass psiClass;
        if (qualifiedName == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(25);
        }
        if ((psiClass = this.findClass(qualifiedName, scope)) == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        if (psiClassArray == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(26);
        }
        return psiClassArray;
    }

    @NotNull
    public static GlobalSearchScope addNonClasspathScope(@NotNull Project project, @NotNull GlobalSearchScope base) {
        if (project == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(27);
        }
        if (base == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(28);
        }
        GlobalSearchScope scope = base;
        for (PsiElementFinder finder : (PsiElementFinder[])Extensions.getExtensions(EP_NAME, (AreaInstance)project)) {
            if (!(finder instanceof NonClasspathClassFinder)) continue;
            scope = scope.uniteWith(NonClasspathDirectoriesScope.compose(((NonClasspathClassFinder)finder).getClassRoots()));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(29);
        }
        return globalSearchScope;
    }

    public PsiManager getPsiManager() {
        return this.myManager;
    }

    @Nullable
    private static VirtualFile findChild(@NotNull VirtualFile root2, @NotNull String relPath, @NotNull String[] extensions) {
        if (root2 == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(30);
        }
        if (relPath == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(31);
        }
        if (extensions == null) {
            NonClasspathClassFinder.$$$reportNull$$$0(32);
        }
        VirtualFile file2 = null;
        for (String extension : extensions) {
            file2 = root2.findChild(relPath + '.' + extension);
            if (file2 != null) break;
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtensions";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: 
            case 13: 
            case 17: 
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 20: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 16: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCache";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addNonClasspathScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCache";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processDirectories";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addNonClasspathScope";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processDirectories$6";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processPackageDirectories$5";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findClass$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

