/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.utils.Interner;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "Lorg/jetbrains/kotlin/serialization/StringTable;", "()V", "qualifiedNames", "Lorg/jetbrains/kotlin/utils/Interner;", "Lorg/jetbrains/kotlin/serialization/StringTableImpl$FqNameProto;", "strings", "", "buildProto", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$StringTable;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable;", "getClassIdIndex", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFqNameIndex", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "getFqNameIndexOfLocalAnonymousClass", "getPackageFqNameIndex", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getSimpleNameIndex", "name", "Lorg/jetbrains/kotlin/name/Name;", "getStringIndex", "string", "serializeTo", "", "output", "Ljava/io/OutputStream;", "FqNameProto", "serialization"})
public class StringTableImpl
implements StringTable {
    private final Interner<String> strings = new Interner();
    private final Interner<FqNameProto> qualifiedNames = new Interner();

    public final int getSimpleNameIndex(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = name.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
        return this.getStringIndex(string);
    }

    @Override
    public int getStringIndex(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        return this.strings.intern(string);
    }

    @Override
    public int getFqNameIndex(@NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (ErrorUtils.isError(descriptor2)) {
            throw (Throwable)new IllegalStateException("Cannot get FQ name of error class: " + descriptor2);
        }
        ClassId classId = DescriptorUtilsKt.getClassId(descriptor2);
        if (classId == null) {
            return this.getFqNameIndexOfLocalAnonymousClass(descriptor2);
        }
        ClassId classId2 = classId;
        return this.getClassIdIndex(classId2);
    }

    @Override
    public int getClassIdIndex(@NotNull ClassId classId) {
        int n;
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder2 = builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        builder2.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder3 = builder;
        ClassId classId2 = classId.getOuterClassId();
        if (classId2 != null) {
            ClassId classId3 = classId2;
            StringTableImpl stringTableImpl = this;
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder4 = builder3;
            ClassId p1 = classId3;
            int n2 = stringTableImpl.getClassIdIndex(p1);
            builder3 = builder4;
            n = n2;
        } else {
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
            n = this.getPackageFqNameIndex(fqName2);
        }
        builder3.setParentQualifiedName(n);
        String string = classId.getShortClassName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classId.shortClassName.asString()");
        builder.setShortName(this.getStringIndex(string));
        return this.qualifiedNames.intern(new FqNameProto(builder));
    }

    public int getFqNameIndexOfLocalAnonymousClass(@NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        throw (Throwable)new IllegalStateException("Cannot get FQ name of local class: " + descriptor2);
    }

    public final int getPackageFqNameIndex(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        int result2 = -1;
        for (Name segment : fqName2.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder;
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder2 = builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
            Name name = segment;
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"segment");
            builder2.setShortName(this.getSimpleNameIndex(name));
            if (result2 != -1) {
                builder.setParentQualifiedName(result2);
            }
            result2 = this.qualifiedNames.intern(new FqNameProto(builder));
        }
        return result2;
    }

    @NotNull
    public final Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> buildProto() {
        ProtoBuf.StringTable.Builder strings = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : this.strings.getAllInternedObjects()) {
            strings.addString(simpleName);
        }
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (FqNameProto fqName2 : this.qualifiedNames.getAllInternedObjects()) {
            qualifiedNames.addQualifiedName(fqName2.getFqName());
        }
        return new Pair((Object)strings.build(), (Object)qualifiedNames.build());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serializeTo(@NotNull OutputStream output) {
        void strings;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = this.buildProto();
        ProtoBuf.StringTable stringTable = (ProtoBuf.StringTable)pair.component1();
        ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)pair.component2();
        strings.writeDelimitedTo(output);
        qualifiedNames.writeDelimitedTo(output);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/serialization/StringTableImpl$FqNameProto;", "", "fqName", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;", "(Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;)V", "getFqName", "()Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;", "equals", "", "other", "hashCode", "", "serialization"})
    private static final class FqNameProto {
        @NotNull
        private final ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName;

        public int hashCode() {
            int result2 = 13;
            result2 = 31 * result2 + this.fqName.getParentQualifiedName();
            result2 = 31 * result2 + this.fqName.getShortName();
            result2 = 31 * result2 + this.fqName.getKind().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof FqNameProto)) {
                return false;
            }
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder otherFqName = ((FqNameProto)other).fqName;
            return this.fqName.getParentQualifiedName() == otherFqName.getParentQualifiedName() && this.fqName.getShortName() == otherFqName.getShortName() && this.fqName.getKind() == otherFqName.getKind();
        }

        @NotNull
        public final ProtoBuf.QualifiedNameTable.QualifiedName.Builder getFqName() {
            return this.fqName;
        }

        public FqNameProto(@NotNull ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName2) {
            Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
            this.fqName = fqName2;
        }
    }
}

