/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.extapi.psi;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.project.ProjectCoreUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SubstrateRef;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;

public class StubBasedPsiElementBase<T extends StubElement>
extends ASTDelegatePsiElement {
    public static final Key<String> CREATION_TRACE = Key.create("CREATION_TRACE");
    public static final boolean ourTraceStubAstBinding = "true".equals(System.getProperty("trace.stub.ast.binding", "false"));
    private volatile SubstrateRef mySubstrateRef;
    private volatile int myStubIndex;
    private final IElementType myElementType;

    public StubBasedPsiElementBase(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(1);
        }
        this.myStubIndex = -1;
        this.mySubstrateRef = new SubstrateRef.StubRef((StubElement)stub);
        this.myElementType = nodeType;
    }

    public StubBasedPsiElementBase(@NotNull ASTNode node) {
        if (node == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(2);
        }
        this.myStubIndex = -1;
        this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
        this.myElementType = node.getElementType();
    }

    public StubBasedPsiElementBase(T stub, IElementType nodeType, ASTNode node) {
        this.myStubIndex = -1;
        if (stub != null) {
            if (nodeType == null) {
                throw new IllegalArgumentException("null cannot be passed to 'nodeType' when 'stub' is non-null");
            }
            if (node != null) {
                throw new IllegalArgumentException("null must be passed to 'node' parameter when 'stub' is non-null");
            }
            this.mySubstrateRef = new SubstrateRef.StubRef((StubElement)stub);
            this.myElementType = nodeType;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("'stub' and 'node' parameters cannot be null both");
            }
            if (nodeType != null) {
                throw new IllegalArgumentException("null must be passed to 'nodeType' parameter when 'node' is non-null");
            }
            this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
            this.myElementType = node.getElementType();
        }
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiFileImpl file2 = (PsiFileImpl)this.getContainingFile();
            if (!file2.isValid()) {
                throw new PsiInvalidElementAccessException(file2);
            }
            FileElement treeElement = file2.getTreeElement();
            if (treeElement != null && this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                ASTNode aSTNode = this.notBoundInExistingAst(file2, treeElement);
                if (aSTNode == null) {
                    StubBasedPsiElementBase.$$$reportNull$$$0(3);
                }
                return aSTNode;
            }
            treeElement = file2.calcTreeElement();
            if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                ASTNode aSTNode = this.failedToBindStubToAst(file2, treeElement);
                if (aSTNode == null) {
                    StubBasedPsiElementBase.$$$reportNull$$$0(4);
                }
                return aSTNode;
            }
        }
        ASTNode aSTNode = this.mySubstrateRef.getNode();
        if (aSTNode == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(5);
        }
        return aSTNode;
    }

    private ASTNode failedToBindStubToAst(@NotNull PsiFileImpl file2, @NotNull FileElement fileElement) {
        if (file2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(6);
        }
        if (fileElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(7);
        }
        VirtualFile vFile = file2.getVirtualFile();
        StubTree stubTree = file2.getStubTree();
        String stubString = stubTree != null ? ((PsiFileStubImpl)stubTree.getRoot()).printTree() : null;
        String astString = RecursionManager.doPreventingRecursion("failedToBindStubToAst", true, () -> {
            if (fileElement == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(40);
            }
            return DebugUtil.treeToString(fileElement, true);
        });
        String message = "Failed to bind stub to AST for element " + this.getClass() + " in " + (vFile == null ? "<unknown file>" : vFile.getPath()) + "\nFile:\n" + file2 + "@" + System.identityHashCode(file2);
        String creationTraces = ourTraceStubAstBinding ? this.dumpCreationTraces(fileElement) : null;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (stubString != null) {
            attachments.add(new Attachment("stubTree.txt", stubString));
        }
        if (astString != null) {
            attachments.add(new Attachment("ast.txt", astString));
        }
        if (creationTraces != null) {
            attachments.add(new Attachment("creationTraces.txt", creationTraces));
        }
        throw new RuntimeExceptionWithAttachments(message, attachments.toArray(Attachment.EMPTY_ARRAY));
    }

    @NotNull
    private String dumpCreationTraces(@NotNull FileElement fileElement) {
        if (fileElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(8);
        }
        final StringBuilder traces = new StringBuilder("\nNow " + Thread.currentThread() + "\n");
        traces.append("My creation trace:\n").append(this.getUserData(CREATION_TRACE));
        traces.append("AST creation traces:\n");
        fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitComposite(CompositeElement composite) {
                PsiElement psi = composite.getPsi();
                if (psi != null) {
                    traces.append(psi).append("@").append(System.identityHashCode(psi)).append("\n");
                    String trace = psi.getUserData(CREATION_TRACE);
                    if (trace != null) {
                        traces.append(trace).append("\n");
                    }
                }
                super.visitComposite(composite);
            }
        });
        String string = traces.toString();
        if (string == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    private ASTNode notBoundInExistingAst(@NotNull PsiFileImpl file2, @NotNull FileElement treeElement) {
        if (file2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(10);
        }
        if (treeElement == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(11);
        }
        String message = "file=" + file2 + "; tree=" + treeElement;
        for (PsiElement each = this; each != null; each = each.getParentByStub()) {
            message = message + "\n each of class " + each.getClass() + "; valid=" + each.isValid();
            if (each instanceof StubBasedPsiElementBase) {
                message = message + "; ref=" + each.mySubstrateRef;
                continue;
            }
            if (!(each instanceof PsiFile)) break;
            message = message + "; same file=" + (each == file2) + "; current tree= " + file2.getTreeElement() + "; stubTree=" + file2.getStubTree() + "; physical=" + file2.isPhysical();
            break;
        }
        for (Object eachStub = this.getStub(); eachStub != null; eachStub = eachStub.getParentStub()) {
            message = message + "\n each stub " + (eachStub instanceof PsiFileStubImpl ? ((PsiFileStubImpl)eachStub).getDiagnostics() : eachStub);
        }
        if (ourTraceStubAstBinding) {
            message = message + this.dumpCreationTraces(treeElement);
        }
        throw new AssertionError((Object)message);
    }

    public final void setNode(@NotNull ASTNode node) {
        if (node == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(12);
        }
        this.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
    }

    public final void setSubstrateRef(@NotNull SubstrateRef substrateRef) {
        if (substrateRef == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(13);
        }
        this.mySubstrateRef = substrateRef;
        this.myStubIndex = -1;
    }

    public final void setStubIndex(int stubIndex) {
        this.myStubIndex = stubIndex;
    }

    public int getStubIndex() {
        return this.myStubIndex;
    }

    @NotNull
    public final SubstrateRef getSubstrateRef() {
        SubstrateRef substrateRef = this.mySubstrateRef;
        if (substrateRef == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(14);
        }
        return substrateRef;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(15);
        }
        return language;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile;
        try {
            psiFile = this.mySubstrateRef.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            if (PsiInvalidElementAccessException.getInvalidationTrace(this) != null) {
                throw new PsiInvalidElementAccessException((PsiElement)this, (Throwable)e);
            }
            throw e;
        }
        if (psiFile == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(16);
        }
        return psiFile;
    }

    @Override
    public boolean isWritable() {
        return this.getContainingFile().isWritable();
    }

    @Override
    public boolean isValid() {
        ProgressManager.checkCanceled();
        return this.mySubstrateRef.isValid();
    }

    @Override
    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        return (PsiManagerEx)this.getContainingFile().getManager();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            Project project2 = project;
            if (project2 == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(17);
            }
            return project2;
        }
        Project project3 = this.getContainingFile().getProject();
        if (project3 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(18);
        }
        return project3;
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @Override
    public PsiElement getContext() {
        T stub = this.getStub();
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getContext();
    }

    protected final PsiElement getParentByStub() {
        T stub = this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @Deprecated
    protected final PsiElement getParentByTree() {
        return SharedImplUtil.getParent(this.getNode());
    }

    @Override
    public PsiElement getParent() {
        T stub = this.getGreenStub();
        if (stub != null && !((ObjectStubBase)stub).isDangling()) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @NotNull
    public IStubElementType getElementType() {
        if (!(this.myElementType instanceof IStubElementType)) {
            throw new ClassCastException("Not a stub type: " + this.myElementType + " in " + this.getClass());
        }
        IStubElementType iStubElementType = (IStubElementType)this.myElementType;
        if (iStubElementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(19);
        }
        return iStubElementType;
    }

    @Nullable
    public T getStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getStub(this.myStubIndex));
    }

    @Nullable
    public final T getGreenStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getGreenStub(this.myStubIndex));
    }

    @Nullable
    public <Psi extends PsiElement> Psi getStubOrPsiChild(@NotNull IStubElementType<? extends StubElement, Psi> elementType) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(20);
        }
        if ((stub = this.getGreenStub()) != null) {
            StubElement<Psi> element = stub.findChildStubByType(elementType);
            if (element != null) {
                return element.getPsi();
            }
        } else {
            ASTNode childNode = this.getNode().findChildByType(elementType);
            if (childNode != null) {
                return (Psi)childNode.getPsi();
            }
        }
        return null;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi getRequiredStubOrPsiChild(@NotNull IStubElementType<S, Psi> elementType) {
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(21);
        }
        Psi result2 = this.getStubOrPsiChild(elementType);
        assert (result2 != null) : "Missing required child of type " + elementType + "; tree: " + DebugUtil.psiToString(this, false);
        Psi Psi = result2;
        if (Psi == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(22);
        }
        return Psi;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull Psi[] array) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(23);
        }
        if (array == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(24);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, array);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(25);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(26);
        }
        return psiElements;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull ArrayFactory<Psi> f) {
        T stub;
        if (elementType == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(27);
        }
        if (f == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(28);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, f);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(29);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(30);
        }
        return psiElements;
    }

    @NotNull
    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull TokenSet filter2, @NotNull Psi[] array) {
        T stub;
        if (filter2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(31);
        }
        if (array == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(32);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(filter2, array);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(33);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = this.getNode().getChildren(filter2);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(34);
        }
        return psiElements;
    }

    @NotNull
    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull TokenSet filter2, @NotNull ArrayFactory<Psi> f) {
        T stub;
        if (filter2 == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(35);
        }
        if (f == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(36);
        }
        if ((stub = this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(filter2, f);
            if (psiElementArray == null) {
                StubBasedPsiElementBase.$$$reportNull$$$0(37);
            }
            return psiElementArray;
        }
        ASTNode[] nodes = this.getNode().getChildren(filter2);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(38);
        }
        return psiElements;
    }

    @Nullable
    protected <E extends PsiElement> E getStubOrPsiParentOfType(@NotNull Class<E> parentClass) {
        T stub;
        if (parentClass == null) {
            StubBasedPsiElementBase.$$$reportNull$$$0(39);
        }
        if ((stub = this.getStub()) != null) {
            return stub.getParentStubOfType(parentClass);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)this, parentClass);
    }

    @Override
    protected Object clone() {
        StubBasedPsiElementBase copy = (StubBasedPsiElementBase)super.clone();
        copy.setSubstrateRef(SubstrateRef.createAstStrongRef(this.getNode()));
        return copy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substrateRef";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpCreationTraces";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstrateRef";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredStubOrPsiChild";
                break;
            }
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "failedToBindStubToAst";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dumpCreationTraces";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notBoundInExistingAst";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSubstrateRef";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChild";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredStubOrPsiChild";
                break;
            }
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChildren";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiParentOfType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$failedToBindStubToAst$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

