/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt$WhenMappings;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a0\u0010\u000b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0011H\u0002\u001a8\u0010\u000b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0011H\u0002\u00a8\u0006\u0015"}, d2={"collectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "encodeSignature", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getOwnTypeParameters", "nameTypeParameters", "", "encodeForSignature", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameterNamer", "Lkotlin/Function1;", "projection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "parameter", "js.frontend"})
public final class EncodeSignatureKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String encodeSignature(@NotNull CallableDescriptor descriptor2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        StringBuilder sig = new StringBuilder();
        Map<TypeParameterDescriptor, String> typeParameterNames = EncodeSignatureKt.nameTypeParameters(descriptor2);
        Iterable iterable = $receiver$iv = (Iterable)descriptor2.getTypeParameters();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            if (!(!it.isCapturedFromOuterDeclaration())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set currentParameters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set usedTypeParameters = CollectionsKt.toMutableSet((Iterable)currentParameters);
        Function1 typeParameterNamer2 = (Function1)new Function1<TypeParameterDescriptor, String>(usedTypeParameters, typeParameterNames){
            final /* synthetic */ Set $usedTypeParameters;
            final /* synthetic */ Map $typeParameterNames;

            @NotNull
            public final String invoke(@NotNull TypeParameterDescriptor typeParameter) {
                Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
                Collection collection = this.$usedTypeParameters;
                TypeParameterDescriptor typeParameterDescriptor = typeParameter.getOriginal();
                collection.add(typeParameterDescriptor);
                V v = this.$typeParameterNames.get(typeParameter.getOriginal());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                return (String)v;
            }
            {
                this.$usedTypeParameters = set;
                this.$typeParameterNames = map2;
                super(1);
            }
        };
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverParameter.type");
            EncodeSignatureKt.encodeForSignature(sig, kotlinType, (Function1<? super TypeParameterDescriptor, String>)typeParameterNamer2).append('/');
        }
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            if (valueParameter.getIndex() > 0) {
                sig.append(",");
            }
            if (valueParameter.getVarargElementType() != null) {
                sig.append("*");
            }
            KotlinType kotlinType = valueParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"valueParameter.type");
            EncodeSignatureKt.encodeForSignature(sig, kotlinType, (Function1<? super TypeParameterDescriptor, String>)typeParameterNamer2);
        }
        boolean first = true;
        for (TypeParameterDescriptor typeParameter : SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)typeParameterNames.keySet()), (Function1)((Function1)new Function1<TypeParameterDescriptor, Boolean>(usedTypeParameters){
            final /* synthetic */ Set $usedTypeParameters;

            public final boolean invoke(@NotNull TypeParameterDescriptor it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$usedTypeParameters.contains(it);
            }
            {
                this.$usedTypeParameters = set;
                super(1);
            }
        }))) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Iterable $i$f$filter = $receiver$iv2 = (Iterable)typeParameter.getUpperBounds();
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                KotlinType it = (KotlinType)element$iv$iv;
                if (!(!KotlinBuiltIns.isNullableAny(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List upperBounds = (List)destination$iv$iv2;
            if (upperBounds.isEmpty() && !currentParameters.contains(typeParameter)) continue;
            sig.append(first ? "|" : ",").append(typeParameterNames.get(typeParameter));
            first = false;
            if (upperBounds.isEmpty()) continue;
            sig.append("<:");
            for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)upperBounds)) {
                int boundIndex = indexedValue.component1();
                KotlinType upperBound = (KotlinType)indexedValue.component2();
                if (boundIndex > 0) {
                    sig.append("&");
                }
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"upperBound");
                EncodeSignatureKt.encodeForSignature(sig, kotlinType, (Function1<? super TypeParameterDescriptor, String>)typeParameterNamer2);
            }
        }
        String string = sig.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sig.toString()");
        return string;
    }

    private static final StringBuilder encodeForSignature(@NotNull StringBuilder $receiver, KotlinType type2, Function1<? super TypeParameterDescriptor, String> typeParameterNamer2) {
        ClassifierDescriptor declaration;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        if ((declaration = classifierDescriptor) instanceof TypeParameterDescriptor) {
            StringBuilder stringBuilder = $receiver.append((String)typeParameterNamer2.invoke((Object)declaration));
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(typeParameterNamer(declaration))");
            return stringBuilder;
        }
        $receiver.append(DescriptorUtils.getFqName(declaration).asString());
        List<TypeParameterDescriptor> parameters2 = declaration.getTypeConstructor().getParameters();
        Collection collection2 = type2.getArguments();
        if (!collection2.isEmpty() && !(collection2 = (Collection)parameters2).isEmpty()) {
            $receiver.append("<");
            Iterable iterable = type2.getArguments();
            List<TypeParameterDescriptor> list2 = parameters2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameters");
            for (Collection collection2 : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
                TypeProjection argument = (TypeProjection)collection2.component1();
                TypeParameterDescriptor parameter = (TypeParameterDescriptor)collection2.component2();
                if (parameter.getIndex() > 0) {
                    $receiver.append(",");
                }
                TypeParameterDescriptor typeParameterDescriptor = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"parameter");
                EncodeSignatureKt.encodeForSignature($receiver, argument, typeParameterDescriptor, typeParameterNamer2);
            }
            $receiver.append(">");
        }
        if (type2.isMarkedNullable()) {
            $receiver.append("?");
        }
        return $receiver;
    }

    private static final StringBuilder encodeForSignature(@NotNull StringBuilder $receiver, TypeProjection projection, TypeParameterDescriptor parameter, Function1<? super TypeParameterDescriptor, String> typeParameterNamer2) {
        StringBuilder stringBuilder;
        if (projection.isStarProjection()) {
            StringBuilder stringBuilder2 = $receiver.append("*");
            stringBuilder = stringBuilder2;
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(\"*\")");
        } else {
            Variance variance = parameter.getVariance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance), (String)"parameter.variance");
            Variance variance2 = projection.getProjectionKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance2), (String)"projection.projectionKind");
            switch (EncodeSignatureKt$WhenMappings.$EnumSwitchMapping$0[UtilsKt.getEffectiveVariance(variance, variance2).ordinal()]) {
                case 1: {
                    $receiver.append("-");
                    break;
                }
                case 2: {
                    $receiver.append("+");
                }
            }
            KotlinType kotlinType = projection.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"projection.type");
            stringBuilder = EncodeSignatureKt.encodeForSignature($receiver, kotlinType, typeParameterNamer2);
        }
        return stringBuilder;
    }

    private static final Map<TypeParameterDescriptor, String> nameTypeParameters(DeclarationDescriptor descriptor2) {
        Map result2 = new LinkedHashMap();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)EncodeSignatureKt.collectTypeParameters(descriptor2))) {
            int listIndex = indexedValue.component1();
            List list2 = (List)indexedValue.component2();
            for (IndexedValue indexedValue2 : CollectionsKt.withIndex((Iterable)list2)) {
                int indexInList = indexedValue2.component1();
                TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)indexedValue2.component2();
                Map map2 = result2;
                String string = "" + listIndex + ':' + indexInList;
                map2.put(typeParameter, string);
            }
        }
        return result2;
    }

    private static final List<List<TypeParameterDescriptor>> collectTypeParameters(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor currentDescriptor = descriptor2;
        List result2 = new ArrayList();
        while (currentDescriptor != null) {
            if (EncodeSignatureKt.getOwnTypeParameters(currentDescriptor) != null) {
                List<TypeParameterDescriptor> list2;
                List<TypeParameterDescriptor> it = list2;
                Collection collection = result2;
                collection.add(it);
            }
            currentDescriptor = currentDescriptor instanceof ConstructorDescriptor ? ((ConstructorDescriptor)currentDescriptor).getConstructedClass().getContainingDeclaration() : currentDescriptor.getContainingDeclaration();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TypeParameterDescriptor> getOwnTypeParameters(DeclarationDescriptor descriptor2) {
        List list2;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)((ClassDescriptor)descriptor2).getDeclaredTypeParameters();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
                if (!(!it.isCapturedFromOuterDeclaration())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
            list2 = EncodeSignatureKt.getOwnTypeParameters(propertyDescriptor);
        } else if (declarationDescriptor instanceof CallableDescriptor) {
            Iterable $receiver$iv;
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)((CallableDescriptor)descriptor2).getTypeParameters();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
                if (!(!it.isCapturedFromOuterDeclaration())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }
}

