/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutors;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/lang/LanguageUtil", "getLanguageForPsi"));
        }
        Language language = LanguageUtil.getFileLanguage(file);
        if (language == null) {
            return null;
        }
        return LanguageSubstitutors.INSTANCE.substituteLanguage(language, file, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        Language l = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
        return l != null ? l : LanguageUtil.getFileTypeLanguage(file.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@Nullable FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        Language language;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/lang/LanguageUtil", "getRootLanguage"));
        }
        PsiFile containingFile = element.getContainingFile();
        FileViewProvider provider = containingFile.getViewProvider();
        Set<Language> languages = provider.getLanguages();
        if (languages.size() > 1 && languages.contains(language = containingFile.getLanguage())) {
            Language language2 = language;
            if (language2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/LanguageUtil", "getRootLanguage"));
            }
            return language2;
        }
        Language language3 = provider.getBaseLanguage();
        if (language3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/LanguageUtil", "getRootLanguage"));
        }
        return language3;
    }
}

