/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.impl;

import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.ForeignLeafType;
import org.jetbrains.kotlin.com.intellij.lang.ITokenTypeRemapper;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.TokenWrapper;
import org.jetbrains.kotlin.com.intellij.lang.WhitespaceSkippedCallback;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lang.impl.MarkerOptionalData;
import org.jetbrains.kotlin.com.intellij.lang.impl.MarkerPool;
import org.jetbrains.kotlin.com.intellij.lang.impl.MarkerProduction;
import org.jetbrains.kotlin.com.intellij.lang.impl.TokenSequence;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.EmptyProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.CharTableImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.text.BlockSupportImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.text.DiffLog;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.text.BlockSupport;
import org.jetbrains.kotlin.com.intellij.psi.tree.ICustomParsingType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILeafElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILightLazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.TripleFunction;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Convertor;
import org.jetbrains.kotlin.com.intellij.util.containers.LimitedPool;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.com.intellij.util.diff.DiffTreeChangeBuilder;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.gnu.trove.TIntObjectHashMap;

public class PsiBuilderImpl
extends UserDataHolderBase
implements PsiBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.impl.PsiBuilderImpl");
    public static final Key<TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState>> CUSTOM_COMPARATOR = Key.create("CUSTOM_COMPARATOR");
    private static final Key<TokenSequence> LAZY_PARSEABLE_TOKENS = Key.create("LAZY_PARSEABLE_TOKENS");
    private static TokenSet ourAnyLanguageWhitespaceTokens = TokenSet.EMPTY;
    private final Project myProject;
    private PsiFile myFile;
    private final int[] myLexStarts;
    private final IElementType[] myLexTypes;
    private int myCurrentLexeme;
    private final Lexer myLexer;
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    private CharTable myCharTable;
    private final CharSequence myText;
    private final CharSequence myLastCommittedText;
    private final char[] myTextArray;
    private boolean myDebugMode;
    private final int myLexemeCount;
    private boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private final ASTNode myOriginalTree;
    private final MyTreeStructure myParentLightTree;
    private final int myOffset;
    private Map<Key, Object> myUserData;
    private IElementType myCachedTokenType;
    private final TIntObjectHashMap<LazyParseableToken> myChameleonCache;
    private final MarkerPool myPool;
    private final MarkerOptionalData myOptionalData;
    private final MarkerProduction myProduction;

    public static void registerWhitespaceToken(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "registerWhitespaceToken"));
        }
        ourAnyLanguageWhitespaceTokens = TokenSet.orSet(ourAnyLanguageWhitespaceTokens, TokenSet.create(type2));
    }

    public PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text2, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this(project, containingFile, parserDefinition, lexer, charTable, text2, originalTree, originalTree == null ? null : originalTree.getText(), parentLightTree, null);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this(project, SharedImplUtil.getContainingFile(chameleon), parserDefinition, lexer, SharedImplUtil.findCharTableByTree(chameleon), text2, Pair.getFirst(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)), Pair.getSecond(chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED)), null, chameleon);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull LighterLazyParseableNode chameleon, @NotNull CharSequence text2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this(project, chameleon.getContainingFile(), parserDefinition, lexer, chameleon.getCharTable(), text2, null, null, ((LazyParseableToken)chameleon).myParentStructure, chameleon);
    }

    private PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text2, @Nullable ASTNode originalTree, @Nullable CharSequence lastCommittedText, @Nullable MyTreeStructure parentLightTree, @Nullable Object parentCachingNode) {
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "<init>"));
        }
        this.myChameleonCache = new TIntObjectHashMap();
        this.myPool = new MarkerPool(this);
        this.myOptionalData = new MarkerOptionalData();
        this.myProduction = new MarkerProduction(this.myPool, this.myOptionalData);
        this.myProject = project;
        this.myFile = containingFile;
        this.myText = text2;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying(text2);
        this.myLexer = lexer;
        this.myWhitespaces = parserDefinition.getWhitespaceTokens();
        this.myComments = parserDefinition.getCommentTokens();
        this.myCharTable = charTable;
        this.myOriginalTree = originalTree;
        this.myLastCommittedText = lastCommittedText;
        if (originalTree == null != (lastCommittedText == null)) {
            throw new IllegalArgumentException("originalTree and lastCommittedText must be null/notnull together but got: originalTree=" + originalTree + "; lastCommittedText=" + (lastCommittedText == null ? null : "'" + StringUtil.first(lastCommittedText, 80, true) + "'"));
        }
        this.myParentLightTree = parentLightTree;
        this.myOffset = parentCachingNode instanceof LazyParseableToken ? ((LazyParseableToken)parentCachingNode).getStartOffset() : 0;
        TokenSequence tokens = this.performLexing(parentCachingNode);
        this.myLexStarts = tokens.lexStarts;
        this.myLexTypes = tokens.lexTypes;
        this.myLexemeCount = tokens.lexemeCount;
    }

    private TokenSequence performLexing(@Nullable Object parentCachingNode) {
        TokenSequence fromParent = null;
        if (parentCachingNode instanceof LazyParseableToken) {
            fromParent = ((LazyParseableToken)parentCachingNode).getParsedTokenSequence();
            assert (fromParent == null || fromParent.lexStarts[fromParent.lexemeCount] == this.myText.length());
            ProgressIndicatorProvider.checkCanceled();
        } else if (parentCachingNode instanceof LazyParseableElement) {
            LazyParseableElement parentElement = (LazyParseableElement)parentCachingNode;
            fromParent = parentElement.getUserData(LAZY_PARSEABLE_TOKENS);
            parentElement.putUserData(LAZY_PARSEABLE_TOKENS, null);
        }
        if (fromParent != null) {
            if (PsiBuilderImpl.doLexingOptimizationCorrectionCheck()) {
                fromParent.assertMatches(this.myText, this.myLexer);
            }
            return fromParent;
        }
        return new TokenSequence.Builder(this.myText, this.myLexer).performLexing();
    }

    private static boolean doLexingOptimizationCorrectionCheck() {
        return false;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void enforceCommentTokens(@NotNull TokenSet tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "enforceCommentTokens"));
        }
        this.myComments = tokens;
    }

    @Override
    @Nullable
    public StartMarker getLatestDoneMarker() {
        for (int index2 = this.myProduction.size() - 1; index2 >= 0; --index2) {
            StartMarker marker = this.myProduction.getDoneMarkerAt(index2);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker precede(StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "Preceding disposed marker";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.addBefore(pre, marker);
        StartMarker startMarker = pre;
        if (startMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "precede"));
        }
        return startMarker;
    }

    @Override
    public CharSequence getOriginalText() {
        return this.myText;
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        IElementType cached = this.myCachedTokenType;
        if (cached == null) {
            this.myCachedTokenType = cached = this.calcTokenType();
        }
        return cached;
    }

    private void clearCachedTokenType() {
        this.myCachedTokenType = null;
    }

    private IElementType remapCurrentToken() {
        if (this.myCachedTokenType != null) {
            return this.myCachedTokenType;
        }
        if (this.myRemapper != null) {
            this.remapCurrentToken(this.myRemapper.filter(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1], this.myLexer.getBufferSequence()));
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    private IElementType calcTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            this.skipWhitespace();
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    @Override
    public void setTokenTypeRemapper(ITokenTypeRemapper remapper) {
        this.myRemapper = remapper;
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    @Override
    public void remapCurrentToken(IElementType type2) {
        this.myLexTypes[this.myCurrentLexeme] = type2;
        this.clearCachedTokenType();
    }

    @Override
    @Nullable
    public IElementType lookAhead(int steps) {
        if (this.eof()) {
            return null;
        }
        int cur = this.myCurrentLexeme;
        while (steps > 0) {
            ++cur;
            while (cur < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[cur])) {
                ++cur;
            }
            --steps;
        }
        return cur < this.myLexemeCount ? this.myLexTypes[cur] : null;
    }

    @Override
    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexeme + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.myLexTypes[cur] : null;
    }

    @Override
    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexeme + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[cur];
    }

    @Override
    public int rawTokenIndex() {
        return this.myCurrentLexeme;
    }

    @Override
    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback callback) {
        this.myWhitespaceSkippedCallback = callback;
    }

    @Override
    public void advanceLexer() {
        ProgressIndicatorProvider.checkCanceled();
        if (this.eof()) {
            return;
        }
        if (!this.myTokenTypeChecked) {
            LOG.error("Probably a bug: eating token without its type checking");
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexeme;
        this.clearCachedTokenType();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexeme < this.myLexemeCount && this.whitespaceOrComment(this.remapCurrentToken())) {
            this.onSkip(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myCurrentLexeme + 1 < this.myLexemeCount ? this.myLexStarts[this.myCurrentLexeme + 1] : this.myText.length());
            ++this.myCurrentLexeme;
            this.clearCachedTokenType();
        }
    }

    private void onSkip(IElementType type2, int start, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type2, start, end);
        }
    }

    @Override
    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[this.myCurrentLexeme];
    }

    @Override
    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type2 = this.getTokenType();
        if (type2 instanceof TokenWrapper) {
            return ((TokenWrapper)type2).getValue();
        }
        return this.myText.subSequence(this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1]).toString();
    }

    public boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    @Override
    @NotNull
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexeme);
        this.myProduction.addMarker(marker);
        StartMarker startMarker = marker;
        if (startMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "mark"));
        }
        return startMarker;
    }

    @NotNull
    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.myPool.allocateStartMarker();
        marker.myLexemeIndex = lexemeIndex;
        if (this.myDebugMode) {
            this.myOptionalData.notifyAllocated(marker.markerId);
        }
        StartMarker startMarker = marker;
        if (startMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createMarker"));
        }
        return startMarker;
    }

    @Override
    public final boolean eof() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            this.skipWhitespace();
        }
        return this.myCurrentLexeme >= this.myLexemeCount;
    }

    private void rollbackTo(@NotNull StartMarker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "rollbackTo"));
        }
        assert (marker.myLexemeIndex >= 0) : "Disposed marker passed to rollbackTo";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        this.myCurrentLexeme = marker.myLexemeIndex;
        this.myTokenTypeChecked = true;
        this.myProduction.rollbackTo(marker);
        this.clearCachedTokenType();
    }

    public boolean hasErrorsAfter(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "hasErrorsAfter"));
        }
        return this.myProduction.hasErrorsAfter((StartMarker)marker);
    }

    private void processDone(@NotNull StartMarker marker, @Nullable String errorMessage, @Nullable StartMarker before) {
        int doneLexeme;
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "processDone"));
        }
        this.doValidityChecks(marker, before);
        if (errorMessage != null) {
            this.myOptionalData.setErrorMessage(marker.markerId, errorMessage);
        }
        int n = doneLexeme = before == null ? this.myCurrentLexeme : before.myLexemeIndex;
        if (marker.myType.isLeftBound() && this.isEmpty(marker.myLexemeIndex, doneLexeme)) {
            marker.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        }
        marker.myDoneLexeme = doneLexeme;
        this.myProduction.addDone(marker, before);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            IElementType token = this.myLexTypes[i];
            if (this.whitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    private void doValidityChecks(@NotNull StartMarker marker, @Nullable StartMarker before) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "doValidityChecks"));
        }
        if (marker.isDone()) {
            LOG.error("Marker already done.");
        }
        if (this.myDebugMode) {
            this.myProduction.doHeavyChecksOnMarkerDone(marker, before);
        }
    }

    @Override
    public void error(String messageText) {
        ProductionMarker lastMarker = this.myProduction.getStartingMarkerAt(this.myProduction.size() - 1);
        if (lastMarker instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexeme) {
            return;
        }
        ErrorItem marker = this.myPool.allocateErrorItem();
        marker.myMessage = messageText;
        marker.myLexemeIndex = this.myCurrentLexeme;
        this.myProduction.addMarker(marker);
    }

    @Override
    @NotNull
    public ASTNode getTreeBuilt() {
        ASTNode aSTNode = this.buildTree();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "getTreeBuilt"));
        }
        return aSTNode;
    }

    @NotNull
    private ASTNode buildTree() {
        boolean isTooDeep;
        StartMarker rootMarker = this.prepareLightTree();
        boolean bl = isTooDeep = this.myFile != null && BlockSupport.isTooDeep(this.myFile.getOriginalFile());
        if (this.myOriginalTree != null && !isTooDeep) {
            DiffLog diffLog = this.merge(this.myOriginalTree, rootMarker, this.myLastCommittedText);
            throw new BlockSupport.ReparsedSuccessfullyException(diffLog);
        }
        TreeElement rootNode = this.createRootAST(rootMarker);
        this.bind(rootMarker, (CompositeElement)rootNode);
        if (isTooDeep && !(rootNode instanceof FileElement)) {
            TreeElement childNode = rootNode.getFirstChildNode();
            childNode.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        assert (rootNode.getTextLength() == this.myText.length()) : rootNode.getElementType();
        TreeElement treeElement = rootNode;
        if (treeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "buildTree"));
        }
        return treeElement;
    }

    @Override
    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        StartMarker rootMarker = this.prepareLightTree();
        MyTreeStructure myTreeStructure = new MyTreeStructure(rootMarker, this.myParentLightTree);
        if (myTreeStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "getLightTree"));
        }
        return myTreeStructure;
    }

    @NotNull
    private TreeElement createRootAST(@NotNull StartMarker rootMarker) {
        CompositeElement rootNode;
        if (rootMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootMarker", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createRootAST"));
        }
        IElementType type2 = rootMarker.getTokenType();
        CompositeElement compositeElement = rootNode = type2 instanceof ILazyParseableElementType ? ASTFactory.lazy((ILazyParseableElementType)type2, null) : PsiBuilderImpl.createComposite(rootMarker);
        if (this.myCharTable == null) {
            CharTable charTable = this.myCharTable = rootNode instanceof FileElement ? ((FileElement)rootNode).getCharTable() : new CharTableImpl();
        }
        if (!(rootNode instanceof FileElement)) {
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, this.myCharTable);
        }
        CompositeElement compositeElement2 = rootNode;
        if (compositeElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createRootAST"));
        }
        return compositeElement2;
    }

    @NotNull
    private DiffLog merge(@NotNull ASTNode oldRoot, @NotNull StartMarker newRoot, @NotNull CharSequence lastCommittedText) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "merge"));
        }
        if (newRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRoot", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "merge"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "merge"));
        }
        DiffLog diffLog = new DiffLog();
        ConvertFromTokensToASTBuilder builder = new ConvertFromTokensToASTBuilder(newRoot, diffLog);
        MyTreeStructure treeStructure = new MyTreeStructure(newRoot, null);
        MyComparator comparator = new MyComparator(this.getUserDataUnprotected(CUSTOM_COMPARATOR), treeStructure);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        BlockSupportImpl.diffTrees(oldRoot, builder, comparator, treeStructure, indicator == null ? new EmptyProgressIndicator() : indicator, lastCommittedText);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "merge"));
        }
        return diffLog2;
    }

    @NotNull
    private StartMarker prepareLightTree() {
        StartMarker rootMarker;
        if (this.myProduction.isEmpty()) {
            LOG.error("Parser produced no markers. Text:\n" + this.myText);
        }
        if ((rootMarker = (StartMarker)Objects.requireNonNull(this.myProduction.getStartingMarkerAt(0))).myFirstChild != null) {
            StartMarker startMarker = rootMarker;
            if (startMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "prepareLightTree"));
            }
            return startMarker;
        }
        this.myTokenTypeChecked = true;
        this.balanceWhiteSpaces();
        rootMarker.myNext = null;
        rootMarker.myParent = rootMarker.myFirstChild = (rootMarker.myLastChild = null);
        StartMarker curNode = rootMarker;
        Stack<StartMarker> nodes = ContainerUtil.newStack();
        nodes.push(rootMarker);
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        for (int i = 1; i < this.myProduction.size(); ++i) {
            ProductionMarker item = this.myProduction.getStartingMarkerAt(i);
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                marker.myParent = curNode;
                marker.myNext = null;
                marker.myFirstChild = (marker.myLastChild = null);
                curNode.addChild(marker);
                nodes.push(curNode);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof ErrorItem) {
                ((ErrorItem)item).myParent = curNode;
                int curToken = item.myLexemeIndex;
                if (curToken == lastErrorIndex) continue;
                lastErrorIndex = curToken;
                curNode.addChild(item);
                continue;
            }
            this.assertMarkersBalanced(this.myProduction.getDoneMarkerAt(i) == curNode, item);
            curNode = (StartMarker)nodes.pop();
            --curDepth;
        }
        if (this.myCurrentLexeme < this.myLexemeCount) {
            List<IElementType> missed = ContainerUtil.newArrayList(this.myLexTypes, this.myCurrentLexeme, this.myLexemeCount);
            LOG.error("Tokens " + missed + " were not inserted into the tree. " + (this.myFile != null ? this.myFile.getLanguage() + ", " : "") + "Text:\n" + this.myText);
        }
        if (rootMarker.getEndIndex() < this.myLexemeCount) {
            List<IElementType> missed = ContainerUtil.newArrayList(this.myLexTypes, rootMarker.getEndIndex(), this.myLexemeCount);
            LOG.error("Tokens " + missed + " are outside of root element \"" + rootMarker.myType + "\". Text:\n" + this.myText);
        }
        this.assertMarkersBalanced(curNode == rootMarker, curNode);
        this.checkTreeDepth(maxDepth, rootMarker.getTokenType() instanceof IFileElementType);
        this.clearCachedTokenType();
        StartMarker startMarker = rootMarker;
        if (startMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "prepareLightTree"));
        }
        return startMarker;
    }

    private void assertMarkersBalanced(boolean condition, @Nullable ProductionMarker marker) {
        if (condition) {
            return;
        }
        this.reportUnbalancedMarkers(marker);
    }

    private void reportUnbalancedMarkers(@Nullable ProductionMarker marker) {
        int index2 = marker != null ? marker.getStartIndex() + 1 : this.myLexStarts.length;
        String context = index2 < this.myLexStarts.length ? this.myText.subSequence(Math.max(0, this.myLexStarts[index2] - 1000), this.myLexStarts[index2]) : "<none>";
        String language = this.myFile != null ? this.myFile.getLanguage() + ", " : "";
        LOG.error("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem\nlanguage: " + language + "\ncontext: '" + context + "'");
    }

    private void balanceWhiteSpaces() {
        RelativeTokenTypesView wsTokens = new RelativeTokenTypesView();
        RelativeTokenTextView tokenTextGetter = new RelativeTokenTextView();
        int lastIndex = 0;
        int size = this.myProduction.size() - 1;
        for (int i = 1; i < size; ++i) {
            int wsEndIndex;
            int wsStartIndex;
            ProductionMarker starting = this.myProduction.getStartingMarkerAt(i);
            if (starting instanceof StartMarker) {
                this.assertMarkersBalanced(((StartMarker)starting).isDone(), starting);
            }
            boolean done2 = starting == null;
            ProductionMarker item = starting != null ? starting : (ProductionMarker)Objects.requireNonNull(this.myProduction.getDoneMarkerAt(i));
            WhitespacesAndCommentsBinder binder = item.getBinder(done2);
            int lexemeIndex = item.getLexemeIndex(done2);
            boolean recursive = binder instanceof WhitespacesAndCommentsBinder.RecursiveBinder;
            int prevProductionLexIndex = recursive ? 0 : this.myProduction.getLexemeIndexAt(i - 1);
            for (wsStartIndex = Math.max(lexemeIndex, lastIndex); wsStartIndex > prevProductionLexIndex && this.whitespaceOrComment(this.myLexTypes[wsStartIndex - 1]); --wsStartIndex) {
            }
            for (wsEndIndex = lexemeIndex; wsEndIndex < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[wsEndIndex]); ++wsEndIndex) {
            }
            if (wsStartIndex != wsEndIndex) {
                wsTokens.configure(wsStartIndex, wsEndIndex);
                tokenTextGetter.configure(wsStartIndex);
                boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
                lexemeIndex = wsStartIndex + binder.getEdgePosition(wsTokens, atEnd, tokenTextGetter);
                item.setLexemeIndex(lexemeIndex, done2);
                if (recursive) {
                    this.myProduction.confineMarkersToMaxLexeme(i, lexemeIndex);
                }
            } else if (lexemeIndex < wsStartIndex) {
                lexemeIndex = wsStartIndex;
                item.setLexemeIndex(wsStartIndex, done2);
            }
            lastIndex = lexemeIndex;
        }
    }

    private void checkTreeDepth(int maxDepth, boolean isFileRoot) {
        if (this.myFile == null) {
            return;
        }
        PsiFile file = this.myFile.getOriginalFile();
        Boolean flag = file.getUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED);
        if (maxDepth > BlockSupport.INCREMENTAL_REPARSE_DEPTH_LIMIT) {
            if (!Boolean.TRUE.equals(flag)) {
                file.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
            }
        } else if (isFileRoot && flag != null) {
            file.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, null);
        }
    }

    private void bind(@NotNull StartMarker rootMarker, @NotNull CompositeElement rootNode) {
        if (rootMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootMarker", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "bind"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "bind"));
        }
        StartMarker curMarker = rootMarker;
        CompositeElement curNode = rootNode;
        int lexIndex = rootMarker.myLexemeIndex;
        ProductionMarker item = rootMarker.myFirstChild != null ? rootMarker.myFirstChild : rootMarker;
        boolean itemDone = rootMarker.myFirstChild == null;
        while (true) {
            lexIndex = this.insertLeaves(lexIndex, item.getLexemeIndex(itemDone), curNode);
            if (item == rootMarker && itemDone) break;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                if (itemDone) {
                    curMarker = (StartMarker)marker.myParent;
                    curNode = curNode.getTreeParent();
                    item = marker.myNext;
                    itemDone = false;
                } else {
                    if (!this.myOptionalData.isCollapsed(marker.markerId)) {
                        curMarker = marker;
                        CompositeElement childNode = PsiBuilderImpl.createComposite(marker);
                        curNode.rawAddChildrenWithoutNotifications(childNode);
                        curNode = childNode;
                        item = marker.myFirstChild != null ? marker.myFirstChild : marker;
                        itemDone = marker.myFirstChild == null;
                        continue;
                    }
                    lexIndex = this.collapseLeaves(curNode, marker);
                    item = marker.myNext;
                    itemDone = false;
                }
            } else if (item instanceof ErrorItem) {
                CompositeElement errorElement = Factory.createErrorElement(((ErrorItem)item).myMessage);
                curNode.rawAddChildrenWithoutNotifications(errorElement);
                item = ((ErrorItem)item).myNext;
                itemDone = false;
            }
            if (item != null) continue;
            item = curMarker;
            itemDone = true;
        }
    }

    private int insertLeaves(int curToken, int lastIdx, CompositeElement curNode) {
        lastIdx = Math.min(lastIdx, this.myLexemeCount);
        while (curToken < lastIdx) {
            ProgressIndicatorProvider.checkCanceled();
            int start = this.myLexStarts[curToken];
            int end = this.myLexStarts[curToken + 1];
            if (start < end || this.myLexTypes[curToken] instanceof ILeafElementType) {
                IElementType type2 = this.myLexTypes[curToken];
                TreeElement leaf = this.createLeaf(type2, start, end);
                curNode.rawAddChildrenWithoutNotifications(leaf);
            }
            ++curToken;
        }
        return curToken;
    }

    private int collapseLeaves(@NotNull CompositeElement ast, @NotNull StartMarker startMarker) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "collapseLeaves"));
        }
        if (startMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startMarker", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "collapseLeaves"));
        }
        int start = this.myLexStarts[startMarker.myLexemeIndex];
        int end = this.myLexStarts[startMarker.getEndIndex()];
        IElementType markerType = startMarker.myType;
        TreeElement leaf = this.createLeaf(markerType, start, end);
        if (markerType instanceof ILazyParseableElementType && ((ILazyParseableElementType)markerType).reuseCollapsedTokens() && startMarker.myLexemeIndex < startMarker.getEndIndex()) {
            int length = startMarker.getEndIndex() - startMarker.myLexemeIndex;
            int[] relativeStarts = new int[length + 1];
            IElementType[] types = new IElementType[length + 1];
            for (int i = startMarker.myLexemeIndex; i < startMarker.getEndIndex(); ++i) {
                relativeStarts[i - startMarker.myLexemeIndex] = this.myLexStarts[i] - start;
                types[i - startMarker.myLexemeIndex] = this.myLexTypes[i];
            }
            relativeStarts[length] = end - start;
            leaf.putUserData(LAZY_PARSEABLE_TOKENS, new TokenSequence(relativeStarts, types, length));
        }
        ast.rawAddChildrenWithoutNotifications(leaf);
        return startMarker.getEndIndex();
    }

    @NotNull
    private static CompositeElement createComposite(@NotNull StartMarker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createComposite"));
        }
        IElementType type2 = marker.myType;
        if (type2 == TokenType.ERROR_ELEMENT) {
            CompositeElement compositeElement = Factory.createErrorElement(marker.myBuilder.myOptionalData.getDoneError(marker.markerId));
            if (compositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createComposite"));
            }
            return compositeElement;
        }
        if (type2 == null) {
            throw new RuntimeException("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem");
        }
        CompositeElement compositeElement = ASTFactory.composite(type2);
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createComposite"));
        }
        return compositeElement;
    }

    @Nullable
    public static String getErrorMessage(@NotNull LighterASTNode node) {
        StartMarker marker;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "getErrorMessage"));
        }
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker && (marker = (StartMarker)node).myType == TokenType.ERROR_ELEMENT) {
            return marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
        }
        return null;
    }

    @Override
    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    @NotNull
    public Lexer getLexer() {
        Lexer lexer = this.myLexer;
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "getLexer"));
        }
        return lexer;
    }

    @NotNull
    protected TreeElement createLeaf(@NotNull IElementType type2, int start, int end) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
        }
        CharSequence text2 = this.myCharTable.intern(this.myText, start, end);
        if (this.myWhitespaces.contains(type2)) {
            PsiWhiteSpaceImpl psiWhiteSpaceImpl = new PsiWhiteSpaceImpl(text2);
            if (psiWhiteSpaceImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
            }
            return psiWhiteSpaceImpl;
        }
        if (type2 instanceof ICustomParsingType) {
            TreeElement treeElement = (TreeElement)((ICustomParsingType)((Object)type2)).parse(text2, this.myCharTable);
            if (treeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
            }
            return treeElement;
        }
        if (type2 instanceof ILazyParseableElementType) {
            LazyParseableElement lazyParseableElement = ASTFactory.lazy((ILazyParseableElementType)type2, text2);
            if (lazyParseableElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
            }
            return lazyParseableElement;
        }
        LeafElement leafElement = ASTFactory.leaf(type2, text2);
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "createLeaf"));
        }
        return leafElement;
    }

    @Override
    public <T> T getUserDataUnprotected(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "getUserDataUnprotected"));
        }
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            return (T)this.myFile;
        }
        return (T)(this.myUserData != null ? this.myUserData.get(key) : null);
    }

    @Override
    public <T> void putUserDataUnprotected(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl", "putUserDataUnprotected"));
        }
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            this.myFile = (PsiFile)value;
            return;
        }
        if (this.myUserData == null) {
            this.myUserData = ContainerUtil.newHashMap();
        }
        this.myUserData.put(key, value);
    }

    private static class ASTConverter
    implements Convertor<Node, ASTNode> {
        @NotNull
        private final StartMarker myRoot;

        private ASTConverter(@NotNull StartMarker root2) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ASTConverter", "<init>"));
            }
            this.myRoot = root2;
        }

        @Override
        public ASTNode convert(Node n) {
            if (n instanceof Token) {
                Token token = (Token)n;
                return token.myBuilder.createLeaf(token.getTokenType(), token.myTokenStart, token.myTokenEnd);
            }
            if (n instanceof ErrorItem) {
                return Factory.createErrorElement(((ErrorItem)n).myMessage);
            }
            StartMarker startMarker = (StartMarker)n;
            CompositeElement composite = n == this.myRoot ? (CompositeElement)this.myRoot.myBuilder.createRootAST(this.myRoot) : PsiBuilderImpl.createComposite(startMarker);
            startMarker.myBuilder.bind(startMarker, composite);
            return composite;
        }
    }

    private static class MyTreeStructure
    implements FlyweightCapableTreeStructure<LighterASTNode> {
        private final LimitedPool<Token> myPool;
        private final LimitedPool<LazyParseableToken> myLazyPool;
        private final StartMarker myRoot;
        private int count;
        private LighterASTNode[] nodes;

        public MyTreeStructure(@NotNull StartMarker root2, @Nullable MyTreeStructure parentTree) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "<init>"));
            }
            if (parentTree == null) {
                this.myPool = new LimitedPool<Token>(1000, new LimitedPool.ObjectFactory<Token>(){

                    @Override
                    public void cleanup(@NotNull Token token) {
                        if (token == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$1", "cleanup"));
                        }
                        token.clean();
                    }

                    @Override
                    @NotNull
                    public Token create() {
                        TokenNode tokenNode = new TokenNode();
                        if (tokenNode == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$1", "create"));
                        }
                        return tokenNode;
                    }
                });
                this.myLazyPool = new LimitedPool<LazyParseableToken>(200, new LimitedPool.ObjectFactory<LazyParseableToken>(){

                    @Override
                    public void cleanup(@NotNull LazyParseableToken token) {
                        if (token == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$2", "cleanup"));
                        }
                        token.clean();
                    }

                    @Override
                    @NotNull
                    public LazyParseableToken create() {
                        LazyParseableToken lazyParseableToken = new LazyParseableToken();
                        if (lazyParseableToken == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure$2", "create"));
                        }
                        return lazyParseableToken;
                    }
                });
            } else {
                this.myPool = parentTree.myPool;
                this.myLazyPool = parentTree.myLazyPool;
            }
            this.myRoot = root2;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            StartMarker startMarker = this.myRoot;
            if (startMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getRoot"));
            }
            return startMarker;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getParent"));
            }
            if (node instanceof ProductionMarker) {
                return ((ProductionMarker)node).myParent;
            }
            if (node instanceof Token) {
                return ((Token)node).myParentNode;
            }
            throw new UnsupportedOperationException("Unknown node type: " + node);
        }

        @Override
        public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getChildren"));
            }
            if (into == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "into", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getChildren"));
            }
            if (item instanceof LazyParseableToken) {
                FlyweightCapableTreeStructure<LighterASTNode> tree = ((LazyParseableToken)item).parseContents();
                LighterASTNode root2 = tree.getRoot();
                if (root2 instanceof ProductionMarker) {
                    ((ProductionMarker)root2).myParent = ((Token)item).myParentNode;
                }
                return tree.getChildren(root2, into);
            }
            if (item instanceof Token || item instanceof ErrorItem) {
                return 0;
            }
            StartMarker marker = (StartMarker)item;
            this.count = 0;
            ProductionMarker child = marker.myFirstChild;
            int lexIndex = marker.myLexemeIndex;
            while (child != null) {
                lexIndex = this.insertLeaves(lexIndex, child.myLexemeIndex, marker.myBuilder, marker);
                if (child instanceof StartMarker && child.myBuilder.myOptionalData.isCollapsed(child.markerId)) {
                    int lastIndex = child.getEndIndex();
                    this.insertLeaf(child.getTokenType(), marker.myBuilder, child.myLexemeIndex, lastIndex, true, marker);
                } else {
                    this.ensureCapacity();
                    this.nodes[this.count++] = child;
                }
                if (child instanceof StartMarker) {
                    lexIndex = child.getEndIndex();
                }
                child = child.myNext;
            }
            this.insertLeaves(lexIndex, marker.getEndIndex(), marker.myBuilder, marker);
            into.set(this.nodes == null ? LighterASTNode.EMPTY_ARRAY : this.nodes);
            this.nodes = null;
            return this.count;
        }

        public void disposeChildren(LighterASTNode[] nodes, int count) {
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                LighterASTNode node = nodes[i];
                if (node instanceof LazyParseableToken) {
                    this.myLazyPool.recycle((LazyParseableToken)node);
                    continue;
                }
                if (!(node instanceof Token)) continue;
                this.myPool.recycle((Token)node);
            }
        }

        private void ensureCapacity() {
            LighterASTNode[] old = this.nodes;
            if (old == null) {
                this.nodes = old = new LighterASTNode[10];
            } else if (this.count >= old.length) {
                LighterASTNode[] newStore = new LighterASTNode[this.count * 3 / 2];
                System.arraycopy(old, 0, newStore, 0, this.count);
                this.nodes = newStore;
            }
        }

        private int insertLeaves(int curToken, int lastIdx, PsiBuilderImpl builder, StartMarker parent2) {
            lastIdx = Math.min(lastIdx, builder.myLexemeCount);
            while (curToken < lastIdx) {
                this.insertLeaf(builder.myLexTypes[curToken], builder, curToken, curToken + 1, false, parent2);
                ++curToken;
            }
            return curToken;
        }

        private void insertLeaf(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder, int startLexemeIndex, int endLexemeIndex, boolean forceInsertion, StartMarker parent2) {
            int end;
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "insertLeaf"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "insertLeaf"));
            }
            int start = builder.myLexStarts[startLexemeIndex];
            if (start > (end = builder.myLexStarts[endLexemeIndex]) || !forceInsertion && start == end && !(type2 instanceof ILeafElementType)) {
                return;
            }
            Token lexeme = this.obtainToken(type2, builder, startLexemeIndex, endLexemeIndex, parent2, start, end);
            this.ensureCapacity();
            this.nodes[this.count++] = lexeme;
        }

        @NotNull
        private Token obtainToken(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder, int startLexemeIndex, int endLexemeIndex, StartMarker parent2, int start, int end) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "obtainToken"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "obtainToken"));
            }
            if (type2 instanceof ILightLazyParseableElementType) {
                Token token = this.obtainLazyToken(type2, builder, startLexemeIndex, endLexemeIndex, parent2, start, end);
                if (token == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "obtainToken"));
                }
                return token;
            }
            Token lexeme = this.myPool.alloc();
            lexeme.initToken(type2, builder, parent2, start, end);
            Token token = lexeme;
            if (token == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "obtainToken"));
            }
            return token;
        }

        @NotNull
        private Token obtainLazyToken(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder, int startLexemeIndex, int endLexemeIndex, StartMarker parent2, int start, int end) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "obtainLazyToken"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "obtainLazyToken"));
            }
            int startInFile = start + builder.myOffset;
            LazyParseableToken token = (LazyParseableToken)builder.myChameleonCache.get(startInFile);
            if (token == null) {
                token = this.myLazyPool.alloc();
                token.myStartIndex = startLexemeIndex;
                token.myEndIndex = endLexemeIndex;
                token.initToken(type2, builder, parent2, start, end);
                builder.myChameleonCache.put(startInFile, token);
            } else if (token.myBuilder != builder || token.myStartIndex != startLexemeIndex || token.myEndIndex != endLexemeIndex) {
                throw new AssertionError((Object)"Wrong chameleon cached");
            }
            token.myParentStructure = this;
            LazyParseableToken lazyParseableToken = token;
            if (lazyParseableToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "obtainLazyToken"));
            }
            return lazyParseableToken;
        }

        @Override
        @NotNull
        public CharSequence toString(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "toString"));
            }
            CharSequence charSequence = this.myRoot.myBuilder.myText.subSequence(node.getStartOffset(), node.getEndOffset());
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "toString"));
            }
            return charSequence;
        }

        @Override
        public int getStartOffset(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getStartOffset"));
            }
            return node.getStartOffset();
        }

        @Override
        public int getEndOffset(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure", "getEndOffset"));
            }
            return node.getEndOffset();
        }
    }

    private static class MyComparator
    implements ShallowNodeComparator<ASTNode, LighterASTNode> {
        private final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom;
        private final MyTreeStructure myTreeStructure;

        private MyComparator(TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom, @NotNull MyTreeStructure treeStructure) {
            if (treeStructure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "<init>"));
            }
            this.custom = custom;
            this.myTreeStructure = treeStructure;
        }

        @Override
        @NotNull
        public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            ThreeState customResult;
            boolean newIsErrorElement;
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
            }
            ProgressIndicatorProvider.checkCanceled();
            boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
            boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
            if (oldIsErrorElement != newIsErrorElement) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                }
                return threeState;
            }
            if (oldIsErrorElement) {
                PsiErrorElement e1 = (PsiErrorElement)((Object)oldNode);
                ThreeState threeState = Comparing.equal(e1.getErrorDescription(), PsiBuilderImpl.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                }
                return threeState;
            }
            if (this.custom != null && (customResult = this.custom.fun(oldNode, newNode, this.myTreeStructure)) != ThreeState.UNSURE) {
                ThreeState threeState = customResult;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                }
                return threeState;
            }
            if (newNode instanceof Token) {
                IElementType type2 = newNode.getTokenType();
                Token token = (Token)newNode;
                if (oldNode instanceof ForeignLeafPsiElement) {
                    ThreeState threeState = type2 instanceof ForeignLeafType && ((ForeignLeafType)type2).getValue().equals(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                    }
                    return threeState;
                }
                if (oldNode instanceof LeafElement) {
                    if (type2 instanceof ForeignLeafType) {
                        ThreeState threeState = ThreeState.NO;
                        if (threeState == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                        }
                        return threeState;
                    }
                    ThreeState threeState = ((LeafElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                    }
                    return threeState;
                }
                if (type2 instanceof ILightLazyParseableElementType) {
                    ThreeState threeState = ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : (TreeUtil.isCollapsedChameleon(oldNode) ? ThreeState.NO : ThreeState.UNSURE);
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                    }
                    return threeState;
                }
                if (oldNode.getElementType() instanceof ILazyParseableElementType && type2 instanceof ILazyParseableElementType || oldNode.getElementType() instanceof ICustomParsingType && type2 instanceof ICustomParsingType) {
                    ThreeState threeState = ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
                    }
                    return threeState;
                }
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "deepEqual"));
            }
            return threeState;
        }

        @Override
        public boolean typesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            IElementType n2t;
            IElementType n1t;
            if (n1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n1", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "typesEqual"));
            }
            if (n2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n2", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "typesEqual"));
            }
            if (n1 instanceof PsiWhiteSpaceImpl) {
                return ourAnyLanguageWhitespaceTokens.contains(n2.getTokenType()) || n2 instanceof Token && ((Token)n2).myBuilder.myWhitespaces.contains(n2.getTokenType());
            }
            if (n1 instanceof ForeignLeafPsiElement) {
                n1t = ((ForeignLeafPsiElement)n1).getForeignType();
                n2t = n2.getTokenType();
            } else {
                n1t = MyComparator.dereferenceToken(n1.getElementType());
                n2t = MyComparator.dereferenceToken(n2.getTokenType());
            }
            return Comparing.equal(n1t, n2t);
        }

        private static IElementType dereferenceToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return MyComparator.dereferenceToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        @Override
        public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            PsiErrorElement e1;
            if (n1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n1", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "hashCodesEqual"));
            }
            if (n2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n2", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$MyComparator", "hashCodesEqual"));
            }
            if (n1 instanceof LeafElement && n2 instanceof Token) {
                boolean isForeign1 = n1 instanceof ForeignLeafPsiElement;
                boolean isForeign2 = n2.getTokenType() instanceof ForeignLeafType;
                if (isForeign1 != isForeign2) {
                    return false;
                }
                if (isForeign1) {
                    return n1.getText().equals(((ForeignLeafType)n2.getTokenType()).getValue());
                }
                return ((LeafElement)n1).textMatches(((Token)n2).getText());
            }
            if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Comparing.equal((e1 = (PsiErrorElement)((Object)n1)).getErrorDescription(), PsiBuilderImpl.getErrorMessage(n2))) {
                return false;
            }
            return ((TreeElement)n1).hc() == ((Node)n2).hc();
        }
    }

    private final class RelativeTokenTextView
    implements WhitespacesAndCommentsBinder.TokenTextGetter {
        private int myStart;

        private RelativeTokenTextView() {
        }

        private void configure(int start) {
            this.myStart = start;
        }

        @Override
        @NotNull
        public CharSequence get(int i) {
            CharSequence charSequence = PsiBuilderImpl.this.myText.subSequence(PsiBuilderImpl.this.myLexStarts[this.myStart + i], PsiBuilderImpl.this.myLexStarts[this.myStart + i + 1]);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$RelativeTokenTextView", "get"));
            }
            return charSequence;
        }
    }

    private final class RelativeTokenTypesView
    extends AbstractList<IElementType> {
        private int myStart;
        private int mySize;

        private RelativeTokenTypesView() {
        }

        private void configure(int start, int end) {
            this.myStart = start;
            this.mySize = end - start;
        }

        @Override
        public IElementType get(int index2) {
            return PsiBuilderImpl.this.myLexTypes[this.myStart + index2];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private static class ConvertFromTokensToASTBuilder
    implements DiffTreeChangeBuilder<ASTNode, LighterASTNode> {
        private final DiffTreeChangeBuilder<ASTNode, ASTNode> myDelegate;
        private final ASTConverter myConverter;

        private ConvertFromTokensToASTBuilder(@NotNull StartMarker rootNode, @NotNull DiffTreeChangeBuilder<ASTNode, ASTNode> delegate2) {
            if (rootNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "<init>"));
            }
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "<init>"));
            }
            this.myDelegate = delegate2;
            this.myConverter = new ASTConverter(rootNode);
        }

        @Override
        public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeDeleted"));
            }
            if (oldNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeDeleted"));
            }
            this.myDelegate.nodeDeleted(oldParent, oldNode);
        }

        @Override
        public void nodeInserted(@NotNull ASTNode oldParent, @NotNull LighterASTNode newNode, int pos) {
            if (oldParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeInserted"));
            }
            if (newNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeInserted"));
            }
            this.myDelegate.nodeInserted(oldParent, this.myConverter.convert((Node)newNode), pos);
        }

        @Override
        public void nodeReplaced(@NotNull ASTNode oldChild, @NotNull LighterASTNode newChild) {
            if (oldChild == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldChild", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeReplaced"));
            }
            if (newChild == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder", "nodeReplaced"));
            }
            ASTNode converted = this.myConverter.convert((Node)newChild);
            this.myDelegate.nodeReplaced(oldChild, converted);
        }
    }

    static class ErrorItem
    extends ProductionMarker {
        private String myMessage;

        ErrorItem(int markerId, PsiBuilderImpl builder) {
            super(markerId, builder);
        }

        @Override
        void clean() {
            super.clean();
            this.myMessage = null;
        }

        @Override
        @NotNull
        public WhitespacesAndCommentsBinder getBinder(boolean done2) {
            assert (!done2);
            WhitespacesAndCommentsBinder whitespacesAndCommentsBinder = WhitespacesBinders.DEFAULT_RIGHT_BINDER;
            if (whitespacesAndCommentsBinder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ErrorItem", "getBinder"));
            }
            return whitespacesAndCommentsBinder;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done2) {
            assert (!done2);
            this.myLexemeIndex = lexemeIndex;
        }

        @Override
        int getLexemeIndex(boolean done2) {
            assert (!done2);
            return this.myLexemeIndex;
        }

        @Override
        public int hc() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = TokenType.ERROR_ELEMENT;
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ErrorItem", "getTokenType"));
            }
            return iElementType;
        }
    }

    private static class LazyParseableToken
    extends Token
    implements LighterLazyParseableNode {
        private MyTreeStructure myParentStructure;
        private FlyweightCapableTreeStructure<LighterASTNode> myParsed;
        private int myStartIndex;
        private int myEndIndex;

        private LazyParseableToken() {
        }

        @Override
        public void clean() {
            this.myBuilder.myChameleonCache.remove(this.getStartOffset());
            super.clean();
            this.myParentStructure = null;
            this.myParsed = null;
        }

        @Override
        public PsiFile getContainingFile() {
            return this.myBuilder.myFile;
        }

        @Override
        public CharTable getCharTable() {
            return this.myBuilder.myCharTable;
        }

        public FlyweightCapableTreeStructure<LighterASTNode> parseContents() {
            if (this.myParsed == null) {
                this.myParsed = ((ILightLazyParseableElementType)((Object)this.getTokenType())).parseContents(this);
            }
            return this.myParsed;
        }

        @Override
        public boolean accept(@NotNull LighterLazyParseableNode.Visitor visitor2) {
            if (visitor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$LazyParseableToken", "accept"));
            }
            for (int i = this.myStartIndex; i < this.myEndIndex; ++i) {
                IElementType type2 = this.myBuilder.myLexTypes[i];
                if (visitor2.visit(type2)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private TokenSequence getParsedTokenSequence() {
            int tokenCount = this.myEndIndex - this.myStartIndex;
            if (tokenCount == 1) {
                return null;
            }
            int[] lexStarts = new int[tokenCount + 1];
            System.arraycopy(this.myBuilder.myLexStarts, this.myStartIndex, lexStarts, 0, tokenCount);
            int diff = this.myBuilder.myLexStarts[this.myStartIndex];
            int i = 0;
            while (i < tokenCount) {
                int n = i++;
                lexStarts[n] = lexStarts[n] - diff;
            }
            lexStarts[tokenCount] = this.getEndOffset() - this.getStartOffset();
            IElementType[] lexTypes = new IElementType[tokenCount + 1];
            System.arraycopy(this.myBuilder.myLexTypes, this.myStartIndex, lexTypes, 0, tokenCount);
            return new TokenSequence(lexStarts, lexTypes, tokenCount);
        }
    }

    private static class TokenNode
    extends Token
    implements LighterASTTokenNode {
        private TokenNode() {
        }

        public String toString() {
            return this.getText().toString();
        }
    }

    private static abstract class Token
    implements Node {
        protected PsiBuilderImpl myBuilder;
        private IElementType myTokenType;
        private int myTokenStart;
        private int myTokenEnd;
        private int myHC = -1;
        private StartMarker myParentNode;

        private Token() {
        }

        public void clean() {
            this.myBuilder = null;
            this.myHC = -1;
            this.myParentNode = null;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                int hc = 0;
                if (this.myTokenType instanceof TokenWrapper) {
                    String value = ((TokenWrapper)this.myTokenType).getValue();
                    for (int i = 0; i < value.length(); ++i) {
                        hc += value.charAt(i);
                    }
                } else {
                    int start = this.myTokenStart;
                    int end = this.myTokenEnd;
                    CharSequence buf = this.myBuilder.myText;
                    char[] bufArray = this.myBuilder.myTextArray;
                    for (int i = start; i < end; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        @Override
        public int getEndOffset() {
            return this.myTokenEnd + this.myBuilder.myOffset;
        }

        @Override
        public int getStartOffset() {
            return this.myTokenStart + this.myBuilder.myOffset;
        }

        @NotNull
        public CharSequence getText() {
            if (this.myTokenType instanceof TokenWrapper) {
                String string = ((TokenWrapper)this.myTokenType).getValue();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$Token", "getText"));
                }
                return string;
            }
            CharSequence charSequence = this.myBuilder.myText.subSequence(this.myTokenStart, this.myTokenEnd);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$Token", "getText"));
            }
            return charSequence;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = this.myTokenType;
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$Token", "getTokenType"));
            }
            return iElementType;
        }

        void initToken(@NotNull IElementType type2, @NotNull PsiBuilderImpl builder, StartMarker parent2, int start, int end) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$Token", "initToken"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$Token", "initToken"));
            }
            this.myParentNode = parent2;
            this.myBuilder = builder;
            this.myTokenType = type2;
            this.myTokenStart = start;
            this.myTokenEnd = end;
        }
    }

    static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        private IElementType myType;
        private int myDoneLexeme = -1;
        private ProductionMarker myFirstChild;
        private ProductionMarker myLastChild;
        private int myHC = -1;

        StartMarker(int markerId, PsiBuilderImpl builder) {
            super(markerId, builder);
        }

        @Override
        void clean() {
            super.clean();
            this.myBuilder.myOptionalData.clean(this.markerId);
            this.myType = null;
            this.myDoneLexeme = -1;
            this.myLastChild = null;
            this.myFirstChild = null;
            this.myHC = -1;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                PsiBuilderImpl builder = this.myBuilder;
                int hc = 0;
                CharSequence buf = builder.myText;
                char[] bufArray = builder.myTextArray;
                ProductionMarker child = this.myFirstChild;
                int lexIdx = this.myLexemeIndex;
                while (child != null) {
                    int lastLeaf = child.myLexemeIndex;
                    for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[lastLeaf]; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                    lexIdx = lastLeaf;
                    hc += child.hc();
                    if (child instanceof StartMarker) {
                        lexIdx = child.getEndIndex();
                    }
                    child = child.myNext;
                }
                for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[this.getEndIndex()]; ++i) {
                    hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.getEndIndex()] + this.myBuilder.myOffset;
        }

        @Override
        public int getEndIndex() {
            return this.myDoneLexeme;
        }

        @Override
        @NotNull
        WhitespacesAndCommentsBinder getBinder(boolean done2) {
            WhitespacesAndCommentsBinder whitespacesAndCommentsBinder = this.myBuilder.myOptionalData.getBinder(this.markerId, done2);
            if (whitespacesAndCommentsBinder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "getBinder"));
            }
            return whitespacesAndCommentsBinder;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done2) {
            if (done2) {
                this.myDoneLexeme = lexemeIndex;
            } else {
                this.myLexemeIndex = lexemeIndex;
            }
        }

        @Override
        int getLexemeIndex(boolean done2) {
            return done2 ? this.myDoneLexeme : this.myLexemeIndex;
        }

        public void addChild(@NotNull ProductionMarker node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "addChild"));
            }
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
                this.myLastChild = node;
            } else {
                this.myLastChild.myNext = node;
                this.myLastChild = node;
            }
        }

        @Override
        @NotNull
        public PsiBuilder.Marker precede() {
            PsiBuilder.Marker marker = this.myBuilder.precede(this);
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "precede"));
            }
            return marker;
        }

        @Override
        public void drop() {
            this.myBuilder.myProduction.dropMarker(this);
        }

        @Override
        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        @Override
        public void done(@NotNull IElementType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "done"));
            }
            this.myType = type2;
            this.myBuilder.processDone(this, null, null);
        }

        @Override
        public void collapse(@NotNull IElementType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "collapse"));
            }
            this.done(type2);
            this.myBuilder.myOptionalData.markCollapsed(this.markerId);
        }

        @Override
        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "doneBefore"));
            }
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "doneBefore"));
            }
            this.myType = type2;
            this.myBuilder.processDone(this, null, (StartMarker)before);
        }

        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before, String errorMessage) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "doneBefore"));
            }
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "doneBefore"));
            }
            StartMarker marker = (StartMarker)before;
            ErrorItem errorItem = this.myBuilder.myPool.allocateErrorItem();
            errorItem.myMessage = errorMessage;
            errorItem.myLexemeIndex = marker.myLexemeIndex;
            this.myBuilder.myProduction.addBefore(errorItem, marker);
            this.doneBefore(type2, before);
        }

        @Override
        public void error(String message) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, null);
        }

        @Override
        public void errorBefore(String message, @NotNull PsiBuilder.Marker before) {
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "errorBefore"));
            }
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, (StartMarker)before);
        }

        @Override
        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void remapTokenType(@NotNull IElementType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$StartMarker", "remapTokenType"));
            }
            this.myType = type2;
        }

        @Override
        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, left, false);
            }
            if (right != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, right, true);
            }
        }

        public String toString() {
            if (this.myBuilder == null) {
                return "<dropped>";
            }
            boolean isDone = this.isDone();
            CharSequence originalText = this.myBuilder.getOriginalText();
            int startOffset = this.getStartOffset() - this.myBuilder.myOffset;
            int endOffset = isDone ? this.getEndOffset() - this.myBuilder.myOffset : this.myBuilder.getCurrentOffset();
            CharSequence text2 = originalText.subSequence(startOffset, endOffset);
            return isDone ? text2.toString() : text2 + "\u2026";
        }

        boolean isDone() {
            return this.myDoneLexeme != -1;
        }
    }

    public static abstract class ProductionMarker
    implements Node {
        final int markerId;
        protected final PsiBuilderImpl myBuilder;
        protected int myLexemeIndex = -1;
        protected ProductionMarker myParent;
        protected ProductionMarker myNext;

        ProductionMarker(int markerId, PsiBuilderImpl builder) {
            this.markerId = markerId;
            this.myBuilder = builder;
        }

        void clean() {
            this.myLexemeIndex = -1;
            this.myNext = null;
            this.myParent = null;
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        public void remapTokenType(@NotNull IElementType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderImpl$ProductionMarker", "remapTokenType"));
            }
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public int getStartIndex() {
            return this.myLexemeIndex;
        }

        public int getEndIndex() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @NotNull
        abstract WhitespacesAndCommentsBinder getBinder(boolean var1);

        abstract void setLexemeIndex(int var1, boolean var2);

        abstract int getLexemeIndex(boolean var1);
    }

    private static interface Node
    extends LighterASTNode {
        public int hc();
    }
}

