/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

public class CallMaker {
    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(0);
        }
        if (calleeExpression == null) {
            CallMaker.$$$reportNull$$$0(1);
        }
        if (argumentExpressions == null) {
            CallMaker.$$$reportNull$$$0(2);
        }
        Call call2 = CallMaker.makeCallWithExpressions(callElement, explicitReceiver, callOperationNode, calleeExpression, argumentExpressions, Call.CallType.DEFAULT);
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(3);
        }
        return call2;
    }

    @NotNull
    public static Call makeCallWithExpressions(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtExpression calleeExpression, @NotNull List<KtExpression> argumentExpressions, @NotNull Call.CallType callType) {
        List arguments2;
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(4);
        }
        if (calleeExpression == null) {
            CallMaker.$$$reportNull$$$0(5);
        }
        if (argumentExpressions == null) {
            CallMaker.$$$reportNull$$$0(6);
        }
        if (callType == null) {
            CallMaker.$$$reportNull$$$0(7);
        }
        if (argumentExpressions.isEmpty()) {
            arguments2 = Collections.emptyList();
        } else {
            arguments2 = new ArrayList(argumentExpressions.size());
            for (KtExpression argumentExpression : argumentExpressions) {
                arguments2.add(CallMaker.makeValueArgument(argumentExpression, calleeExpression));
            }
        }
        Call call2 = CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, callType);
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(8);
        }
        return call2;
    }

    @NotNull
    public static Call makeCall(KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, KtExpression calleeExpression, List<? extends ValueArgument> arguments2) {
        Call call2 = CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, Call.CallType.DEFAULT);
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(9);
        }
        return call2;
    }

    @NotNull
    public static Call makeCall(KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, KtExpression calleeExpression, List<? extends ValueArgument> arguments2, Call.CallType callType) {
        CallImpl callImpl = new CallImpl(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments2, callType);
        if (callImpl == null) {
            CallMaker.$$$reportNull$$$0(10);
        }
        return callImpl;
    }

    @NotNull
    public static Call makeCall(@NotNull ReceiverValue leftAsReceiver, KtBinaryExpression expression2) {
        if (leftAsReceiver == null) {
            CallMaker.$$$reportNull$$$0(11);
        }
        Call call2 = CallMaker.makeCallWithExpressions(expression2, leftAsReceiver, null, expression2.getOperationReference(), Collections.singletonList(expression2.getRight()));
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(12);
        }
        return call2;
    }

    @NotNull
    public static Call makeCall(@NotNull ReceiverValue baseAsReceiver, KtUnaryExpression expression2) {
        if (baseAsReceiver == null) {
            CallMaker.$$$reportNull$$$0(13);
        }
        Call call2 = CallMaker.makeCall(expression2, baseAsReceiver, null, expression2.getOperationReference(), Collections.emptyList());
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(14);
        }
        return call2;
    }

    @NotNull
    public static Call makeArraySetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull Call.CallType callType) {
        if (arrayAsReceiver == null) {
            CallMaker.$$$reportNull$$$0(15);
        }
        if (arrayAccessExpression == null) {
            CallMaker.$$$reportNull$$$0(16);
        }
        if (rightHandSide == null) {
            CallMaker.$$$reportNull$$$0(17);
        }
        if (callType == null) {
            CallMaker.$$$reportNull$$$0(18);
        }
        ArrayList<KtExpression> arguments2 = Lists.newArrayList(arrayAccessExpression.getIndexExpressions());
        arguments2.add(rightHandSide);
        Call call2 = CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arguments2, callType);
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(19);
        }
        return call2;
    }

    @NotNull
    public static Call makeArrayGetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull Call.CallType callType) {
        if (arrayAsReceiver == null) {
            CallMaker.$$$reportNull$$$0(20);
        }
        if (arrayAccessExpression == null) {
            CallMaker.$$$reportNull$$$0(21);
        }
        if (callType == null) {
            CallMaker.$$$reportNull$$$0(22);
        }
        Call call2 = CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arrayAccessExpression.getIndexExpressions(), callType);
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(23);
        }
        return call2;
    }

    public static Call makeCallForCollectionLiteral(@NotNull KtCollectionLiteralExpression collectionLiteralExpression) {
        if (collectionLiteralExpression == null) {
            CallMaker.$$$reportNull$$$0(24);
        }
        return CallMaker.makeCallWithExpressions(collectionLiteralExpression, null, null, collectionLiteralExpression, collectionLiteralExpression.getInnerExpressions(), Call.CallType.DEFAULT);
    }

    @NotNull
    public static ValueArgument makeValueArgument(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            CallMaker.$$$reportNull$$$0(25);
        }
        ValueArgument valueArgument = CallMaker.makeValueArgument(expression2, expression2);
        if (valueArgument == null) {
            CallMaker.$$$reportNull$$$0(26);
        }
        return valueArgument;
    }

    @NotNull
    public static ValueArgument makeValueArgument(@Nullable KtExpression expression2, @NotNull KtElement reportErrorsOn) {
        if (reportErrorsOn == null) {
            CallMaker.$$$reportNull$$$0(27);
        }
        ExpressionValueArgument expressionValueArgument = new ExpressionValueArgument(expression2, reportErrorsOn, false);
        if (expressionValueArgument == null) {
            CallMaker.$$$reportNull$$$0(28);
        }
        return expressionValueArgument;
    }

    @NotNull
    public static ValueArgument makeExternalValueArgument(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            CallMaker.$$$reportNull$$$0(29);
        }
        ExpressionValueArgument expressionValueArgument = new ExpressionValueArgument(expression2, expression2, true);
        if (expressionValueArgument == null) {
            CallMaker.$$$reportNull$$$0(30);
        }
        return expressionValueArgument;
    }

    @NotNull
    public static Call makePropertyCall(@Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull KtSimpleNameExpression nameExpression) {
        if (nameExpression == null) {
            CallMaker.$$$reportNull$$$0(31);
        }
        Call call2 = CallMaker.makeCallWithExpressions(nameExpression, explicitReceiver, callOperationNode, nameExpression, Collections.emptyList());
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(32);
        }
        return call2;
    }

    @NotNull
    public static Call makeConstructorCallWithoutTypeArguments(@NotNull KtCallElement callElement) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(33);
        }
        DelegatingCall delegatingCall = new DelegatingCall(CallMaker.makeCall(null, null, callElement)){

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list2 = Collections.emptyList();
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/CallMaker$1", "getTypeArguments"));
            }
        };
        if (delegatingCall == null) {
            CallMaker.$$$reportNull$$$0(34);
        }
        return delegatingCall;
    }

    @NotNull
    public static Call makeConstructorCallForEnumEntryWithoutInitializer(final @NotNull KtSuperTypeCallEntry callElement) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(35);
        }
        Call call2 = new Call(){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return null;
            }

            @Override
            @Nullable
            public Receiver getExplicitReceiver() {
                return null;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List<? extends ValueArgument> list2 = callElement.getValueArguments();
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public List<? extends LambdaArgument> getFunctionLiteralArguments() {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list2;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list2 = Collections.emptyList();
                if (list2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtSuperTypeCallEntry ktSuperTypeCallEntry = callElement;
                if (ktSuperTypeCallEntry == null) {
                    2.$$$reportNull$$$0(3);
                }
                return ktSuperTypeCallEntry;
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    2.$$$reportNull$$$0(4);
                }
                return callType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionLiteralArguments";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeArguments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(36);
        }
        return call2;
    }

    @NotNull
    public static Call makeCall(final @Nullable Receiver explicitReceiver, final @Nullable ASTNode callOperationNode, final @NotNull KtCallElement callElement) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(37);
        }
        Call call2 = new Call(){

            @Override
            public ASTNode getCallOperationNode() {
                return callOperationNode;
            }

            @Override
            @Nullable
            public Receiver getExplicitReceiver() {
                return explicitReceiver;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List<? extends ValueArgument> list2 = callElement.getValueArguments();
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public List<? extends LambdaArgument> getFunctionLiteralArguments() {
                List<KtLambdaArgument> list2 = callElement.getLambdaArguments();
                if (list2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return list2;
            }

            @Override
            @NotNull
            public List<KtTypeProjection> getTypeArguments() {
                List<KtTypeProjection> list2 = callElement.getTypeArguments();
                if (list2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @Override
            @Nullable
            public KtTypeArgumentList getTypeArgumentList() {
                return callElement.getTypeArgumentList();
            }

            @Override
            @NotNull
            public KtElement getCallElement() {
                KtCallElement ktCallElement = callElement;
                if (ktCallElement == null) {
                    3.$$$reportNull$$$0(3);
                }
                return ktCallElement;
            }

            public String toString() {
                return DebugTextUtilKt.getDebugText(callElement);
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    3.$$$reportNull$$$0(4);
                }
                return callType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionLiteralArguments";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeArguments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCallType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (call2 == null) {
            CallMaker.$$$reportNull$$$0(38);
        }
        return call2;
    }

    @NotNull
    public static Call makeCall(@NotNull KtElement callElement, @NotNull ReceiverValue explicitReceiver) {
        if (callElement == null) {
            CallMaker.$$$reportNull$$$0(39);
        }
        if (explicitReceiver == null) {
            CallMaker.$$$reportNull$$$0(40);
        }
        CallImpl callImpl = new CallImpl(callElement, explicitReceiver, null, null, Collections.emptyList());
        if (callImpl == null) {
            CallMaker.$$$reportNull$$$0(41);
        }
        return callImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeExpression";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentExpressions";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker";
                break;
            }
            case 7: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftAsReceiver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseAsReceiver";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAsReceiver";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightHandSide";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionLiteralExpression";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportErrorsOn";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExpression";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makeCallWithExpressions";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "makeCall";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "makeArraySetCall";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "makeArrayGetCall";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "makeValueArgument";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "makeExternalValueArgument";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "makePropertyCall";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "makeConstructorCallWithoutTypeArguments";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "makeConstructorCallForEnumEntryWithoutInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeCallWithExpressions";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                break;
            }
            case 11: 
            case 13: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "makeCall";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "makeArraySetCall";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "makeArrayGetCall";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "makeCallForCollectionLiteral";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "makeValueArgument";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "makeExternalValueArgument";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "makePropertyCall";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "makeConstructorCallWithoutTypeArguments";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "makeConstructorCallForEnumEntryWithoutInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CallImpl
    implements Call {
        private final KtElement callElement;
        private final Receiver explicitReceiver;
        private final ASTNode callOperationNode;
        private final KtExpression calleeExpression;
        private final List<? extends ValueArgument> valueArguments;
        private final Call.CallType callType;

        protected CallImpl(@NotNull KtElement callElement, @NotNull Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @Nullable KtExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments2) {
            if (callElement == null) {
                CallImpl.$$$reportNull$$$0(0);
            }
            if (explicitReceiver == null) {
                CallImpl.$$$reportNull$$$0(1);
            }
            if (valueArguments2 == null) {
                CallImpl.$$$reportNull$$$0(2);
            }
            this(callElement, explicitReceiver, callOperationNode, calleeExpression, valueArguments2, Call.CallType.DEFAULT);
        }

        protected CallImpl(@NotNull KtElement callElement, @Nullable Receiver explicitReceiver, @Nullable ASTNode callOperationNode, @Nullable KtExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments2, @NotNull Call.CallType callType) {
            if (callElement == null) {
                CallImpl.$$$reportNull$$$0(3);
            }
            if (valueArguments2 == null) {
                CallImpl.$$$reportNull$$$0(4);
            }
            if (callType == null) {
                CallImpl.$$$reportNull$$$0(5);
            }
            this.callElement = callElement;
            this.explicitReceiver = explicitReceiver;
            this.callOperationNode = callOperationNode;
            this.calleeExpression = calleeExpression;
            this.valueArguments = valueArguments2;
            this.callType = callType;
        }

        @Override
        public ASTNode getCallOperationNode() {
            return this.callOperationNode;
        }

        @Override
        @Nullable
        public Receiver getExplicitReceiver() {
            return this.explicitReceiver;
        }

        @Override
        @Nullable
        public ReceiverValue getDispatchReceiver() {
            return null;
        }

        @Override
        public KtExpression getCalleeExpression() {
            return this.calleeExpression;
        }

        @Override
        @NotNull
        public List<? extends ValueArgument> getValueArguments() {
            List<? extends ValueArgument> list2 = this.valueArguments;
            if (list2 == null) {
                CallImpl.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @Override
        @NotNull
        public KtElement getCallElement() {
            KtElement ktElement = this.callElement;
            if (ktElement == null) {
                CallImpl.$$$reportNull$$$0(7);
            }
            return ktElement;
        }

        @Override
        public KtValueArgumentList getValueArgumentList() {
            return null;
        }

        @NotNull
        public List<LambdaArgument> getFunctionLiteralArguments() {
            List<LambdaArgument> list2 = Collections.emptyList();
            if (list2 == null) {
                CallImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<KtTypeProjection> getTypeArguments() {
            List<KtTypeProjection> list2 = Collections.emptyList();
            if (list2 == null) {
                CallImpl.$$$reportNull$$$0(9);
            }
            return list2;
        }

        @Override
        public KtTypeArgumentList getTypeArgumentList() {
            return null;
        }

        public String toString() {
            return this.getCallElement().getText();
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = this.callType;
            if (callType == null) {
                CallImpl.$$$reportNull$$$0(10);
            }
            return callType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "explicitReceiver";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueArguments";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callType";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$CallImpl";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueArguments";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallElement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionLiteralArguments";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExpressionValueArgument
    implements ValueArgument {
        private final KtExpression expression;
        private final KtElement reportErrorsOn;
        private final boolean isExternal;

        private ExpressionValueArgument(@Nullable KtExpression expression2, @NotNull KtElement reportErrorsOn, boolean isExternal) {
            if (reportErrorsOn == null) {
                ExpressionValueArgument.$$$reportNull$$$0(0);
            }
            this.expression = expression2;
            this.reportErrorsOn = expression2 == null ? reportErrorsOn : expression2;
            this.isExternal = isExternal;
        }

        @Override
        public boolean isExternal() {
            return this.isExternal;
        }

        @Override
        public KtExpression getArgumentExpression() {
            return this.expression;
        }

        @Override
        public ValueArgumentName getArgumentName() {
            return null;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        @NotNull
        public KtElement asElement() {
            KtElement ktElement = this.reportErrorsOn;
            if (ktElement == null) {
                ExpressionValueArgument.$$$reportNull$$$0(1);
            }
            return ktElement;
        }

        @Override
        public LeafPsiElement getSpreadElement() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionValueArgument argument = (ExpressionValueArgument)o;
            return !(this.expression != null ? !this.expression.equals(argument.expression) : argument.expression != null);
        }

        public int hashCode() {
            return this.expression != null ? this.expression.hashCode() : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reportErrorsOn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$ExpressionValueArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/util/CallMaker$ExpressionValueArgument";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

