/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.extapi.psi.PsiFileBase;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.FileContentUtilCore;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtFileClassProvider;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtPlaceHolderStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtFile
extends PsiFileBase
implements PsiClassOwner,
PsiNamedElement,
KtAnnotated,
KtDeclarationContainer,
KtElement {
    private final boolean isCompiled;
    private Boolean isScript = null;

    public KtFile(FileViewProvider viewProvider, boolean compiled) {
        super(viewProvider, KotlinLanguage.INSTANCE);
        this.isCompiled = compiled;
    }

    @Override
    public FileASTNode getNode() {
        return super.getNode();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        if (kotlinFileType == null) {
            KtFile.$$$reportNull$$$0(0);
        }
        return kotlinFileType;
    }

    @Override
    public String toString() {
        return "KtFile: " + this.getName();
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            List<PsiElement> list2 = Arrays.asList(stub.getChildrenByType(KtStubElementTypes.DECLARATION_TYPES, KtDeclaration.ARRAY_FACTORY));
            if (list2 == null) {
                KtFile.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<KtDeclaration> list3 = PsiTreeUtil.getChildrenOfTypeAsList(this, KtDeclaration.class);
        if (list3 == null) {
            KtFile.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @Nullable
    public KtImportList getImportList() {
        return this.findChildByTypeOrClass(KtStubElementTypes.IMPORT_LIST, KtImportList.class);
    }

    @Nullable
    public KtFileAnnotationList getFileAnnotationList() {
        return this.findChildByTypeOrClass(KtStubElementTypes.FILE_ANNOTATION_LIST, KtFileAnnotationList.class);
    }

    @Nullable
    public <T extends KtElementImplStub<? extends StubElement<?>>> T findChildByTypeOrClass(@NotNull KtPlaceHolderStubElementType<T> elementType, @NotNull Class<T> elementClass) {
        KotlinFileStub stub;
        if (elementType == null) {
            KtFile.$$$reportNull$$$0(3);
        }
        if (elementClass == null) {
            KtFile.$$$reportNull$$$0(4);
        }
        if ((stub = this.getStub()) != null) {
            StubElement importListStub = stub.findChildStubByType(elementType);
            return (T)(importListStub != null ? (KtElementImplStub)importListStub.getPsi() : null);
        }
        return (T)((KtElementImplStub)this.findChildByClass(elementClass));
    }

    @NotNull
    public List<KtImportDirective> getImportDirectives() {
        KtImportList importList = this.getImportList();
        List<KtImportDirective> list2 = importList != null ? importList.getImports() : Collections.emptyList();
        if (list2 == null) {
            KtFile.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    public KtImportDirective findImportByAlias(@NotNull String name) {
        if (name == null) {
            KtFile.$$$reportNull$$$0(6);
        }
        for (KtImportDirective directive : this.getImportDirectives()) {
            if (!name.equals(directive.getAliasName())) continue;
            return directive;
        }
        return null;
    }

    @Nullable
    public KtPackageDirective getPackageDirective() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            StubElement packageDirectiveStub = stub.findChildStubByType(KtStubElementTypes.PACKAGE_DIRECTIVE);
            return packageDirectiveStub != null ? (KtPackageDirective)packageDirectiveStub.getPsi() : null;
        }
        return this.getPackageDirectiveByTree();
    }

    @Nullable
    private KtPackageDirective getPackageDirectiveByTree() {
        ASTNode ast = this.getNode().findChildByType(KtNodeTypes.PACKAGE_DIRECTIVE);
        return ast != null ? (KtPackageDirective)ast.getPsi() : null;
    }

    @Override
    @Deprecated
    @NotNull
    public String getPackageName() {
        String string = this.getPackageFqName().asString();
        if (string == null) {
            KtFile.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public FqName getPackageFqName() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            FqName fqName2 = stub.getPackageFqName();
            if (fqName2 == null) {
                KtFile.$$$reportNull$$$0(8);
            }
            return fqName2;
        }
        FqName fqName3 = this.getPackageFqNameByTree();
        if (fqName3 == null) {
            KtFile.$$$reportNull$$$0(9);
        }
        return fqName3;
    }

    @NotNull
    public FqName getPackageFqNameByTree() {
        KtPackageDirective packageDirective = this.getPackageDirectiveByTree();
        if (packageDirective == null) {
            FqName fqName2 = FqName.ROOT;
            if (fqName2 == null) {
                KtFile.$$$reportNull$$$0(10);
            }
            return fqName2;
        }
        FqName fqName3 = packageDirective.getFqName();
        if (fqName3 == null) {
            KtFile.$$$reportNull$$$0(11);
        }
        return fqName3;
    }

    @Override
    @Nullable
    public KotlinFileStub getStub() {
        return (KotlinFileStub)super.getStub();
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        KtFileClassProvider fileClassProvider = ServiceManager.getService(this.getProject(), KtFileClassProvider.class);
        if (fileClassProvider != null && !this.isScript()) {
            PsiClass[] psiClassArray = fileClassProvider.getFileClasses(this);
            if (psiClassArray == null) {
                KtFile.$$$reportNull$$$0(12);
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            KtFile.$$$reportNull$$$0(13);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    public void setPackageName(String packageName) {
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.isScript = null;
    }

    @Nullable
    public KtScript getScript() {
        if (this.isScript != null && !this.isScript.booleanValue()) {
            return null;
        }
        KtScript result2 = PsiTreeUtil.getChildOfType(this, KtScript.class);
        if (this.isScript == null) {
            this.isScript = result2 != null;
        }
        return result2;
    }

    public boolean isScript() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            return stub.isScript();
        }
        return this.isScriptByTree();
    }

    public boolean isScriptByTree() {
        return this.getScript() != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = super.getName();
        if (string == null) {
            KtFile.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            KtFile.$$$reportNull$$$0(15);
        }
        if (visitor2 instanceof KtVisitor) {
            this.accept((KtVisitor)visitor2, null);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    @NotNull
    public KtFile getContainingKtFile() {
        KtFile ktFile = this;
        if (ktFile == null) {
            KtFile.$$$reportNull$$$0(16);
        }
        return ktFile;
    }

    @Override
    public <D> void acceptChildren(@NotNull KtVisitor<Void, D> visitor2, D data2) {
        if (visitor2 == null) {
            KtFile.$$$reportNull$$$0(17);
        }
        KtPsiUtil.visitChildren(this, visitor2, data2);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            KtFile.$$$reportNull$$$0(18);
        }
        return visitor2.visitKtFile(this, data2);
    }

    @Override
    @NotNull
    public List<KtAnnotation> getAnnotations() {
        KtFileAnnotationList fileAnnotationList = this.getFileAnnotationList();
        if (fileAnnotationList == null) {
            List<KtAnnotation> list2 = Collections.emptyList();
            if (list2 == null) {
                KtFile.$$$reportNull$$$0(19);
            }
            return list2;
        }
        List<KtAnnotation> list3 = fileAnnotationList.getAnnotations();
        if (list3 == null) {
            KtFile.$$$reportNull$$$0(20);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<KtAnnotationEntry> getAnnotationEntries() {
        KtFileAnnotationList fileAnnotationList = this.getFileAnnotationList();
        if (fileAnnotationList == null) {
            List<KtAnnotationEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                KtFile.$$$reportNull$$$0(21);
            }
            return list2;
        }
        List<KtAnnotationEntry> list3 = fileAnnotationList.getAnnotationEntries();
        if (list3 == null) {
            KtFile.$$$reportNull$$$0(22);
        }
        return list3;
    }

    @NotNull
    public List<KtAnnotationEntry> getDanglingAnnotations() {
        KotlinFileStub stub = this.getStub();
        KtModifierList[] danglingModifierLists = stub == null ? this.findChildrenByClass(KtModifierList.class) : (KtModifierList[])stub.getChildrenByType(KtStubElementTypes.MODIFIER_LIST, KtStubElementTypes.MODIFIER_LIST.getArrayFactory());
        List<KtAnnotationEntry> list2 = ArraysKt.flatMap(danglingModifierLists, KtModifierList::getAnnotationEntries);
        if (list2 == null) {
            KtFile.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            KtFile.$$$reportNull$$$0(24);
        }
        PsiElement result2 = super.setName(name);
        boolean willBeScript = name.endsWith(".kts");
        if (this.isScript() != willBeScript) {
            FileContentUtilCore.reparseFiles(CollectionsKt.listOfNotNull(this.getVirtualFile()));
        }
        return result2;
    }

    @Override
    @NotNull
    public KtElement getPsiOrParent() {
        KtFile ktFile = this;
        if (ktFile == null) {
            KtFile.$$$reportNull$$$0(25);
        }
        return ktFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportDirectives";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFqName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFqNameByTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingKtFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationEntries";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDanglingAnnotations";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiOrParent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findChildByTypeOrClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findImportByAlias";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

