/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsNameClashChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J$\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J$\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0014\u0010$\u001a\u00020\u000e*\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u000e*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsNameClashChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "clashedDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "clashedFakeOverrides", "", "Lkotlin/Pair;", "nameSuggestion", "Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "scopes", "", "isHeader", "", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isImpl", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDescriptor", "checkOverrideClashes", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "target", "collect", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getScope", "isFakeOverridingNative", "presentsInGeneratedCode", "isCommonDiagnosticReported", "Companion", "kotlin-compiler"})
public final class JsNameClashChecker
implements SimpleDeclarationChecker {
    private final NameSuggestion nameSuggestion = new NameSuggestion();
    private final Map<DeclarationDescriptor, Map<String, DeclarationDescriptor>> scopes;
    private final Map<DeclarationDescriptor, Pair<DeclarationDescriptor, DeclarationDescriptor>> clashedFakeOverrides;
    private final Set<DeclarationDescriptor> clashedDescriptors;
    private static final Set<DiagnosticFactory1<PsiElement, ? extends Object>> COMMON_DIAGNOSTICS;
    public static final Companion Companion;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        if (!DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
            this.checkDescriptor(descriptor2, declaration, diagnosticHolder, bindingContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDescriptor(DeclarationDescriptor descriptor2, KtDeclaration declaration, DiagnosticSink diagnosticHolder, BindingContext bindingContext) {
        DeclarationDescriptor fqnDescriptor;
        String name;
        Map<String, DeclarationDescriptor> scope;
        DeclarationDescriptor existing;
        SuggestedName suggested;
        if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
            return;
        }
        SuggestedName suggestedName = this.nameSuggestion.suggest(descriptor2);
        if (suggestedName == null) {
            Intrinsics.throwNpe();
        }
        if ((suggested = suggestedName).getStable() && suggested.getScope() instanceof ClassOrPackageFragmentDescriptor && this.presentsInGeneratedCode(suggested.getDescriptor()) && (existing = (scope = this.getScope(suggested.getScope())).get(name = CollectionsKt.last(suggested.getNames()))) != null && Intrinsics.areEqual(existing, descriptor2) ^ true && this.isImpl(existing) == this.isImpl(descriptor2) && this.isHeader(existing) == this.isHeader(descriptor2) && !this.isCommonDiagnosticReported(bindingContext, declaration)) {
            diagnosticHolder.report(ErrorsJs.JS_NAME_CLASH.on((KtElement)((PsiElement)declaration), name, existing));
            PsiElement existingDeclaration = SourceLocationUtilsKt.findPsi(existing);
            if (this.clashedDescriptors.add(existing) && existingDeclaration instanceof KtDeclaration && Intrinsics.areEqual(existingDeclaration, declaration) ^ true) {
                diagnosticHolder.report(ErrorsJs.JS_NAME_CLASH.on((KtElement)existingDeclaration, name, descriptor2));
            }
        }
        if ((fqnDescriptor = suggested.getDescriptor()) instanceof ClassDescriptor) {
            Sequence fakeOverrides2 = SequencesKt.filter(SequencesKt.mapNotNull(CollectionsKt.asSequence(ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)fqnDescriptor).getDefaultType().getMemberScope(), null, null, 3, null)), checkDescriptor.fakeOverrides.1.INSTANCE), checkDescriptor.fakeOverrides.2.INSTANCE);
            Iterator iterator2 = fakeOverrides2.iterator();
            while (iterator2.hasNext()) {
                void secondExample;
                void firstExample;
                CallableMemberDescriptor existing2;
                String name2;
                SuggestedName overrideFqn;
                Map<String, DeclarationDescriptor> scope2;
                DeclarationDescriptor declarationDescriptor;
                CallableMemberDescriptor override = (CallableMemberDescriptor)iterator2.next();
                if (this.nameSuggestion.suggest(override) == null) {
                    Intrinsics.throwNpe();
                }
                if (!((declarationDescriptor = (scope2 = this.getScope(overrideFqn.getScope())).get(name2 = CollectionsKt.last(overrideFqn.getNames()))) instanceof CallableMemberDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((existing2 = (CallableMemberDescriptor)declarationDescriptor) != null && Intrinsics.areEqual(existing2, overrideFqn.getDescriptor()) ^ true && !this.isFakeOverridingNative(existing2)) {
                    diagnosticHolder.report(ErrorsJs.JS_FAKE_NAME_CLASH.on((KtElement)((PsiElement)declaration), name2, override, existing2));
                    break;
                }
                Pair<DeclarationDescriptor, DeclarationDescriptor> clashedOverrides = this.clashedFakeOverrides.get(override);
                if (clashedOverrides == null) continue;
                Pair<DeclarationDescriptor, DeclarationDescriptor> pair = clashedOverrides;
                DeclarationDescriptor declarationDescriptor2 = pair.component1();
                DeclarationDescriptor declarationDescriptor3 = pair.component2();
                pair = null;
                diagnosticHolder.report(ErrorsJs.JS_FAKE_NAME_CLASH.on((KtElement)((PsiElement)declaration), name2, (DeclarationDescriptor)firstExample, (DeclarationDescriptor)secondExample));
                break;
            }
        }
    }

    private final boolean isCommonDiagnosticReported(@NotNull BindingContext $receiver, KtDeclaration declaration) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = $receiver.getDiagnostics().forElement(declaration);
            for (Object element$iv : $receiver$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                if (!CollectionsKt.contains(JsNameClashChecker.Companion.getCOMMON_DIAGNOSTICS(), it.getFactory())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isImpl(@NotNull DeclarationDescriptor $receiver) {
        return $receiver instanceof MemberDescriptor && ((MemberDescriptor)$receiver).isImpl();
    }

    private final boolean isHeader(@NotNull DeclarationDescriptor $receiver) {
        return $receiver instanceof MemberDescriptor && ((MemberDescriptor)$receiver).isHeader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFakeOverridingNative(CallableMemberDescriptor descriptor2) {
        boolean bl;
        if (!Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) return false;
        Iterable $receiver$iv = descriptor2.getOverriddenDescriptors();
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            CallableMemberDescriptor it;
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
            if (this.presentsInGeneratedCode(callableMemberDescriptor)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DeclarationDescriptor> getScope(DeclarationDescriptor descriptor2) {
        Map map2;
        Map<DeclarationDescriptor, Map<String, DeclarationDescriptor>> $receiver$iv = this.scopes;
        Map<String, DeclarationDescriptor> value$iv = $receiver$iv.get(descriptor2);
        if (value$iv == null) {
            Map scope = new LinkedHashMap();
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                void $receiver$iv$iv;
                Iterable $receiver$iv2;
                this.collect(((PackageFragmentDescriptor)descriptor2).getMemberScope(), (Map<String, DeclarationDescriptor>)scope);
                ModuleDescriptor module2 = DescriptorUtils.getContainingModule(descriptor2);
                Iterable iterable = module2.getSubPackagesOf(((PackageFragmentDescriptor)descriptor2).getFqName(), getScope.1.1.INSTANCE);
                Iterator iterator2 = $receiver$iv2;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    FqName it = (FqName)element$iv$iv;
                    Iterable list$iv$iv = module2.getPackage(it).getFragments();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                $receiver$iv2 = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv2) {
                    PackageFragmentDescriptor it = (PackageFragmentDescriptor)element$iv;
                    this.collect(it, (Map<String, DeclarationDescriptor>)scope);
                }
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                this.collect(((ClassDescriptor)descriptor2).getDefaultType().getMemberScope(), (Map<String, DeclarationDescriptor>)scope);
            }
            Map answer$iv = scope;
            $receiver$iv.put(descriptor2, answer$iv);
            map2 = answer$iv;
        } else {
            void var3_3;
            map2 = var3_3;
        }
        return map2;
    }

    private final void collect(MemberScope scope, Map<String, DeclarationDescriptor> target) {
        for (DeclarationDescriptor descriptor2 : ResolutionScope.DefaultImpls.getContributedDescriptors$default(scope, null, null, 3, null)) {
            this.collect(descriptor2, target);
        }
    }

    private final void collect(DeclarationDescriptor descriptor2, Map<String, DeclarationDescriptor> target) {
        block5: {
            if (descriptor2 instanceof PropertyDescriptor && (DescriptorUtilsKt.isExtension(descriptor2) || AnnotationsUtils.hasJsNameInAccessors((PropertyDescriptor)descriptor2))) {
                Iterable $receiver$iv = ((PropertyDescriptor)descriptor2).getAccessors();
                for (Object element$iv : $receiver$iv) {
                    PropertyAccessorDescriptor it;
                    PropertyAccessorDescriptor propertyAccessorDescriptor = it = (PropertyAccessorDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(propertyAccessorDescriptor, "it");
                    this.collect(propertyAccessorDescriptor, target);
                }
                return;
            }
            SuggestedName suggestedName = this.nameSuggestion.suggest(descriptor2);
            if (suggestedName == null) {
                return;
            }
            SuggestedName fqn = suggestedName;
            if (!fqn.getStable() || !this.presentsInGeneratedCode(fqn.getDescriptor())) break block5;
            Object object = target;
            String element$iv = CollectionsKt.last(fqn.getNames());
            DeclarationDescriptor it = fqn.getDescriptor();
            object.put((String)element$iv, (DeclarationDescriptor)it);
            DeclarationDescriptor declarationDescriptor = fqn.getDescriptor();
            if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                declarationDescriptor = null;
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
            if (callableMemberDescriptor != null) {
                Object it2 = object = callableMemberDescriptor;
                this.checkOverrideClashes((CallableMemberDescriptor)it2, target);
            }
        }
    }

    private final void checkOverrideClashes(CallableMemberDescriptor descriptor2, Map<String, DeclarationDescriptor> target) {
        Iterator<CallableMemberDescriptor> iterator2 = DescriptorUtils.getAllOverriddenDeclarations(descriptor2).iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map<Object, Object> map2;
            SuggestedName overriddenFqn;
            CallableMemberDescriptor overriddenDescriptor2;
            CallableMemberDescriptor callableMemberDescriptor = overriddenDescriptor2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "overriddenDescriptor");
            if (this.nameSuggestion.suggest(callableMemberDescriptor) == null) {
                Intrinsics.throwNpe();
            }
            if (!overriddenFqn.getStable()) continue;
            DeclarationDescriptor existing = target.get(CollectionsKt.last(overriddenFqn.getNames()));
            if (existing != null) {
                if (!(Intrinsics.areEqual(existing, descriptor2) ^ true) || !Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) continue;
                map2 = this.clashedFakeOverrides;
                object = new Pair<DeclarationDescriptor, CallableMemberDescriptor>(existing, overriddenDescriptor2);
                map2.put((String)((Object)descriptor2), (DeclarationDescriptor)object);
                continue;
            }
            map2 = target;
            object = CollectionsKt.last(overriddenFqn.getNames());
            CallableMemberDescriptor callableMemberDescriptor2 = descriptor2;
            map2.put((String)object, callableMemberDescriptor2);
        }
    }

    private final boolean presentsInGeneratedCode(DeclarationDescriptor descriptor2) {
        return !AnnotationsUtils.isNativeObject(descriptor2) && !AnnotationsUtils.isLibraryObject(descriptor2);
    }

    public JsNameClashChecker() {
        JsNameClashChecker jsNameClashChecker = this;
        Object object = new LinkedHashMap();
        jsNameClashChecker.scopes = object;
        jsNameClashChecker = this;
        object = new LinkedHashMap();
        jsNameClashChecker.clashedFakeOverrides = object;
        jsNameClashChecker = this;
        jsNameClashChecker.clashedDescriptors = object = (Set)new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        COMMON_DIAGNOSTICS = SetsKt.setOf(new DiagnosticFactory1[]{Errors.REDECLARATION, Errors.CONFLICTING_OVERLOADS, Errors.PACKAGE_OR_CLASSIFIER_REDECLARATION});
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageVersionSettings);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R^\u0010\u0003\u001aL\u0012H\u0012F\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00010\u0001 \u0007*\"\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsNameClashChecker$Companion;", "", "()V", "COMMON_DIAGNOSTICS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "getCOMMON_DIAGNOSTICS", "()Ljava/util/Set;", "kotlin-compiler"})
    public static final class Companion {
        private final Set<DiagnosticFactory1<PsiElement, ? extends Object>> getCOMMON_DIAGNOSTICS() {
            return COMMON_DIAGNOSTICS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

