/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.CodePosition;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUCache;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.FunctionReaderKt;
import org.jetbrains.kotlin.js.parser.OffsetToSourceMapping;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapLocationRemapper;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParseResult;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParser;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.JsLibraryUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b*\u0002\r\u001f\u0018\u00002\u00020\u0001:\u0001(B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002J\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0018\u0010&\u001a\u00020!2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010'\u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0013\u001aB\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016 \u0015* \u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "", "reporter", "Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "currentModuleName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "fragments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "(Lorg/jetbrains/kotlin/js/config/JsConfig$Reporter;Lorg/jetbrains/kotlin/js/config/JsConfig;Lorg/jetbrains/kotlin/js/backend/ast/JsName;Ljava/util/List;)V", "functionCache", "org/jetbrains/kotlin/js/inline/FunctionReader$functionCache$1", "Lorg/jetbrains/kotlin/js/inline/FunctionReader$functionCache$1;", "moduleNameMap", "", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "moduleNameToInfo", "Lorg/jetbrains/kotlin/com/google/common/collect/HashMultimap;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/js/inline/FunctionReader$ModuleInfo;", "buildModuleNameMap", "contains", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "get", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "offset", "org/jetbrains/kotlin/js/inline/FunctionReader$offset$1", "text", "", "(Ljava/lang/String;I)Lorg/jetbrains/kotlin/js/inline/FunctionReader$offset$1;", "readFunction", "readFunctionFromSource", "info", "rewindToIdentifierStart", "index", "ModuleInfo", "kotlin-compiler"})
public final class FunctionReader {
    private final HashMultimap<String, ModuleInfo> moduleNameToInfo;
    private final Map<String, JsExpression> moduleNameMap;
    private final functionCache.1 functionCache;
    private final JsConfig.Reporter reporter;
    private final JsConfig config;
    private final JsName currentModuleName;

    /*
     * WARNING - void declaration
     */
    private final Map<String, JsExpression> buildModuleNameMap(List<? extends JsProgramFragment> fragments2) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)fragments2;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            JsProgramFragment it = (JsProgramFragment)element$iv$iv;
            Iterable list$iv$iv = it.getInlineModuleMap().entrySet();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map.Entry $k_v;
            Map map2 = destination$iv$iv2;
            Map.Entry entry = $k_v = (Map.Entry)element$iv$iv;
            String k = (String)entry.getKey();
            entry = $k_v;
            JsExpression v = (JsExpression)entry.getValue();
            Pair<String, JsExpression> pair = TuplesKt.to(k, v);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private final int rewindToIdentifierStart(String text2, int index2) {
        int result2;
        for (result2 = index2; result2 > 0 && Character.isJavaIdentifierPart(text2.charAt(result2 - 1)); --result2) {
        }
        return result2;
    }

    private final offset.1 offset(String text2, int offset2) {
        return new CharSequence(text2, offset2){
            final /* synthetic */ String $text;
            final /* synthetic */ int $offset;

            public int getLength() {
                return this.$text.length() - this.$offset;
            }

            public char get(int index2) {
                return this.$text.charAt(index2 + this.$offset);
            }

            @NotNull
            public CharSequence subSequence(int startIndex, int endIndex) {
                return this.$text.subSequence(startIndex + this.$offset, endIndex + this.$offset);
            }

            @NotNull
            public String toString() {
                String string = this.$text;
                int n = this.$offset;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
                return string3;
            }
            {
                this.$text = $captured_local_variable$0;
                this.$offset = $captured_local_variable$1;
            }
        };
    }

    public final boolean contains(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        String moduleName = JsDescriptorUtils.getModuleName(descriptor2);
        String currentModuleName = this.config.getModuleId();
        return Intrinsics.areEqual(currentModuleName, moduleName) ^ true && this.moduleNameToInfo.keys().contains(moduleName);
    }

    @NotNull
    public final JsFunction get(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Object v = this.functionCache.get(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(v, "functionCache.get(descriptor)");
        return (JsFunction)v;
    }

    private final JsFunction readFunction(CallableDescriptor descriptor2) {
        if (this.contains(descriptor2) ^ true) {
            return null;
        }
        String moduleName = JsDescriptorUtils.getModuleName(descriptor2);
        Iterator iterator2 = this.moduleNameToInfo.get((Object)moduleName).iterator();
        while (iterator2.hasNext()) {
            ModuleInfo info;
            ModuleInfo moduleInfo = info = (ModuleInfo)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(moduleInfo, "info");
            JsFunction function2 = this.readFunctionFromSource(descriptor2, moduleInfo);
            if (function2 == null) continue;
            return function2;
        }
        return null;
    }

    private final JsFunction readFunctionFromSource(CallableDescriptor descriptor2, ModuleInfo info) {
        int offset2;
        String source = info.getFileContent();
        String tag = Namer.getFunctionTag(descriptor2, this.config);
        CharSequence charSequence = source;
        String string = tag;
        Intrinsics.checkExpressionValueIsNotNull(string, "tag");
        int index2 = StringsKt.indexOf$default(charSequence, string, 0, false, 6, null);
        if (index2 < 0) {
            return null;
        }
        for (offset2 = index2 + tag.length() + 1; offset2 < source.length() && FunctionReaderKt.access$isWhitespaceOrComma$p(source.charAt(offset2)); ++offset2) {
        }
        CodePosition position = info.getOffsetToSourceMapping().get(offset2);
        JsFunction function2 = ParserUtilsKt.parseFunction(source, info.getFilePath(), position, offset2, ThrowExceptionOnErrorReporter.INSTANCE, new JsRootScope(new JsProgram()));
        JsExpression jsExpression = this.moduleNameMap.get(tag);
        if (jsExpression == null || (jsExpression = jsExpression.deepCopy()) == null) {
            jsExpression = this.currentModuleName.makeRef();
        }
        JsExpression moduleReference = jsExpression;
        SourceMap sourceMap2 = info.getSourceMap();
        if (sourceMap2 != null) {
            SourceMapLocationRemapper remapper = new SourceMapLocationRemapper(sourceMap2);
            remapper.remap(function2);
        }
        HashMap replacements = MapsKt.hashMapOf(TuplesKt.to(info.getModuleVariable(), moduleReference), TuplesKt.to(info.getKotlinVariable(), Namer.kotlinObject()));
        FunctionReaderKt.access$replaceExternalNames(function2, replacements);
        FunctionReaderKt.access$markInlineArguments(function2, descriptor2);
        return function2;
    }

    /*
     * WARNING - void declaration
     */
    public FunctionReader(@NotNull JsConfig.Reporter reporter2, @NotNull JsConfig config, @NotNull JsName currentModuleName, @NotNull List<? extends JsProgramFragment> fragments2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(reporter2, "reporter");
        Intrinsics.checkParameterIsNotNull(config, "config");
        Intrinsics.checkParameterIsNotNull(currentModuleName, "currentModuleName");
        Intrinsics.checkParameterIsNotNull(fragments2, "fragments");
        this.reporter = reporter2;
        this.config = config;
        this.currentModuleName = currentModuleName;
        this.moduleNameToInfo = HashMultimap.create();
        Iterable iterable = $receiver$iv = (Iterable)this.config.getLibraries();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file = new File((String)p1);
            collection.add(file);
        }
        List libs = (List)destination$iv$iv;
        this.moduleNameMap = this.buildModuleNameMap(fragments2);
        JsLibraryUtils.traverseJsLibraries(libs, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public final void invoke(@NotNull JsLibrary $content_path_sourceMapContent) {
                int index2;
                Intrinsics.checkParameterIsNotNull($content_path_sourceMapContent, "<name for destructuring parameter 0>");
                String content = $content_path_sourceMapContent.component1();
                String path = $content_path_sourceMapContent.component2();
                String sourceMapContent = $content_path_sourceMapContent.component3();
                int current = 0;
                while ((index2 = StringsKt.indexOf$default((CharSequence)content, FunctionReaderKt.access$getDEFINE_MODULE_FIND_PATTERN$p(), current, false, 4, null)) >= 0) {
                    SourceMap sourceMap2;
                    current = index2 + 1;
                    index2 = this.rewindToIdentifierStart(content, index2);
                    Matcher preciseMatcher = FunctionReaderKt.access$getDEFINE_MODULE_PATTERN$p().matcher(this.offset(content, index2));
                    if (!preciseMatcher.lookingAt()) continue;
                    String moduleName = preciseMatcher.group(3);
                    String moduleVariable = preciseMatcher.group(4);
                    String kotlinVariable = preciseMatcher.group(1);
                    if (sourceMapContent != null) {
                        String string;
                        String it = string;
                        SourceMapParseResult result2 = SourceMapParser.INSTANCE.parse(new StringReader(it));
                        SourceMapParseResult sourceMapParseResult = result2;
                        if (sourceMapParseResult instanceof SourceMapSuccess) {
                            sourceMap2 = ((SourceMapSuccess)result2).getValue();
                        } else {
                            if (!(sourceMapParseResult instanceof SourceMapError)) throw new NoWhenBranchMatchedException();
                            reporter.warning("Error parsing source map file for " + path + ": " + ((SourceMapError)result2).getMessage());
                            sourceMap2 = null;
                        }
                    } else {
                        sourceMap2 = null;
                    }
                    SourceMap sourceMap3 = sourceMap2;
                    String string = moduleVariable;
                    Intrinsics.checkExpressionValueIsNotNull(string, "moduleVariable");
                    String string2 = kotlinVariable;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "kotlinVariable");
                    ModuleInfo moduleInfo = new ModuleInfo(path, content, string, string2, new OffsetToSourceMapping(content), sourceMap3);
                    moduleNameToInfo.put(moduleName, moduleInfo);
                }
            }
        });
        this.functionCache = new SLRUCache<CallableDescriptor, JsFunction>(this, 50, 50){
            final /* synthetic */ FunctionReader this$0;

            @NotNull
            public JsFunction createValue(@NotNull CallableDescriptor descriptor2) {
                JsFunction $receiver$iv;
                Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
                JsFunction jsFunction = $receiver$iv = FunctionReader.access$readFunction(this.this$0, descriptor2);
                if (jsFunction == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "Could not read function: " + descriptor2;
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                return jsFunction;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    @Nullable
    public static final /* synthetic */ JsFunction access$readFunction(FunctionReader $this, @NotNull CallableDescriptor descriptor2) {
        return $this.readFunction(descriptor2);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionReader$ModuleInfo;", "", "filePath", "", "fileContent", "moduleVariable", "kotlinVariable", "offsetToSourceMapping", "Lorg/jetbrains/kotlin/js/parser/OffsetToSourceMapping;", "sourceMap", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/js/parser/OffsetToSourceMapping;Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;)V", "getFileContent", "()Ljava/lang/String;", "getFilePath", "getKotlinVariable", "getModuleVariable", "getOffsetToSourceMapping", "()Lorg/jetbrains/kotlin/js/parser/OffsetToSourceMapping;", "getSourceMap", "()Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;", "kotlin-compiler"})
    public static final class ModuleInfo {
        @NotNull
        private final String filePath;
        @NotNull
        private final String fileContent;
        @NotNull
        private final String moduleVariable;
        @NotNull
        private final String kotlinVariable;
        @NotNull
        private final OffsetToSourceMapping offsetToSourceMapping;
        @Nullable
        private final SourceMap sourceMap;

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final String getFileContent() {
            return this.fileContent;
        }

        @NotNull
        public final String getModuleVariable() {
            return this.moduleVariable;
        }

        @NotNull
        public final String getKotlinVariable() {
            return this.kotlinVariable;
        }

        @NotNull
        public final OffsetToSourceMapping getOffsetToSourceMapping() {
            return this.offsetToSourceMapping;
        }

        @Nullable
        public final SourceMap getSourceMap() {
            return this.sourceMap;
        }

        public ModuleInfo(@NotNull String filePath, @NotNull String fileContent, @NotNull String moduleVariable, @NotNull String kotlinVariable, @NotNull OffsetToSourceMapping offsetToSourceMapping, @Nullable SourceMap sourceMap2) {
            Intrinsics.checkParameterIsNotNull(filePath, "filePath");
            Intrinsics.checkParameterIsNotNull(fileContent, "fileContent");
            Intrinsics.checkParameterIsNotNull(moduleVariable, "moduleVariable");
            Intrinsics.checkParameterIsNotNull(kotlinVariable, "kotlinVariable");
            Intrinsics.checkParameterIsNotNull(offsetToSourceMapping, "offsetToSourceMapping");
            this.filePath = filePath;
            this.fileContent = fileContent;
            this.moduleVariable = moduleVariable;
            this.kotlinVariable = kotlinVariable;
            this.offsetToSourceMapping = offsetToSourceMapping;
            this.sourceMap = sourceMap2;
        }
    }
}

