/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;

class HardElementInfo
extends SmartPointerElementInfo {
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final Project myProject;

    public HardElementInfo(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/HardElementInfo", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/HardElementInfo", "<init>"));
        }
        this.myElement = element;
        this.myProject = project;
    }

    @Override
    public PsiElement restoreElement() {
        return this.myElement;
    }

    @Override
    public PsiFile restoreFile() {
        return this.myElement.isValid() ? this.myElement.getContainingFile() : null;
    }

    @Override
    public int elementHashCode() {
        return this.myElement.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/HardElementInfo", "pointsToTheSameElementAs"));
        }
        return Comparing.equal(this.myElement, ApplicationManager.getApplication().runReadAction(new Computable<PsiElement>(){

            @Override
            public PsiElement compute() {
                return other.restoreElement();
            }
        }));
    }

    @Override
    public VirtualFile getVirtualFile() {
        return PsiUtilCore.getVirtualFile(this.myElement);
    }

    @Override
    public Segment getRange() {
        return this.myElement.getTextRange();
    }

    @Override
    public Segment getPsiRange() {
        return this.getRange();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/HardElementInfo", "getProject"));
        }
        return project;
    }

    public String toString() {
        return "hard{" + this.myElement + " of " + this.myElement.getClass() + "}";
    }
}

