/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.patterns;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.patterns.ElementPattern;
import org.jetbrains.kotlin.com.intellij.patterns.ElementPatternCondition;
import org.jetbrains.kotlin.com.intellij.patterns.InitialPatternCondition;
import org.jetbrains.kotlin.com.intellij.patterns.PatternCondition;
import org.jetbrains.kotlin.com.intellij.patterns.PatternConditionPlus;
import org.jetbrains.kotlin.com.intellij.patterns.StandardPatterns;
import org.jetbrains.kotlin.com.intellij.patterns.ValuePatternCondition;
import org.jetbrains.kotlin.com.intellij.util.PairProcessor;
import org.jetbrains.kotlin.com.intellij.util.ProcessingContext;

public abstract class ObjectPattern<T, Self extends ObjectPattern<T, Self>>
implements ElementPattern<T>,
Cloneable {
    private InitialPatternCondition<T> myInitialCondition;
    private Object myConditions;

    protected ObjectPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "<init>"));
        }
        this.myInitialCondition = condition;
        this.myConditions = null;
    }

    protected ObjectPattern(final Class<T> aClass2) {
        this(new InitialPatternCondition<T>(aClass2){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return aClass2.isInstance(o);
            }
        });
    }

    @Override
    public final boolean accepts(@Nullable Object t) {
        return this.accepts(t, new ProcessingContext());
    }

    @Override
    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        if (!this.myInitialCondition.accepts(o, context)) {
            return false;
        }
        if (this.myConditions == null) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.myConditions instanceof PatternCondition) {
            return ((PatternCondition)this.myConditions).accepts(o, context);
        }
        List list2 = (List)this.myConditions;
        int listSize = list2.size();
        for (int i = 0; i < listSize; ++i) {
            if (((PatternCondition)list2.get(i)).accepts(o, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public final ElementPatternCondition<T> getCondition() {
        if (this.myConditions == null) {
            ElementPatternCondition<T> elementPatternCondition = new ElementPatternCondition<T>(this.myInitialCondition);
            if (elementPatternCondition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "getCondition"));
            }
            return elementPatternCondition;
        }
        if (this.myConditions instanceof PatternCondition) {
            PatternCondition singleCondition = (PatternCondition)this.myConditions;
            ElementPatternCondition elementPatternCondition = new ElementPatternCondition(this.myInitialCondition, Collections.singletonList(singleCondition));
            if (elementPatternCondition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "getCondition"));
            }
            return elementPatternCondition;
        }
        ElementPatternCondition<T> elementPatternCondition = new ElementPatternCondition<T>(this.myInitialCondition, (List)this.myConditions);
        if (elementPatternCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "getCondition"));
        }
        return elementPatternCondition;
    }

    @NotNull
    public Self andNot(ElementPattern pattern) {
        Capture not = StandardPatterns.not(pattern);
        Self Self = this.and(not);
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "andNot"));
        }
        return Self;
    }

    @NotNull
    public Self andOr(ElementPattern ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "andOr"));
        }
        ElementPattern or = StandardPatterns.or(patterns);
        Self Self = this.and(or);
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "andOr"));
        }
        return Self;
    }

    @NotNull
    public Self and(ElementPattern pattern) {
        Self Self = this.with(new PatternConditionPlus<T, T>("and", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<T, ProcessingContext> processor) {
                return processor.process((ProcessingContext)t, context);
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "and"));
        }
        return Self;
    }

    @NotNull
    public Self equalTo(final @NotNull T o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "equalTo"));
        }
        Self Self = this.with(new ValuePatternCondition<T>("equalTo"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern$3", "accepts"));
                }
                return t.equals(o);
            }

            @Override
            public Collection<T> getValues() {
                return Collections.singletonList(o);
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "equalTo"));
        }
        return Self;
    }

    @NotNull
    public Self oneOf(T ... values2) {
        int length = values2.length;
        final Collection<T> list2 = length == 1 ? Collections.singletonList(values2[0]) : (length >= 11 ? new HashSet<T>(Arrays.asList(values2)) : Arrays.asList(values2));
        Self Self = this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return list2;
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern$4", "accepts"));
                }
                return list2.contains(t);
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "oneOf"));
        }
        return Self;
    }

    @NotNull
    public Self oneOf(final Collection<T> set) {
        Self Self = this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return set;
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern$5", "accepts"));
                }
                return set.contains(t);
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "oneOf"));
        }
        return Self;
    }

    @NotNull
    public Self isNull() {
        Self Self = this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o == null;
            }
        }));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "isNull"));
        }
        return Self;
    }

    @NotNull
    public Self notNull() {
        Self Self = this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o != null;
            }
        }));
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "notNull"));
        }
        return Self;
    }

    @NotNull
    public Self save(final Key<? super T> key) {
        Self Self = this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern$8", "accepts"));
                }
                context.put(key, t);
                return true;
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "save"));
        }
        return Self;
    }

    @NotNull
    public Self save(final @NonNls String key) {
        Self Self = this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern$9", "accepts"));
                }
                context.put(key, t);
                return true;
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "save"));
        }
        return Self;
    }

    @NotNull
    public Self with(PatternCondition<? super T> pattern) {
        ElementPatternCondition<? super T> condition = this.getCondition().append(pattern);
        Self Self = this.adapt(condition);
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "with"));
        }
        return Self;
    }

    @NotNull
    private Self adapt(ElementPatternCondition<T> condition) {
        ObjectPattern objectPattern;
        try {
            ObjectPattern s = (ObjectPattern)this.clone();
            s.myInitialCondition = condition.getInitialCondition();
            List<PatternCondition<T>> conditions2 = condition.getConditions();
            s.myConditions = conditions2.isEmpty() ? null : (conditions2.size() == 1 ? conditions2.get(0) : conditions2);
            objectPattern = s;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (objectPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "adapt"));
        }
        return (Self)objectPattern;
    }

    @NotNull
    public Self without(final PatternCondition<? super T> pattern) {
        Self Self = this.with(new PatternCondition<T>("without"){

            @Override
            public boolean accepts(@NotNull T o, ProcessingContext context) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern$10", "accepts"));
                }
                return !pattern.accepts(o, context);
            }
        });
        if (Self == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern", "without"));
        }
        return Self;
    }

    public String toString() {
        return this.getCondition().toString();
    }

    public static class Capture<T>
    extends ObjectPattern<T, Capture<T>> {
        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/patterns/ObjectPattern$Capture", "<init>"));
            }
            super(condition);
        }
    }
}

