/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ExpressionTypingServices {
    private final ExpressionTypingFacade expressionTypingFacade;
    private final ExpressionTypingComponents expressionTypingComponents;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final StatementFilter statementFilter;

    public ExpressionTypingServices(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker, @NotNull StatementFilter statementFilter, @NotNull ExpressionTypingVisitorDispatcher.ForDeclarations facade) {
        if (components == null) {
            ExpressionTypingServices.$$$reportNull$$$0(0);
        }
        if (annotationChecker == null) {
            ExpressionTypingServices.$$$reportNull$$$0(1);
        }
        if (statementFilter == null) {
            ExpressionTypingServices.$$$reportNull$$$0(2);
        }
        if (facade == null) {
            ExpressionTypingServices.$$$reportNull$$$0(3);
        }
        this.expressionTypingComponents = components;
        this.annotationChecker = annotationChecker;
        this.statementFilter = statementFilter;
        this.expressionTypingFacade = facade;
    }

    @NotNull
    public StatementFilter getStatementFilter() {
        StatementFilter statementFilter = this.statementFilter;
        if (statementFilter == null) {
            ExpressionTypingServices.$$$reportNull$$$0(4);
        }
        return statementFilter;
    }

    @NotNull
    public KotlinType safeGetType(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        KotlinType type2;
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(5);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(6);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(7);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(8);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(9);
        }
        KotlinType kotlinType = (type2 = this.getType(scope, expression2, expectedType, dataFlowInfo, trace)) != null ? type2 : ErrorUtils.createErrorType("Type for " + expression2.getText());
        if (kotlinType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(10);
        }
        return kotlinType;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean isStatement) {
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(11);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(12);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(13);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(14);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(15);
        }
        KotlinTypeInfo kotlinTypeInfo = this.getTypeInfo(scope, expression2, expectedType, dataFlowInfo, trace, isStatement, expression2, ContextDependency.INDEPENDENT);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(16);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean isStatement, @NotNull KtExpression contextExpression, @NotNull ContextDependency contextDependency) {
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(17);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(18);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(19);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(20);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(21);
        }
        if (contextExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(22);
        }
        if (contextDependency == null) {
            ExpressionTypingServices.$$$reportNull$$$0(23);
        }
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, scope, dataFlowInfo, expectedType, contextDependency, this.statementFilter);
        if (contextExpression != expression2) {
            context = (ExpressionTypingContext)context.replaceExpressionContextProvider(arg -> {
                if (expression2 == null) {
                    ExpressionTypingServices.$$$reportNull$$$0(57);
                }
                if (contextExpression == null) {
                    ExpressionTypingServices.$$$reportNull$$$0(58);
                }
                return arg == expression2 ? contextExpression : null;
            });
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingFacade.getTypeInfo(expression2, context, isStatement);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(24);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression2, @NotNull ResolutionContext resolutionContext) {
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(25);
        }
        if (resolutionContext == null) {
            ExpressionTypingServices.$$$reportNull$$$0(26);
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingFacade.getTypeInfo(expression2, ExpressionTypingContext.newContext(resolutionContext));
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(27);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getType(@NotNull LexicalScope scope, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(28);
        }
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(29);
        }
        if (expectedType == null) {
            ExpressionTypingServices.$$$reportNull$$$0(30);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(31);
        }
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(32);
        }
        return this.getTypeInfo(scope, expression2, expectedType, dataFlowInfo, trace, false).getType();
    }

    public void checkFunctionReturnType(@NotNull LexicalScope functionInnerScope, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo, @Nullable KotlinType expectedReturnType, BindingTrace trace) {
        if (functionInnerScope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(33);
        }
        if (function2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(34);
        }
        if (functionDescriptor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(35);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(36);
        }
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor.getReturnType();
            if (!function2.hasBlockBody() && !function2.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        this.checkFunctionReturnType(function2, ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE));
    }

    void checkFunctionReturnType(KtDeclarationWithBody function2, ExpressionTypingContext context) {
        KtExpression bodyExpression = function2.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function2.hasBlockBody();
        ExpressionTypingContext newContext = blockBody ? (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context;
        this.expressionTypingFacade.getTypeInfo(bodyExpression, newContext, blockBody);
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(KtBlockExpression expression2, ExpressionTypingContext context, boolean isStatement) {
        KotlinTypeInfo kotlinTypeInfo = this.getBlockReturnedType(expression2, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context);
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(37);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(@NotNull KtBlockExpression expression2, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context) {
        if (expression2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(38);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(39);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(40);
        }
        List<KtExpression> block = StatementFilterKt.filterStatements(this.statementFilter, expression2);
        DeclarationDescriptor containingDescriptor = context.scope.getOwnerDescriptor();
        TraceBasedLocalRedeclarationChecker redeclarationChecker = new TraceBasedLocalRedeclarationChecker(context.trace, this.expressionTypingComponents.overloadChecker);
        LexicalWritableScope scope = new LexicalWritableScope(context.scope, containingDescriptor, false, redeclarationChecker, LexicalScopeKind.CODE_BLOCK);
        KotlinTypeInfo r = block.isEmpty() ? this.expressionTypingComponents.dataFlowAnalyzer.createCheckedTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context, expression2) : this.getBlockReturnedTypeWithWritableScope(scope, block, coercionStrategyForLastExpression, (ExpressionTypingContext)context.replaceStatementFilter(this.statementFilter));
        scope.freeze();
        if (containingDescriptor instanceof ScriptDescriptor) {
            context.trace.record(BindingContext.SCRIPT_SCOPE, (ScriptDescriptor)containingDescriptor, scope);
        }
        KotlinTypeInfo kotlinTypeInfo = r;
        if (kotlinTypeInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(41);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinType getBodyExpressionType(@NotNull BindingTrace trace, @NotNull LexicalScope outerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor) {
        if (trace == null) {
            ExpressionTypingServices.$$$reportNull$$$0(42);
        }
        if (outerScope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(43);
        }
        if (dataFlowInfo == null) {
            ExpressionTypingServices.$$$reportNull$$$0(44);
        }
        if (function2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(45);
        }
        if (functionDescriptor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(46);
        }
        KtExpression bodyExpression = function2.getBodyExpression();
        assert (bodyExpression != null);
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor, trace, this.expressionTypingComponents.overloadChecker);
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
        KotlinTypeInfo typeInfo = this.expressionTypingFacade.getTypeInfo(bodyExpression, context, function2.hasBlockBody());
        KotlinType type2 = typeInfo.getType();
        if (type2 != null) {
            KotlinType kotlinType = type2;
            if (kotlinType == null) {
                ExpressionTypingServices.$$$reportNull$$$0(47);
            }
            return kotlinType;
        }
        SimpleType simpleType2 = ErrorUtils.createErrorType("Error function type");
        if (simpleType2 == null) {
            ExpressionTypingServices.$$$reportNull$$$0(48);
        }
        return simpleType2;
    }

    KotlinTypeInfo getBlockReturnedTypeWithWritableScope(@NotNull LexicalWritableScope scope, @NotNull List<? extends KtElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context) {
        if (scope == null) {
            ExpressionTypingServices.$$$reportNull$$$0(49);
        }
        if (block == null) {
            ExpressionTypingServices.$$$reportNull$$$0(50);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(51);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(52);
        }
        if (block.isEmpty()) {
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.expressionTypingComponents.builtIns.getUnitType(), context);
        }
        ExpressionTypingVisitorDispatcher.ForBlock blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(context);
        DataFlowInfo beforeJumpInfo = newContext.dataFlowInfo;
        boolean jumpOutPossible = false;
        Iterator<? extends KtElement> iterator2 = block.iterator();
        while (iterator2.hasNext()) {
            KtElement statement2 = iterator2.next();
            if (!(statement2 instanceof KtExpression)) continue;
            KtExpression statementExpression = (KtExpression)statement2;
            if (!iterator2.hasNext()) {
                result2 = this.getTypeOfLastExpressionInBlock(statementExpression, (ExpressionTypingContext)newContext.replaceExpectedType(context.expectedType), coercionStrategyForLastExpression, blockLevelVisitor);
                if (result2.getType() != null && statementExpression.getParent() instanceof KtBlockExpression) {
                    DataFlowValue lastExpressionValue = DataFlowValueFactory.createDataFlowValue(statementExpression, result2.getType(), context);
                    DataFlowValue blockExpressionValue = DataFlowValueFactory.createDataFlowValue((KtBlockExpression)statementExpression.getParent(), result2.getType(), context);
                    result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(blockExpressionValue, lastExpressionValue, this.expressionTypingComponents.languageVersionSettings));
                }
            } else {
                result2 = blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)newContext.replaceContextDependency(ContextDependency.INDEPENDENT), true);
            }
            DataFlowInfo newDataFlowInfo = result2.getDataFlowInfo();
            if (!jumpOutPossible) {
                beforeJumpInfo = result2.getJumpFlowInfo();
                jumpOutPossible = result2.getJumpOutPossible();
            }
            if (newDataFlowInfo != context.dataFlowInfo) {
                newContext = (ExpressionTypingContext)newContext.replaceDataFlowInfo(newDataFlowInfo);
            }
            blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope);
        }
        return result2.replaceJumpOutPossible(jumpOutPossible).replaceJumpFlowInfo(beforeJumpInfo);
    }

    private KotlinTypeInfo getTypeOfLastExpressionInBlock(@NotNull KtExpression statementExpression, @NotNull ExpressionTypingContext context, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingInternals blockLevelVisitor) {
        if (statementExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(53);
        }
        if (context == null) {
            ExpressionTypingServices.$$$reportNull$$$0(54);
        }
        if (coercionStrategyForLastExpression == null) {
            ExpressionTypingServices.$$$reportNull$$$0(55);
        }
        if (blockLevelVisitor == null) {
            ExpressionTypingServices.$$$reportNull$$$0(56);
        }
        if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType expectedType = context.expectedType == TypeUtils.UNIT_EXPECTED_TYPE || coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && KotlinBuiltIns.isUnit(context.expectedType) ? TypeUtils.UNIT_EXPECTED_TYPE : context.expectedType;
            return blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)context.replaceExpectedType(expectedType), true);
        }
        KotlinTypeInfo result2 = blockLevelVisitor.getTypeInfo(statementExpression, context, true);
        if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
            KtBinaryExpression binaryExpression;
            IElementType operationType;
            boolean mightBeUnit = false;
            if (statementExpression instanceof KtDeclaration && (!(statementExpression instanceof KtNamedFunction) || statementExpression.getName() != null)) {
                mightBeUnit = true;
            }
            if (statementExpression instanceof KtBinaryExpression && ((operationType = (binaryExpression = (KtBinaryExpression)statementExpression).getOperationToken()) == KtTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType))) {
                mightBeUnit = true;
            }
            if (mightBeUnit) {
                assert (result2.getType() == null || KotlinBuiltIns.isUnit(result2.getType()));
                result2 = result2.replaceType(this.expressionTypingComponents.builtIns.getUnitType());
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 24: 
            case 27: 
            case 37: 
            case 41: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 24: 
            case 27: 
            case 37: 
            case 41: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationChecker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 24: 
            case 27: 
            case 37: 
            case 41: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices";
                break;
            }
            case 5: 
            case 11: 
            case 17: 
            case 28: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 12: 
            case 18: 
            case 25: 
            case 29: 
            case 38: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 13: 
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 8: 
            case 14: 
            case 20: 
            case 31: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 9: 
            case 15: 
            case 21: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 22: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextExpression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDependency";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolutionContext";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionInnerScope";
                break;
            }
            case 34: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 35: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 39: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coercionStrategyForLastExpression";
                break;
            }
            case 40: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerScope";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementExpression";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockLevelVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementFilter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "safeGetType";
                break;
            }
            case 16: 
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
            case 37: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockReturnedType";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyExpressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 24: 
            case 27: 
            case 37: 
            case 41: 
            case 47: 
            case 48: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "safeGetType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfo";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionReturnType";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBlockReturnedType";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBodyExpressionType";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getBlockReturnedTypeWithWritableScope";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfLastExpressionInBlock";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeInfo$56";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 24: 
            case 27: 
            case 37: 
            case 41: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

