/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001f\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001d\u0010\u0006\u001a\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\b\u001a\u001d\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u001d\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u001d\u0010\u000f\u001a\u00020\r\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u001d\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"getFile", "Ljava/io/File;", "TF", "", "file", "(Ljava/lang/Object;)Ljava/io/File;", "getFileContents", "", "(Ljava/lang/Object;)Ljava/lang/CharSequence;", "getFileContentsStream", "Ljava/io/InputStream;", "(Ljava/lang/Object;)Ljava/io/InputStream;", "getFileName", "", "(Ljava/lang/Object;)Ljava/lang/String;", "getFilePath", "isValidFile", "", "(Ljava/lang/Object;)Z", "kotlin-compiler"})
public final class ScriptFileUtilKt {
    @NotNull
    public static final <TF> String getFileName(@NotNull TF file2) {
        String string;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        TF TF = file2;
        if (TF instanceof PsiFile) {
            String string2 = ((PsiFile)file2).getOriginalFile().getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "file.originalFile.name");
        } else if (TF instanceof VirtualFile) {
            String string3 = ((VirtualFile)file2).getName();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "file.name");
        } else if (TF instanceof File) {
            String string4 = ((File)file2).getName();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull(string4, "file.name");
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return string;
    }

    @NotNull
    public static final <TF> String getFilePath(@NotNull TF file2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        TF TF = file2;
        if (TF instanceof PsiFile) {
            PsiFile psiFile = ((PsiFile)file2).getOriginalFile();
            PsiFile $receiver = psiFile;
            Object object2 = $receiver.getVirtualFile();
            if (object2 == null || (object2 = ((VirtualFile)object2).getPath()) == null) {
                object2 = $receiver.getName();
            }
            object = object2;
            Intrinsics.checkExpressionValueIsNotNull(object2, "file.originalFile.run { \u2026rtualFile?.path ?: name }");
        } else if (TF instanceof VirtualFile) {
            String string = ((VirtualFile)file2).getPath();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "file.path");
        } else if (TF instanceof File) {
            String string = ((File)file2).getCanonicalPath();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull(string, "file.canonicalPath");
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return object;
    }

    public static final <TF> boolean isValidFile(@NotNull TF file2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        TF TF = file2;
        if (TF instanceof PsiFile) {
            bl = ((PsiFile)file2).isValid();
        } else if (TF instanceof VirtualFile) {
            bl = ((VirtualFile)file2).isValid();
        } else if (TF instanceof File) {
            bl = ((File)file2).exists() && ((File)file2).isFile();
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return bl;
    }

    @Nullable
    public static final <TF> File getFile(@NotNull TF file2) {
        File file3;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        TF TF = file2;
        if (TF instanceof PsiFile) {
            PsiFile psiFile;
            PsiFile $receiver = psiFile = ((PsiFile)file2).getOriginalFile();
            VirtualFile virtualFile = $receiver.getVirtualFile();
            file3 = new File(virtualFile != null ? virtualFile.getPath() : null);
        } else if (TF instanceof VirtualFile) {
            file3 = new File(((VirtualFile)file2).getPath());
        } else if (TF instanceof File) {
            file3 = (File)file2;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return file3;
    }

    @NotNull
    public static final <TF> CharSequence getFileContents(@NotNull TF file2) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        TF TF = file2;
        if (TF instanceof PsiFile) {
            CharSequence charSequence2 = ((PsiFile)file2).getViewProvider().getContents();
            charSequence = charSequence2;
            Intrinsics.checkExpressionValueIsNotNull(charSequence2, "file.viewProvider.contents");
        } else if (TF instanceof VirtualFile) {
            InputStream inputStream = ((VirtualFile)file2).getInputStream();
            Charset charset = ((VirtualFile)file2).getCharset();
            Intrinsics.checkExpressionValueIsNotNull(charset, "file.charset");
            Charset charset2 = charset;
            charSequence = TextStreamsKt.readText(new InputStreamReader(inputStream, charset2));
        } else if (TF instanceof File) {
            charSequence = FilesKt.readText$default((File)file2, null, 1, null);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return charSequence;
    }

    @NotNull
    public static final <TF> InputStream getFileContentsStream(@NotNull TF file2) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        TF TF = file2;
        if (TF instanceof PsiFile) {
            ByteArrayInputStream byteArrayInputStream;
            String string = ((Object)((PsiFile)file2).getViewProvider().getContents()).toString();
            Charset charset = Charsets.UTF_8;
            String string2 = string;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            byteArrayInputStream2(byArray2);
            inputStream = byteArrayInputStream3;
        } else if (TF instanceof VirtualFile) {
            InputStream inputStream2 = ((VirtualFile)file2).getInputStream();
            inputStream = inputStream2;
            Intrinsics.checkExpressionValueIsNotNull(inputStream2, "file.inputStream");
        } else if (TF instanceof File) {
            File file3 = (File)file2;
            inputStream = new FileInputStream(file3);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported file type " + file2);
        }
        return inputStream;
    }
}

