/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.script.dependencies.KotlinScriptExternalDependencies;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.script.ScriptFileUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J3\u0010\u0013\u001a\u0004\u0018\u00010\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0006\u0010\u0016\u001a\u0002H\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001f\u0010\u001f\u001a\u00020 \"\b\b\u0000\u0010\u0015*\u00020\u00012\u0006\u0010\u0016\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010!R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "", "template", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "annotationsForSamWithReceivers", "", "", "getAnnotationsForSamWithReceivers", "()Ljava/util/List;", "fileType", "Lorg/jetbrains/kotlin/com/intellij/openapi/fileTypes/LanguageFileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "name", "getName", "()Ljava/lang/String;", "getTemplate", "()Lkotlin/reflect/KClass;", "getDependenciesFor", "Lkotlin/script/dependencies/KotlinScriptExternalDependencies;", "TF", "file", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "previousDependencies", "(Ljava/lang/Object;Lcom/intellij/openapi/project/Project;Lkotlin/script/dependencies/KotlinScriptExternalDependencies;)Lkotlin/script/dependencies/KotlinScriptExternalDependencies;", "getScriptName", "Lorg/jetbrains/kotlin/name/Name;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "isScript", "", "(Ljava/lang/Object;)Z", "kotlin-compiler"})
public class KotlinScriptDefinition {
    @NotNull
    private final String name = "Kotlin Script";
    @NotNull
    private final LanguageFileType fileType;
    @NotNull
    private final KClass<? extends Object> template;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public LanguageFileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public List<String> getAnnotationsForSamWithReceivers() {
        return CollectionsKt.emptyList();
    }

    public <TF> boolean isScript(@NotNull TF file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return StringsKt.endsWith$default(ScriptFileUtilKt.getFileName(file2), KotlinParserDefinition.STD_SCRIPT_EXT, false, 2, null);
    }

    @NotNull
    public Name getScriptName(@NotNull KtScript script) {
        Intrinsics.checkParameterIsNotNull(script, "script");
        String string = script.getContainingKtFile().getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "script.containingKtFile.name");
        return NameUtils.getScriptNameForFile(string);
    }

    @Nullable
    public <TF> KotlinScriptExternalDependencies getDependenciesFor(@NotNull TF file2, @NotNull Project project, @Nullable KotlinScriptExternalDependencies previousDependencies) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(project, "project");
        return null;
    }

    @NotNull
    public final KClass<? extends Object> getTemplate() {
        return this.template;
    }

    public KotlinScriptDefinition(@NotNull KClass<? extends Object> template) {
        Intrinsics.checkParameterIsNotNull(template, "template");
        this.template = template;
        this.name = "Kotlin Script";
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull(kotlinFileType, "KotlinFileType.INSTANCE");
        this.fileType = kotlinFileType;
    }
}

