/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;

public abstract class KtStubElementType<StubT extends StubElement, PsiT extends KtElementImplStub<?>>
extends IStubElementType<StubT, PsiT> {
    @NotNull
    private final Constructor<PsiT> byNodeConstructor;
    @NotNull
    private final Constructor<PsiT> byStubConstructor;
    @NotNull
    private final PsiT[] emptyArray;
    @NotNull
    private final ArrayFactory<PsiT> arrayFactory;

    public KtStubElementType(@NotNull @NonNls String debugName, @NotNull Class<PsiT> psiClass, @NotNull Class<?> stubClass) {
        if (debugName == null) {
            KtStubElementType.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            KtStubElementType.$$$reportNull$$$0(1);
        }
        if (stubClass == null) {
            KtStubElementType.$$$reportNull$$$0(2);
        }
        super(debugName, KotlinLanguage.INSTANCE);
        try {
            this.byNodeConstructor = psiClass.getConstructor(ASTNode.class);
            this.byStubConstructor = psiClass.getConstructor(stubClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Stub element type declaration for " + psiClass.getSimpleName() + " is missing required constructors", e);
        }
        this.emptyArray = (KtElementImplStub[])Array.newInstance(psiClass, 0);
        this.arrayFactory = count -> {
            if (psiClass == null) {
                KtStubElementType.$$$reportNull$$$0(11);
            }
            if (count == 0) {
                return this.emptyArray;
            }
            return (KtElementImplStub[])Array.newInstance(psiClass, count);
        };
    }

    @NotNull
    public PsiT createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            KtStubElementType.$$$reportNull$$$0(3);
        }
        KtElementImplStub ktElementImplStub = (KtElementImplStub)ReflectionUtil.createInstance(this.byNodeConstructor, node);
        if (ktElementImplStub == null) {
            KtStubElementType.$$$reportNull$$$0(4);
        }
        return (PsiT)ktElementImplStub;
    }

    @Override
    @NotNull
    public PsiT createPsi(@NotNull StubT stub) {
        if (stub == null) {
            KtStubElementType.$$$reportNull$$$0(5);
        }
        KtElementImplStub ktElementImplStub = (KtElementImplStub)ReflectionUtil.createInstance(this.byStubConstructor, stub);
        if (ktElementImplStub == null) {
            KtStubElementType.$$$reportNull$$$0(6);
        }
        return (PsiT)ktElementImplStub;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = "kotlin." + this.toString();
        if (string == null) {
            KtStubElementType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi instanceof KtClassOrObject || psi instanceof KtFunction) {
            return true;
        }
        if (psi instanceof KtProperty) {
            return !((KtProperty)psi).isLocal();
        }
        return KtStubElementType.createStubDependingOnParent(node);
    }

    private static boolean createStubDependingOnParent(ASTNode node) {
        ASTNode parent2 = node.getTreeParent();
        IElementType parentType = parent2.getElementType();
        if (parentType instanceof IStubElementType) {
            return ((IStubElementType)parentType).shouldCreateStub(parent2);
        }
        return parentType instanceof IStubFileElementType;
    }

    @Override
    public void indexStub(@NotNull StubT stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtStubElementType.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            KtStubElementType.$$$reportNull$$$0(9);
        }
    }

    @NotNull
    public ArrayFactory<PsiT> getArrayFactory() {
        ArrayFactory<PsiT> arrayFactory = this.arrayFactory;
        if (arrayFactory == null) {
            KtStubElementType.$$$reportNull$$$0(10);
        }
        return arrayFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiFromAst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFromAst";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$51";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

