/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.injection.InjectedLanguageManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondTypeImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiDiamondTypeUtil {
    private static final Logger LOG = Logger.getInstance("#" + PsiDiamondTypeUtil.class.getName());

    private PsiDiamondTypeUtil() {
    }

    public static boolean canCollapseToDiamond(PsiNewExpression expression2, PsiNewExpression context, @Nullable PsiType expectedType) {
        return PsiDiamondTypeUtil.canCollapseToDiamond(expression2, context, expectedType, false);
    }

    public static boolean canChangeContextForDiamond(PsiNewExpression expression2, PsiType expectedType) {
        PsiNewExpression copy = (PsiNewExpression)expression2.copy();
        return PsiDiamondTypeUtil.canCollapseToDiamond(copy, copy, expectedType, true);
    }

    private static boolean canCollapseToDiamond(PsiNewExpression expression2, PsiNewExpression context, @Nullable PsiType expectedType, boolean skipDiamonds) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.getLanguageLevel(context).isAtLeast(LanguageLevel.JDK_1_7) && (classReference = expression2.getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length > 0) {
            if (!skipDiamonds && typeElements.length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return false;
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(expression2, context);
            if (inferenceResult.getErrorMessage() == null) {
                List<PsiType> types = inferenceResult.getInferredTypes();
                PsiType[] typeArguments = null;
                if (expectedType instanceof PsiClassType) {
                    typeArguments = ((PsiClassType)expectedType).getParameters();
                }
                if (typeArguments == null) {
                    typeArguments = parameterList.getTypeArguments();
                }
                if (types.size() == typeArguments.length) {
                    PsiMethod method = expression2.resolveMethod();
                    PsiElement resolve2 = classReference.resolve();
                    if (resolve2 instanceof PsiClass) {
                        PsiTypeParameter[] typeParameters2 = ((PsiClass)resolve2).getTypeParameters();
                        return PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, expression2, true, method, typeParameters2);
                    }
                }
            }
        }
        return false;
    }

    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        if (psiElement instanceof PsiReferenceParameterList) {
            PsiNewExpression expression2 = (PsiNewExpression)JavaPsiFacade.getElementFactory(psiElement.getProject()).createExpressionFromText("new a<>()", psiElement);
            PsiJavaCodeReferenceElement classReference = expression2.getClassReference();
            LOG.assertTrue(classReference != null);
            PsiReferenceParameterList parameterList = classReference.getParameterList();
            LOG.assertTrue(parameterList != null);
            return psiElement.replace(parameterList);
        }
        return psiElement;
    }

    public static PsiElement replaceDiamondWithExplicitTypes(PsiElement element) {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof PsiJavaCodeReferenceElement)) {
            return parent2;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)parent2;
        StringBuilder text2 = new StringBuilder();
        text2.append(javaCodeReferenceElement.getQualifiedName());
        text2.append('<');
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
        PsiDiamondType.DiamondInferenceResult result2 = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, newExpression);
        text2.append(StringUtil.join(result2.getInferredTypes(), psiType -> psiType.getCanonicalText(), ","));
        text2.append('>');
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(element.getProject());
        PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(text2.toString(), element);
        return CodeStyleManager.getInstance(javaCodeReferenceElement.getProject()).reformat(javaCodeReferenceElement.replace(newReference));
    }

    public static PsiExpression expandTopLevelDiamondsInside(PsiExpression expr) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (expr instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expr).getClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            return (PsiExpression)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes(parameterList).getParent();
        }
        return expr;
    }

    public static String getCollapsedType(PsiType type2, PsiElement context) {
        int idx;
        String typeText = type2.getCanonicalText();
        if (PsiUtil.isLanguageLevel7OrHigher(context) && (idx = typeText.indexOf(60)) >= 0) {
            return typeText.substring(0, idx) + "<>";
        }
        return typeText;
    }

    public static boolean areTypeArgumentsRedundant(PsiType[] typeArguments, PsiCallExpression expression2, boolean constructorRef, @Nullable PsiMethod method, PsiTypeParameter[] typeParameters2) {
        try {
            PsiElement copy;
            PsiType typeByParent = PsiTypesUtil.getExpectedTypeByParent(expression2);
            if (typeByParent != null) {
                String arrayInitializer = "new " + typeByParent.getCanonicalText() + "[]{0}";
                Project project = expression2.getProject();
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance(project).getElementFactory();
                PsiNewExpression newExpr = (PsiNewExpression)elementFactory.createExpressionFromText(arrayInitializer, expression2);
                newExpr = (PsiNewExpression)JavaCodeStyleManager.getInstance(project).shortenClassReferences(newExpr);
                PsiArrayInitializerExpression initializer2 = newExpr.getArrayInitializer();
                LOG.assertTrue(initializer2 != null);
                copy = initializer2.getInitializers()[0].replace(expression2);
            } else {
                PsiExpressionList argumentList2 = expression2.getArgumentList();
                int offset2 = (argumentList2 != null ? argumentList2 : expression2).getTextRange().getStartOffset();
                PsiCall call2 = LambdaUtil.treeWalkUp(expression2);
                if (call2 != null) {
                    PsiCall callCopy = LambdaUtil.copyTopLevelCall(call2);
                    copy = callCopy != null ? callCopy.findElementAt(offset2 - call2.getTextRange().getStartOffset()) : null;
                } else {
                    PsiElement startMethodElementInCopy;
                    InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(expression2.getProject());
                    if (injectedLanguageManager.getInjectionHost(expression2) != null) {
                        return false;
                    }
                    PsiFile containingFile = expression2.getContainingFile();
                    PsiFile fileCopy = (PsiFile)containingFile.copy();
                    copy = fileCopy.findElementAt(offset2);
                    if (method != null && method.getContainingFile() == containingFile && (method = PsiTreeUtil.getParentOfType(startMethodElementInCopy = fileCopy.findElementAt(method.getTextOffset()), PsiMethod.class)) == null) {
                        return false;
                    }
                }
            }
            PsiCallExpression exprCopy = PsiTreeUtil.getParentOfType(copy, PsiCallExpression.class, false);
            if (exprCopy != null) {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance(exprCopy.getProject()).getElementFactory();
                if (constructorRef) {
                    if (!(exprCopy instanceof PsiNewExpression) || !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory, (PsiNewExpression)exprCopy)) {
                        return false;
                    }
                } else {
                    LOG.assertTrue(method != null);
                    if (!PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory, exprCopy, method, typeParameters2)) {
                        return false;
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.info(e);
            return false;
        }
        return true;
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiCallExpression exprCopy, PsiMethod method, PsiTypeParameter[] typeParameters2) throws IncorrectOperationException {
        PsiReferenceParameterList list2 = ((PsiCallExpression)elementFactory.createExpressionFromText("foo()", null)).getTypeArgumentList();
        exprCopy.getTypeArgumentList().replace(list2);
        JavaResolveResult copyResult = exprCopy.resolveMethodGenerics();
        if (method != copyResult.getElement()) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = copyResult.getSubstitutor();
        int length = typeParameters2.length;
        for (int i = 0; i < length; ++i) {
            PsiTypeParameter typeParameter = typeParameters2[i];
            PsiType inferredType = psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (!typeArguments[i].equals(inferredType)) {
                return false;
            }
            if (PsiUtil.resolveClassInType(method.getReturnType()) != typeParameter || PsiPrimitiveType.getUnboxedType(inferredType) == null) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(exprCopy);
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiNewExpression exprCopy) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement collapsedClassReference = ((PsiNewExpression)elementFactory.createExpressionFromText("new A<>()", null)).getClassOrAnonymousClassReference();
        LOG.assertTrue(collapsedClassReference != null);
        PsiReferenceParameterList diamondParameterList = collapsedClassReference.getParameterList();
        LOG.assertTrue(diamondParameterList != null);
        PsiJavaCodeReferenceElement classReference = exprCopy.getClassOrAnonymousClassReference();
        LOG.assertTrue(classReference != null);
        PsiReferenceParameterList parameterList = classReference.getParameterList();
        LOG.assertTrue(parameterList != null);
        parameterList.replace(diamondParameterList);
        PsiType[] inferredArgs = classReference.getParameterList().getTypeArguments();
        if (typeArguments.length != inferredArgs.length) {
            return false;
        }
        for (int i = 0; i < typeArguments.length; ++i) {
            PsiWildcardType wildcardType;
            PsiType bound;
            PsiType typeArgument = typeArguments[i];
            if (inferredArgs[i] instanceof PsiWildcardType && (bound = (wildcardType = (PsiWildcardType)inferredArgs[i]).getBound()) != null && (!wildcardType.isExtends() ? typeArgument.isAssignableFrom(bound) : bound.isAssignableFrom(typeArgument)) || typeArgument.equals(inferredArgs[i])) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(exprCopy);
    }

    private static boolean checkParentApplicability(PsiCallExpression exprCopy) {
        while (exprCopy != null) {
            JavaResolveResult resolveResult = exprCopy.resolveMethodGenerics();
            if (resolveResult instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolveResult).isApplicable()) {
                return false;
            }
            exprCopy = PsiTreeUtil.getParentOfType((PsiElement)exprCopy, PsiCallExpression.class, true);
        }
        return true;
    }

    public static void removeRedundantTypeArguments(PsiElement element) {
        for (PsiNewExpression newExpression : PsiTreeUtil.collectElementsOfType(element, PsiNewExpression.class)) {
            PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
            if (classReference == null || !PsiDiamondTypeUtil.canCollapseToDiamond(newExpression, newExpression, null)) continue;
            PsiDiamondTypeUtil.replaceExplicitWithDiamond(classReference.getParameterList());
        }
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(element.getProject()).getElementFactory();
        for (PsiMethodCallExpression call2 : PsiTreeUtil.collectElementsOfType(element, PsiMethodCallExpression.class)) {
            PsiTypeParameter[] parameters2;
            PsiType[] arguments2 = call2.getTypeArguments();
            PsiMethod method = call2.resolveMethod();
            if (method == null || arguments2.length != (parameters2 = method.getTypeParameters()).length || !PsiDiamondTypeUtil.areTypeArgumentsRedundant(arguments2, call2, false, method, parameters2)) continue;
            PsiMethodCallExpression expr = (PsiMethodCallExpression)factory2.createExpressionFromText("foo()", null);
            call2.getTypeArgumentList().replace(expr.getTypeArgumentList());
        }
    }
}

