/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.EnvironmentUtil;

public class PathExecLazyValue
extends AtomicNotNullLazyValue<Boolean> {
    private final String myName;

    public PathExecLazyValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/openapi/util/io/PathExecLazyValue", "<init>"));
        }
        if (StringUtil.containsAnyChar(name, "/\\")) {
            throw new IllegalArgumentException(name);
        }
        this.myName = name;
    }

    @Override
    @NotNull
    protected Boolean compute() {
        String path = EnvironmentUtil.getValue("PATH");
        if (path != null) {
            for (String dir : StringUtil.tokenize(path, File.pathSeparator)) {
                if (!new File(dir, this.myName).canExecute()) continue;
                Boolean bl = true;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/io/PathExecLazyValue", "compute"));
                }
                return bl;
            }
        }
        Boolean bl = false;
        if (bl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/io/PathExecLazyValue", "compute"));
        }
        return bl;
    }
}

