/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.core;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.SuggestedNameInfo;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.VariableKind;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class CoreJavaCodeStyleManager
extends JavaCodeStyleManager {
    @Override
    public boolean addImport(@NotNull PsiJavaFile file2, @NotNull PsiClass refClass) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "addImport"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "addImport"));
        }
        return false;
    }

    @Override
    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element, int flags) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "shortenClassReferences"));
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "shortenClassReferences"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public String getPrefixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "getPrefixByVariableKind"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "getPrefixByVariableKind"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getSuffixByVariableKind(@NotNull VariableKind variableKind) {
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "getSuffixByVariableKind"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "getSuffixByVariableKind"));
        }
        return "";
    }

    @Override
    public int findEntryIndex(@NotNull PsiImportStatementBase statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "findEntryIndex"));
        }
        return 0;
    }

    @Override
    public PsiElement shortenClassReferences(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "shortenClassReferences"));
        }
        return element;
    }

    @Override
    public void shortenClassReferences(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "shortenClassReferences"));
        }
    }

    @Override
    public void optimizeImports(@NotNull PsiFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "optimizeImports"));
        }
    }

    @Override
    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "prepareOptimizeImportsResult"));
        }
        return null;
    }

    @Override
    @NotNull
    public SuggestedNameInfo suggestVariableName(@NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type2, boolean correctKeywords) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "suggestVariableName"));
        }
        SuggestedNameInfo suggestedNameInfo = SuggestedNameInfo.NULL_INFO;
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "suggestVariableName"));
        }
        return suggestedNameInfo;
    }

    @Override
    @NotNull
    public String variableNameToPropertyName(@NotNull @NonNls String name, @NotNull VariableKind variableKind) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "variableNameToPropertyName"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "variableNameToPropertyName"));
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "variableNameToPropertyName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String propertyNameToVariableName(@NotNull @NonNls String propertyName, @NotNull VariableKind variableKind) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "propertyNameToVariableName"));
        }
        if (variableKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableKind", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "propertyNameToVariableName"));
        }
        String string = propertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "propertyNameToVariableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String suggestUniqueVariableName(@NotNull @NonNls String baseName, PsiElement place, boolean lookForward) {
        String name;
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        int index2 = 0;
        Object scope = PsiTreeUtil.getNonStrictParentOfType(place, PsiStatement.class, PsiCodeBlock.class, PsiMethod.class);
        block2: while (true) {
            name = baseName;
            if (index2 > 0) {
                name = name + index2;
            }
            ++index2;
            if (!PsiUtil.isVariableNameUnique(name, place)) continue;
            if (!lookForward) break;
            final String name1 = name;
            for (Object run2 = scope; run2 != null; run2 = run2.getNextSibling()) {
                class CancelException
                extends RuntimeException {
                    CancelException() {
                    }
                }
                try {
                    run2.accept(new JavaRecursiveElementWalkingVisitor(){

                        @Override
                        public void visitAnonymousClass(PsiAnonymousClass aClass2) {
                        }

                        @Override
                        public void visitVariable(PsiVariable variable) {
                            if (name1.equals(variable.getName())) {
                                throw new CancelException();
                            }
                        }
                    });
                    continue;
                }
                catch (CancelException e) {
                    continue block2;
                }
            }
            break;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(final @NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean ignorePlaceName, boolean lookForward) {
        if (baseNameInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNameInfo", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        String[] names2 = baseNameInfo.names;
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(names2.length);
        for (String name : names2) {
            String placeName;
            if (ignorePlaceName && place instanceof PsiNamedElement && Comparing.strEqual(placeName = ((PsiNamedElement)place).getName(), name)) {
                uniqueNames.add(name);
                continue;
            }
            uniqueNames.add(this.suggestUniqueVariableName(name, place, lookForward));
        }
        SuggestedNameInfo suggestedNameInfo = new SuggestedNameInfo(ArrayUtil.toStringArray(uniqueNames)){

            @Override
            public void nameChosen(String name) {
                baseNameInfo.nameChosen(name);
            }
        };
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        return suggestedNameInfo;
    }

    @Override
    @NotNull
    public PsiElement qualifyClassReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "qualifyClassReferences"));
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "qualifyClassReferences"));
        }
        return psiElement;
    }

    @Override
    public void removeRedundantImports(@NotNull PsiJavaFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "removeRedundantImports"));
        }
    }

    @Override
    public Collection<PsiImportStatementBase> findRedundantImports(@NotNull PsiJavaFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/core/CoreJavaCodeStyleManager", "findRedundantImports"));
        }
        return null;
    }
}

