/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.expression.StringTemplateTranslator;
import org.jetbrains.kotlin.js.translate.expression.TryTranslator;
import org.jetbrains.kotlin.js.translate.expression.WhenTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.UnaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public final class ExpressionVisitor
extends TranslatorVisitor<JsNode> {
    @Override
    protected JsNode emptyResult(@NotNull TranslationContext context) {
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(0);
        }
        return JsLiteral.NULL;
    }

    @Override
    @NotNull
    public JsNode visitConstantExpression(@NotNull KtConstantExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(2);
        }
        JsNode jsNode = ExpressionVisitor.translateConstantExpression(expression, context).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(3);
        }
        return jsNode;
    }

    @NotNull
    private static JsNode translateConstantExpression(@NotNull KtConstantExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(5);
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression, context.bindingContext());
        assert (compileTimeValue != null) : ErrorReportingUtils.message(expression, "Expression is not compile time value: " + expression.getText() + " ");
        JsExpression result2 = Translation.translateConstant(compileTimeValue, expression, context);
        if (result2 == null) {
            throw new AssertionError((Object)ErrorReportingUtils.message(expression, "Unsupported constant expression: " + expression.getText() + " "));
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(6);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitBlockExpression(@NotNull KtBlockExpression jetBlock, @NotNull TranslationContext context) {
        if (jetBlock == null) {
            ExpressionVisitor.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(8);
        }
        List<KtExpression> statements = jetBlock.getStatements();
        JsBlock jsBlock = new JsBlock();
        for (KtExpression statement : statements) {
            JsNode jsNode = Translation.translateExpression(statement, context, jsBlock);
            JsStatement jsStatement = JsAstUtils.convertToStatement(jsNode);
            if (JsAstUtils.isEmptyStatement(jsStatement)) continue;
            jsBlock.getStatements().add(jsStatement);
        }
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(9);
        }
        return jsBlock2;
    }

    @Override
    public JsNode visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull TranslationContext context) {
        if (multiDeclaration == null) {
            ExpressionVisitor.$$$reportNull$$$0(10);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(11);
        }
        KtExpression jetInitializer = multiDeclaration.getInitializer();
        assert (jetInitializer != null) : "Initializer for multi declaration must be not null";
        JsExpression initializer2 = Translation.translateAsExpression(jetInitializer, context);
        return DestructuringDeclarationTranslator.translate(multiDeclaration, context.scope().declareTemporary(), initializer2, context);
    }

    @Override
    @NotNull
    public JsNode visitReturnExpression(@NotNull KtReturnExpression jetReturnExpression, @NotNull TranslationContext context) {
        JsReturn jsReturn;
        if (jetReturnExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(12);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(13);
        }
        KtExpression returned = jetReturnExpression.getReturnedExpression();
        KtDeclarationWithBody parent2 = PsiTreeUtil.getParentOfType((PsiElement)jetReturnExpression, KtDeclarationWithBody.class);
        if (parent2 instanceof KtSecondaryConstructor) {
            JsNode jsNode = new JsReturn(new JsNameRef("$this")).source(jetReturnExpression);
            if (jsNode == null) {
                ExpressionVisitor.$$$reportNull$$$0(14);
            }
            return jsNode;
        }
        if (returned == null) {
            jsReturn = new JsReturn(null);
        } else {
            JsExpression jsReturnExpression = Translation.translateAsExpression(returned, context);
            KotlinType returnedType = context.bindingContext().getType(returned);
            assert (returnedType != null) : "Resolved return expression is expected to have type: " + PsiUtilsKt.getTextWithLocation(jetReturnExpression);
            if (KotlinBuiltIns.isCharOrNullableChar(returnedType) && TranslationUtils.shouldBoxReturnValue((CallableDescriptor)context.getDeclarationDescriptor())) {
                jsReturnExpression = JsAstUtils.charToBoxedChar(jsReturnExpression);
            }
            jsReturn = new JsReturn(jsReturnExpression);
        }
        MetadataProperties.setReturnTarget(jsReturn, ExpressionVisitor.getNonLocalReturnTarget(jetReturnExpression, context));
        JsNode jsNode = jsReturn.source(jetReturnExpression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(15);
        }
        return jsNode;
    }

    @Nullable
    private static FunctionDescriptor getNonLocalReturnTarget(@NotNull KtReturnExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(16);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(17);
        }
        DeclarationDescriptor descriptor2 = context.getDeclarationDescriptor();
        assert (descriptor2 instanceof CallableMemberDescriptor) : "Return expression can only be inside callable declaration: " + PsiUtilsKt.getTextWithLocation(expression);
        KtSimpleNameExpression target = expression.getTargetLabel();
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (target == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    return BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                }
            } else {
                PsiElement element = context.bindingContext().get(BindingContext.LABEL_TARGET, target);
                descriptor2 = context.bindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            }
        }
        assert (descriptor2 == null || descriptor2 instanceof FunctionDescriptor) : "Function descriptor expected to be target of return label: " + PsiUtilsKt.getTextWithLocation(expression);
        return (FunctionDescriptor)descriptor2;
    }

    @Override
    @NotNull
    public JsNode visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, @NotNull TranslationContext context) {
        KtExpression expressionInside;
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(18);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(19);
        }
        if ((expressionInside = expression.getExpression()) != null) {
            JsNode jsNode = Translation.translateExpression(expressionInside, context);
            if (jsNode == null) {
                ExpressionVisitor.$$$reportNull$$$0(20);
            }
            return jsNode;
        }
        JsEmpty jsEmpty = JsEmpty.INSTANCE;
        if (jsEmpty == null) {
            ExpressionVisitor.$$$reportNull$$$0(21);
        }
        return jsEmpty;
    }

    @Override
    @NotNull
    public JsNode visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(22);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(23);
        }
        JsExpression jsExpression = BinaryOperationTranslator.translate(expression, context);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(24);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitProperty(@NotNull KtProperty expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(25);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(26);
        }
        VariableDescriptor descriptor2 = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.VARIABLE, expression);
        JsExpression initializer2 = TranslationUtils.translateInitializerForProperty(expression, context);
        KtExpression delegateExpression = expression.getDelegateExpression();
        JsName name = context.getNameForDescriptor(descriptor2);
        if (delegateExpression != null) {
            initializer2 = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context, expression);
            assert (initializer2 != null) : "Initializer must be non-null for property with delegate";
        } else if (BindingContextUtils.isVarCapturedInClosure(context.bindingContext(), descriptor2)) {
            JsNameRef alias = Namer.getCapturedVarAccessor(name.makeRef());
            initializer2 = JsAstUtils.wrapValue(alias, initializer2 == null ? JsLiteral.NULL : initializer2);
        }
        JsNode jsNode = JsAstUtils.newVar(name, initializer2).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(27);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(28);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(29);
        }
        JsExpression jsExpression = CallableReferenceTranslator.INSTANCE.translate(expression, context);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(30);
        }
        return jsExpression;
    }

    @Override
    public JsNode visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(31);
        }
        KtExpression receiverExpression = expression.getReceiverExpression();
        assert (receiverExpression != null) : "Class literal expression should have a left-hand side";
        DoubleColonLHS lhs = context.bindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        assert (lhs != null) : "Class literal expression should have LHS resolved";
        if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
            JsExpression receiver = Translation.translateAsExpression(receiverExpression, context);
            KotlinType type2 = context.bindingContext().getType(receiverExpression);
            if (type2 != null && KotlinBuiltIns.isChar(type2)) {
                receiver = JsAstUtils.charToBoxedChar(receiver);
            }
            return new JsInvocation((JsExpression)context.namer().kotlin("getKClassFromExpression"), receiver);
        }
        return new JsInvocation((JsExpression)context.namer().kotlin("getKClass"), UtilsKt.getReferenceToJsClass(lhs.getType(), context));
    }

    @Override
    @NotNull
    public JsNode visitCallExpression(@NotNull KtCallExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(32);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(33);
        }
        JsNode jsNode = CallExpressionTranslator.translate(expression, null, context).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(34);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitIfExpression(@NotNull KtIfExpression expression, @NotNull TranslationContext context) {
        JsStatement elseStatement;
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(35);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(36);
        }
        assert (expression.getCondition() != null) : "condition should not ne null: " + expression.getText();
        JsExpression testExpression = Translation.translateAsExpression(expression.getCondition(), context);
        boolean isKotlinExpression = BindingContextUtilsKt.isUsedAsExpression(expression, context.bindingContext());
        KtExpression thenExpression = expression.getThen();
        KtExpression elseExpression = expression.getElse();
        JsStatement thenStatement = thenExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(thenExpression, context) : null;
        JsStatement jsStatement = elseStatement = elseExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(elseExpression, context) : null;
        if (isKotlinExpression) {
            boolean canBeJsExpression;
            JsExpression jsThenExpression = JsAstUtils.extractExpressionFromStatement(thenStatement);
            JsExpression jsElseExpression = JsAstUtils.extractExpressionFromStatement(elseStatement);
            boolean bl = canBeJsExpression = jsThenExpression != null && jsElseExpression != null;
            if (canBeJsExpression) {
                JsExpression jsExpression = new JsConditional(testExpression, jsThenExpression, jsElseExpression).source(expression);
                if (jsExpression == null) {
                    ExpressionVisitor.$$$reportNull$$$0(37);
                }
                return jsExpression;
            }
        }
        if (thenStatement == null) {
            thenStatement = JsEmpty.INSTANCE;
        }
        JsIf ifStatement = new JsIf(testExpression, thenStatement, elseStatement);
        JsNode jsNode = ifStatement.source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(38);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(39);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(40);
        }
        JsExpression jsExpression = ReferenceTranslator.translateSimpleName(expression, context).source(expression);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(41);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitWhileExpression(@NotNull KtWhileExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(42);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(43);
        }
        JsNode jsNode = LoopTranslator.createWhile(false, expression, context);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(44);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitDoWhileExpression(@NotNull KtDoWhileExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(45);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(46);
        }
        JsNode jsNode = LoopTranslator.createWhile(true, expression, context);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(47);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, @NotNull TranslationContext context) {
        JsStringLiteral stringLiteral;
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(48);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(49);
        }
        if ((stringLiteral = ExpressionVisitor.resolveAsStringConstant(expression, context)) != null) {
            JsStringLiteral jsStringLiteral = stringLiteral;
            if (jsStringLiteral == null) {
                ExpressionVisitor.$$$reportNull$$$0(50);
            }
            return jsStringLiteral;
        }
        JsNode jsNode = ExpressionVisitor.resolveAsTemplate(expression, context).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(51);
        }
        return jsNode;
    }

    @NotNull
    private static JsNode resolveAsTemplate(@NotNull KtStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(52);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(53);
        }
        JsExpression jsExpression = StringTemplateTranslator.translate(expression, context);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(54);
        }
        return jsExpression;
    }

    @Nullable
    private static JsStringLiteral resolveAsStringConstant(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        Object value;
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(55);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(56);
        }
        if ((value = BindingUtils.getCompileTimeValue(context.bindingContext(), expression)) == null) {
            return null;
        }
        assert (value instanceof String) : "Compile time constant template should be a String constant.";
        String constantString = (String)value;
        return context.program().getStringLiteral(constantString);
    }

    @Override
    @NotNull
    public JsNode visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(57);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(58);
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(59);
        }
        return jsNode;
    }

    @Override
    public JsNode visitLabeledExpression(@NotNull KtLabeledExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(60);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(61);
        }
        KtExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        if (BindingContextUtilsKt.isUsedAsExpression(expression, context.bindingContext())) {
            return Translation.translateAsExpression(baseExpression, context).source(expression);
        }
        JsScope scope = context.scope();
        assert (scope instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsFunctionScope functionScope = (JsFunctionScope)scope;
        String labelIdent = ExpressionVisitor.getReferencedName(expression.getTargetLabel());
        JsName labelName = functionScope.enterLabel(labelIdent);
        JsStatement baseStatement = Translation.translateAsStatement(baseExpression, context);
        functionScope.exitLabel();
        return new JsLabel(labelName, baseStatement).source(expression);
    }

    @Override
    @NotNull
    public JsNode visitPrefixExpression(@NotNull KtPrefixExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(62);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(63);
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context).source(expression);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(64);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitPostfixExpression(@NotNull KtPostfixExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(65);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(66);
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context).source(expression);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(67);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitIsExpression(@NotNull KtIsExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(68);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(69);
        }
        JsExpression jsExpression = Translation.patternTranslator(context).translateIsExpression(expression);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(70);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(71);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(72);
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(73);
        }
        return jsNode;
    }

    @Override
    @Nullable
    public JsNode visitWhenExpression(@NotNull KtWhenExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(74);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(75);
        }
        return WhenTranslator.translate(expression, context);
    }

    @Override
    @NotNull
    public JsNode visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(76);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(77);
        }
        JsExpression jsExpression = PatternTranslator.isCastExpression(expression) ? PatternTranslator.newInstance(context).translateCastExpression(expression) : Translation.translateAsExpression(expression.getLeft(), context);
        JsExpression jsExpression2 = jsExpression.source(expression);
        if (jsExpression2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(78);
        }
        return jsExpression2;
    }

    private static String getReferencedName(KtSimpleNameExpression expression) {
        return expression.getReferencedName().replaceAll("^@", "").replaceAll("(?:^`(.*)`$)", "$1");
    }

    private static JsNameRef getTargetLabel(KtExpressionWithLabel expression, TranslationContext context) {
        KtSimpleNameExpression labelElement = expression.getTargetLabel();
        if (labelElement == null) {
            return null;
        }
        String labelIdent = ExpressionVisitor.getReferencedName(labelElement);
        JsScope scope = context.scope();
        assert (scope instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsName labelName = ((JsFunctionScope)scope).findLabel(labelIdent);
        assert (labelName != null);
        return labelName.makeRef();
    }

    @Override
    @NotNull
    public JsNode visitBreakExpression(@NotNull KtBreakExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(79);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(80);
        }
        JsNode jsNode = new JsBreak(ExpressionVisitor.getTargetLabel(expression, context)).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(81);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitContinueExpression(@NotNull KtContinueExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(82);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(83);
        }
        JsNode jsNode = new JsContinue(ExpressionVisitor.getTargetLabel(expression, context)).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(84);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(85);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(86);
        }
        JsExpression jsExpression = new LiteralFunctionTranslator(context).translate(expression.getFunctionLiteral());
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(87);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitNamedFunction(@NotNull KtNamedFunction expression, @NotNull TranslationContext context) {
        boolean isExpression;
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(88);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(89);
        }
        JsExpression alias = new LiteralFunctionTranslator(context).translate(expression);
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression);
        JsNameRef nameRef = (JsNameRef)ReferenceTranslator.translateAsValueReference(descriptor2, context);
        assert (nameRef.getName() != null);
        if (InlineUtil.isInline(descriptor2)) {
            MetadataProperties.setStaticRef(nameRef.getName(), alias);
        }
        JsExpression result2 = (isExpression = BindingContextUtilsKt.isUsedAsExpression(expression, context.bindingContext())) ? alias : JsAstUtils.newVar(nameRef.getName(), alias);
        JsNode jsNode = result2.source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(90);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitThisExpression(@NotNull KtThisExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(91);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(92);
        }
        DeclarationDescriptor thisExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression.getInstanceReference());
        assert (thisExpression != null) : "This expression must reference a descriptor: " + expression.getText();
        JsExpression jsExpression = context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(thisExpression)).source(expression);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(93);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(94);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(95);
        }
        JsExpression jsExpression = AccessTranslationUtils.translateAsGet(expression, context);
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(96);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSuperExpression(@NotNull KtSuperExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(97);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(98);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression, context.bindingContext());
        JsExpression jsExpression = context.getDispatchReceiver((ReceiverParameterDescriptor)resolvedCall2.getResultingDescriptor());
        if (jsExpression == null) {
            ExpressionVisitor.$$$reportNull$$$0(99);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitForExpression(@NotNull KtForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(100);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(101);
        }
        JsNode jsNode = LoopTranslator.translateForExpression(expression, context).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(102);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitTryExpression(@NotNull KtTryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(103);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(104);
        }
        JsTry jsTry = new TryTranslator(expression, context).translate();
        if (jsTry == null) {
            ExpressionVisitor.$$$reportNull$$$0(105);
        }
        return jsTry;
    }

    @Override
    @NotNull
    public JsNode visitThrowExpression(@NotNull KtThrowExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(106);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(107);
        }
        KtExpression thrownExpression = expression.getThrownExpression();
        assert (thrownExpression != null) : "Thrown expression must not be null";
        JsNode jsNode = new JsThrow(Translation.translateAsExpression(thrownExpression, context)).source(expression);
        if (jsNode == null) {
            ExpressionVisitor.$$$reportNull$$$0(108);
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression, @NotNull TranslationContext context) {
        ResolvedCall<FunctionDescriptor> superCall;
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(109);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(110);
        }
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), expression.getObjectDeclaration());
        ExpressionVisitor.translateClassOrObject(expression.getObjectDeclaration(), descriptor2, context);
        JsExpression constructor = ReferenceTranslator.translateAsTypeReference(descriptor2, context);
        List<DeclarationDescriptor> closure = context.getClassOrConstructorClosure(descriptor2);
        ArrayList<JsExpression> closureArgs = new ArrayList<JsExpression>();
        if (closure != null) {
            for (DeclarationDescriptor capturedValue : closure) {
                closureArgs.add(context.getArgumentForClosureConstructor(capturedValue));
            }
        }
        if ((superCall = BindingUtils.getSuperCall(context.bindingContext(), expression.getObjectDeclaration())) != null) {
            closureArgs.addAll(CallArgumentTranslator.translate(superCall, null, context).getTranslateArguments());
        }
        JsNew jsNew = new JsNew(constructor, closureArgs);
        if (jsNew == null) {
            ExpressionVisitor.$$$reportNull$$$0(111);
        }
        return jsNew;
    }

    @Override
    public JsNode visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression, TranslationContext context) {
        if (expression == null) {
            ExpressionVisitor.$$$reportNull$$$0(112);
        }
        for (KtAnnotationEntry entry : expression.getAnnotationEntries()) {
            KtExpression baseExpression;
            KotlinRetention retention;
            ClassifierDescriptor classifierDescriptor;
            AnnotationDescriptor descriptor2 = context.bindingContext().get(BindingContext.ANNOTATION, entry);
            if (descriptor2 == null || (classifierDescriptor = descriptor2.getType().getConstructor().getDeclarationDescriptor()) == null || (retention = DescriptorUtilsKt.getAnnotationRetention(classifierDescriptor)) != KotlinRetention.SOURCE || (baseExpression = expression.getBaseExpression()) == null) continue;
            return baseExpression.accept(this, context);
        }
        return (JsNode)super.visitAnnotatedExpression(expression, context);
    }

    @Override
    public JsNode visitClass(@NotNull KtClass klass2, TranslationContext context) {
        if (klass2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(113);
        }
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), klass2);
        ExpressionVisitor.translateClassOrObject(klass2, descriptor2, context);
        return JsEmpty.INSTANCE;
    }

    @Override
    public JsNode visitTypeAlias(@NotNull KtTypeAlias typeAlias, TranslationContext data2) {
        if (typeAlias == null) {
            ExpressionVisitor.$$$reportNull$$$0(114);
        }
        return JsEmpty.INSTANCE;
    }

    private static void translateClassOrObject(@NotNull KtClassOrObject declaration, @NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        if (declaration == null) {
            ExpressionVisitor.$$$reportNull$$$0(115);
        }
        if (descriptor2 == null) {
            ExpressionVisitor.$$$reportNull$$$0(116);
        }
        if (context == null) {
            ExpressionVisitor.$$$reportNull$$$0(117);
        }
        JsScope scope = context.getScopeForDescriptor(descriptor2);
        TranslationContext classContext = context.innerWithUsageTracker(scope, descriptor2);
        ClassTranslator.translate(declaration, classContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 54: 
            case 59: 
            case 64: 
            case 67: 
            case 70: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 111: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 54: 
            case 59: 
            case 64: 
            case 67: 
            case 70: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 111: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 16: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 39: 
            case 42: 
            case 45: 
            case 48: 
            case 52: 
            case 55: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 79: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 109: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 54: 
            case 59: 
            case 64: 
            case 67: 
            case 70: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetBlock";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiDeclaration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetReturnExpression";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "visitConstantExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translateConstantExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBlockExpression";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "visitReturnExpression";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "visitParenthesizedExpression";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBinaryExpression";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "visitProperty";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "visitCallableReferenceExpression";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "visitCallExpression";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "visitIfExpression";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSimpleNameExpression";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "visitWhileExpression";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "visitDoWhileExpression";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "visitStringTemplateExpression";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsTemplate";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "visitDotQualifiedExpression";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPrefixExpression";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPostfixExpression";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "visitIsExpression";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSafeQualifiedExpression";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBreakExpression";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "visitContinueExpression";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "visitLambdaExpression";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "visitNamedFunction";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "visitThisExpression";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "visitArrayAccessExpression";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "visitSuperExpression";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "visitForExpression";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "visitTryExpression";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "visitThrowExpression";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "visitObjectLiteralExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "emptyResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 54: 
            case 59: 
            case 64: 
            case 67: 
            case 70: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 111: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateConstantExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitDestructuringDeclaration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNonLocalReturnTarget";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsTemplate";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsStringConstant";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "visitDotQualifiedExpression";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "visitPrefixExpression";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visitPostfixExpression";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "visitIsExpression";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "visitSafeQualifiedExpression";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeAlias";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "translateClassOrObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 51: 
            case 54: 
            case 59: 
            case 64: 
            case 67: 
            case 70: 
            case 73: 
            case 78: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 105: 
            case 108: 
            case 111: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

