/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @NotNull
    public static CompilerMessageLocation psiElementToMessageLocation(@Nullable PsiElement element) {
        if (element == null) {
            CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
            if (compilerMessageLocation == null) {
                MessageUtil.$$$reportNull$$$0(0);
            }
            return compilerMessageLocation;
        }
        PsiFile file2 = element.getContainingFile();
        CompilerMessageLocation compilerMessageLocation = MessageUtil.psiFileToMessageLocation(file2, "<no path>", DiagnosticUtils.getLineAndColumnInPsiFile(file2, element.getTextRange()));
        if (compilerMessageLocation == null) {
            MessageUtil.$$$reportNull$$$0(1);
        }
        return compilerMessageLocation;
    }

    @NotNull
    public static CompilerMessageLocation psiFileToMessageLocation(@NotNull PsiFile file2, @Nullable String defaultValue, @NotNull DiagnosticUtils.LineAndColumn lineAndColumn) {
        String path;
        VirtualFile virtualFile;
        if (file2 == null) {
            MessageUtil.$$$reportNull$$$0(2);
        }
        if (lineAndColumn == null) {
            MessageUtil.$$$reportNull$$$0(3);
        }
        if ((virtualFile = file2.getVirtualFile()) == null) {
            path = defaultValue;
        } else {
            path = virtualFile.getPath();
            if (virtualFile instanceof CoreLocalVirtualFile || virtualFile instanceof CoreJarVirtualFile) {
                path = FileUtil.toSystemDependentName(path);
            }
        }
        CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.create(path, lineAndColumn.getLine(), lineAndColumn.getColumn(), lineAndColumn.getLineContent());
        if (compilerMessageLocation == null) {
            MessageUtil.$$$reportNull$$$0(4);
        }
        return compilerMessageLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineAndColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "psiElementToMessageLocation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "psiFileToMessageLocation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToMessageLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

