/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;

public final class PatternBuilder {
    @NotNull
    private static final NamePredicate KOTLIN_NAME_PREDICATE = new NamePredicate("kotlin");
    @NotNull
    private static final Name KOTLIN_NAME = Name.identifier("Kotlin".toLowerCase());

    private PatternBuilder() {
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull NamePredicate checker, @NotNull String stringWithPattern) {
        if (checker == null) {
            PatternBuilder.$$$reportNull$$$0(0);
        }
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList(checker);
        checkers.addAll(PatternBuilder.parseFqNamesFromString(stringWithPattern));
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers, PatternBuilder.parseArgumentsFromString(stringWithPattern));
        if (descriptorPredicate == null) {
            PatternBuilder.$$$reportNull$$$0(2);
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern, @NotNull NamePredicate checker) {
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(3);
        }
        if (checker == null) {
            PatternBuilder.$$$reportNull$$$0(4);
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList(PatternBuilder.parseFqNamesFromString(stringWithPattern));
        checkers.add(checker);
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers);
        if (descriptorPredicate == null) {
            PatternBuilder.$$$reportNull$$$0(5);
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(6);
        }
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(PatternBuilder.parseFqNamesFromString(stringWithPattern), PatternBuilder.parseArgumentsFromString(stringWithPattern));
        if (descriptorPredicate == null) {
            PatternBuilder.$$$reportNull$$$0(7);
        }
        return descriptorPredicate;
    }

    @NotNull
    private static List<NamePredicate> parseFqNamesFromString(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(8);
        }
        stringWithPattern = PatternBuilder.getNamePatternFromString(stringWithPattern);
        String[] subPatterns = stringWithPattern.split("\\.");
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        for (String subPattern : subPatterns) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        ArrayList<NamePredicate> arrayList = checkers;
        if (arrayList == null) {
            PatternBuilder.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static List<NamePredicate> parseArgumentsFromString(@NotNull String stringWithPattern) {
        String[] subPatterns;
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(10);
        }
        if ((stringWithPattern = PatternBuilder.getArgumentsPatternFromString(stringWithPattern)) == null) {
            return null;
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        if (stringWithPattern.isEmpty()) {
            return checkers;
        }
        for (String subPattern : subPatterns = stringWithPattern.split("\\,")) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        return checkers;
    }

    @NotNull
    private static String getNamePatternFromString(@NotNull String stringWithPattern) {
        int left;
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(11);
        }
        if ((left = stringWithPattern.indexOf("(")) < 0) {
            String string = stringWithPattern;
            if (string == null) {
                PatternBuilder.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = stringWithPattern.substring(0, left);
        if (string == null) {
            PatternBuilder.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static String getArgumentsPatternFromString(@NotNull String stringWithPattern) {
        int left;
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(14);
        }
        if ((left = stringWithPattern.indexOf("(")) < 0) {
            return null;
        }
        int right = stringWithPattern.indexOf(")");
        assert (right == stringWithPattern.length() - 1) : "expected ')' at the end: " + stringWithPattern;
        return stringWithPattern.substring(left + 1, right);
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers) {
        if (checkers == null) {
            PatternBuilder.$$$reportNull$$$0(15);
        }
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers, null);
        if (descriptorPredicate == null) {
            PatternBuilder.$$$reportNull$$$0(16);
        }
        return descriptorPredicate;
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers, @Nullable List<NamePredicate> arguments2) {
        if (checkers == null) {
            PatternBuilder.$$$reportNull$$$0(17);
        }
        assert (!checkers.isEmpty());
        final ArrayList<NamePredicate> checkersWithPrefixChecker = Lists.newArrayList();
        if (!checkers.get(0).apply(KOTLIN_NAME)) {
            checkersWithPrefixChecker.add(KOTLIN_NAME_PREDICATE);
        }
        checkersWithPrefixChecker.addAll(checkers);
        assert (checkersWithPrefixChecker.size() > 1);
        final ArrayList<NamePredicate> argumentCheckers = arguments2 != null ? Lists.newArrayList(arguments2) : null;
        DescriptorPredicate descriptorPredicate = new DescriptorPredicate(){

            @Override
            public boolean apply(@Nullable FunctionDescriptor descriptor2) {
                assert (descriptor2 != null) : "argument for DescriptorPredicate.apply should not be null, checkers=" + checkersWithPrefixChecker;
                try {
                    return this.doApply(descriptor2);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            private boolean doApply(@NotNull FunctionDescriptor descriptor2) {
                List<Name> nameParts;
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((nameParts = DescriptorUtils.getFqName(descriptor2).pathSegments()).size() != checkersWithPrefixChecker.size()) {
                    return false;
                }
                return this.allNamePartsValid(nameParts) && this.checkAllArgumentsValidIfNeeded(descriptor2);
            }

            private boolean checkAllArgumentsValidIfNeeded(@NotNull FunctionDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (argumentCheckers != null) {
                    List<ValueParameterDescriptor> valueParameterDescriptors = descriptor2.getValueParameters();
                    if (valueParameterDescriptors.size() != argumentCheckers.size()) {
                        return false;
                    }
                    for (int i = 0; i < valueParameterDescriptors.size(); ++i) {
                        ValueParameterDescriptor valueParameterDescriptor = valueParameterDescriptors.get(i);
                        Name name = DescriptorUtilsKt.getNameIfStandardType(valueParameterDescriptor.getType());
                        NamePredicate namePredicate = (NamePredicate)argumentCheckers.get(i);
                        if (namePredicate.apply(name)) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean allNamePartsValid(@NotNull List<Name> nameParts) {
                if (nameParts == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (int i = 0; i < nameParts.size(); ++i) {
                    Name namePart = nameParts.get(i);
                    NamePredicate correspondingPredicate = (NamePredicate)checkersWithPrefixChecker.get(i);
                    if (correspondingPredicate.apply(namePart)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nameParts";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/js/patterns/PatternBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doApply";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkAllArgumentsValidIfNeeded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "allNamePartsValid";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (descriptorPredicate == null) {
            PatternBuilder.$$$reportNull$$$0(18);
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(NamePredicate ... checkers) {
        if (checkers == null) {
            PatternBuilder.$$$reportNull$$$0(19);
        }
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(Arrays.asList(checkers));
        if (descriptorPredicate == null) {
            PatternBuilder.$$$reportNull$$$0(20);
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicateImpl pattern(String ... names2) {
        if (names2 == null) {
            PatternBuilder.$$$reportNull$$$0(21);
        }
        DescriptorPredicateImpl descriptorPredicateImpl = new DescriptorPredicateImpl(names2);
        if (descriptorPredicateImpl == null) {
            PatternBuilder.$$$reportNull$$$0(22);
        }
        return descriptorPredicateImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringWithPattern";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/patterns/PatternBuilder";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/patterns/PatternBuilder";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "pattern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFqNamesFromString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePatternFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pattern";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseFqNamesFromString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseArgumentsFromString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNamePatternFromString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsPatternFromString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DescriptorPredicateImpl
    implements DescriptorPredicate {
        private final String[] names;
        private String receiverFqName;
        private boolean checkOverridden;

        public DescriptorPredicateImpl(String ... names2) {
            this.names = names2;
        }

        public DescriptorPredicateImpl isExtensionOf(String receiverFqName) {
            this.receiverFqName = receiverFqName;
            return this;
        }

        public DescriptorPredicateImpl checkOverridden() {
            this.checkOverridden = true;
            return this;
        }

        private boolean matches(@NotNull CallableDescriptor callable) {
            if (callable == null) {
                DescriptorPredicateImpl.$$$reportNull$$$0(0);
            }
            DeclarationDescriptor descriptor2 = callable;
            int nameIndex = this.names.length - 1;
            do {
                if (nameIndex == -1) {
                    return false;
                }
                if (!descriptor2.getName().asString().equals(this.names[nameIndex])) {
                    return false;
                }
                --nameIndex;
            } while (!((descriptor2 = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor));
            return nameIndex == 0 && this.names[0].equals(((PackageFragmentDescriptor)descriptor2).getFqName().asString());
        }

        @Override
        public boolean apply(@Nullable FunctionDescriptor functionDescriptor) {
            assert (functionDescriptor != null) : "argument for DescriptorPredicate.apply should not be null, receiverFqName=" + this.receiverFqName + " names=" + Arrays.asList(this.names);
            ReceiverParameterDescriptor actualReceiver = functionDescriptor.getExtensionReceiverParameter();
            if (actualReceiver != null) {
                if (this.receiverFqName == null) {
                    return false;
                }
                String actualReceiverFqName = DescriptorUtilsKt.getJetTypeFqName(actualReceiver.getType(), false);
                if (!actualReceiverFqName.equals(this.receiverFqName)) {
                    return false;
                }
            }
            if (!(functionDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                return this.matches(functionDescriptor);
            }
            for (CallableMemberDescriptor callableMemberDescriptor : OverridingUtil.getOverriddenDeclarations(functionDescriptor)) {
                if (!this.matches(callableMemberDescriptor)) continue;
                return true;
            }
            if (this.checkOverridden) {
                for (CallableDescriptor callableDescriptor : DescriptorUtils.getAllOverriddenDescriptors(functionDescriptor)) {
                    if (!this.matches(callableDescriptor)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/js/patterns/PatternBuilder$DescriptorPredicateImpl", "matches"));
        }
    }
}

