/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Factory;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentHashSet;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentIntObjectHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentIntObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentList;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentLongObjectHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentLongObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentSoftHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentSoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakValueIntObjectHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.containers.Convertor;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.FilteringIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.THashSet;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

public class ContainerUtil
extends ContainerUtilRt {
    private static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(16, Runtime.getRuntime().availableProcessors());
    private static final ConcurrentMapFactory V8_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap() {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }
    };
    private static final ConcurrentMapFactory PLATFORM_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap() {
            ConcurrentMap<T, V> concurrentMap = this.createMap(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL);
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            return concurrentMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            java.util.concurrent.ConcurrentHashMap concurrentHashMap = new java.util.concurrent.ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            if (hashingStrategy != ContainerUtil.canonicalStrategy()) {
                throw new UnsupportedOperationException("Custom hashStrategy is not supported in java.util.concurrent.ConcurrentHashMap");
            }
            ConcurrentMap<T, V> concurrentMap = this.createMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$21", "createMap"));
            }
            return concurrentMap;
        }
    };
    private static final ConcurrentMapFactory CHM_FACTORY = SystemInfo.isOracleJvm || SystemInfo.isSunJvm || SystemInfo.isAppleJvm || ContainerUtil.isAtLeastJava7() ? V8_MAP_FACTORY : PLATFORM_MAP_FACTORY;

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = ContainerUtilRt.newHashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap();
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        THashMap tHashMap = new THashMap(strategy);
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveMap"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "canonicalStrategy"));
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "identityStrategy"));
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        if (identityHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newIdentityHashMap"));
        }
        return identityHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = ContainerUtilRt.newLinkedList();
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newLinkedList"));
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        ArrayList<E> arrayList = ContainerUtilRt.newArrayList(array);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithCapacity(size);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newArrayListWithCapacity"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        AbstractList abstractList = new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index2) {
                if (index2 < 0 || index2 >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index2 + " size:" + this.size);
                }
                return elements[start + index2];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newSmartList"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T element) {
        SmartList<T> smartList = new SmartList<T>(element);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newSmartList"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = ContainerUtilRt.newHashSet();
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        HashSet<T> hashSet = ContainerUtilRt.newHashSet(elements);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterable);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        Set<Object> set = empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newHashOrEmptySet"));
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = ContainerUtilRt.newLinkedHashSet();
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        LinkedHashSet<? extends T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet<T> tHashSet = new THashSet<T>(strategy);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet<T> tHashSet = ContainerUtil.newTroveSet(Arrays.asList(elements));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet<T> tHashSet = new THashSet<T>(Arrays.asList(elements), strategy);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        THashSet<T> tHashSet = new THashSet<T>(elements);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        THashSet tHashSet = new THashSet(ContainerUtil.identityStrategy());
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newIdentityTroveSet"));
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        THashMap tHashMap = new THashMap(ContainerUtil.identityStrategy());
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newIdentityTroveMap"));
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        ConcurrentHashSet concurrentHashSet = new ConcurrentHashSet();
        if (concurrentHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newConcurrentSet"));
        }
        return concurrentHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        ConcurrentMap concurrentMap = CHM_FACTORY.createMap();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return concurrentMap;
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashStrategy) {
        if (hashStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashStrategy", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "reverse"));
        }
        if (elements.isEmpty()) {
            List list2 = ContainerUtilRt.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "reverse"));
            }
            return list2;
        }
        AbstractList abstractList = new AbstractList<E>(){

            @Override
            public E get(int index2) {
                return elements.get(elements.size() - 1 - index2);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "reverse"));
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "immutableSet"));
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "immutableSet"));
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "immutableSet"));
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(new THashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "immutableSet"));
        }
        return set;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (appendix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appendix", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    public static <K, V> Map<K, V> newMapFromKeys(@NotNull Iterator<K> keys2, @NotNull Convertor<K, V> valueConvertor) {
        if (keys2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newMapFromKeys"));
        }
        if (valueConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueConvertor", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newMapFromKeys"));
        }
        HashMap<K, V> map2 = ContainerUtil.newHashMap();
        while (keys2.hasNext()) {
            K key = keys2.next();
            map2.put(key, valueConvertor.convert(key));
        }
        HashMap<K, V> hashMap = map2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newMapFromKeys"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> emptyIterator() {
        EmptyIterator emptyIterator = EmptyIterator.getInstance();
        if (emptyIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "emptyIterator"));
        }
        return emptyIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> emptyIterable() {
        EmptyIterable emptyIterable = EmptyIterable.getInstance();
        if (emptyIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "emptyIterable"));
        }
        return emptyIterable;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "find"));
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<T> processor) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "process"));
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list2, @NotNull Processor<T> processor) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "process"));
        }
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            T t = list2.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "process"));
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<V> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "find"));
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<V> iterator2, @NotNull Condition<T> condition) {
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "find"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "find"));
        }
        while (iterator2.hasNext()) {
            V value = iterator2.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? super V> aClass2, @NotNull Function<T, V> mapper) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass2, mapper);
        if (VArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? super V> aClass2, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        List<V> list2 = ContainerUtil.map2List(collection, mapper);
        Object[] array = (Object[])Array.newInstance(aClass2, list2.size());
        Object[] objectArray = list2.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2Array"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "filter"));
        }
        List<? super T> list2 = ContainerUtil.findAll(collection, condition);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "filter"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "filter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "filter"));
        }
        List<? super T> list2 = ContainerUtil.findAll(collection, condition);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "filter"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (collection.isEmpty()) {
            List<T> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAll"));
            }
            return list2;
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "skipNulls"));
        }
        List<Object> list2 = ContainerUtil.findAll(collection, Condition.NOT_NULL);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "skipNulls"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        if (instanceOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceOf", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        List<Object> list2 = ContainerUtil.findAll(collection, instanceOf);
        if (list2.size() == collection.length) {
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
            }
            return collection;
        }
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list2.size());
        Object[] objectArray = list2.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findAllAsArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        if (arrays == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrays", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        Iterable<? super T> iterable = ContainerUtil.iterate(Arrays.asList(arrays), condition);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        if (collection.isEmpty()) {
            Iterable<T> iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "iterate"));
            }
            return iterable;
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator2 = new Iterator<T>(){
                    private final Iterator<? extends T> impl;
                    private T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result2 = this.next;
                        this.next = this.findNext();
                        return result2;
                    }

                    @Nullable
                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$7", "iterator"));
                }
                return iterator2;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "iterate"));
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list2, int index1, int index2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "swapElements"));
        }
        E e1 = list2.get(index1);
        E e2 = list2.get(index2);
        list2.set(index1, e2);
        list2.set(index2, e1);
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (enumeration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeration", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        return c;
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, A ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        for (A element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addAllNotNull"));
        }
        return c;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<T> iterable, @NotNull Class<U> aClass2) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass2);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<T> iterator2, @NotNull Class<U> aClass2) {
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "findInstance"));
        }
        return (U)ContainerUtil.find(iterator2, FilteringIterator.instanceOf(aClass2));
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<V, Collection<? extends T>> fun) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        List<? extends T> list2 = ContainerUtil.concat(Arrays.asList(array), fun);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
            }
            return list3;
        }
        if (list1.isEmpty()) {
            List<T> list4 = list2;
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
            }
            return list4;
        }
        if (list2.isEmpty()) {
            List<T> list5 = list1;
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
            }
            return list5;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 < size1) {
                    return list1.get(index2);
                }
                return list2.get(index2 - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull Iterable<? extends V> list2, @NotNull Function<V, Collection<? extends T>> listGenerator) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        if (listGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listGenerator", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (V v : list2) {
            result2.addAll(listGenerator.fun(v));
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "concat"));
        }
        return list3;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection1", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "intersects"));
        }
        if (collection2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection2", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "intersects"));
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<T> iterator2, final @NotNull Function<T, U> mapper) {
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapIterator"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapIterator"));
        }
        Iterator iterator3 = new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
        if (iterator3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapIterator"));
        }
        return iterator3;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list2, @Nullable T def) {
        return ContainerUtil.isEmpty(list2) ? def : list2.get(list2.size() - 1);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list2) {
        return ContainerUtil.getLastItem(list2, null);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<T> factory2) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = c != null ? c.toArray(factory2.create(c.size())) : factory2.create(0);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    public static <T> void sort(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "sort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "sort"));
        }
        int size = list2.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list2.get(0);
            if (comparator.compare(t0, t1 = list2.get(1)) > 0) {
                list2.set(0, t1);
                list2.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list2.get(i);
                    if (comparator.compare(ti, tj = list2.get(j)) >= 0) continue;
                    list2.set(i, tj);
                    list2.set(j, ti);
                }
            }
        } else {
            Collections.sort(list2, comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping2) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map"));
        }
        List<V> list2 = ContainerUtilRt.map2List(iterable, mapping2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<T, V> mapping2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (mapping2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        List<V> list2 = ContainerUtil.mapNotNull(Arrays.asList(array), mapping2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping2) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (mapping2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        if (iterable.isEmpty()) {
            List<T> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapNotNull"));
            }
            return list2;
        }
        ArrayList<T> result2 = new ArrayList<T>(iterable.size());
        for (T t : iterable) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "mapNotNull"));
        }
        return list3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<T, V> mapping2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map"));
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list2 = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createMaybeSingletonList"));
        }
        return list2;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull Factory<V> factory2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "getOrCreate"));
        }
        V value = result2.get(key);
        if (value == null) {
            value = factory2.create();
            result2.put(key, value);
        }
        return value;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "and"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "and"));
        }
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "and"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "and"));
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> void quickSort(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        ContainerUtil.quickSort(list2, comparator, 0, list2.size());
    }

    private static <T> void quickSort(@NotNull List<T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "quickSort"));
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "med3"));
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<E>> collections) {
        if (collections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collections", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "flatten"));
        }
        ArrayList result2 = new ArrayList();
        for (Collection<E> list2 : collections) {
            result2.addAll(list2);
        }
        List list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "flatten"));
        }
        return list3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = ContainerUtilRt.newStack();
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "newStack"));
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list2 = ContainerUtilRt.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "emptyList"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        ConcurrentList<T> concurrentList = ContainerUtil.createConcurrentList();
        if (concurrentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createLockFreeCopyOnWriteList"));
        }
        return concurrentList;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap();
        if (concurrentIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentIntObjectMap"));
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap();
        if (concurrentLongObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentLongObjectMap"));
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        ConcurrentWeakValueHashMap concurrentWeakValueHashMap = new ConcurrentWeakValueHashMap();
        if (concurrentWeakValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentWeakValueMap"));
        }
        return concurrentWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        ConcurrentWeakValueIntObjectHashMap concurrentWeakValueIntObjectHashMap = new ConcurrentWeakValueIntObjectHashMap();
        if (concurrentWeakValueIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentIntObjectWeakValueMap"));
        }
        return concurrentWeakValueIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeySoftValueMap"));
        }
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakKeySoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeySoftValueMap"));
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeySoftValueMap"));
        }
        return concurrentMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeyWeakValueMap"));
        }
        return concurrentMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeyWeakValueMap"));
        }
        ConcurrentWeakKeyWeakValueHashMap concurrentWeakKeyWeakValueHashMap = new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
        if (concurrentWeakKeyWeakValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeyWeakValueMap"));
        }
        return concurrentWeakKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentSoftValueHashMap concurrentSoftValueHashMap = new ConcurrentSoftValueHashMap();
        if (concurrentSoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentSoftValueMap"));
        }
        return concurrentSoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        ConcurrentSoftHashMap concurrentSoftHashMap = new ConcurrentSoftHashMap();
        if (concurrentSoftHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentSoftMap"));
        }
        return concurrentSoftHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap();
        if (concurrentWeakHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentWeakMap"));
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "createConcurrentList"));
        }
        return lockFreeCopyOnWriteArrayList;
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result2, @Nullable T element) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "addIfNotNull"));
        }
        ContainerUtilRt.addIfNotNull(result2, element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        List<V> list2 = ContainerUtilRt.map2List(collection, mapper);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "map2List"));
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = ContainerUtilRt.toArray(collection, array);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        if (sample == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        T[] TArray = ContainerUtilRt.toArray(c, sample);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "toArray"));
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory2, boolean clear) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        int size = collection.size();
        T[] a = factory2.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "copyAndClear"));
        }
        return a;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    private static boolean isAtLeastJava7() {
        return StringUtil.compareVersionNumbers(SystemInfo.JAVA_VERSION, "1.7") >= 0;
    }

    @Contract(pure=true)
    public static <T extends Comparable<T>> int compareLexicographically(@NotNull List<T> o1, @NotNull List<T> o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "compareLexicographically"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil", "compareLexicographically"));
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result2 = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result2 == 0) continue;
            return result2;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    private static interface ConcurrentMapFactory {
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap();

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3);

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3, @NotNull TObjectHashingStrategy<T> var4);
    }
}

