/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.pom.java;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreBundle;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public enum LanguageLevel {
    JDK_1_3("Java 1.3", JavaCoreBundle.message("jdk.1.3.language.level.description", new Object[0]), "1.3", new String[0]),
    JDK_1_4("Java 1.4", JavaCoreBundle.message("jdk.1.4.language.level.description", new Object[0]), "1.4", new String[0]),
    JDK_1_5("Java 5.0", JavaCoreBundle.message("jdk.1.5.language.level.description", new Object[0]), "1.5", "5"),
    JDK_1_6("Java 6", JavaCoreBundle.message("jdk.1.6.language.level.description", new Object[0]), "1.6", "6"),
    JDK_1_7("Java 7", JavaCoreBundle.message("jdk.1.7.language.level.description", new Object[0]), "1.7", "7"),
    JDK_1_8("Java 8", JavaCoreBundle.message("jdk.1.8.language.level.description", new Object[0]), "1.8", "8"),
    JDK_1_9("Java 9", JavaCoreBundle.message("jdk.1.9.language.level.description", new Object[0]), "1.9", "9"),
    JDK_X("Java X", JavaCoreBundle.message("jdk.X.language.level.description", new Object[0]), "", new String[0]);

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final String myName;
    private final String myPresentableText;
    private final String myCompilerComplianceDefaultOption;
    private final String[] myCompilerComplianceOptionVariants;

    private LanguageLevel(@NotNull String name, @NotNull @Nls String presentableText, @NotNull String compilerComplianceDefaultOption, String ... compilerComplianceAlternativeOptions) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableText", "org/jetbrains/kotlin/com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        if (compilerComplianceDefaultOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerComplianceDefaultOption", "org/jetbrains/kotlin/com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        if (compilerComplianceAlternativeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerComplianceAlternativeOptions", "org/jetbrains/kotlin/com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        this.myName = name;
        this.myPresentableText = presentableText;
        this.myCompilerComplianceDefaultOption = compilerComplianceDefaultOption;
        this.myCompilerComplianceOptionVariants = ArrayUtil.prepend(compilerComplianceDefaultOption, compilerComplianceAlternativeOptions);
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/kotlin/com/intellij/pom/java/LanguageLevel", "isAtLeast"));
        }
        return this.compareTo(level) >= 0;
    }

    static {
        HIGHEST = JDK_1_8;
        KEY = Key.create("LANGUAGE_LEVEL");
    }
}

