/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegen;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ParametersBuilder;
import org.jetbrains.kotlin.codegen.inline.PropertyReferenceInfo;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class LambdaInfo
implements LabelOwner {
    public final KtExpression expression;
    private final KotlinTypeMapper typeMapper;
    public final Set<String> labels;
    private final CalculatedClosure closure;
    public final boolean isCrossInline;
    private final FunctionDescriptor functionDescriptor;
    private final ClassDescriptor classDescriptor;
    private final Type closureClassType;
    private SMAPAndMethodNode node;
    private List<CapturedParamDesc> capturedVars;
    private final boolean isBoundCallableReference;
    private final PropertyReferenceInfo propertyReferenceInfo;

    public LambdaInfo(@NotNull KtExpression expression, @NotNull KotlinTypeMapper typeMapper, boolean isCrossInline, boolean isBoundCallableReference) {
        if (expression == null) {
            LambdaInfo.$$$reportNull$$$0(0);
        }
        if (typeMapper == null) {
            LambdaInfo.$$$reportNull$$$0(1);
        }
        this.isCrossInline = isCrossInline;
        this.expression = expression instanceof KtLambdaExpression ? ((KtLambdaExpression)expression).getFunctionLiteral() : expression;
        this.typeMapper = typeMapper;
        this.isBoundCallableReference = isBoundCallableReference;
        BindingContext bindingContext = typeMapper.getBindingContext();
        FunctionDescriptor function2 = bindingContext.get(BindingContext.FUNCTION, this.expression);
        if (function2 == null && expression instanceof KtCallableReferenceExpression) {
            VariableDescriptor variableDescriptor = bindingContext.get(BindingContext.VARIABLE, this.expression);
            assert (variableDescriptor instanceof VariableDescriptorWithAccessors) : "Reference expression not resolved to variable descriptor with accessors: " + expression.getText();
            this.classDescriptor = CodegenBinding.anonymousClassForCallable(bindingContext, variableDescriptor);
            this.closureClassType = typeMapper.mapClass(this.classDescriptor);
            SimpleFunctionDescriptor getFunction = PropertyReferenceCodegen.findGetFunction(variableDescriptor);
            this.functionDescriptor = PropertyReferenceCodegen.createFakeOpenDescriptor(getFunction, this.classDescriptor);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(((KtCallableReferenceExpression)expression).getCallableReference(), bindingContext);
            this.propertyReferenceInfo = new PropertyReferenceInfo((VariableDescriptor)resolvedCall2.getResultingDescriptor(), getFunction);
        } else {
            this.propertyReferenceInfo = null;
            this.functionDescriptor = function2;
            assert (this.functionDescriptor != null) : "Function is not resolved to descriptor: " + expression.getText();
            this.classDescriptor = CodegenBinding.anonymousClassForCallable(bindingContext, this.functionDescriptor);
            this.closureClassType = CodegenBinding.asmTypeForAnonymousClass(bindingContext, this.functionDescriptor);
        }
        this.closure = bindingContext.get(CodegenBinding.CLOSURE, this.classDescriptor);
        assert (this.closure != null) : "Closure for lambda should be not null " + expression.getText();
        this.labels = InlineCodegen.getDeclarationLabels(expression, this.functionDescriptor);
    }

    @NotNull
    public SMAPAndMethodNode getNode() {
        SMAPAndMethodNode sMAPAndMethodNode = this.node;
        if (sMAPAndMethodNode == null) {
            LambdaInfo.$$$reportNull$$$0(2);
        }
        return sMAPAndMethodNode;
    }

    public void setNode(@NotNull SMAPAndMethodNode node) {
        if (node == null) {
            LambdaInfo.$$$reportNull$$$0(3);
        }
        this.node = node;
    }

    @NotNull
    public FunctionDescriptor getFunctionDescriptor() {
        FunctionDescriptor functionDescriptor = this.functionDescriptor;
        if (functionDescriptor == null) {
            LambdaInfo.$$$reportNull$$$0(4);
        }
        return functionDescriptor;
    }

    @NotNull
    public KtExpression getFunctionWithBodyOrCallableReference() {
        KtExpression ktExpression = this.expression;
        if (ktExpression == null) {
            LambdaInfo.$$$reportNull$$$0(5);
        }
        return ktExpression;
    }

    @NotNull
    public ClassDescriptor getClassDescriptor() {
        ClassDescriptor classDescriptor = this.classDescriptor;
        if (classDescriptor == null) {
            LambdaInfo.$$$reportNull$$$0(6);
        }
        return classDescriptor;
    }

    @NotNull
    public Type getLambdaClassType() {
        Type type2 = this.closureClassType;
        if (type2 == null) {
            LambdaInfo.$$$reportNull$$$0(7);
        }
        return type2;
    }

    @NotNull
    public List<CapturedParamDesc> getCapturedVars() {
        if (this.capturedVars == null) {
            EnclosedValueDescriptor descriptor22;
            Type type2;
            this.capturedVars = new ArrayList<CapturedParamDesc>();
            if (this.closure.getCaptureThis() != null) {
                type2 = this.typeMapper.mapType(this.closure.getCaptureThis());
                descriptor22 = new EnclosedValueDescriptor("this$0", null, StackValue.field(type2, this.closureClassType, "this$0", false, StackValue.LOCAL_0), type2);
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
            if (this.closure.getCaptureReceiverType() != null) {
                type2 = this.typeMapper.mapType(this.closure.getCaptureReceiverType());
                descriptor22 = new EnclosedValueDescriptor("receiver$0", null, StackValue.field(type2, this.closureClassType, "receiver$0", false, StackValue.LOCAL_0), type2);
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
            for (EnclosedValueDescriptor descriptor22 : this.closure.getCaptureVariables().values()) {
                this.capturedVars.add(this.getCapturedParamInfo(descriptor22));
            }
        }
        List<CapturedParamDesc> list2 = this.capturedVars;
        if (list2 == null) {
            LambdaInfo.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    private CapturedParamDesc getCapturedParamInfo(@NotNull EnclosedValueDescriptor descriptor2) {
        if (descriptor2 == null) {
            LambdaInfo.$$$reportNull$$$0(9);
        }
        CapturedParamDesc capturedParamDesc = new CapturedParamDesc(this.closureClassType, descriptor2.getFieldName(), descriptor2.getType());
        if (capturedParamDesc == null) {
            LambdaInfo.$$$reportNull$$$0(10);
        }
        return capturedParamDesc;
    }

    @NotNull
    public List<Type> getInvokeParamsWithoutCaptured() {
        List<Type> list2 = Arrays.asList(this.typeMapper.mapAsmMethod(this.functionDescriptor).getArgumentTypes());
        if (list2 == null) {
            LambdaInfo.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    public Parameters addAllParameters(@NotNull FieldRemapper remapper) {
        if (remapper == null) {
            LambdaInfo.$$$reportNull$$$0(12);
        }
        Method asmMethod = this.typeMapper.mapAsmMethod(this.getFunctionDescriptor());
        ParametersBuilder builder = ParametersBuilder.initializeBuilderFrom(AsmTypes.OBJECT_TYPE, asmMethod.getDescriptor(), this);
        for (CapturedParamDesc info : this.getCapturedVars()) {
            CapturedParamInfo field = remapper.findField(new FieldInsnNode(0, info.getContainingLambdaName(), info.getFieldName(), ""));
            assert (field != null) : "Captured field not found: " + info.getContainingLambdaName() + "." + info.getFieldName();
            builder.addCapturedParam(field, info.getFieldName());
        }
        Parameters parameters2 = builder.buildParameters();
        if (parameters2 == null) {
            LambdaInfo.$$$reportNull$$$0(13);
        }
        return parameters2;
    }

    @Override
    public boolean isMyLabel(@NotNull String name) {
        if (name == null) {
            LambdaInfo.$$$reportNull$$$0(14);
        }
        return this.labels.contains(name);
    }

    public boolean isBoundCallableReference() {
        return this.isBoundCallableReference;
    }

    public boolean isPropertyReference() {
        return this.propertyReferenceInfo != null;
    }

    public PropertyReferenceInfo getPropertyReferenceInfo() {
        return this.propertyReferenceInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/inline/LambdaInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remapper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/LambdaInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionWithBodyOrCallableReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLambdaClassType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedVars";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedParamInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvokeParamsWithoutCaptured";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedParamInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addAllParameters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMyLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

