/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.binding.CodegenAnnotatingVisitor;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.util.slicedMap.BasicWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.org.objectweb.asm.Type;

public class CodegenBinding {
    public static final WritableSlice<ClassDescriptor, MutableClosure> CLOSURE = Slices.createSimpleSlice();
    public static final WritableSlice<CallableDescriptor, ClassDescriptor> CLASS_FOR_CALLABLE = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Type> ASM_TYPE = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Boolean> ENUM_ENTRY_CLASS_NEED_SUBCLASS = Slices.createSimpleSetSlice();
    public static final WritableSlice<ClassDescriptor, Collection<ClassDescriptor>> INNER_CLASSES = Slices.createSimpleSlice();
    public static final WritableSlice<KtExpression, SamType> SAM_VALUE = Slices.createSimpleSlice();
    public static final WritableSlice<KtCallElement, KtExpression> SAM_CONSTRUCTOR_TO_ARGUMENT = Slices.createSimpleSlice();
    public static final WritableSlice<KtWhenExpression, WhenByEnumsMapping> MAPPING_FOR_WHEN_BY_ENUM = Slices.createSimpleSlice();
    public static final WritableSlice<String, List<WhenByEnumsMapping>> MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE = Slices.createSimpleSlice();
    public static final WritableSlice<VariableDescriptor, VariableDescriptor> LOCAL_VARIABLE_DELEGATE = Slices.createSimpleSlice();
    public static final WritableSlice<VariableDescriptor, VariableDescriptor> LOCAL_VARIABLE_PROPERTY_METADATA = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, FunctionDescriptor> SUSPEND_FUNCTION_TO_JVM_VIEW = Slices.createSimpleSlice();
    public static final WritableSlice<ValueParameterDescriptor, ValueParameterDescriptor> PARAMETER_SYNONYM = Slices.createSimpleSlice();

    private CodegenBinding() {
    }

    public static void initTrace(@NotNull GenerationState state2) {
        if (state2 == null) {
            CodegenBinding.$$$reportNull$$$0(0);
        }
        CodegenAnnotatingVisitor visitor2 = new CodegenAnnotatingVisitor(state2);
        for (KtFile file2 : CodegenBinding.allFilesInPackages(state2.getBindingContext(), state2.getFiles())) {
            file2.accept(visitor2);
        }
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, KtEnumEntry enumEntry) {
        return CodegenBinding.enumEntryNeedSubclass(bindingContext, bindingContext.get(BindingContext.CLASS, enumEntry));
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, ClassDescriptor classDescriptor) {
        return Boolean.TRUE.equals(bindingContext.get(ENUM_ENTRY_CLASS_NEED_SUBCLASS, classDescriptor));
    }

    @NotNull
    public static ClassDescriptor anonymousClassForCallable(@NotNull BindingContext bindingContext, @NotNull CallableDescriptor descriptor2) {
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            CodegenBinding.$$$reportNull$$$0(2);
        }
        ClassDescriptor classDescriptor = bindingContext.get(CLASS_FOR_CALLABLE, descriptor2);
        if (classDescriptor == null) {
            CodegenBinding.$$$reportNull$$$0(3);
        }
        return classDescriptor;
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull KtElement expression) {
        ClassDescriptor descriptor2;
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            CodegenBinding.$$$reportNull$$$0(5);
        }
        if (expression instanceof KtObjectLiteralExpression) {
            expression = ((KtObjectLiteralExpression)expression).getObjectDeclaration();
        }
        if ((descriptor2 = bindingContext.get(BindingContext.CLASS, expression)) != null) {
            Type type2 = CodegenBinding.getAsmType(bindingContext, descriptor2);
            if (type2 == null) {
                CodegenBinding.$$$reportNull$$$0(6);
            }
            return type2;
        }
        SimpleFunctionDescriptor functionDescriptor = bindingContext.get(BindingContext.FUNCTION, expression);
        if (functionDescriptor != null) {
            Type type3 = CodegenBinding.asmTypeForAnonymousClass(bindingContext, functionDescriptor);
            if (type3 == null) {
                CodegenBinding.$$$reportNull$$$0(7);
            }
            return type3;
        }
        VariableDescriptor variableDescriptor = bindingContext.get(BindingContext.VARIABLE, expression);
        if (variableDescriptor != null) {
            Type type4 = CodegenBinding.asmTypeForAnonymousClass(bindingContext, variableDescriptor);
            if (type4 == null) {
                CodegenBinding.$$$reportNull$$$0(8);
            }
            return type4;
        }
        throw new IllegalStateException("Couldn't compute ASM type for " + PsiUtilsKt.getElementTextWithContext(expression));
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull CallableDescriptor descriptor2) {
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            CodegenBinding.$$$reportNull$$$0(10);
        }
        Type type2 = CodegenBinding.getAsmType(bindingContext, CodegenBinding.anonymousClassForCallable(bindingContext, descriptor2));
        if (type2 == null) {
            CodegenBinding.$$$reportNull$$$0(11);
        }
        return type2;
    }

    public static boolean canHaveOuter(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor classDescriptor) {
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(12);
        }
        if (classDescriptor == null) {
            CodegenBinding.$$$reportNull$$$0(13);
        }
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            return false;
        }
        MutableClosure closure = bindingContext.get(CLOSURE, classDescriptor);
        if (closure == null || closure.getEnclosingClass() == null) {
            return false;
        }
        return classDescriptor.isInner() || !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor);
    }

    @NotNull
    static MutableClosure recordClosure(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @Nullable ClassDescriptor enclosing, @NotNull Type asmType, @NotNull JvmFileClassesProvider fileClassesManager) {
        if (trace == null) {
            CodegenBinding.$$$reportNull$$$0(14);
        }
        if (classDescriptor == null) {
            CodegenBinding.$$$reportNull$$$0(15);
        }
        if (asmType == null) {
            CodegenBinding.$$$reportNull$$$0(16);
        }
        if (fileClassesManager == null) {
            CodegenBinding.$$$reportNull$$$0(17);
        }
        KtElement element = (KtElement)DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor);
        assert (element != null) : "No source element for " + classDescriptor;
        MutableClosure closure = new MutableClosure(classDescriptor, enclosing);
        if (classDescriptor.isInner()) {
            closure.setCaptureThis();
        }
        trace.record(ASM_TYPE, classDescriptor, asmType);
        trace.record(CLOSURE, classDescriptor, closure);
        if (enclosing != null && !JvmCodegenUtil.isArgumentWhichWillBeInlined(trace.getBindingContext(), classDescriptor)) {
            CodegenBinding.recordInnerClass(trace, enclosing, classDescriptor);
        }
        MutableClosure mutableClosure = closure;
        if (mutableClosure == null) {
            CodegenBinding.$$$reportNull$$$0(18);
        }
        return mutableClosure;
    }

    private static void recordInnerClass(@NotNull BindingTrace bindingTrace, @NotNull ClassDescriptor outer, @NotNull ClassDescriptor inner) {
        Collection<ClassDescriptor> innerClasses;
        if (bindingTrace == null) {
            CodegenBinding.$$$reportNull$$$0(19);
        }
        if (outer == null) {
            CodegenBinding.$$$reportNull$$$0(20);
        }
        if (inner == null) {
            CodegenBinding.$$$reportNull$$$0(21);
        }
        if ((innerClasses = bindingTrace.get(INNER_CLASSES, outer)) == null) {
            innerClasses = new ArrayList<ClassDescriptor>(1);
            bindingTrace.record(INNER_CLASSES, outer, innerClasses);
        }
        innerClasses.add(inner);
    }

    @NotNull
    private static Collection<KtFile> allFilesInPackages(BindingContext bindingContext, Collection<KtFile> files2) {
        HashSet<FqName> names2 = new HashSet<FqName>();
        for (KtFile ktFile : files2) {
            if (ktFile.isScript()) continue;
            names2.add(ktFile.getPackageFqName());
        }
        HashSet<KtFile> answer = new HashSet<KtFile>();
        answer.addAll(files2);
        for (FqName name : names2) {
            Collection<KtFile> jetFiles = bindingContext.get(BindingContext.PACKAGE_TO_FILES, name);
            if (jetFiles == null) continue;
            answer.addAll(jetFiles);
        }
        ArrayList<KtFile> arrayList = new ArrayList<KtFile>(answer);
        Collections.sort(arrayList, new Comparator<KtFile>(){

            @NotNull
            private String path(KtFile file2) {
                VirtualFile virtualFile = file2.getVirtualFile();
                assert (virtualFile != null) : "VirtualFile is null for JetFile: " + file2.getName();
                String string = virtualFile.getPath();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public int compare(@NotNull KtFile first, @NotNull KtFile second) {
                if (first == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (second == null) {
                    1.$$$reportNull$$$0(2);
                }
                return this.path(first).compareTo(this.path(second));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/codegen/binding/CodegenBinding$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "first";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "second";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "path";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/codegen/binding/CodegenBinding$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "compare";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        ArrayList<KtFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            CodegenBinding.$$$reportNull$$$0(22);
        }
        return arrayList2;
    }

    @NotNull
    public static Type getAsmType(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor klass2) {
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(23);
        }
        if (klass2 == null) {
            CodegenBinding.$$$reportNull$$$0(24);
        }
        Type type2 = bindingContext.get(ASM_TYPE, klass2);
        assert (type2 != null) : "Type is not yet recorded for " + klass2;
        Type type3 = type2;
        if (type3 == null) {
            CodegenBinding.$$$reportNull$$$0(25);
        }
        return type3;
    }

    @NotNull
    public static Collection<ClassDescriptor> getAllInnerClasses(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor outermostClass) {
        Collection<ClassDescriptor> innerClasses;
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(26);
        }
        if (outermostClass == null) {
            CodegenBinding.$$$reportNull$$$0(27);
        }
        if ((innerClasses = bindingContext.get(INNER_CLASSES, outermostClass)) == null || innerClasses.isEmpty()) {
            Set<ClassDescriptor> set = Collections.emptySet();
            if (set == null) {
                CodegenBinding.$$$reportNull$$$0(28);
            }
            return set;
        }
        HashSet<ClassDescriptor> allInnerClasses = new HashSet<ClassDescriptor>();
        ArrayDeque<ClassDescriptor> stack = new ArrayDeque<ClassDescriptor>(innerClasses);
        do {
            Collection<ClassDescriptor> nextClasses;
            ClassDescriptor currentClass;
            if (!allInnerClasses.add(currentClass = (ClassDescriptor)stack.pop()) || (nextClasses = bindingContext.get(INNER_CLASSES, currentClass)) == null) continue;
            for (ClassDescriptor nextClass : nextClasses) {
                stack.push(nextClass);
            }
        } while (!stack.isEmpty());
        HashSet<ClassDescriptor> hashSet = allInnerClasses;
        if (hashSet == null) {
            CodegenBinding.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    @NotNull
    public static VariableDescriptor getDelegatedLocalVariableMetadata(@NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext) {
        if (variableDescriptor == null) {
            CodegenBinding.$$$reportNull$$$0(30);
        }
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(31);
        }
        VariableDescriptor metadataVariableDescriptor = bindingContext.get(LOCAL_VARIABLE_PROPERTY_METADATA, variableDescriptor);
        assert (metadataVariableDescriptor != null) : "Metadata for local delegated property should be not null: " + variableDescriptor;
        VariableDescriptor variableDescriptor2 = metadataVariableDescriptor;
        if (variableDescriptor2 == null) {
            CodegenBinding.$$$reportNull$$$0(32);
        }
        return variableDescriptor2;
    }

    static {
        BasicWritableSlice.initSliceDebugNames(CodegenBinding.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 12: 
            case 23: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/binding/CodegenBinding";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileClassesManager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingTrace";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inner";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outermostClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/binding/CodegenBinding";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "anonymousClassForCallable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeForAnonymousClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "recordClosure";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "allFilesInPackages";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsmType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegatedLocalVariableMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initTrace";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "anonymousClassForCallable";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 32: {
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeForAnonymousClass";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canHaveOuter";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "recordClosure";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "recordInnerClass";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAsmType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAllInnerClasses";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDelegatedLocalVariableMetadata";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

